/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.neon.lexer;

import java.util.Collection;
import java.util.EnumSet;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.languages.neon.lexer.NeonLexer;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum NeonTokenId implements TokenId
{
    NEON_KEYWORD("keyword"),
    NEON_INTERPUNCTION("interpunction"),
    NEON_BLOCK("block"),
    NEON_VALUED_BLOCK("valuedblock"),
    NEON_STRING("string"),
    NEON_COMMENT("comment"),
    NEON_UNKNOWN("error"),
    NEON_LITERAL("literal"),
    NEON_VARIABLE("variable"),
    NEON_NUMBER("number"),
    NEON_REFERENCE("reference"),
    NEON_WHITESPACE("whitespace");

    private final String name;
    private static final Language<NeonTokenId> LANGUAGE;

    private NeonTokenId(String name) {
        this.name = name;
    }

    public String primaryCategory() {
        return this.name;
    }

    public static Language<NeonTokenId> language() {
        return LANGUAGE;
    }

    static {
        LANGUAGE = new LanguageHierarchy<NeonTokenId>(){

            protected Collection<NeonTokenId> createTokenIds() {
                return EnumSet.allOf(NeonTokenId.class);
            }

            protected Lexer<NeonTokenId> createLexer(LexerRestartInfo<NeonTokenId> info) {
                return NeonLexer.create(info);
            }

            protected String mimeType() {
                return "text/x-neon";
            }
        }.language();
    }
}

