/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleType;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public final class JavadocForBinaryImpl
implements JavadocForBinaryQueryImplementation {
    private static final String NB_ALL_INFIX = "nbbuild" + File.separatorChar + "build" + File.separatorChar + "javadoc" + File.separatorChar;
    private static final String EXT_INFIX = "build" + File.separatorChar + "javadoc" + File.separatorChar;
    static boolean ignoreNonexistentRoots = true;
    private final NbModuleProject project;

    public JavadocForBinaryImpl(NbModuleProject project) {
        this.project = project;
    }

    public JavadocForBinaryQuery.Result findJavadoc(URL binaryRoot) {
        if (!binaryRoot.equals(FileUtil.urlForArchiveOrDir((File)this.project.getModuleJarLocation()))) {
            return this.findForCPExt(binaryRoot);
        }
        String cnb = this.project.getCodeNameBase();
        if (cnb == null) {
            return null;
        }
        String cnbdashes = cnb.replace('.', '-');
        try {
            ArrayList<URL> candidates = new ArrayList<URL>();
            NbPlatform platform = this.project.getPlatform(false);
            if (platform == null) {
                return null;
            }
            for (URL root : platform.getJavadocRoots()) {
                candidates.add(new URL(root, cnbdashes + "/"));
            }
            NbModuleType type = this.project.getModuleType();
            File dir = type == NbModuleType.NETBEANS_ORG ? this.project.getNbrootFile(NB_ALL_INFIX + cnbdashes) : new File(this.project.getProjectDirectoryFile(), EXT_INFIX + cnbdashes);
            if (dir != null) {
                candidates.add(FileUtil.urlForArchiveOrDir((File)dir));
            }
            if (ignoreNonexistentRoots) {
                Iterator it = candidates.iterator();
                while (it.hasNext()) {
                    URL u = (URL)it.next();
                    if (URLMapper.findFileObject((URL)u) != null) continue;
                    it.remove();
                }
            }
            return new R(candidates.toArray(new URL[0]));
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    private JavadocForBinaryQuery.Result findForCPExt(URL binaryRoot) {
        URL jar = FileUtil.getArchiveFile((URL)binaryRoot);
        if (jar == null) {
            return null;
        }
        File binaryRootF = Utilities.toFile((URI)URI.create(jar.toExternalForm()));
        String n = binaryRootF.getName();
        if (!n.endsWith(".jar")) {
            return null;
        }
        File jFolder = new File(binaryRootF.getParentFile(), n.substring(0, n.length() - ".jar".length()) + "-javadoc");
        if (jFolder.isDirectory()) {
            return new R(new URL[]{FileUtil.urlForArchiveOrDir((File)jFolder)});
        }
        File jZip = new File(jFolder.getAbsolutePath() + ".zip");
        if (jZip.isFile()) {
            return new R(new URL[]{FileUtil.urlForArchiveOrDir((File)jZip)});
        }
        return null;
    }

    private static final class R
    implements JavadocForBinaryQuery.Result {
        private final URL[] roots;

        public R(URL[] roots) {
            this.roots = roots;
        }

        public URL[] getRoots() {
            return this.roots;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

