/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.mx.project;

import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.modules.java.mx.project.Jdks;
import org.netbeans.modules.java.mx.project.SuiteProject;
import org.netbeans.modules.java.mx.project.SuiteSources;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.queries.AnnotationProcessingQueryImplementation;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;

final class SuiteClassPathProvider
extends ProjectOpenedHook
implements ClassPathProvider,
AnnotationProcessingQueryImplementation {
    private final SuiteProject project;
    private final Jdks jdks;

    public SuiteClassPathProvider(SuiteProject project, Jdks jdks) {
        this.project = project;
        this.jdks = jdks;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        SuiteSources.Group g = this.project.getSources().findGroup(file);
        if (g == null) {
            return null;
        }
        if ("classpath/boot".equals(type)) {
            return g.getBootCP();
        }
        if ("classpath/compile".equals(type)) {
            return g.getCP();
        }
        if ("classpath/source".equals(type)) {
            return g.getSourceCP();
        }
        if ("classpath/processor".equals(type)) {
            return g.getProcessorCP();
        }
        return null;
    }

    public void projectOpened() {
        for (SuiteSources.Group s : this.project.getSources().groups()) {
            GlobalPathRegistry.getDefault().register("classpath/boot", new ClassPath[]{s.getBootCP()});
            GlobalPathRegistry.getDefault().register("classpath/source", new ClassPath[]{s.getSourceCP()});
            GlobalPathRegistry.getDefault().register("classpath/compile", new ClassPath[]{s.getCP()});
        }
    }

    public void projectClosed() {
        for (SuiteSources.Group s : this.project.getSources().groups()) {
            GlobalPathRegistry.getDefault().unregister("classpath/boot", new ClassPath[]{s.getBootCP()});
            GlobalPathRegistry.getDefault().unregister("classpath/source", new ClassPath[]{s.getSourceCP()});
            GlobalPathRegistry.getDefault().unregister("classpath/compile", new ClassPath[]{s.getCP()});
        }
    }

    public AnnotationProcessingQuery.Result getAnnotationProcessingOptions(FileObject file) {
        SuiteSources.Group g = this.project.getSources().findGroup(file);
        return g;
    }
}

