/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute;

import java.sql.SQLWarning;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.db.dataview.api.DataView;
import org.netbeans.modules.db.sql.execute.StatementInfo;

public class SQLExecutionResult {
    private final StatementInfo statementInfo;
    private final DataView dataView;

    public SQLExecutionResult(StatementInfo info, DataView dataView) {
        this.statementInfo = info;
        this.dataView = dataView;
    }

    public StatementInfo getStatementInfo() {
        return this.statementInfo;
    }

    public DataView getDataView() {
        return this.dataView;
    }

    public boolean hasResults() {
        return this.dataView.hasResultSet();
    }

    public boolean hasExceptions() {
        return this.dataView.hasExceptions();
    }

    public int getUpdateCount() {
        return this.dataView.getUpdateCount();
    }

    public List<Integer> getUpdateCounts() {
        return this.dataView.getUpdateCounts();
    }

    public List<Long> getFetchTimes() {
        return this.dataView.getFetchTimes();
    }

    public Collection<Throwable> getExceptions() {
        return this.dataView.getExceptions();
    }

    public long getExecutionTime() {
        return this.dataView.getExecutionTime();
    }

    public int getErrorPosition() {
        return this.dataView.getErrorPosition();
    }

    public int[] getRawErrorLocation() {
        int errorOffset = this.getErrorPosition();
        if (errorOffset >= 0) {
            return this.getStatementInfo().translateToRawPosLineColumn(errorOffset);
        }
        return new int[]{this.getStatementInfo().getStartLine(), this.getStatementInfo().getStartColumn()};
    }

    public boolean hasWarnings() {
        return this.dataView.hasWarnings();
    }

    public Collection<SQLWarning> getWarnings() {
        return this.dataView.getWarnings();
    }

    public String toString() {
        return "SQLExecutionResult[dataView=" + this.dataView + ",rowCount=" + this.getUpdateCount() + ",exception=" + this.getExceptions() + ",executionTime=" + this.getExecutionTime() + "]";
    }
}

