/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.common;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public interface CacheEntryExpiration {
    public static final CacheEntryExpiration DEFAULT = new Impl();
    public static final CacheEntryExpiration IMMORTAL = new Impl(Duration.ZERO, Duration.ZERO);

    public static CacheEntryExpiration withLifespan(Duration lifespan) {
        return lifespan == null ? DEFAULT : new Impl(lifespan, null);
    }

    public static CacheEntryExpiration withMaxIdle(Duration maxIdle) {
        return maxIdle == null ? DEFAULT : new Impl(null, maxIdle);
    }

    public static CacheEntryExpiration withLifespanAndMaxIdle(Duration lifespan, Duration maxIdle) {
        return lifespan == null && maxIdle == null ? DEFAULT : new Impl(lifespan, maxIdle);
    }

    public Optional<Duration> lifespan();

    public Optional<Duration> maxIdle();

    public boolean isImmortal();

    public boolean isDefault();

    public static class Impl
    implements CacheEntryExpiration {
        private final Duration lifespan;
        private final Duration maxIdle;

        private Impl() {
            this.lifespan = null;
            this.maxIdle = null;
        }

        private Impl(Duration lifespan, Duration maxIdle) {
            this.lifespan = lifespan;
            this.maxIdle = maxIdle;
        }

        @Override
        public Optional<Duration> lifespan() {
            return Optional.ofNullable(this.lifespan);
        }

        @Override
        public Optional<Duration> maxIdle() {
            return Optional.ofNullable(this.maxIdle);
        }

        public Duration rawLifespan() {
            return this.lifespan;
        }

        public Duration rawMaxIdle() {
            return this.maxIdle;
        }

        @Override
        public boolean isImmortal() {
            return this == IMMORTAL;
        }

        @Override
        public boolean isDefault() {
            return this == DEFAULT;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Impl that = (Impl)o;
            return Objects.equals(this.lifespan, that.lifespan) && Objects.equals(this.maxIdle, that.maxIdle);
        }

        public int hashCode() {
            return Objects.hash(this.lifespan, this.maxIdle);
        }

        public String toString() {
            if (this == IMMORTAL) {
                return "Impl{IMMORTAL}";
            }
            if (this == DEFAULT) {
                return "Impl{DEFAULT}";
            }
            return "Impl{lifespan=" + String.valueOf(this.lifespan) + ", maxIdle=" + String.valueOf(this.maxIdle) + "}";
        }
    }
}

