/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.artifacts.configurations;

import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationCreationRequest;

public abstract class AbstractRoleBasedConfigurationCreationRequest
implements RoleBasedConfigurationCreationRequest {
    protected final String configurationName;
    protected final ConfigurationRole role;

    protected AbstractRoleBasedConfigurationCreationRequest(String configurationName, ConfigurationRole role) {
        this.configurationName = configurationName;
        this.role = role;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public ConfigurationRole getRole() {
        return this.role;
    }

    public Configuration verifyExistingConfigurationUsage(Configuration conf) {
        this.warnAboutReservedName();
        ConfigurationInternal internalConf = (ConfigurationInternal)conf;
        if (!this.getRole().isUsageConsistentWithRole(conf)) {
            this.warnAboutNeedToMutateUsage(internalConf);
            if (internalConf.usageCanBeMutated()) {
                internalConf.setAllowedUsageFromRole(this.getRole());
            } else {
                this.failOnInabilityToMutateUsage();
            }
        }
        return conf;
    }
}

