/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.watcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public class FileWatcher
implements AutoCloseable {
    private final Collection<FileSystemWatcher> watchers;
    private final CountDownLatch join;

    FileWatcher(Collection<FileSystemWatcher> watchers, CountDownLatch join) {
        this.watchers = watchers;
        this.join = join;
    }

    @Override
    public void close() {
        this.watchers.forEach(FileSystemWatcher::close);
    }

    public void await() throws InterruptedException {
        this.join.await();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.join.await(timeout, unit);
    }

    public long getCount() {
        return this.join.getCount();
    }

    static class FileSystemWatcher {
        private final WatchService watchService;
        private final Set<Path> watching;

        FileSystemWatcher(FileSystem fs) throws IOException {
            this.watchService = fs.newWatchService();
            this.watching = new HashSet<Path>();
        }

        void addPath(Path path) throws IOException {
            if (this.watching.add(path)) {
                path.getParent().register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            }
        }

        void watch(BiConsumer<Path, String> changed) throws Exception {
            WatchKey key;
            while ((key = this.watchService.take()) != null) {
                Path dir = (Path)key.watchable();
                for (WatchEvent<?> event : key.pollEvents()) {
                    Path path = dir.resolve((Path)event.context());
                    if (!this.watching.contains(path)) continue;
                    changed.accept(path, event.kind().name());
                }
                if (key.reset()) continue;
                break;
            }
        }

        void close() {
            try {
                this.watchService.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class Builder {
        private final List<File> watching = new ArrayList<File>();
        private Executor executor;
        private BiConsumer<File, String> changed;

        public Builder executor(Executor executor) {
            this.executor = Objects.requireNonNull(executor);
            return this;
        }

        public Builder changed(BiConsumer<File, String> changed) {
            this.changed = Objects.requireNonNull(changed);
            return this;
        }

        public Builder file(File file) {
            if (file != null) {
                this.watching.add(file);
            }
            return this;
        }

        public Builder files(Collection<File> files) {
            if (files != null) {
                for (File file : files) {
                    this.file(file);
                }
            }
            return this;
        }

        public Builder files(File ... files) {
            if (files != null) {
                for (File file : files) {
                    this.file(file);
                }
            }
            return this;
        }

        public FileWatcher build() throws IOException {
            Objects.requireNonNull(this.executor, "no executor was set");
            Objects.requireNonNull(this.changed, "no changed callback was set");
            HashMap<FileSystem, FileSystemWatcher> map = new HashMap<FileSystem, FileSystemWatcher>();
            for (File file : this.watching) {
                Path path = file.toPath();
                FileSystem fs = path.getFileSystem();
                FileSystemWatcher watcher = (FileSystemWatcher)map.get(fs);
                if (watcher == null) {
                    watcher = new FileSystemWatcher(fs);
                    map.put(fs, watcher);
                }
                watcher.addPath(path);
            }
            Collection<FileSystemWatcher> watchers = map.values();
            CountDownLatch join = new CountDownLatch(watchers.size());
            for (FileSystemWatcher watcher : watchers) {
                this.executor.execute(() -> {
                    try {
                        watcher.watch((path, kind) -> this.changed.accept(path.toFile(), (String)kind));
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        watcher.close();
                        join.countDown();
                    }
                });
            }
            return new FileWatcher(watchers, join);
        }
    }
}

