/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.actions.ActionMappingPropertyReader;
import org.netbeans.modules.gradle.actions.ActionMappingScanner;
import org.netbeans.modules.gradle.actions.ActionPersistenceUtils;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.execute.ActionMapping;
import org.netbeans.modules.gradle.api.execute.GradleExecConfiguration;
import org.netbeans.modules.gradle.execute.ConfigurableActionProvider;
import org.netbeans.modules.gradle.execute.GradleExecAccessor;
import org.netbeans.modules.gradle.execute.ProjectConfigurationSupport;
import org.netbeans.modules.gradle.spi.actions.GradleActionsProvider;
import org.netbeans.modules.gradle.spi.actions.ProjectActionMappingProvider;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;
import org.xml.sax.SAXException;

public class ConfigurableActionsProviderImpl
implements ProjectActionMappingProvider,
ConfigurableActionProvider {
    private static final Logger LOG = Logger.getLogger(ConfigurableActionsProviderImpl.class.getName());
    private static final RequestProcessor ACTIONS_REFRESH_RP = new RequestProcessor(ConfigurableActionsProviderImpl.class);
    private final Project project;
    private final FileObject projectDirectory;
    final PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("ProjectInfo".equals(evt.getPropertyName())) {
                ConfigurableActionsProviderImpl.this.reload();
            }
        }
    };
    final FileChangeListener fcl = new FileChangeAdapter(){

        public void fileRenamed(FileRenameEvent fe) {
            ConfigurableActionsProviderImpl.this.actionFileChanged(fe.getFile(), fe.getName(), false);
        }

        public void fileDeleted(FileEvent fe) {
            ConfigurableActionsProviderImpl.this.actionFileChanged(fe.getFile(), null, true);
        }

        public void fileChanged(FileEvent fe) {
            ConfigurableActionsProviderImpl.this.actionFileChanged(fe.getFile(), null, false);
        }

        public void fileDataCreated(FileEvent fe) {
            ConfigurableActionsProviderImpl.this.actionFileChanged(fe.getFile(), null, false);
        }
    };
    private ProjectConfigurationProvider<GradleExecConfiguration> confProvider;
    private Lookup.Result<GradleActionsProvider> providers;
    private Map<String, ActionData> cache = null;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private Map<String, GradleExecConfiguration> configurations = new HashMap<String, GradleExecConfiguration>();
    private Set<String> actionIDs = new HashSet<String>();
    private Set<String> plugins;
    private RequestProcessor.Task pendingTask;
    private final AtomicInteger serial = new AtomicInteger(0);

    public ConfigurableActionsProviderImpl(Project project, Lookup l) {
        this.project = project;
        this.projectDirectory = project.getProjectDirectory();
        FileChangeListener wl = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.fcl, (Object)this.projectDirectory);
        this.projectDirectory.addFileChangeListener(wl);
        LOG.log(Level.FINER, "Initializing ConfigurableAP for {0}", project);
    }

    void setConfigurationProvider(ProjectConfigurationProvider p) {
        this.confProvider = p;
        p.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ConfigurableActionsProviderImpl.this.configurationsChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectConfigurationProvider<GradleExecConfiguration> conf() {
        if (this.confProvider != null) {
            return this.confProvider;
        }
        ConfigurableActionsProviderImpl configurableActionsProviderImpl = this;
        synchronized (configurableActionsProviderImpl) {
            this.confProvider = (ProjectConfigurationProvider)this.project.getLookup().lookup(ProjectConfigurationProvider.class);
            this.setConfigurationProvider(this.confProvider);
            return this.confProvider;
        }
    }

    private String effectiveConfig() {
        return ProjectConfigurationSupport.getEffectiveConfiguration(this.project, Lookup.EMPTY).getId();
    }

    ActionMapping findMapping(String action, String cfgId) {
        ActionData ad = this.getActionData(cfgId);
        ActionMapping m = null;
        if (ad != null) {
            m = ad.getAction(action);
        }
        if (m == null && !"%%DEFAULT%%".equals(cfgId)) {
            m = this.getActionData("%%DEFAULT%%").getAction(action);
        }
        return m;
    }

    Set<String> customizedActions(String cfgId) {
        ActionData ad = this.getActionData(cfgId);
        if (ad == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(ad.customizedMappings.keySet());
    }

    @Override
    public ActionMapping findMapping(String action) {
        return this.findMapping(action, this.effectiveConfig());
    }

    @Override
    public Set<String> customizedActions() {
        return this.customizedActions(this.effectiveConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeListener(ChangeListener l) {
        ConfigurableActionsProviderImpl configurableActionsProviderImpl = this;
        synchronized (configurableActionsProviderImpl) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChangeListener(ChangeListener l) {
        ConfigurableActionsProviderImpl configurableActionsProviderImpl = this;
        synchronized (configurableActionsProviderImpl) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GradleExecConfiguration> findConfigurations() {
        Set<String> confIds;
        ConfigurableActionsProviderImpl configurableActionsProviderImpl = this;
        synchronized (configurableActionsProviderImpl) {
            if (this.cache != null) {
                return new ArrayList<GradleExecConfiguration>(this.configurations.values());
            }
            confIds = this.cache == null ? null : this.cache.keySet();
        }
        LOG.log(Level.FINER, "Reloading configuration; old IDs: {0}", confIds);
        Map<String, ActionData> map = this.updateCache(this.serial.incrementAndGet(), confIds);
        ArrayList<GradleExecConfiguration> lst = new ArrayList<GradleExecConfiguration>(map.size());
        for (ActionData ad : map.values()) {
            if (!ad.fromProvider) continue;
            lst.add(ad.cfg);
        }
        return lst;
    }

    @Override
    public ProjectActionMappingProvider findActionProvider(final String configurationId) {
        return new ProjectActionMappingProvider(){

            @Override
            public ActionMapping findMapping(String action) {
                return ConfigurableActionsProviderImpl.this.findMapping(action, configurationId);
            }

            @Override
            public Set<String> customizedActions() {
                return ConfigurableActionsProviderImpl.this.customizedActions(configurationId);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionMapping findDefaultMapping(String configurationId, String action) {
        ActionMapping result;
        ActionData ad;
        Map<String, ActionData> snap = null;
        ConfigurableActionsProviderImpl configurableActionsProviderImpl = this;
        synchronized (configurableActionsProviderImpl) {
            snap = this.cache;
        }
        if (snap == null) {
            LOG.log(Level.FINER, "Reloading configuration");
            snap = this.updateCache(this.serial.incrementAndGet(), null);
        }
        if ((ad = snap.get(configurationId)) != null && (result = ad.getDefaultAction(action)) != null) {
            return result;
        }
        ActionData def = snap.get("%%DEFAULT%%");
        if (def != ad && def != null) {
            return def.getDefaultAction(action);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Set<String> getPlugins() {
        ConfigurableActionsProviderImpl configurableActionsProviderImpl = this;
        synchronized (configurableActionsProviderImpl) {
            if (this.plugins == null) {
                GradleBaseProject gbp = GradleBaseProject.get(this.project);
                this.plugins = gbp.getPlugins();
            }
            return this.plugins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends GradleActionsProvider> providers() {
        Collection lst;
        if (this.providers != null) {
            return this.providers.allInstances();
        }
        LOG.log(Level.FINER, "Initializing providers lookup for: {0}", this.project);
        ProxyLookup combined = new ProxyLookup(new Lookup[]{Lookup.getDefault(), this.project.getLookup()});
        final Lookup.Result result = combined.lookupResult(GradleActionsProvider.class);
        ConfigurableActionsProviderImpl configurableActionsProviderImpl = this;
        synchronized (configurableActionsProviderImpl) {
            if (this.providers != null) {
                return this.providers.allInstances();
            }
            LOG.log(Level.FINER, "Attaching provider listener");
            result.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent ev) {
                    ConfigurableActionsProviderImpl configurableActionsProviderImpl = ConfigurableActionsProviderImpl.this;
                    synchronized (configurableActionsProviderImpl) {
                        if (ConfigurableActionsProviderImpl.this.providers != result) {
                            return;
                        }
                    }
                    LOG.log(Level.FINER, "Action providers change for {0}, refreshing", ConfigurableActionsProviderImpl.this.project);
                    ConfigurableActionsProviderImpl.this.refresh();
                }
            });
            lst = result.allInstances();
            this.providers = result;
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configurationsChanged() {
        Collection confs = this.conf().getConfigurations();
        HashSet ids = new HashSet();
        confs.forEach(c -> ids.add(c.getId()));
        ConfigurableActionsProviderImpl configurableActionsProviderImpl = this;
        synchronized (configurableActionsProviderImpl) {
            if (this.cache != null && this.cache.keySet().equals(ids)) {
                LOG.log(Level.FINER, "Configuration set did not change - stop.");
                return;
            }
        }
        this.refresh();
        LOG.log(Level.FINER, "Different configuraitons set, reloading");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        ConfigurableActionsProviderImpl configurableActionsProviderImpl = this;
        synchronized (configurableActionsProviderImpl) {
            this.plugins = null;
            Set<String> confIds = this.cache == null ? null : this.cache.keySet();
            this.cache = null;
            if (this.pendingTask != null) {
                this.pendingTask.cancel();
            }
            this.pendingTask = ACTIONS_REFRESH_RP.post(() -> {
                ConfigurableActionsProviderImpl configurableActionsProviderImpl = this;
                synchronized (configurableActionsProviderImpl) {
                    this.pendingTask = null;
                }
                this.updateCache(this.serial.incrementAndGet(), confIds);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionData getActionData(String id) {
        Map<String, ActionData> snap;
        Collection configs = this.conf().getConfigurations();
        GradleExecConfiguration foundConfig = null;
        ConfigurableActionsProviderImpl configurableActionsProviderImpl = this;
        synchronized (configurableActionsProviderImpl) {
            snap = this.cache;
            if (snap != null) {
                ActionData ad = this.cache.get(id);
                if (ad != null) {
                    if (ad.customizedMappings != null) {
                        return ad;
                    }
                } else {
                    foundConfig = configs.stream().filter(c -> c.getId().equals(id)).findAny().orElse(null);
                    if (foundConfig == null) {
                        return null;
                    }
                }
            }
        }
        if (snap != null) {
            Map<String, ActionMapping> map = this.loadCustomActions(id);
            ConfigurableActionsProviderImpl configurableActionsProviderImpl2 = this;
            synchronized (configurableActionsProviderImpl2) {
                if (snap == this.cache) {
                    ActionData ad = this.cache.get(id);
                    if (ad != null) {
                        if (ad.customizedMappings != null) {
                            return ad;
                        }
                        ad.customizedMappings = map;
                    } else {
                        ad = new ActionData(false, foundConfig);
                        this.cache.put(id, ad);
                    }
                    ad.customizedMappings = map;
                    FileObject f = ActionPersistenceUtils.findActionsFile(this.projectDirectory, id);
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.log(Level.FINER, "Adding listener for: {0} - {1}", new Object[]{id, f});
                    }
                    ad.attach(this.projectDirectory, f, this.fcl);
                    return ad;
                }
                return this.cache.get(id);
            }
        }
        return this.updateCache(this.serial.incrementAndGet(), null).get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ActionData> updateCache(int serial, Set<String> oldConfigs) {
        ArrayList<ChangeListener> ll;
        LOG.log(Level.FINER, "Updating action cache for {0}, serial {1}, oldConfigs {2}", new Object[]{this.project, serial, oldConfigs});
        Refresher r = new Refresher();
        r.run();
        ConfigurableActionsProviderImpl configurableActionsProviderImpl = this;
        synchronized (configurableActionsProviderImpl) {
            if (serial != this.serial.get()) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "Reloaded serial {0}-{1} does not match current {2}, stop.", new Object[]{this.project, serial, this.serial.get()});
                }
                return r.actionMap;
            }
            Map<String, ActionData> oldCache = this.cache;
            Map<String, ActionData> newCache = r.actionMap;
            this.cache = newCache;
            HashMap<String, GradleExecConfiguration> confs = new HashMap<String, GradleExecConfiguration>();
            newCache.forEach((k, v) -> confs.put((String)k, v.cfg));
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Project {0} got configurations: {1}", new Object[]{this.project, confs.keySet()});
            }
            this.configurations = confs;
            this.actionIDs = r.actionIDs;
            if (oldCache != null) {
                for (ActionData ad : oldCache.values()) {
                    ad.detach();
                }
            }
            for (ActionData ad : newCache.values()) {
                ad.attach(this.projectDirectory, null, this.fcl);
            }
            if (newCache.keySet().equals(oldConfigs)) {
                LOG.log(Level.FINER, "No configuraiton change - stop.");
                return this.cache;
            }
            ll = new ArrayList<ChangeListener>(this.listeners);
            if (LOG.isLoggable(Level.FINER)) {
                HashSet toRemove = new HashSet(oldCache == null ? Collections.emptySet() : oldCache.keySet());
                toRemove.removeAll(newCache.keySet());
                HashSet<String> toAdd = new HashSet<String>(newCache.keySet());
                if (oldCache != null) {
                    toAdd.remove(oldCache.keySet());
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "Removed config: {0}, added config: {1}", new Object[]{toRemove, toAdd});
                }
            }
            if (oldConfigs == null) {
                return this.cache;
            }
            if (this.listeners.isEmpty()) {
                return this.cache;
            }
        }
        LOG.log(Level.FINER, "Firing config/action change events");
        ChangeEvent e = new ChangeEvent(this);
        ll.forEach(l -> l.stateChanged(e));
        return r.actionMap;
    }

    private static String[] maybeEmpty(String args) {
        if (args == null) {
            return new String[0];
        }
        return BaseUtilities.parseParameters((String)args);
    }

    private Map<String, ActionMapping> loadCustomizedDefaultConfig() {
        FileObject defaultConfigFile = this.project.getProjectDirectory().getFileObject("gradle.properties");
        if (defaultConfigFile == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ActionMapping> mapping = new HashMap<String, ActionMapping>();
        try (InputStream is = defaultConfigFile.getInputStream();){
            Properties props = new Properties();
            props.load(is);
            Set<ActionMapping> actions = ActionMappingPropertyReader.loadMappings(props);
            for (ActionMapping am : actions) {
                mapping.put(am.getName(), am);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mapping;
    }

    private Map<String, ActionMapping> loadCustomActions(String id) {
        if ("%%DEFAULT%%".equals(id)) {
            return this.loadCustomizedDefaultConfig();
        }
        FileObject configFile = ActionPersistenceUtils.findActionsFile(this.projectDirectory, id);
        if (configFile == null || !configFile.isValid() || !configFile.isData()) {
            return Collections.emptyMap();
        }
        HashMap<String, ActionMapping> mapping = new HashMap<String, ActionMapping>();
        try (InputStream is = configFile.getInputStream();){
            HashMap map = new HashMap();
            Set<ActionMapping> actions = ActionMappingScanner.loadMappings(is);
            for (ActionMapping am : actions) {
                mapping.put(am.getName(), am);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        return mapping;
    }

    private void reload() {
        this.refresh();
    }

    private void actionFileChanged(FileObject af, String originalName, boolean delete) {
        this.actionFileChanged0(af, originalName, delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean actionFileChanged0(FileObject af, String originalName, boolean delete) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Action file changed: {0}, orig: {1}, deleted: {2}", new Object[]{af.getNameExt(), originalName, delete});
        }
        String name = af.getName();
        if (af.getParent() != this.project.getProjectDirectory()) {
            return false;
        }
        String selectedId = this.findConfigurationId(af.getNameExt());
        ActionData dataHolder = null;
        ConfigurableActionsProviderImpl configurableActionsProviderImpl = this;
        synchronized (configurableActionsProviderImpl) {
            if (this.cache != null && selectedId != null) {
                dataHolder = this.cache.get(selectedId);
                LOG.log(Level.FINER, "selectedId: {0}, holder: {1}", new Object[]{selectedId, dataHolder});
                if (dataHolder == null) {
                    return false;
                }
                LOG.log(Level.FINER, "Invalidating holder");
                if (delete) {
                    dataHolder.clearCustomMappings();
                } else {
                    dataHolder.customizedMappings = null;
                    dataHolder.attach(this.projectDirectory, af, this.fcl);
                }
            }
        }
        return true;
    }

    private String findConfigurationId(String fileNameExt) {
        if ("gradle.properties".equals(fileNameExt)) {
            return "%%DEFAULT%%";
        }
        if (fileNameExt.startsWith("nb-actions-") && fileNameExt.endsWith(".xml")) {
            return fileNameExt.substring("nb-actions-".length(), fileNameExt.length() - ".xml".length());
        }
        return null;
    }

    private class ActionData {
        private final GradleExecConfiguration cfg;
        private final List<ActionMapping> mappings = new ArrayList<ActionMapping>();
        private final boolean fromProvider;
        private FileObject monitoringFile;
        private FileChangeListener listener;
        private Map<String, ActionMapping> customizedMappings = null;

        public ActionData(boolean provided, GradleExecConfiguration cfg) {
            this.fromProvider = provided;
            this.cfg = cfg;
        }

        ActionMapping getAction(String id) {
            ActionMapping result = this.customizedMappings.get(id);
            if (result != null) {
                return result;
            }
            return this.getDefaultAction(id);
        }

        ActionMapping getDefaultAction(String id) {
            ActionMapping result = null;
            for (ActionMapping mapping : this.mappings) {
                if (!mapping.getName().equals(id) || !mapping.isApplicable(ConfigurableActionsProviderImpl.this.getPlugins()) || result != null && result.compareTo(mapping) >= 0) continue;
                result = mapping;
            }
            return result;
        }

        void clearCustomMappings() {
            this.customizedMappings = Collections.emptyMap();
            this.detach();
        }

        void attach(FileObject projectDir, FileObject f, FileChangeListener fcl) {
            if (this.listener != null) {
                return;
            }
            if (f == null && (f = ActionPersistenceUtils.findActionsFile(projectDir, this.cfg.getId())) == null) {
                return;
            }
            LOG.log(Level.FINER, "Started to monitor {0}", f);
            this.monitoringFile = f;
            this.listener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)fcl, (Object)f);
            f.addFileChangeListener(this.listener);
        }

        void detach() {
            if (this.monitoringFile == null) {
                this.listener = null;
                return;
            }
            if (this.listener != null) {
                LOG.log(Level.FINER, "Stopped monitoring {0}", this.monitoringFile);
                this.monitoringFile.removeFileChangeListener(this.listener);
            }
            this.monitoringFile = null;
            this.listener = null;
        }
    }

    class Refresher
    implements Runnable {
        Map<String, GradleExecConfiguration> config = new HashMap<String, GradleExecConfiguration>();
        Set<String> actionIDs = new HashSet<String>();
        Map<String, ActionData> actionMap = new HashMap<String, ActionData>();
        ActionData currentData;

        Refresher() {
        }

        @Override
        public void run() {
            Collection<? extends GradleActionsProvider> lst = ConfigurableActionsProviderImpl.this.providers();
            for (GradleActionsProvider gradleActionsProvider : lst) {
                ActionData ad;
                Set<ActionMapping> defaultMappings;
                HashMap<GradleExecConfiguration, Set<ActionMapping>> mapp;
                block16: {
                    LOG.log(Level.FINER, "Loading defaults from provider {0}", gradleActionsProvider);
                    this.actionIDs.addAll(gradleActionsProvider.getSupportedActions());
                    mapp = new HashMap<GradleExecConfiguration, Set<ActionMapping>>();
                    try {
                        InputStream istm = gradleActionsProvider.defaultActionMapConfig();
                        try {
                            if (istm == null) continue;
                            defaultMappings = ActionMappingScanner.loadMappings(istm, mapp);
                            break block16;
                        }
                        finally {
                            if (istm == null) continue;
                            istm.close();
                        }
                    }
                    catch (IOException | ParserConfigurationException | SAXException ex) {}
                    continue;
                }
                this.currentData = ad = this.actionMap.get("%%DEFAULT%%");
                if (ad == null) {
                    ad = new ActionData(true, GradleExecAccessor.createDefault());
                    this.actionMap.put("%%DEFAULT%%", ad);
                    ad.customizedMappings = ConfigurableActionsProviderImpl.this.loadCustomActions(ad.cfg.getId());
                    LOG.log(Level.FINER, "Loaded customizations for <default>: {0}", ad.customizedMappings.keySet());
                }
                HashSet<String> newEntries = new HashSet<String>();
                for (ActionMapping actionMapping : defaultMappings) {
                    ad.mappings.add(actionMapping);
                    newEntries.add(actionMapping.getName());
                }
                LOG.log(Level.FINER, "Loaded actions: {0}", newEntries);
                for (Map.Entry entry : mapp.entrySet()) {
                    GradleExecConfiguration c = (GradleExecConfiguration)entry.getKey();
                    LOG.log(Level.FINER, "Loading config {0}", c.getId());
                    GradleExecConfiguration existing = this.config.get(c.getId());
                    if (existing != null) {
                        LOG.log(Level.FINER, "Merging {0} with {1}", new Object[]{existing, c});
                        existing = this.mergeConfigurations(existing, c);
                    } else {
                        existing = c;
                    }
                    this.config.put(existing.getId(), existing);
                    ad = this.actionMap.get(existing.getId());
                    if (ad == null) {
                        ad = new ActionData(true, existing);
                        this.actionMap.put(existing.getId(), ad);
                        ad.customizedMappings = ConfigurableActionsProviderImpl.this.loadCustomActions(ad.cfg.getId());
                        LOG.log(Level.FINER, "Loaded customizations for config {1}: {0}", new Object[]{ad.customizedMappings.keySet(), existing.getId()});
                    }
                    newEntries = new HashSet();
                    for (ActionMapping m : (Set)entry.getValue()) {
                        ad.mappings.add(m);
                        newEntries.add(m.getName());
                    }
                    LOG.log(Level.FINER, "Loaded config actions: {0}", newEntries);
                }
            }
        }

        private GradleExecConfiguration mergeConfigurations(GradleExecConfiguration one, GradleExecConfiguration two) {
            String dispName = one.getName();
            HashMap<String, String> props = new HashMap<String, String>(one.getProjectProperties());
            props.putAll(two.getProjectProperties());
            String args = String.join((CharSequence)" ", one.getCommandLineArgs(), two.getCommandLineArgs());
            String[] params = ConfigurableActionsProviderImpl.maybeEmpty(one.getCommandLineArgs());
            String[] params2 = ConfigurableActionsProviderImpl.maybeEmpty(two.getCommandLineArgs());
            String[] all = new String[params.length + params2.length];
            System.arraycopy(params, 0, all, 0, params.length);
            System.arraycopy(params2, 0, all, params.length, params2.length);
            return GradleExecAccessor.instance().update(one, dispName, props, args);
        }
    }
}

