/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.AnnoConstruct;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TypeMetadata;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.jvm.PoolConstant;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;

public abstract class Type
extends AnnoConstruct
implements TypeMirror,
PoolConstant {
    protected final List<TypeMetadata> metadata;
    public static final JCNoType noType = new JCNoType(){

        @Override
        public String toString() {
            return "none";
        }
    };
    public static final JCNoType recoveryType = new JCNoType(){

        @Override
        public String toString() {
            return "recovery";
        }
    };
    public static final JCNoType stuckType = new JCNoType(){

        @Override
        public String toString() {
            return "stuck";
        }
    };
    public static boolean moreInfo = false;
    public Symbol.TypeSymbol tsym;
    private static final Types.TypeMapping<Void> stripMetadata = new StructuralTypeMapping<Void>(){

        @Override
        public Type visitClassType(ClassType t, Void aVoid) {
            return super.visitClassType((ClassType)4.dropMetadata(t), aVoid);
        }

        @Override
        public Type visitArrayType(ArrayType t, Void aVoid) {
            return super.visitArrayType((ArrayType)4.dropMetadata(t), aVoid);
        }

        @Override
        public Type visitWildcardType(WildcardType wt, Void aVoid) {
            return super.visitWildcardType((WildcardType)4.dropMetadata(wt), aVoid);
        }

        @Override
        public Type visitType(Type t, Void aVoid) {
            return 4.dropMetadata(t);
        }

        private static Type dropMetadata(Type t) {
            if (t.getMetadata().isEmpty()) {
                return t;
            }
            Type baseType = t.baseType();
            if (baseType.getMetadata().isEmpty()) {
                return baseType;
            }
            return baseType.cloneWithMetadata(List.nil());
        }
    };

    @Override
    public int poolTag() {
        throw new AssertionError((Object)"Invalid pool entry");
    }

    @Override
    public Object poolKey(Types types) {
        return new Types.UniqueType(this, types);
    }

    public boolean hasTag(TypeTag tag) {
        return tag == this.getTag();
    }

    public abstract TypeTag getTag();

    public boolean isNumeric() {
        return false;
    }

    public boolean isIntegral() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isPrimitiveOrVoid() {
        return false;
    }

    public boolean isReference() {
        return false;
    }

    public boolean isNullOrReference() {
        return false;
    }

    public boolean isPartial() {
        return false;
    }

    public Object constValue() {
        return this.getMetadata(TypeMetadata.ConstantValue.class, TypeMetadata.ConstantValue::value, null);
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    public Type getModelType() {
        return this;
    }

    public static List<Type> getModelTypes(List<Type> ts) {
        ListBuffer<Type> lb = new ListBuffer<Type>();
        for (Type t : ts) {
            lb.append(t.getModelType());
        }
        return lb.toList();
    }

    public Type getOriginalType() {
        return this;
    }

    public <R, S> R accept(Visitor<R, S> v, S s) {
        return v.visitType(this, s);
    }

    public Type(Symbol.TypeSymbol tsym, List<TypeMetadata> metadata) {
        Assert.checkNonNull(metadata);
        this.tsym = tsym;
        this.metadata = metadata;
    }

    public <Z> Type map(Types.TypeMapping<Z> mapping, Z arg) {
        return (Type)mapping.visit(this, arg);
    }

    public <Z> Type map(Types.TypeMapping<Z> mapping) {
        return (Type)mapping.visit(this, null);
    }

    public Type constType(Object constValue) {
        throw new AssertionError();
    }

    public Type baseType() {
        return this;
    }

    protected Type typeNoMetadata() {
        return this.metadata.isEmpty() ? this : this.stripMetadata();
    }

    protected Type cloneWithMetadata(List<TypeMetadata> metadata) {
        throw new AssertionError((Object)("Cannot add metadata to this type: " + String.valueOf((Object)this.getTag())));
    }

    public List<TypeMetadata> getMetadata() {
        return this.metadata;
    }

    public <M extends TypeMetadata> M getMetadata(Class<M> metadataClass) {
        return (M)((TypeMetadata)this.getMetadata(metadataClass, Function.identity(), null));
    }

    public <M extends TypeMetadata, Z> Z getMetadata(Class<M> metadataClass, Function<M, Z> metadataFunc, Z defaultValue) {
        for (TypeMetadata m : this.metadata) {
            if (m.getClass() != metadataClass) continue;
            return metadataFunc.apply(m);
        }
        return defaultValue;
    }

    public Type addMetadata(TypeMetadata md) {
        Assert.check(this.getMetadata(md.getClass()) == null);
        return this.cloneWithMetadata(this.metadata.prepend(md));
    }

    public Type dropMetadata(Class<? extends TypeMetadata> metadataClass) {
        List<TypeMetadata> newMetadata = List.nil();
        for (TypeMetadata m : this.metadata) {
            if (m.getClass() == metadataClass) continue;
            newMetadata = newMetadata.prepend(m);
        }
        return this.cloneWithMetadata(newMetadata);
    }

    protected boolean needsStripping() {
        return false;
    }

    public Type stripMetadataIfNeeded() {
        return this.needsStripping() ? (Type)this.accept(stripMetadata, null) : this;
    }

    public Type stripMetadata() {
        return (Type)this.accept(stripMetadata, null);
    }

    public Type preannotatedType() {
        return this.addMetadata(new TypeMetadata.Annotations());
    }

    public Type annotatedType(List<Attribute.TypeCompound> annos) {
        return this.addMetadata(new TypeMetadata.Annotations(annos));
    }

    public boolean isAnnotated() {
        return this.getMetadata(TypeMetadata.Annotations.class) != null;
    }

    @Override
    public List<Attribute.TypeCompound> getAnnotationMirrors() {
        return this.getMetadata(TypeMetadata.Annotations.class, TypeMetadata.Annotations::annotations, List.nil());
    }

    public static List<Type> baseTypes(List<Type> ts) {
        if (ts.nonEmpty()) {
            Type t = ((Type)ts.head).baseType();
            List<Type> baseTypes = Type.baseTypes(ts.tail);
            if (t != ts.head || baseTypes != ts.tail) {
                return baseTypes.prepend(t);
            }
        }
        return ts;
    }

    protected void appendAnnotationsString(StringBuilder sb, boolean prefix) {
        if (this.isAnnotated()) {
            if (prefix) {
                sb.append(" ");
            }
            sb.append(((List)this.getAnnotationMirrors()).toString(" "));
            sb.append(" ");
        }
    }

    protected void appendAnnotationsString(StringBuilder sb) {
        this.appendAnnotationsString(sb, false);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAnnotationsString(sb);
        if (this.tsym == null || this.tsym.name == null) {
            sb.append("<none>");
        } else {
            sb.append(this.tsym.name.toString());
        }
        if (moreInfo && this.hasTag(TypeTag.TYPEVAR)) {
            sb.append(this.hashCode());
        }
        return sb.toString();
    }

    public static String toString(List<Type> ts) {
        if (ts.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(((Type)ts.head).toString());
        List l = ts.tail;
        while (l.nonEmpty()) {
            buf.append(",").append(((Type)l.head).toString());
            l = l.tail;
        }
        return buf.toString();
    }

    public String stringValue() {
        Object cv = Assert.checkNonNull(this.constValue());
        return cv.toString();
    }

    @Override
    public boolean equals(Object t) {
        return this == t;
    }

    public boolean equalsIgnoreMetadata(Type t) {
        return this.typeNoMetadata().equals(t.typeNoMetadata());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String argtypes(boolean varargs) {
        List<Type> args = this.getParameterTypes();
        if (!varargs) {
            return args.toString();
        }
        StringBuilder buf = new StringBuilder();
        while (args.tail.nonEmpty()) {
            buf.append(args.head);
            args = args.tail;
            buf.append(',');
        }
        if (((Type)args.head).hasTag(TypeTag.ARRAY)) {
            buf.append(((ArrayType)args.head).elemtype);
            if (((List)((Type)args.head).getAnnotationMirrors()).nonEmpty()) {
                buf.append(((Type)args.head).getAnnotationMirrors());
            }
            buf.append("...");
        } else {
            buf.append(args.head);
        }
        return buf.toString();
    }

    public List<Type> getTypeArguments() {
        return List.nil();
    }

    public Type getEnclosingType() {
        return null;
    }

    public List<Type> getParameterTypes() {
        return List.nil();
    }

    public Type getReturnType() {
        return null;
    }

    public Type getReceiverType() {
        return null;
    }

    public List<Type> getThrownTypes() {
        return List.nil();
    }

    public Type getUpperBound() {
        return null;
    }

    public Type getLowerBound() {
        return null;
    }

    public List<Type> allparams() {
        return List.nil();
    }

    public boolean isErroneous() {
        return false;
    }

    public static boolean isErroneous(List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (((Type)l.head).isErroneous()) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    public boolean isParameterized() {
        return false;
    }

    public boolean isRaw() {
        return false;
    }

    public boolean isCompound() {
        return false;
    }

    public boolean isIntersection() {
        return false;
    }

    public boolean isUnion() {
        return false;
    }

    public boolean isInterface() {
        return (this.tsym.flags() & 0x200L) != 0L;
    }

    public boolean isFinal() {
        return (this.tsym.flags() & 0x10L) != 0L;
    }

    public boolean isValueBased() {
        return this.tsym != null && (this.tsym.flags_field & 0x20000000000000L) != 0L;
    }

    public boolean contains(Type t) {
        return t.equalsIgnoreMetadata(this);
    }

    public static boolean contains(List<Type> ts, Type t) {
        List<Type> l = ts;
        while (l.tail != null) {
            if (((Type)l.head).contains(t)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    public boolean containsAny(List<Type> ts) {
        for (Type t : ts) {
            if (!this.contains(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(List<Type> ts1, List<Type> ts2) {
        for (Type t : ts1) {
            if (!t.containsAny(ts2)) continue;
            return true;
        }
        return false;
    }

    public static List<Type> filter(List<Type> ts, Predicate<Type> tf) {
        ListBuffer<Type> buf = new ListBuffer<Type>();
        for (Type t : ts) {
            if (!tf.test(t)) continue;
            buf.append(t);
        }
        return buf.toList();
    }

    public boolean isSuperBound() {
        return false;
    }

    public boolean isExtendsBound() {
        return false;
    }

    public boolean isUnbound() {
        return false;
    }

    public Type withTypeVar(Type t) {
        return this;
    }

    public MethodType asMethodType() {
        throw new AssertionError();
    }

    public void complete() {
    }

    public Symbol.TypeSymbol asElement() {
        return this.tsym;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.OTHER;
    }

    @Override
    public <R, P> R accept(TypeVisitor<R, P> v, P p) {
        throw new AssertionError();
    }

    public static interface Visitor<R, S> {
        public R visitClassType(ClassType var1, S var2);

        public R visitWildcardType(WildcardType var1, S var2);

        public R visitArrayType(ArrayType var1, S var2);

        public R visitMethodType(MethodType var1, S var2);

        public R visitPackageType(PackageType var1, S var2);

        public R visitModuleType(ModuleType var1, S var2);

        public R visitTypeVar(TypeVar var1, S var2);

        public R visitCapturedType(CapturedType var1, S var2);

        public R visitForAll(ForAll var1, S var2);

        public R visitUndetVar(UndetVar var1, S var2);

        public R visitErrorType(ErrorType var1, S var2);

        public R visitType(Type var1, S var2);
    }

    public static class ArrayType
    extends Type
    implements PoolConstant.LoadableConstant,
    javax.lang.model.type.ArrayType {
        public Type elemtype;

        public ArrayType(Type elemtype, Symbol.TypeSymbol arrayClass) {
            this(elemtype, arrayClass, List.nil());
        }

        public ArrayType(Type elemtype, Symbol.TypeSymbol arrayClass, List<TypeMetadata> metadata) {
            super(arrayClass, metadata);
            this.elemtype = elemtype;
        }

        public ArrayType(ArrayType that) {
            this(that.elemtype, that.tsym, that.getMetadata());
        }

        @Override
        public int poolTag() {
            return 7;
        }

        @Override
        protected ArrayType cloneWithMetadata(List<TypeMetadata> md) {
            return new ArrayType(this.elemtype, this.tsym, md){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.ARRAY;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitArrayType(this, s);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Type t = this.elemtype;
            while (t.getKind() == TypeKind.ARRAY) {
                t = ((ArrayType)t).getComponentType();
            }
            sb.append(t);
            t = this;
            do {
                t.appendAnnotationsString(sb, true);
                sb.append("[]");
            } while ((t = ((ArrayType)t).getComponentType()).getKind() == TypeKind.ARRAY);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            ArrayType arrayType;
            return obj instanceof ArrayType && (this == (arrayType = (ArrayType)obj) || this.elemtype.equals(arrayType.elemtype));
        }

        @Override
        public int hashCode() {
            return (TypeTag.ARRAY.ordinal() << 5) + this.elemtype.hashCode();
        }

        public boolean isVarargs() {
            return false;
        }

        @Override
        public List<Type> allparams() {
            return this.elemtype.allparams();
        }

        @Override
        public boolean isErroneous() {
            return this.elemtype.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.elemtype.isParameterized();
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public boolean isRaw() {
            return this.elemtype.isRaw();
        }

        public ArrayType makeVarargs() {
            return new ArrayType(this.elemtype, this.tsym, this.metadata){

                @Override
                public boolean isVarargs() {
                    return true;
                }
            };
        }

        @Override
        public boolean contains(Type elem) {
            return elem.equalsIgnoreMetadata(this) || this.elemtype.contains(elem);
        }

        @Override
        public void complete() {
            this.elemtype.complete();
        }

        @Override
        public Type getComponentType() {
            return this.elemtype;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.ARRAY;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitArray(this, p);
        }
    }

    public static class JCNoType
    extends Type
    implements NoType {
        public JCNoType() {
            super(null, List.nil());
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.NONE;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.NONE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }

        @Override
        public boolean isCompound() {
            return false;
        }
    }

    public static class ErrorType
    extends ClassType
    implements javax.lang.model.type.ErrorType {
        private Type originalType = null;

        public ErrorType(Symbol.ClassSymbol c, Type originalType) {
            this(originalType, c);
            c.type = this;
            c.kind = Kinds.Kind.ERR;
            c.members_field = new Scope.ErrorScope(c);
        }

        public ErrorType(Type originalType, Symbol.TypeSymbol tsym) {
            super(noType, List.nil(), null);
            this.tsym = tsym;
            this.originalType = originalType == null ? noType : originalType;
        }

        public ErrorType(Type originalType, Symbol.TypeSymbol tsym, List<TypeMetadata> metadata) {
            super(noType, List.nil(), null, metadata);
            this.tsym = tsym;
            this.originalType = originalType == null ? noType : originalType;
        }

        @Override
        protected ErrorType cloneWithMetadata(List<TypeMetadata> md) {
            return new ErrorType(this.originalType, this.tsym, md){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.ERROR;
        }

        @Override
        public boolean isPartial() {
            return true;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        public ErrorType(Name name, Symbol.TypeSymbol container, Type originalType) {
            this(new Symbol.ClassSymbol(0x40000009L, name, null, container), originalType);
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitErrorType(this, s);
        }

        @Override
        public Type constType(Object constValue) {
            return this;
        }

        @Override
        public Type getEnclosingType() {
            return noType;
        }

        @Override
        public Type getReturnType() {
            return this;
        }

        public Type asSub(Symbol sym) {
            return this;
        }

        public boolean isGenType(Type t) {
            return true;
        }

        @Override
        public boolean isErroneous() {
            return true;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public boolean isInterface() {
            return false;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.ERROR;
        }

        @Override
        public Type getOriginalType() {
            return this.originalType;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitError(this, p);
        }
    }

    static class BottomType
    extends Type
    implements NullType {
        public BottomType() {
            super(null, List.nil());
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.BOT;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.NULL;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNull(this, p);
        }

        @Override
        public Type constType(Object value) {
            return this;
        }

        @Override
        public String stringValue() {
            return "null";
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }
    }

    public static class JCVoidType
    extends Type
    implements NoType {
        public JCVoidType() {
            super(null, List.nil());
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.VOID;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.VOID;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }

        @Override
        public boolean isPrimitiveOrVoid() {
            return true;
        }
    }

    public static class UndetVar
    extends DelegatedType {
        public ArrayDeque<Infer.IncorporationAction> incorporationActions = new ArrayDeque();
        protected Map<InferenceBound, List<Type>> bounds;
        private Type inst = null;
        public int declaredCount;
        public UndetVarListener listener = null;
        Kind kind;
        Types.TypeMapping<Void> toTypeVarMap = new StructuralTypeMapping<Void>(){

            @Override
            public Type visitUndetVar(UndetVar uv, Void _unused) {
                return uv.inst != null ? uv.inst : uv.qtype;
            }
        };

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitUndetVar(this, s);
        }

        public UndetVar(TypeVar origin, UndetVarListener listener, Types types) {
            super(TypeTag.UNDETVAR, origin);
            this.kind = origin.isCaptured() ? Kind.CAPTURED : Kind.NORMAL;
            this.listener = listener;
            this.bounds = new EnumMap<InferenceBound, List<Type>>(InferenceBound.class);
            List<Type> declaredBounds = types.getBounds(origin);
            this.declaredCount = declaredBounds.length();
            this.bounds.put(InferenceBound.UPPER, List.nil());
            this.bounds.put(InferenceBound.LOWER, List.nil());
            this.bounds.put(InferenceBound.EQ, List.nil());
            for (Type t : declaredBounds.reverse()) {
                this.addBound(InferenceBound.UPPER, t, types, true);
            }
            if (origin.isCaptured() && !origin.lower.hasTag(TypeTag.BOT)) {
                this.addBound(InferenceBound.LOWER, origin.lower, types, true);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAnnotationsString(sb);
            if (this.inst == null) {
                sb.append(this.qtype);
                sb.append('?');
            } else {
                sb.append(this.inst);
            }
            return sb.toString();
        }

        public String debugString() {
            String result = "inference var = " + String.valueOf(this.qtype) + "\n";
            if (this.inst != null) {
                result = result + "inst = " + String.valueOf(this.inst) + "\n";
            }
            for (InferenceBound bound : InferenceBound.values()) {
                List<Type> aboundList = this.bounds.get((Object)bound);
                if (aboundList == null || aboundList.size() <= 0) continue;
                result = result + String.valueOf((Object)bound) + " = " + String.valueOf(aboundList) + "\n";
            }
            return result;
        }

        public void setThrow() {
            if (this.kind == Kind.CAPTURED) {
                throw new IllegalStateException();
            }
            this.kind = Kind.THROWS;
        }

        public void setNormal() {
            Assert.check(this.kind == Kind.CAPTURED);
            this.kind = Kind.NORMAL;
        }

        public UndetVar dup(Types types) {
            UndetVar uv2 = new UndetVar((TypeVar)this.qtype, this.listener, types);
            this.dupTo(uv2, types);
            return uv2;
        }

        public void dupTo(UndetVar uv2, Types types) {
            uv2.listener = null;
            uv2.bounds.clear();
            for (InferenceBound ib : InferenceBound.values()) {
                uv2.bounds.put(ib, List.nil());
                for (Type t : this.getBounds(ib)) {
                    uv2.addBound(ib, t, types, true);
                }
            }
            uv2.inst = this.inst;
            uv2.listener = this.listener;
            uv2.incorporationActions = new ArrayDeque();
            for (Infer.IncorporationAction action : this.incorporationActions) {
                uv2.incorporationActions.add(action.dup(uv2));
            }
            uv2.kind = this.kind;
        }

        @Override
        public boolean isPartial() {
            return true;
        }

        @Override
        public Type baseType() {
            return this.inst == null ? this : this.inst.baseType();
        }

        public Type getInst() {
            return this.inst;
        }

        public void setInst(Type inst) {
            this.inst = inst;
            if (this.listener != null) {
                this.listener.varInstantiated(this);
            }
        }

        public List<Type> getBounds(InferenceBound ... ibs) {
            ListBuffer<Type> buf = new ListBuffer<Type>();
            for (InferenceBound ib : ibs) {
                buf.appendList(this.bounds.get((Object)ib));
            }
            return buf.toList();
        }

        public List<Type> getDeclaredBounds() {
            ListBuffer<Type> buf = new ListBuffer<Type>();
            int count = 0;
            for (Type b : this.getBounds(InferenceBound.UPPER)) {
                if (count++ == this.declaredCount) break;
                buf.append(b);
            }
            return buf.toList();
        }

        public void setBounds(InferenceBound ib, List<Type> newBounds) {
            this.bounds.put(ib, newBounds);
        }

        public final void addBound(InferenceBound ib, Type bound, Types types) {
            this.addBound(ib, bound, types, false);
        }

        private void addBound(InferenceBound ib, Type bound, Types types, boolean update) {
            if (this.kind == Kind.CAPTURED && !update) {
                if (bound.hasTag(TypeTag.UNDETVAR) && !((UndetVar)bound).isCaptured()) {
                    ((UndetVar)bound).addBound(ib.complement(), this, types, false);
                }
            } else {
                Type bound2 = bound.map(this.toTypeVarMap).baseType();
                List<Type> prevBounds = this.bounds.get((Object)ib);
                if (bound == this.qtype) {
                    return;
                }
                for (Type b : prevBounds) {
                    if (!types.isSameType(b, bound2)) continue;
                    return;
                }
                this.bounds.put(ib, prevBounds.prepend(bound2));
                this.notifyBoundChange(ib, bound2, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void substBounds(List<Type> from, List<Type> to, Types types) {
            ListBuffer boundsChanged = new ListBuffer();
            UndetVarListener prevListener = this.listener;
            try {
                this.listener = (uv, ib, t, _ignored) -> {
                    Assert.check(uv == this);
                    boundsChanged.add(new Pair<InferenceBound, Type>(ib, t));
                };
                for (Map.Entry<InferenceBound, List<Type>> _entry : this.bounds.entrySet()) {
                    InferenceBound ib2 = _entry.getKey();
                    List<Type> prevBounds = _entry.getValue();
                    ListBuffer<Type> newBounds = new ListBuffer<Type>();
                    ListBuffer<Type> deps = new ListBuffer<Type>();
                    for (Type t2 : prevBounds) {
                        if (!t2.containsAny(from)) {
                            newBounds.append(t2);
                            continue;
                        }
                        deps.append(t2);
                    }
                    this.bounds.put(ib2, newBounds.toList());
                    for (Type dep : deps) {
                        this.addBound(ib2, types.subst(dep, from, to), types, true);
                    }
                }
                this.listener = prevListener;
            }
            catch (Throwable throwable) {
                this.listener = prevListener;
                for (Pair boundUpdate : boundsChanged) {
                    this.notifyBoundChange((InferenceBound)((Object)boundUpdate.fst), (Type)boundUpdate.snd, true);
                }
                throw throwable;
            }
            for (Pair boundUpdate : boundsChanged) {
                this.notifyBoundChange((InferenceBound)((Object)boundUpdate.fst), (Type)boundUpdate.snd, true);
            }
        }

        private void notifyBoundChange(InferenceBound ib, Type bound, boolean update) {
            if (this.listener != null) {
                this.listener.varBoundChanged(this, ib, bound, update);
            }
        }

        public final boolean isCaptured() {
            return this.kind == Kind.CAPTURED;
        }

        public final boolean isThrows() {
            return this.kind == Kind.THROWS;
        }

        public static interface UndetVarListener {
            public void varBoundChanged(UndetVar var1, InferenceBound var2, Type var3, boolean var4);

            default public void varInstantiated(UndetVar uv) {
                Assert.error();
            }
        }

        static enum Kind {
            NORMAL,
            CAPTURED,
            THROWS;

        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum InferenceBound {
            LOWER{

                @Override
                public InferenceBound complement() {
                    return UPPER;
                }
            }
            ,
            EQ{

                @Override
                public InferenceBound complement() {
                    return EQ;
                }
            }
            ,
            UPPER{

                @Override
                public InferenceBound complement() {
                    return LOWER;
                }
            };


            public abstract InferenceBound complement();

            public boolean lessThan(InferenceBound that) {
                if (that == this) {
                    return false;
                }
                switch (that.ordinal()) {
                    case 2: {
                        return true;
                    }
                    case 0: {
                        return false;
                    }
                    case 1: {
                        return this != UPPER;
                    }
                }
                Assert.error("Cannot get here!");
                return false;
            }
        }
    }

    public static class ForAll
    extends DelegatedType
    implements ExecutableType {
        public List<Type> tvars;

        public ForAll(List<Type> tvars, Type qtype) {
            super(TypeTag.FORALL, (MethodType)qtype);
            this.tvars = tvars;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitForAll(this, s);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAnnotationsString(sb);
            sb.append('<');
            sb.append(this.tvars);
            sb.append('>');
            sb.append(this.qtype);
            return sb.toString();
        }

        @Override
        public List<Type> getTypeArguments() {
            return this.tvars;
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }

        @Override
        public boolean contains(Type elem) {
            return this.qtype.contains(elem);
        }

        @Override
        public MethodType asMethodType() {
            return (MethodType)this.qtype;
        }

        @Override
        public void complete() {
            List<Type> l = this.tvars;
            while (l.nonEmpty()) {
                ((TypeVar)l.head).getUpperBound().complete();
                l = l.tail;
            }
            this.qtype.complete();
        }

        public List<TypeVar> getTypeVariables() {
            return List.convert(TypeVar.class, this.getTypeArguments());
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.EXECUTABLE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitExecutable(this, p);
        }
    }

    public static abstract class DelegatedType
    extends Type {
        public Type qtype;
        public TypeTag tag;

        public DelegatedType(TypeTag tag, Type qtype) {
            this(tag, qtype, List.nil());
        }

        public DelegatedType(TypeTag tag, Type qtype, List<TypeMetadata> metadata) {
            super(qtype.tsym, metadata);
            this.tag = tag;
            this.qtype = qtype;
        }

        @Override
        public TypeTag getTag() {
            return this.tag;
        }

        @Override
        public String toString() {
            return this.qtype.toString();
        }

        @Override
        public List<Type> getTypeArguments() {
            return this.qtype.getTypeArguments();
        }

        @Override
        public Type getEnclosingType() {
            return this.qtype.getEnclosingType();
        }

        @Override
        public List<Type> getParameterTypes() {
            return this.qtype.getParameterTypes();
        }

        @Override
        public Type getReturnType() {
            return this.qtype.getReturnType();
        }

        @Override
        public Type getReceiverType() {
            return this.qtype.getReceiverType();
        }

        @Override
        public List<Type> getThrownTypes() {
            return this.qtype.getThrownTypes();
        }

        @Override
        public List<Type> allparams() {
            return this.qtype.allparams();
        }

        @Override
        public Type getUpperBound() {
            return this.qtype.getUpperBound();
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }
    }

    public static class CapturedType
    extends TypeVar {
        public WildcardType wildcard;

        public CapturedType(Name name, Symbol owner, Type upper, Type lower, WildcardType wildcard) {
            super(name, owner, lower);
            this.lower = Assert.checkNonNull(lower);
            this.setUpperBound(upper);
            this.wildcard = wildcard;
        }

        public CapturedType(Symbol.TypeSymbol tsym, Type bound, Type upper, Type lower, WildcardType wildcard, List<TypeMetadata> metadata) {
            super(tsym, bound, lower, metadata);
            this.wildcard = wildcard;
        }

        @Override
        protected CapturedType cloneWithMetadata(List<TypeMetadata> md) {
            return new CapturedType(this.tsym, this.getUpperBound(), this.getUpperBound(), this.lower, this.wildcard, md){

                @Override
                public Type baseType() {
                    return this.baseType();
                }

                @Override
                public Type getUpperBound() {
                    return this.getUpperBound();
                }

                @Override
                public void setUpperBound(Type bound) {
                    this.setUpperBound(bound);
                }
            };
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitCapturedType(this, s);
        }

        @Override
        public boolean isCaptured() {
            return true;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAnnotationsString(sb);
            sb.append("capture#");
            sb.append(((long)this.hashCode() & 0xFFFFFFFFL) % 997L);
            sb.append(" of ");
            sb.append(this.wildcard);
            return sb.toString();
        }
    }

    public static class TypeVar
    extends Type
    implements TypeVariable {
        private Type _bound = null;
        public Type lower;
        int rank_field = -1;

        public TypeVar(Name name, Symbol owner, Type lower) {
            super(null, List.nil());
            Assert.checkNonNull(lower);
            this.tsym = new Symbol.TypeVariableSymbol(0L, name, this, owner);
            this.setUpperBound(null);
            this.lower = lower;
        }

        public TypeVar(Symbol.TypeSymbol tsym, Type bound, Type lower) {
            this(tsym, bound, lower, List.nil());
        }

        public TypeVar(Symbol.TypeSymbol tsym, Type bound, Type lower, List<TypeMetadata> metadata) {
            super(tsym, metadata);
            Assert.checkNonNull(lower);
            this.setUpperBound(bound);
            this.lower = lower;
        }

        @Override
        protected TypeVar cloneWithMetadata(List<TypeMetadata> md) {
            return new TypeVar(this.tsym, this.getUpperBound(), this.lower, md){

                @Override
                public Type baseType() {
                    return this.baseType();
                }

                @Override
                public Type getUpperBound() {
                    return this.getUpperBound();
                }

                @Override
                public void setUpperBound(Type bound) {
                    this.setUpperBound(bound);
                }
            };
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.TYPEVAR;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitTypeVar(this, s);
        }

        @Override
        public Type getUpperBound() {
            return this._bound;
        }

        public void setUpperBound(Type bound) {
            this._bound = bound;
        }

        @Override
        public Type getLowerBound() {
            return this.lower;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.TYPEVAR;
        }

        public boolean isCaptured() {
            return false;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitTypeVariable(this, p);
        }
    }

    public static class ModuleType
    extends Type
    implements NoType {
        ModuleType(Symbol.ModuleSymbol tsym) {
            super(tsym, List.nil());
        }

        @Override
        public ModuleType annotatedType(List<Attribute.TypeCompound> annos) {
            throw new AssertionError((Object)"Cannot annotate a module type");
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.MODULE;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitModuleType(this, s);
        }

        @Override
        public String toString() {
            return this.tsym.getQualifiedName().toString();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.MODULE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }
    }

    public static class PackageType
    extends Type
    implements NoType {
        PackageType(Symbol.PackageSymbol tsym) {
            super(tsym, List.nil());
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.PACKAGE;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitPackageType(this, s);
        }

        @Override
        public String toString() {
            return this.tsym.getQualifiedName().toString();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.PACKAGE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }
    }

    public static class MethodType
    extends Type
    implements ExecutableType,
    PoolConstant.LoadableConstant {
        public List<Type> argtypes;
        public Type restype;
        public List<Type> thrown;
        public Type recvtype;

        public MethodType(List<Type> argtypes, Type restype, List<Type> thrown, Symbol.TypeSymbol methodClass) {
            super(methodClass, List.nil());
            this.argtypes = argtypes;
            this.restype = restype;
            this.thrown = thrown;
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.METHOD;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitMethodType(this, s);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAnnotationsString(sb);
            sb.append('(');
            sb.append(this.argtypes);
            sb.append(')');
            sb.append(this.restype);
            return sb.toString();
        }

        @Override
        public List<Type> getParameterTypes() {
            return this.argtypes;
        }

        @Override
        public Type getReturnType() {
            return this.restype;
        }

        @Override
        public Type getReceiverType() {
            return this.recvtype == null ? noType : this.recvtype;
        }

        @Override
        public List<Type> getThrownTypes() {
            return this.thrown;
        }

        @Override
        public boolean isErroneous() {
            return MethodType.isErroneous(this.argtypes) || this.restype != null && this.restype.isErroneous();
        }

        @Override
        public int poolTag() {
            return 16;
        }

        @Override
        public boolean contains(Type elem) {
            return elem.equalsIgnoreMetadata(this) || MethodType.contains(this.argtypes, elem) || this.restype.contains(elem) || MethodType.contains(this.thrown, elem);
        }

        @Override
        public MethodType asMethodType() {
            return this;
        }

        @Override
        public void complete() {
            List<Type> l = this.argtypes;
            while (l.nonEmpty()) {
                ((Type)l.head).complete();
                l = l.tail;
            }
            this.restype.complete();
            this.recvtype.complete();
            l = this.thrown;
            while (l.nonEmpty()) {
                ((Type)l.head).complete();
                l = l.tail;
            }
        }

        public List<TypeVar> getTypeVariables() {
            return List.nil();
        }

        @Override
        public Symbol.TypeSymbol asElement() {
            return null;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.EXECUTABLE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitExecutable(this, p);
        }
    }

    public static class IntersectionClassType
    extends ClassType
    implements IntersectionType {
        public boolean allInterfaces;

        public IntersectionClassType(List<Type> bounds, Symbol.ClassSymbol csym, boolean allInterfaces) {
            super(noType, List.nil(), csym);
            this.allInterfaces = allInterfaces;
            Assert.check((csym.flags() & 0x1000000L) != 0L);
            this.supertype_field = (Type)bounds.head;
            this.interfaces_field = bounds.tail;
            Assert.check(!this.supertype_field.tsym.isCompleted() || !this.supertype_field.isInterface(), this.supertype_field);
        }

        @Override
        public java.util.List<? extends TypeMirror> getBounds() {
            return Collections.unmodifiableList(this.getExplicitComponents());
        }

        @Override
        public boolean isCompound() {
            return true;
        }

        public List<Type> getComponents() {
            return this.interfaces_field.prepend(this.supertype_field);
        }

        @Override
        public boolean isIntersection() {
            return true;
        }

        public List<Type> getExplicitComponents() {
            return this.allInterfaces ? this.interfaces_field : this.getComponents();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.INTERSECTION;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitIntersection(this, p);
        }
    }

    public static class UnionClassType
    extends ClassType
    implements UnionType {
        final List<? extends Type> alternatives_field;

        public UnionClassType(ClassType ct, List<? extends Type> alternatives) {
            super(ct.outer_field, ct.typarams_field, ct.tsym);
            this.allparams_field = ct.allparams_field;
            this.supertype_field = ct.supertype_field;
            this.interfaces_field = ct.interfaces_field;
            this.all_interfaces_field = ct.interfaces_field;
            this.alternatives_field = alternatives;
        }

        public Type getLub() {
            return this.tsym.type;
        }

        @Override
        public java.util.List<? extends TypeMirror> getAlternatives() {
            return Collections.unmodifiableList(this.alternatives_field);
        }

        @Override
        public boolean isUnion() {
            return true;
        }

        @Override
        public boolean isCompound() {
            return this.getLub().isCompound();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.UNION;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitUnion(this, p);
        }

        public Iterable<? extends Type> getAlternativeTypes() {
            return this.alternatives_field;
        }
    }

    public static class ErasedClassType
    extends ClassType {
        public ErasedClassType(Type outer, Symbol.TypeSymbol tsym, List<TypeMetadata> metadata) {
            super(outer, List.nil(), tsym, metadata);
        }

        @Override
        public boolean hasErasedSupertypes() {
            return true;
        }
    }

    public static class ClassType
    extends Type
    implements DeclaredType,
    PoolConstant.LoadableConstant,
    javax.lang.model.type.ErrorType {
        private Type outer_field;
        public List<Type> typarams_field;
        public List<Type> allparams_field;
        public Type supertype_field;
        public List<Type> interfaces_field;
        public List<Type> all_interfaces_field;
        int rank_field = -1;

        public ClassType(Type outer, List<Type> typarams, Symbol.TypeSymbol tsym) {
            this(outer, typarams, tsym, List.nil());
        }

        public ClassType(Type outer, List<Type> typarams, Symbol.TypeSymbol tsym, List<TypeMetadata> metadata) {
            super(tsym, metadata);
            this.outer_field = outer;
            this.typarams_field = typarams;
            this.allparams_field = null;
            this.supertype_field = null;
            this.interfaces_field = null;
        }

        @Override
        public int poolTag() {
            return 7;
        }

        @Override
        protected ClassType cloneWithMetadata(List<TypeMetadata> md) {
            return new ClassType(this.outer_field, this.typarams_field, this.tsym, md){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.CLASS;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitClassType(this, s);
        }

        @Override
        public Type constType(Object constValue) {
            return this.addMetadata(new TypeMetadata.ConstantValue(constValue));
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.getEnclosingType().hasTag(TypeTag.CLASS) && this.tsym.owner.kind == Kinds.Kind.TYP) {
                buf.append(this.getEnclosingType().toString());
                buf.append(".");
                this.appendAnnotationsString(buf);
                buf.append(this.className(this.tsym, false));
            } else if (this.isAnnotated()) {
                if (!this.tsym.packge().isUnnamed()) {
                    buf.append(this.tsym.packge());
                    buf.append(".");
                }
                ListBuffer<Name> names = new ListBuffer<Name>();
                Symbol sym = this.tsym.owner;
                while (sym != null && sym.kind == Kinds.Kind.TYP) {
                    names.prepend(sym.name);
                    sym = sym.owner;
                }
                for (Name name : names) {
                    buf.append(name);
                    buf.append(".");
                }
                this.appendAnnotationsString(buf);
                buf.append(this.tsym.name);
            } else {
                buf.append(this.className(this.tsym, true));
            }
            if (((List)this.getTypeArguments()).nonEmpty()) {
                buf.append('<');
                buf.append(((List)this.getTypeArguments()).toString());
                buf.append(">");
            }
            return buf.toString();
        }

        private String className(Symbol sym, boolean longform) {
            if (sym.name.length() == 0 && (sym.flags() & 0x1000000L) != 0L) {
                StringBuilder s = new StringBuilder(this.supertype_field.toString());
                List<Type> is = this.interfaces_field;
                while (is.nonEmpty()) {
                    s.append("&");
                    s.append(((Type)is.head).toString());
                    is = is.tail;
                }
                return s.toString();
            }
            if (sym.name.length() == 0) {
                ClassType norm = (ClassType)this.tsym.type;
                Object s = norm == null ? Log.getLocalizedString("anonymous.class", new Object[]{null}) : (norm.interfaces_field != null && norm.interfaces_field.nonEmpty() ? Log.getLocalizedString("anonymous.class", norm.interfaces_field.head) : Log.getLocalizedString("anonymous.class", norm.supertype_field));
                if (moreInfo) {
                    s = (String)s + String.valueOf(sym.hashCode());
                }
                return s;
            }
            if (longform) {
                sym.apiComplete();
                return sym.getQualifiedName().toString();
            }
            return sym.name.toString();
        }

        @Override
        public List<Type> getTypeArguments() {
            if (this.typarams_field == null) {
                this.complete();
                if (this.typarams_field == null) {
                    this.typarams_field = List.nil();
                }
            }
            return this.typarams_field;
        }

        public boolean hasErasedSupertypes() {
            return this.isRaw();
        }

        @Override
        public Type getEnclosingType() {
            return this.outer_field;
        }

        public void setEnclosingType(Type outer) {
            this.outer_field = outer;
        }

        @Override
        public List<Type> allparams() {
            if (this.allparams_field == null) {
                this.allparams_field = ((List)this.getTypeArguments()).prependList(this.getEnclosingType().allparams());
            }
            return this.allparams_field;
        }

        @Override
        public boolean isErroneous() {
            return this.getEnclosingType().isErroneous() || ClassType.isErroneous((List<Type>)this.getTypeArguments()) || this != this.tsym.type && this.tsym.type.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.allparams().tail != null;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public boolean isRaw() {
            return this != this.tsym.type && this.tsym.type.allparams().nonEmpty() && this.allparams().isEmpty();
        }

        @Override
        public boolean contains(Type elem) {
            return elem.equalsIgnoreMetadata(this) || this.isParameterized() && (this.getEnclosingType().contains(elem) || ClassType.contains((List<Type>)this.getTypeArguments(), elem)) || this.isCompound() && (this.supertype_field.contains(elem) || ClassType.contains(this.interfaces_field, elem));
        }

        @Override
        public void complete() {
            this.tsym.complete();
        }

        @Override
        public TypeKind getKind() {
            this.tsym.apiComplete();
            return this.tsym.kind == Kinds.Kind.TYP ? TypeKind.DECLARED : TypeKind.ERROR;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitDeclared(this, p);
        }
    }

    public static class WildcardType
    extends Type
    implements javax.lang.model.type.WildcardType {
        public Type type;
        public BoundKind kind;
        public TypeVar bound;
        boolean isPrintingBound = false;

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitWildcardType(this, s);
        }

        public WildcardType(Type type, BoundKind kind, Symbol.TypeSymbol tsym) {
            this(type, kind, tsym, null, List.nil());
        }

        public WildcardType(Type type, BoundKind kind, Symbol.TypeSymbol tsym, List<TypeMetadata> metadata) {
            this(type, kind, tsym, null, metadata);
        }

        public WildcardType(Type type, BoundKind kind, Symbol.TypeSymbol tsym, TypeVar bound) {
            this(type, kind, tsym, bound, List.nil());
        }

        public WildcardType(Type type, BoundKind kind, Symbol.TypeSymbol tsym, TypeVar bound, List<TypeMetadata> metadata) {
            super(tsym, metadata);
            this.type = Assert.checkNonNull(type);
            this.kind = kind;
            this.bound = bound;
        }

        @Override
        protected WildcardType cloneWithMetadata(List<TypeMetadata> md) {
            return new WildcardType(this.type, this.kind, this.tsym, this.bound, md){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.WILDCARD;
        }

        @Override
        public boolean contains(Type t) {
            return this.kind != BoundKind.UNBOUND && this.type.contains(t);
        }

        @Override
        public boolean isSuperBound() {
            return this.kind == BoundKind.SUPER || this.kind == BoundKind.UNBOUND;
        }

        @Override
        public boolean isExtendsBound() {
            return this.kind == BoundKind.EXTENDS || this.kind == BoundKind.UNBOUND;
        }

        @Override
        public boolean isUnbound() {
            return this.kind == BoundKind.UNBOUND || this.kind == BoundKind.EXTENDS && this.type.tsym.flatName() == this.type.tsym.name.table.names.java_lang_Object;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public Type withTypeVar(Type t) {
            if (this.bound == t) {
                return this;
            }
            this.bound = (TypeVar)t;
            return this;
        }

        @Override
        public String toString() {
            StringBuilder s = new StringBuilder();
            this.appendAnnotationsString(s);
            s.append(this.kind.toString());
            if (this.kind != BoundKind.UNBOUND) {
                s.append(this.type);
            }
            if (moreInfo && this.bound != null && !this.isPrintingBound) {
                try {
                    this.isPrintingBound = true;
                    s.append("{:").append(this.bound.getUpperBound()).append(":}");
                }
                finally {
                    this.isPrintingBound = false;
                }
            }
            return s.toString();
        }

        @Override
        public Type getExtendsBound() {
            if (this.kind == BoundKind.EXTENDS) {
                return this.type;
            }
            return null;
        }

        @Override
        public Type getSuperBound() {
            if (this.kind == BoundKind.SUPER) {
                return this.type;
            }
            return null;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.WILDCARD;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitWildcard(this, p);
        }
    }

    public static class JCPrimitiveType
    extends Type
    implements PrimitiveType {
        TypeTag tag;

        public JCPrimitiveType(TypeTag tag, Symbol.TypeSymbol tsym) {
            this(tag, tsym, List.nil());
        }

        private JCPrimitiveType(TypeTag tag, Symbol.TypeSymbol tsym, List<TypeMetadata> metadata) {
            super(tsym, metadata);
            this.tag = tag;
            Assert.check(tag.isPrimitive);
        }

        @Override
        protected JCPrimitiveType cloneWithMetadata(List<TypeMetadata> md) {
            return new JCPrimitiveType(this.tag, this.tsym, md){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public boolean isNumeric() {
            return this.tag != TypeTag.BOOLEAN;
        }

        @Override
        public boolean isIntegral() {
            switch (this.tag) {
                case CHAR: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public TypeTag getTag() {
            return this.tag;
        }

        @Override
        public boolean isPrimitiveOrVoid() {
            return true;
        }

        @Override
        public Type constType(Object constValue) {
            return this.addMetadata(new TypeMetadata.ConstantValue(constValue));
        }

        @Override
        public String stringValue() {
            Object cv = Assert.checkNonNull(this.constValue());
            if (this.tag == TypeTag.BOOLEAN) {
                return (Integer)cv == 0 ? "false" : "true";
            }
            if (this.tag == TypeTag.CHAR) {
                return String.valueOf((char)((Integer)cv).intValue());
            }
            return cv.toString();
        }

        @Override
        public boolean isFalse() {
            return this.tag == TypeTag.BOOLEAN && this.constValue() != null && (Integer)this.constValue() == 0;
        }

        @Override
        public boolean isTrue() {
            return this.tag == TypeTag.BOOLEAN && this.constValue() != null && (Integer)this.constValue() != 0;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitPrimitive(this, p);
        }

        @Override
        public TypeKind getKind() {
            switch (this.tag) {
                case BYTE: {
                    return TypeKind.BYTE;
                }
                case CHAR: {
                    return TypeKind.CHAR;
                }
                case SHORT: {
                    return TypeKind.SHORT;
                }
                case INT: {
                    return TypeKind.INT;
                }
                case LONG: {
                    return TypeKind.LONG;
                }
                case FLOAT: {
                    return TypeKind.FLOAT;
                }
                case DOUBLE: {
                    return TypeKind.DOUBLE;
                }
                case BOOLEAN: {
                    return TypeKind.BOOLEAN;
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class StructuralTypeMapping<S>
    extends Types.TypeMapping<S> {
        @Override
        public Type visitClassType(ClassType t, S s) {
            Type outer = t.getEnclosingType();
            Type outer1 = (Type)this.visit(outer, s);
            java.util.List typarams = t.getTypeArguments();
            List<Type> typarams1 = this.visit((List<Type>)typarams, s);
            if (outer1 == outer && typarams1 == typarams) {
                return t;
            }
            return new ClassType(outer1, typarams1, t.tsym, t.metadata){

                @Override
                protected boolean needsStripping() {
                    return true;
                }
            };
        }

        @Override
        public Type visitWildcardType(WildcardType wt, S s) {
            Type t = wt.type;
            if (t != null) {
                t = (Type)this.visit(t, s);
            }
            if (t == wt.type) {
                return wt;
            }
            return new WildcardType(t, wt.kind, wt.tsym, wt.bound, wt.metadata){

                @Override
                protected boolean needsStripping() {
                    return true;
                }
            };
        }

        @Override
        public Type visitArrayType(ArrayType t, S s) {
            Type elemtype = t.elemtype;
            Type elemtype1 = (Type)this.visit(elemtype, s);
            if (elemtype1 == elemtype) {
                return t;
            }
            return new ArrayType(elemtype1, t.tsym, t.metadata){

                @Override
                protected boolean needsStripping() {
                    return true;
                }
            };
        }

        @Override
        public Type visitMethodType(MethodType t, S s) {
            List<Type> argtypes = t.argtypes;
            Type restype = t.restype;
            List<Type> thrown = t.thrown;
            List<Type> argtypes1 = this.visit(argtypes, s);
            Type restype1 = (Type)this.visit(restype, s);
            List<Type> thrown1 = this.visit(thrown, s);
            if (argtypes1 == argtypes && restype1 == restype && thrown1 == thrown) {
                return t;
            }
            return new MethodType(argtypes1, restype1, thrown1, t.tsym){

                @Override
                protected boolean needsStripping() {
                    return true;
                }
            };
        }

        @Override
        public Type visitForAll(ForAll t, S s) {
            return (Type)this.visit(t.qtype, s);
        }
    }
}

