/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.injection.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.javaee.injection.spi.InjectionTargetQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class InjectionTargetQuery {
    private static Lookup.Result<InjectionTargetQueryImplementation> implementations;
    private static List<InjectionTargetQueryImplementation> cache;

    private InjectionTargetQuery() {
    }

    public static boolean isInjectionTarget(CompilationController controller, TypeElement typeElement) {
        if (typeElement == null || controller == null) {
            throw new NullPointerException("Passed null to InjectionTargetQuery.isInjectionTarget(CompilationController, TypeElement)");
        }
        for (InjectionTargetQueryImplementation elem : InjectionTargetQuery.getInstances()) {
            if (!elem.isInjectionTarget(controller, typeElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInjectionTarget(FileObject fileObject, final String className) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final boolean[] result = new boolean[]{false};
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = controller.getElements().getTypeElement(className);
                if (typeElement != null) {
                    result[0] = InjectionTargetQuery.isInjectionTarget(controller, typeElement);
                }
            }
        }, true);
        return result[0];
    }

    public static boolean isStaticReferenceRequired(CompilationController controller, TypeElement typeElement) {
        if (typeElement == null || controller == null) {
            throw new NullPointerException("Passed null to InjectionTargetQuery.isStaticReferenceRequired(CompilationController, TypeElement)");
        }
        for (InjectionTargetQueryImplementation elem : InjectionTargetQuery.getInstances()) {
            if (!elem.isStaticReferenceRequired(controller, typeElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStaticReferenceRequired(FileObject fileObject, final String className) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final boolean[] result = new boolean[]{false};
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = controller.getElements().getTypeElement(className);
                if (typeElement != null) {
                    result[0] = InjectionTargetQuery.isStaticReferenceRequired(controller, typeElement);
                }
            }
        }, true);
        return result[0];
    }

    private static synchronized List<InjectionTargetQueryImplementation> getInstances() {
        if (implementations == null) {
            implementations = Lookup.getDefault().lookup(new Lookup.Template(InjectionTargetQueryImplementation.class));
            implementations.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent ev) {
                    Class<InjectionTargetQuery> clazz = InjectionTargetQuery.class;
                    synchronized (InjectionTargetQuery.class) {
                        cache = null;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
        if (cache == null) {
            cache = new ArrayList<InjectionTargetQueryImplementation>(implementations.allInstances());
        }
        return cache;
    }
}

