/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.Service;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.AbstractKmsCryptoClientBuilder;
import com.oracle.bmc.keymanagement.KmsCryptoClient;
import jakarta.annotation.Nonnull;

public class KmsCryptoClientBuilder
extends AbstractKmsCryptoClientBuilder<KmsCryptoClientBuilder, KmsCryptoClient> {
    public KmsCryptoClientBuilder(Service service) {
        super(service);
    }

    public KmsCryptoClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        if (authenticationDetailsProvider == null) {
            throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
        }
        String cryptoEndpoint = this.getEndpoint();
        KmsCryptoClientBuilder copy = (KmsCryptoClientBuilder)KmsCryptoClient.builder().copyFrom(this).endpoint(cryptoEndpoint);
        return new KmsCryptoClient(copy, authenticationDetailsProvider);
    }
}

