/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.GenericResourceBean;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.netbeans.modules.websvc.rest.wizard.SourceGroupUISupport;
import org.netbeans.modules.websvc.rest.wizard.SourcePanel;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class SingletonSetupPanelVisual
extends JPanel
implements AbstractPanel.Settings,
SourcePanel {
    private Project project;
    private List<ChangeListener> listeners;
    private boolean resourceClassNameOveridden;
    private JLabel classLabel;
    private JTextField classTextField;
    private JLabel contentClassLabel;
    private JTextField contentClassTextField;
    private JSeparator jSeparator2;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JComboBox medaTypeComboBox;
    private JLabel mediaTypeLabel;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JButton selectClassButton;
    private JLabel uriLabel;
    private JTextField uriTextField;
    public static final String DEFAULT_URI = "generic";

    public SingletonSetupPanelVisual(String name) {
        this.setName(name);
        this.listeners = new ArrayList<ChangeListener>();
        this.initComponents();
        this.packageComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SingletonSetupPanelVisual.this.fireChange();
            }
        });
        this.medaTypeComboBox.setModel(new DefaultComboBoxModel<Constants.MimeType>(GenericResourceBean.getSupportedMimeTypes()));
        ((JTextComponent)this.packageComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SingletonSetupPanelVisual.this.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SingletonSetupPanelVisual.this.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SingletonSetupPanelVisual.this.fireChange();
            }
        });
    }

    private void initComponents() {
        this.classLabel = new JLabel();
        this.classTextField = new JTextField();
        this.uriLabel = new JLabel();
        this.uriTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.medaTypeComboBox = new JComboBox();
        this.mediaTypeLabel = new JLabel();
        this.contentClassLabel = new JLabel();
        this.selectClassButton = new JButton();
        this.contentClassTextField = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.setName("");
        this.setPreferredSize(new Dimension(450, 193));
        this.classLabel.setLabelFor(this.classTextField);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/rest/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.classLabel, (String)bundle.getString("MSG_ClassName"));
        this.classTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SingletonSetupPanelVisual.this.classTextFieldKeyReleased(evt);
            }
        });
        this.uriLabel.setLabelFor(this.uriTextField);
        Mnemonics.setLocalizedText((JLabel)this.uriLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_UriTemplate"));
        this.uriTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SingletonSetupPanelVisual.this.uriTextFieldKeyReleased(evt);
            }
        });
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_Project"));
        this.projectTextField.setEditable(false);
        this.locationLabel.setLabelFor(this.locationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_SrcLocation"));
        this.locationComboBox.setMinimumSize(new Dimension(4, 20));
        this.locationComboBox.setPreferredSize(new Dimension(130, 25));
        this.locationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SingletonSetupPanelVisual.this.locationComboBoxActionPerformed(evt);
            }
        });
        this.packageLabel.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_Package"));
        this.packageComboBox.setEditable(true);
        this.packageComboBox.setMinimumSize(new Dimension(4, 20));
        this.packageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SingletonSetupPanelVisual.this.packageChanged(evt);
            }
        });
        this.packageComboBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SingletonSetupPanelVisual.this.packageComboBoxKeyReleased(evt);
            }
        });
        this.medaTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.medaTypeComboBox.setMinimumSize(new Dimension(4, 20));
        this.mediaTypeLabel.setLabelFor(this.medaTypeComboBox);
        Mnemonics.setLocalizedText((JLabel)this.mediaTypeLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_MimeType"));
        this.contentClassLabel.setLabelFor(this.contentClassTextField);
        Mnemonics.setLocalizedText((JLabel)this.contentClassLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_RepresentationClass"));
        Mnemonics.setLocalizedText((AbstractButton)this.selectClassButton, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_Select"));
        this.selectClassButton.setHorizontalAlignment(10);
        this.selectClassButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SingletonSetupPanelVisual.this.selectClassButtonActionPerformed(evt);
            }
        });
        this.selectClassButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SingletonSetupPanelVisual.this.mouseClickHandler(evt);
            }
        });
        this.contentClassTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SingletonSetupPanelVisual.this.representationClassChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectLabel).addComponent(this.contentClassLabel).addComponent(this.classLabel).addComponent(this.uriLabel).addComponent(this.mediaTypeLabel).addComponent(this.packageLabel).addComponent(this.locationLabel)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.classTextField, GroupLayout.Alignment.TRAILING, -1, 303, Short.MAX_VALUE).addComponent(this.medaTypeComboBox, GroupLayout.Alignment.TRAILING, 0, 303, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.contentClassTextField, -1, 218, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectClassButton)).addComponent(this.uriTextField, GroupLayout.Alignment.TRAILING, -1, 303, Short.MAX_VALUE).addComponent(this.locationComboBox, GroupLayout.Alignment.TRAILING, 0, 303, Short.MAX_VALUE).addComponent(this.packageComboBox, GroupLayout.Alignment.TRAILING, 0, 303, Short.MAX_VALUE).addComponent(this.projectTextField, -1, 303, Short.MAX_VALUE)).addContainerGap()).addComponent(this.jSeparator2, -1, 454, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLabel).addComponent(this.projectTextField, -2, -1, -2)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationComboBox, -2, 23, -2).addComponent(this.locationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.packageComboBox, -2, -1, -2).addComponent(this.packageLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.uriLabel).addComponent(this.uriTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.classLabel).addComponent(this.classTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mediaTypeLabel).addComponent(this.medaTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contentClassTextField, -1, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.contentClassLabel).addComponent(this.selectClassButton)))));
        this.classLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"ClassName"));
        this.classLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_ClassName"));
        this.classTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"ClassName"));
        this.classTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_ClassName"));
        this.uriLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"UirTemplate"));
        this.uriLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Uri"));
        this.uriTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"UriTemplate"));
        this.uriTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Uri"));
        this.projectLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"Project"));
        this.projectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Project"));
        this.projectTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"Project"));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Project"));
        this.locationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"Location"));
        this.locationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Location"));
        this.locationComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"Location"));
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Location"));
        this.packageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"ResourcePackage"));
        this.packageLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_ResourcePackage"));
        this.packageComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"ResourcePackage"));
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_ResourcePackage"));
        this.medaTypeComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"MimeType"));
        this.medaTypeComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_MimeType"));
        this.mediaTypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"MimeType"));
        this.mediaTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_MimeType"));
        this.contentClassLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"RepresentationClass"));
        this.contentClassLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_RepresentationClass"));
        this.selectClassButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"SelectRepresentationClass"));
        this.selectClassButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_SelectRepresenationClass"));
        this.contentClassTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"RepresentationClass"));
        this.contentClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_RepresentationClass"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_Specify_Resource_Class"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_Specify_Resource_Class"));
    }

    private void containerTextFieldActionPerformed(ActionEvent evt) {
    }

    private void representationClassChanged(KeyEvent evt) {
        this.fireChange();
    }

    private void selectClassButtonActionPerformed(ActionEvent evt) {
        this.fireChange();
    }

    private void mouseClickHandler(MouseEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ElementHandle handle = TypeElementFinder.find((ClasspathInfo)Util.getClasspathInfo(SingletonSetupPanelVisual.this.project), (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

                    public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String textForQuery, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> searchScopes) {
                        return classpathInfo.getClassIndex().getDeclaredTypes(textForQuery, nameKind, searchScopes);
                    }

                    public boolean accept(ElementHandle<TypeElement> typeHandle) {
                        return true;
                    }
                });
                if (handle != null) {
                    SingletonSetupPanelVisual.this.contentClassTextField.setText(handle.getQualifiedName());
                    SingletonSetupPanelVisual.this.fireChange();
                }
            }
        });
    }

    private void locationComboBoxActionPerformed(ActionEvent evt) {
        this.locationChanged();
    }

    private void classTextFieldKeyReleased(KeyEvent evt) {
        this.resourceClassNameOveridden = true;
        this.fireChange();
    }

    private void packageComboBoxKeyReleased(KeyEvent evt) {
        this.fireChange();
    }

    private void uriTextFieldKeyReleased(KeyEvent evt) {
        String uri = this.uriTextField.getText();
        if (!this.resourceClassNameOveridden) {
            this.classTextField.setText(this.findFreeClassName(uri));
        }
        this.fireChange();
    }

    private void packageChanged(ActionEvent evt) {
        this.fireChange();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void fireChange() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    @Override
    public boolean valid(WizardDescriptor wizard) {
        AbstractPanel.clearErrorMessage(wizard);
        String resourceUri = this.uriTextField.getText().trim();
        String packageName = this.getPackage();
        String className = this.classTextField.getText().trim();
        SourceGroup[] groups = SourceGroupSupport.getJavaSourceGroups(this.project);
        if (groups == null || groups.length < 1) {
            AbstractPanel.setErrorMessage(wizard, "MSG_NoJavaSourceRoots");
            return false;
        }
        if (className.length() == 0 || !Utilities.isJavaIdentifier((String)className)) {
            AbstractPanel.setErrorMessage(wizard, "MSG_InvalidResourceClassName");
            return false;
        }
        if (resourceUri.length() == 0) {
            AbstractPanel.setErrorMessage(wizard, "MSG_EmptyUriTemplate");
            return false;
        }
        if (!Util.isValidPackageName(packageName)) {
            AbstractPanel.setErrorMessage(wizard, "MSG_InvalidPackageName");
            return false;
        }
        if (this.getResourceClassFile() != null) {
            AbstractPanel.setErrorMessage(wizard, "MSG_ExistingClass");
            return false;
        }
        if (!Util.isValidUri(resourceUri)) {
            AbstractPanel.setErrorMessage(wizard, "MSG_IncorrectUriTemplate");
            return false;
        }
        return true;
    }

    public SourceGroup getLocationValue() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getPackage() {
        return ((JTextComponent)this.packageComboBox.getEditor().getEditorComponent()).getText();
    }

    private void locationChanged() {
        this.updateSourceGroupPackages();
        this.fireChange();
    }

    private String getResourceClassName() {
        return this.classTextField.getText();
    }

    private FileObject getResourceClassFile() {
        FileObject folder = null;
        try {
            folder = SourceGroupSupport.getFolderForPackage(this.getLocationValue(), this.getPackage());
            if (folder != null) {
                return folder.getFileObject(this.getResourceClassName(), "java");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void read(WizardDescriptor settings) {
        this.project = Templates.getProject((WizardDescriptor)settings);
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)settings);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        SourceGroup[] sourceGroups = SourceGroupSupport.getJavaSourceGroups(this.project);
        SourceGroupUISupport.connect(this.locationComboBox, sourceGroups);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.updateSourceGroupPackages();
        if (targetFolder != null) {
            SourceGroup targetSourceGroup = SourceGroupSupport.findSourceGroupForFile(sourceGroups, targetFolder);
            if (targetSourceGroup != null) {
                this.locationComboBox.setSelectedItem(targetSourceGroup);
                String targetPackage = SourceGroupSupport.getPackageForFolder(targetSourceGroup, targetFolder);
                if (targetPackage != null) {
                    ((JTextComponent)this.packageComboBox.getEditor().getEditorComponent()).setText(targetPackage);
                }
            }
        } else {
            String targetPackage = (String)settings.getProperty("targetPackage");
            if (targetPackage != null) {
                ((JTextComponent)this.packageComboBox.getEditor().getEditorComponent()).setText(targetPackage);
            }
        }
        String value = (String)settings.getProperty("ResourceURI");
        if (value == null || value.trim().length() == 0) {
            this.uriTextField.setText(DEFAULT_URI);
            this.classTextField.setText(this.findFreeClassName(DEFAULT_URI));
            this.contentClassTextField.setText(GenericResourceBean.getDefaultRepresetationClass((Constants.MimeType)((Object)this.medaTypeComboBox.getSelectedItem())));
        } else {
            this.uriTextField.setText(value);
            this.classTextField.setText((String)settings.getProperty("ResourceClass"));
            this.medaTypeComboBox.setSelectedItem((Object)((Constants.MimeType[])settings.getProperty("MimeTypes"))[0]);
            String[] types = (String[])settings.getProperty("RepresentationTypes");
            if (types != null && types.length > 0) {
                this.contentClassTextField.setText(types[0]);
            }
        }
    }

    @Override
    public void store(WizardDescriptor settings) {
        settings.putProperty("resourcePackage", (Object)this.getPackage());
        settings.putProperty("ResourceClass", (Object)this.classTextField.getText());
        settings.putProperty("ResourceURI", (Object)this.uriTextField.getText());
        settings.putProperty("MimeTypes", (Object)new Constants.MimeType[]{(Constants.MimeType)((Object)this.medaTypeComboBox.getSelectedItem())});
        settings.putProperty("RepresentationTypes", (Object)new String[]{this.contentClassTextField.getText()});
        settings.putProperty("sourceGroup", (Object)this.getLocationValue());
        try {
            FileObject packageFO = SourceGroupSupport.getFolderForPackage(this.getLocationValue(), this.getPackage(), false);
            if (packageFO != null) {
                Templates.setTargetFolder((WizardDescriptor)settings, (FileObject)packageFO);
            } else {
                Templates.setTargetFolder((WizardDescriptor)settings, null);
                settings.putProperty("targetPackage", (Object)this.getPackage());
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public SourceGroup getSourceGroup() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    @Override
    public String getPackageName() {
        return ((JTextComponent)this.packageComboBox.getEditor().getEditorComponent()).getText();
    }

    public double getRenderedHeight() {
        return this.selectClassButton.getLocation().getY() + this.selectClassButton.getSize().getHeight() + this.getGap();
    }

    private double getGap() {
        double gap = this.contentClassTextField.getLocation().getY();
        return gap -= this.medaTypeComboBox.getLocation().getY() + (double)this.medaTypeComboBox.getHeight();
    }

    private void updateSourceGroupPackages() {
        SourceGroup sourceGroup = this.getSourceGroup();
        if (sourceGroup != null) {
            ComboBoxModel model = PackageView.createListView((SourceGroup)sourceGroup);
            if (model.getSelectedItem() != null && model.getSelectedItem().toString().startsWith("META-INF") && model.getSize() > 1) {
                model.setSelectedItem(model.getElementAt(1));
            }
            this.packageComboBox.setModel(model);
        }
    }

    private String findFreeClassName(String uri) {
        try {
            FileObject folder = SourceGroupSupport.getFolderForPackage(this.getLocationValue(), this.getPackage());
            if (folder != null) {
                return FileUtil.findFreeFileName((FileObject)folder, (String)Util.deriveResourceClassName(uri), (String)"java");
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }
}

