/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.saas;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.support.java.GenerationUtils;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.jaxws.saas.RestWrapperForSoapGenerator;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.codegen.ui.ProgressDialog;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RestResourceGenerator {
    public static final String RESOURCE_TEMPLATE = "Templates/WebServices/GenericResource.java";
    private FileObject folder;
    private URI wsdlURL;
    private WsdlModel wsdlModel;
    private ProgressHandle pHandle;
    private int totalWorkUnits;
    private int workUnits;
    private RequestProcessor.Task generatorTask;
    private String packageName;
    private ProgressDialog dialog;

    public RestResourceGenerator(FileObject folder, URI wsdlURL, String packageName) {
        this.folder = folder;
        this.wsdlURL = wsdlURL;
        this.packageName = packageName;
    }

    public void generate() {
        String mes = NbBundle.getMessage(RestResourceGenerator.class, (String)"MSG_GENERATING_REST_RESOURCE");
        this.dialog = new ProgressDialog(mes);
        this.generatorTask = RequestProcessor.getDefault().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    RestResourceGenerator.this.initProgressReporting(RestResourceGenerator.this.dialog.getProgressHandle());
                    Project project = FileOwnerQuery.getOwner((FileObject)RestResourceGenerator.this.folder);
                    String clientPackageName = RestResourceGenerator.this.getPackageName(RestResourceGenerator.this.packageName + "_client");
                    JaxWsModel jaxwsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
                    String clientName = RestResourceGenerator.this.getWsdlName(RestResourceGenerator.this.wsdlURL.toString());
                    Client c = RestResourceGenerator.this.clientExists(jaxwsModel, clientName);
                    if (c == null) {
                        String mes = NbBundle.getMessage(RestResourceGenerator.class, (String)"MSG_GENERATING_CLIENT_ARTIFACTS");
                        RestResourceGenerator.this.reportProgress(mes);
                        clientName = RestResourceGenerator.this.generateClient(project, RestResourceGenerator.this.wsdlURL.toString(), clientPackageName);
                    } else {
                        clientPackageName = c.getPackageName();
                    }
                    Client client = jaxwsModel.findClientByName(clientName);
                    if (client == null) {
                        RestResourceGenerator.this.finishProgressReporting();
                        RestResourceGenerator.this.dialog.close();
                        return;
                    }
                    JAXWSClientSupport clientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)RestResourceGenerator.this.folder);
                    FileObject localWsdlFolder = clientSupport.getLocalWsdlFolderForClient(clientName, false);
                    FileObject localWsdl = localWsdlFolder.getFileObject(client.getLocalWsdlFile());
                    WsdlModeler wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(localWsdl.toURL());
                    wsdlModeler.setPackageName(clientPackageName);
                    wsdlModeler.setCatalog(clientSupport.getCatalog());
                    WsdlModel model = wsdlModeler.getAndWaitForWsdlModel();
                    if (model == null) {
                        RestResourceGenerator.this.finishProgressReporting();
                        RestResourceGenerator.this.dialog.close();
                        return;
                    }
                    JavaSource targetSource = null;
                    RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
                    try {
                        restSupport.ensureRestDevelopmentReady(RestSupport.RestConfig.IDE);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify();
                    }
                    List services = model.getServices();
                    for (WsdlService service : services) {
                        List ports = service.getPorts();
                        for (WsdlPort port : ports) {
                            FileObject fo = RestResourceGenerator.this.folder.getFileObject(port.getName(), "java");
                            if (fo != null) {
                                NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RestResourceGenerator.class, (String)"MSG_CONFIRM_DELETE", (Object)port.getName()), NbBundle.getMessage(RestResourceGenerator.class, (String)"TITLE_CONFIRM_DELETE"), 0);
                                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.YES_OPTION) continue;
                                FileLock lock = null;
                                try {
                                    lock = fo.lock();
                                    fo.delete(lock);
                                }
                                catch (IOException ex) {
                                    ErrorManager.getDefault().notify((Throwable)ex);
                                }
                                finally {
                                    if (lock != null) {
                                        lock.releaseLock();
                                    }
                                }
                            }
                            String mes = NbBundle.getMessage(RestResourceGenerator.class, (String)"MSG_GENERATING_RESOURCE_FILE");
                            RestResourceGenerator.this.reportProgress(mes);
                            targetSource = JavaSourceHelper.createJavaSource((String)RestResourceGenerator.RESOURCE_TEMPLATE, (FileObject)RestResourceGenerator.this.folder, (String)RestResourceGenerator.this.packageName, (String)port.getName());
                            List operations = port.getOperations();
                            for (WsdlOperation operation : operations) {
                                try {
                                    new RestWrapperForSoapGenerator(service, port, operation, project, (FileObject)targetSource.getFileObjects().iterator().next(), RestResourceGenerator.this.wsdlURL.toString()).generate();
                                }
                                catch (IOException ex) {
                                    ErrorManager.getDefault().notify((Throwable)ex);
                                    try {
                                        restSupport.getRestServicesModel().runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                                            public Void run(RestServicesMetadata metadata) throws IOException {
                                                RestServices root = metadata.getRoot();
                                                if (root.sizeRestServiceDescription() < 1) {
                                                    // empty if block
                                                }
                                                return null;
                                            }
                                        });
                                    }
                                    catch (IOException e) {
                                        Exceptions.printStackTrace((Throwable)e);
                                    }
                                }
                            }
                            try {
                                RestResourceGenerator.this.initializeClient(service, port, RestResourceGenerator.this.wsdlURL.toString(), targetSource);
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            try {
                                FileObject targetFile = (FileObject)targetSource.getFileObjects().iterator().next();
                                RestResourceGenerator.openFileInEditor(DataObject.find((FileObject)targetFile));
                            }
                            catch (DataObjectNotFoundException ex) {
                                ErrorManager.getDefault().notify((Throwable)ex);
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    RestResourceGenerator.this.finishProgressReporting();
                    RestResourceGenerator.this.dialog.close();
                }
            }
        });
        this.generatorTask.schedule(50);
        this.dialog.open();
    }

    private String getPackageName(String name) {
        ArrayList<String> names = new ArrayList<String>();
        String pName = name;
        int suffix = 0;
        Project project = FileOwnerQuery.getOwner((FileObject)this.folder);
        JaxWsModel model = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
        Client[] clients = model.getClients();
        for (Client client : clients) {
            names.add(client.getPackageName());
        }
        for (String n : names) {
            if (!pName.equals(n)) continue;
            pName = name + String.valueOf(++suffix);
        }
        return pName;
    }

    private void initializeClient(final WsdlService service, final WsdlPort port, String wsdlUrl, JavaSource targetSource) throws IOException {
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                TreeMaker make = workingCopy.getTreeMaker();
                MethodTree constructor = JavaSourceHelper.getDefaultConstructor((CompilationController)workingCopy);
                String body = "\n{\nport = getPort();\n}\n";
                ModifiersTree publicTree = GenerationUtils.newInstance((WorkingCopy)workingCopy).createModifiers(Modifier.PUBLIC);
                List params = Collections.emptyList();
                List vars = Collections.emptyList();
                List thrws = Collections.emptyList();
                MethodTree modifiedConstructor = make.Constructor(publicTree, params, vars, thrws, body);
                workingCopy.rewrite((Tree)constructor, (Tree)modifiedConstructor);
                ClassTree modifiedClass = JavaSourceHelper.addField((WorkingCopy)workingCopy, (ClassTree)javaClass, (Modifier[])new Modifier[]{Modifier.PRIVATE}, null, null, (String)"port", (Object)port.getJavaName(), null);
                workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                ClassTree modifiedJavaClass = JavaSourceHelper.addMethod((WorkingCopy)workingCopy, (ClassTree)modifiedClass, (Modifier[])new Modifier[]{Modifier.PRIVATE}, null, null, (String)"getPort", (Object)port.getJavaName(), null, null, null, null, (String)RestResourceGenerator.this.generateGetPort(service, port), (String)"");
                workingCopy.rewrite((Tree)javaClass, (Tree)modifiedJavaClass);
            }

            public void cancel() {
            }
        };
        targetSource.runModificationTask((Task)task).commit();
    }

    private String generateGetPort(WsdlService service, WsdlPort port) {
        String getPort = "";
        String serviceVar = "service";
        String serviceJavaName = service.getJavaName();
        String portJavaName = port.getJavaName();
        String portGetterMethod = port.getPortGetter();
        Object[] args = new String[]{serviceJavaName, portJavaName, portGetterMethod, "", "", serviceVar};
        String body = "\ntry '{' // Call Web Service Operation\n   {0} {5} = new {0}();\n   {1} p = {5}.{2}();\n\nreturn p;\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
        body = body + "\nreturn null;\n";
        getPort = "\n{\n" + MessageFormat.format(body, args) + "\n}\n";
        return getPort;
    }

    private Client clientExists(JaxWsModel jaxwsModel, String clientName) {
        Client[] clients = jaxwsModel.getClients();
        for (int i = 0; i < clients.length; ++i) {
            if (!clients[i].getName().equals(clientName)) continue;
            return clients[i];
        }
        return null;
    }

    private String generateClient(Project project, String wsdlUrl, String packageName) throws IOException {
        JAXWSClientSupport jaxWsClientSupport = null;
        if (project != null) {
            jaxWsClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)project.getProjectDirectory());
        }
        if (jaxWsClientSupport == null) {
            String mes = NbBundle.getMessage(RestResourceGenerator.class, (String)"ERR_NoWebServiceClientSupport");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            return null;
        }
        if (packageName != null && packageName.length() == 0) {
            packageName = null;
        }
        return jaxWsClientSupport.addServiceClient(this.getWsdlName(wsdlUrl), wsdlUrl, packageName, true);
    }

    private String getWsdlName(String wsdlUrl) {
        String wsdlName;
        int ind = wsdlUrl.lastIndexOf("/");
        String string = wsdlName = ind >= 0 ? wsdlUrl.substring(ind + 1) : wsdlUrl;
        if (wsdlName.toUpperCase().endsWith("?WSDL")) {
            wsdlName = wsdlName.substring(0, wsdlName.length() - 5);
        }
        if ((ind = wsdlName.lastIndexOf(".")) > 0) {
            wsdlName = wsdlName.substring(0, ind);
        }
        return this.convertAllSpecialChars(wsdlName);
    }

    private String convertAllSpecialChars(String resultStr) {
        StringBuffer sb = new StringBuffer(resultStr);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '/' || c == '.' || c == '_' || c == ' ' || c == '-') continue;
            sb.setCharAt(i, '_');
        }
        return sb.toString();
    }

    public static void openFileInEditor(DataObject dobj) {
        final OpenCookie openCookie = (OpenCookie)dobj.getCookie(OpenCookie.class);
        if (openCookie != null) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    openCookie.open();
                }
            }, 1000);
        } else {
            final EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    ec.open();
                }
            }, 1000);
        }
    }

    public void initProgressReporting(ProgressHandle pHandle) {
        this.initProgressReporting(pHandle, true);
    }

    public void initProgressReporting(ProgressHandle pHandle, boolean start) {
        this.pHandle = pHandle;
        this.totalWorkUnits = this.getTotalWorkUnits();
        this.workUnits = 0;
        if (pHandle != null && start) {
            if (this.totalWorkUnits > 0) {
                pHandle.start(this.totalWorkUnits);
            } else {
                pHandle.start();
            }
        }
    }

    public void reportProgress(String message) {
        if (this.pHandle != null) {
            if (this.totalWorkUnits > 0) {
                this.pHandle.progress(message, ++this.workUnits);
            } else {
                this.pHandle.progress(message);
            }
        }
    }

    public void finishProgressReporting() {
        if (this.pHandle != null) {
            this.pHandle.finish();
        }
    }

    public int getTotalWorkUnits() {
        return 0;
    }

    protected ProgressHandle getProgressHandle() {
        return this.pHandle;
    }
}

