/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import org.netbeans.api.project.Project;
import org.netbeans.modules.ant.freeform.spi.HelpIDFragmentProvider;
import org.netbeans.modules.ant.freeform.spi.ProjectAccessor;
import org.netbeans.modules.java.freeform.AnnotationProcessingQueryImpl;
import org.netbeans.modules.java.freeform.Classpaths;
import org.netbeans.modules.java.freeform.JavaActions;
import org.netbeans.modules.java.freeform.JavaFreeformFileBuiltQuery;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.modules.java.freeform.JavaProjectNature;
import org.netbeans.modules.java.freeform.JavadocQuery;
import org.netbeans.modules.java.freeform.LookupMergerImpl;
import org.netbeans.modules.java.freeform.SourceForBinaryQueryImpl;
import org.netbeans.modules.java.freeform.SourceLevelQueryImpl;
import org.netbeans.modules.java.freeform.TestQuery;
import org.netbeans.modules.java.freeform.UsageLogger;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.LookupProvider;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LookupProviderImpl
implements LookupProvider {
    private static final String HELP_ID_FRAGMENT = "java";

    public Lookup createAdditionalLookup(Lookup baseContext) {
        Project prj = (Project)baseContext.lookup(Project.class);
        ProjectAccessor acc = (ProjectAccessor)baseContext.lookup(ProjectAccessor.class);
        AuxiliaryConfiguration aux = (AuxiliaryConfiguration)baseContext.lookup(AuxiliaryConfiguration.class);
        assert (aux != null);
        assert (prj != null);
        assert (acc != null);
        return new ProjectLookup(prj, acc.getHelper(), acc.getEvaluator(), aux);
    }

    private static Lookup initLookup(Project project, AntProjectHelper projectHelper, PropertyEvaluator projectEvaluator, AuxiliaryConfiguration aux) {
        SourceForBinaryQueryImpl sfbq = new SourceForBinaryQueryImpl(projectHelper, projectEvaluator, aux);
        Classpaths cp = new Classpaths(projectHelper, projectEvaluator, aux, sfbq);
        return Lookups.fixed((Object[])new Object[]{cp, new SourceLevelQueryImpl(projectHelper, projectEvaluator, aux), sfbq, new AnnotationProcessingQueryImpl(projectHelper, projectEvaluator, aux), new OpenHook(project, cp), new TestQuery(projectHelper, projectEvaluator, aux), new JavadocQuery(projectHelper, projectEvaluator, aux), new PrivilegedTemplatesImpl(), new JavaActions(project, projectHelper, projectEvaluator, aux), new LookupMergerImpl(), new JavaFreeformFileBuiltQuery(project, projectHelper, projectEvaluator, aux), new HelpIDFragmentProviderImpl()});
    }

    public static boolean isMyProject(AuxiliaryConfiguration aux) {
        return JavaProjectGenerator.getJavaCompilationUnits(aux) != null;
    }

    static Element upgradeSchema(Element old, String to) {
        Document doc = old.getOwnerDocument();
        Element nue = doc.createElementNS(to, "java-data");
        LookupProviderImpl.copyXMLTree(doc, old, nue, to);
        return nue;
    }

    private static void copyXMLTree(Document doc, Element from, Element to, String newNamespace) {
        NodeList nl = from.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node newNode;
            Node node = nl.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element oldElement = (Element)node;
                    newNode = doc.createElementNS(newNamespace, oldElement.getTagName());
                    NamedNodeMap attrs = oldElement.getAttributes();
                    int alength = attrs.getLength();
                    for (int j = 0; j < alength; ++j) {
                        Attr oldAttr = (Attr)attrs.item(j);
                        ((Element)newNode).setAttributeNS(oldAttr.getNamespaceURI(), oldAttr.getName(), oldAttr.getValue());
                    }
                    LookupProviderImpl.copyXMLTree(doc, oldElement, (Element)newNode, newNamespace);
                    break;
                }
                case 3: {
                    newNode = doc.createTextNode(((Text)node).getData());
                    break;
                }
                case 8: {
                    newNode = doc.createComment(((Comment)node).getData());
                    break;
                }
                default: {
                    throw new AssertionError(node);
                }
            }
            to.appendChild(newNode);
        }
    }

    private static final class ProjectLookup
    extends ProxyLookup
    implements AntProjectListener {
        private AntProjectHelper helper;
        private PropertyEvaluator evaluator;
        private Project project;
        private AuxiliaryConfiguration aux;
        private boolean isMyProject;

        public ProjectLookup(Project project, AntProjectHelper helper, PropertyEvaluator evaluator, AuxiliaryConfiguration aux) {
            super(new Lookup[0]);
            this.project = project;
            this.helper = helper;
            this.evaluator = evaluator;
            this.aux = new UpgradingAuxiliaryConfiguration(aux);
            this.isMyProject = LookupProviderImpl.isMyProject(aux);
            this.updateLookup();
            helper.addAntProjectListener((AntProjectListener)this);
        }

        private void updateLookup() {
            Lookup l = Lookup.EMPTY;
            if (this.isMyProject) {
                l = LookupProviderImpl.initLookup(this.project, this.helper, this.evaluator, this.aux);
            }
            this.setLookups(new Lookup[]{l});
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            if (LookupProviderImpl.isMyProject(this.aux) != this.isMyProject) {
                this.isMyProject = !this.isMyProject;
                this.updateLookup();
            }
        }

        public void propertiesChanged(AntProjectEvent ev) {
        }
    }

    private static class OpenHook
    extends ProjectOpenedHook {
        private final Project project;
        private final Classpaths cp;

        public OpenHook(Project project, Classpaths cp) {
            this.project = project;
            this.cp = cp;
        }

        protected void projectOpened() {
            this.cp.opened();
            UsageLogger.log(this.project);
        }

        protected void projectClosed() {
            this.cp.closed();
        }
    }

    private static final class PrivilegedTemplatesImpl
    implements PrivilegedTemplates,
    RecommendedTemplates {
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/Classes/Class.java", "Templates/Classes/Package", "Templates/Classes/Interface.java"};
        private static final String[] RECOMENDED_TYPES = new String[]{"java-classes", "java-main-class", "java-forms", "gui-java-application", "java-beans", "oasis-XML-catalogs", "XML", "ant-script", "ant-task", "servlet-types", "wsdl", "junit", "simple-files"};

        private PrivilegedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            return RECOMENDED_TYPES;
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }
    }

    private static final class HelpIDFragmentProviderImpl
    implements HelpIDFragmentProvider {
        private HelpIDFragmentProviderImpl() {
        }

        public String getHelpIDFragment() {
            return LookupProviderImpl.HELP_ID_FRAGMENT;
        }
    }

    static final class UpgradingAuxiliaryConfiguration
    implements AuxiliaryConfiguration {
        private final AuxiliaryConfiguration delegate;

        public UpgradingAuxiliaryConfiguration(AuxiliaryConfiguration delegate) {
            this.delegate = delegate;
        }

        public Element getConfigurationFragment(String elementName, String namespace, boolean shared) {
            if (elementName.equals("java-data") && shared) {
                Element nue = null;
                block0: for (int nsIndex = 0; nsIndex < JavaProjectNature.JAVA_NAMESPACES.length; ++nsIndex) {
                    if (!namespace.equals(JavaProjectNature.JAVA_NAMESPACES[nsIndex])) continue;
                    for (int nsLookup = nsIndex; nsLookup < JavaProjectNature.JAVA_NAMESPACES.length; ++nsLookup) {
                        nue = this.delegate.getConfigurationFragment("java-data", JavaProjectNature.JAVA_NAMESPACES[nsLookup], true);
                        if (nue == null) continue;
                        if (nsLookup == nsIndex) break block0;
                        nue = LookupProviderImpl.upgradeSchema(nue, JavaProjectNature.JAVA_NAMESPACES[nsIndex]);
                        break block0;
                    }
                    break;
                }
                return nue;
            }
            return this.delegate.getConfigurationFragment(elementName, namespace, shared);
        }

        public void putConfigurationFragment(Element fragment, boolean shared) throws IllegalArgumentException {
            this.delegate.putConfigurationFragment(fragment, shared);
        }

        public boolean removeConfigurationFragment(String elementName, String namespace, boolean shared) throws IllegalArgumentException {
            return this.delegate.removeConfigurationFragment(elementName, namespace, shared);
        }
    }
}

