/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.document;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.spi.editor.document.EditorMimeTypesImplementation;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class EditorMimeTypes {
    public static final String PROP_SUPPORTED_MIME_TYPES = "supportedMimeTypes";
    private static EditorMimeTypes instance;
    private final EditorMimeTypesImplementation impl = (EditorMimeTypesImplementation)Lookup.getDefault().lookup(EditorMimeTypesImplementation.class);
    private final PropertyChangeSupport listeners;
    private final PropertyChangeListener listener;

    private EditorMimeTypes() {
        if (this.impl == null) {
            throw new IllegalStateException(String.format("No %s instance in the default Lookup.", EditorMimeTypesImplementation.class));
        }
        this.listeners = new PropertyChangeSupport(this);
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (EditorMimeTypes.PROP_SUPPORTED_MIME_TYPES.equals(evt.getPropertyName())) {
                    EditorMimeTypes.this.listeners.firePropertyChange(EditorMimeTypes.PROP_SUPPORTED_MIME_TYPES, null, null);
                }
            }
        };
        this.impl.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.impl));
    }

    @NonNull
    public Set<String> getSupportedMimeTypes() {
        return this.impl.getSupportedMimeTypes();
    }

    public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.listeners.removePropertyChangeListener(listener);
    }

    @NonNull
    public static synchronized EditorMimeTypes getDefault() {
        if (instance == null) {
            instance = new EditorMimeTypes();
        }
        return instance;
    }
}

