/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.drivers.ButtonDriver;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class CheckboxOperator
extends ComponentOperator
implements Outputable {
    public static final String TEXT_DPROP = "Label";
    private TestOut output;
    ButtonDriver driver = DriverManager.getButtonDriver(this.getClass());

    public CheckboxOperator(Checkbox b) {
        super(b);
    }

    public CheckboxOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((Checkbox)cont.waitSubComponent(new CheckboxFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public CheckboxOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public CheckboxOperator(ContainerOperator cont, String text, int index) {
        this((Checkbox)CheckboxOperator.waitComponent(cont, (ComponentChooser)new CheckboxByLabelFinder(text, cont.getComparator()), index));
        this.copyEnvironment(cont);
    }

    public CheckboxOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public CheckboxOperator(ContainerOperator cont, int index) {
        this((Checkbox)CheckboxOperator.waitComponent(cont, (ComponentChooser)new CheckboxFinder(), index));
        this.copyEnvironment(cont);
    }

    public CheckboxOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static Checkbox findCheckbox(Container cont, ComponentChooser chooser, int index) {
        return (Checkbox)CheckboxOperator.findComponent(cont, new CheckboxFinder(chooser), index);
    }

    public static Checkbox findCheckbox(Container cont, ComponentChooser chooser) {
        return CheckboxOperator.findCheckbox(cont, chooser, 0);
    }

    public static Checkbox findCheckbox(Container cont, String text, boolean ce, boolean ccs, int index) {
        return CheckboxOperator.findCheckbox(cont, new CheckboxByLabelFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static Checkbox findCheckbox(Container cont, String text, boolean ce, boolean ccs) {
        return CheckboxOperator.findCheckbox(cont, text, ce, ccs, 0);
    }

    public static Checkbox waitCheckbox(Container cont, ComponentChooser chooser, int index) {
        return (Checkbox)CheckboxOperator.waitComponent(cont, (ComponentChooser)new CheckboxFinder(chooser), index);
    }

    public static Checkbox waitCheckbox(Container cont, ComponentChooser chooser) {
        return CheckboxOperator.waitCheckbox(cont, chooser, 0);
    }

    public static Checkbox waitCheckbox(Container cont, String text, boolean ce, boolean ccs, int index) {
        return CheckboxOperator.waitCheckbox(cont, new CheckboxByLabelFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static Checkbox waitCheckbox(Container cont, String text, boolean ce, boolean ccs) {
        return CheckboxOperator.waitCheckbox(cont, text, ce, ccs, 0);
    }

    @Override
    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    @Override
    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (ButtonDriver)DriverManager.getDriver("drivers.button", this.getClass(), anotherOperator.getProperties());
    }

    public void changeSelection(boolean newValue) {
        this.makeComponentVisible();
        if (this.getState() != newValue) {
            try {
                this.waitComponentEnabled();
            }
            catch (InterruptedException e) {
                throw new JemmyException("Interrupted!", e);
            }
            this.output.printLine("Change checkbox selection to " + (newValue ? "true" : "false") + "\n    :" + this.toStringSource());
            this.output.printGolden("Change checkbox selection to " + (newValue ? "true" : "false"));
            this.driver.push(this);
            if (this.getVerification()) {
                this.waitSelected(newValue);
            }
        }
    }

    public void changeSelectionNoBlock(boolean selected) {
        this.produceNoBlocking(new Operator.NoBlockingAction("Button selection changing"){

            @Override
            public Object doAction(Object param) {
                CheckboxOperator.this.changeSelection((Boolean)param);
                return null;
            }
        }, selected ? Boolean.TRUE : Boolean.FALSE);
    }

    public void waitSelected(final boolean selected) {
        this.getOutput().printLine("Wait button to be selected \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait button to be selected");
        this.waitState(new ComponentChooser(){

            @Override
            public boolean checkComponent(Component comp) {
                return CheckboxOperator.this.getState() == selected;
            }

            @Override
            public String getDescription() {
                return "Items has been " + (selected ? "" : "un") + "selected";
            }
        });
    }

    @Override
    public Hashtable getDump() {
        Hashtable result = super.getDump();
        result.put(TEXT_DPROP, ((Checkbox)this.getSource()).getLabel());
        return result;
    }

    public void addItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("addItemListener"){

            @Override
            public void map() {
                ((Checkbox)CheckboxOperator.this.getSource()).addItemListener(itemListener);
            }
        });
    }

    public CheckboxGroup getCheckboxGroup() {
        return (CheckboxGroup)this.runMapping(new Operator.MapAction("getCheckboxGroup"){

            @Override
            public Object map() {
                return ((Checkbox)CheckboxOperator.this.getSource()).getCheckboxGroup();
            }
        });
    }

    public String getLabel() {
        return (String)this.runMapping(new Operator.MapAction("getLabel"){

            @Override
            public Object map() {
                return ((Checkbox)CheckboxOperator.this.getSource()).getLabel();
            }
        });
    }

    public boolean getState() {
        return this.runMapping(new Operator.MapBooleanAction("getState"){

            @Override
            public boolean map() {
                return ((Checkbox)CheckboxOperator.this.getSource()).getState();
            }
        });
    }

    public void removeItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("removeItemListener"){

            @Override
            public void map() {
                ((Checkbox)CheckboxOperator.this.getSource()).removeItemListener(itemListener);
            }
        });
    }

    public void setCheckboxGroup(final CheckboxGroup grp) {
        this.runMapping(new Operator.MapVoidAction("setCheckboxGroup"){

            @Override
            public void map() {
                ((Checkbox)CheckboxOperator.this.getSource()).setCheckboxGroup(grp);
            }
        });
    }

    public void setLabel(final String string) {
        this.runMapping(new Operator.MapVoidAction("setLabel"){

            @Override
            public void map() {
                ((Checkbox)CheckboxOperator.this.getSource()).setLabel(string);
            }
        });
    }

    public void setState(final boolean state) {
        this.runMapping(new Operator.MapVoidAction("setState"){

            @Override
            public void map() {
                ((Checkbox)CheckboxOperator.this.getSource()).setState(state);
            }
        });
    }

    public static class CheckboxFinder
    extends Operator.Finder {
        public CheckboxFinder(ComponentChooser sf) {
            super(Checkbox.class, sf);
        }

        public CheckboxFinder() {
            super(Checkbox.class);
        }
    }

    public static class CheckboxByLabelFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;

        public CheckboxByLabelFinder(String lb, Operator.StringComparator comparator) {
            this.label = lb;
            this.comparator = comparator;
        }

        public CheckboxByLabelFinder(String lb) {
            this(lb, Operator.getDefaultStringComparator());
        }

        @Override
        public boolean checkComponent(Component comp) {
            if (comp instanceof Checkbox && ((Checkbox)comp).getLabel() != null) {
                return this.comparator.equals(((Checkbox)comp).getLabel(), this.label);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Checkbox with label \"" + this.label + "\"";
        }
    }
}

