/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseSoftwareImageSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="databaseVersion")
    private final String databaseVersion;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="imageType")
    private final ImageType imageType;
    @JsonProperty(value="imageShapeFamily")
    private final ImageShapeFamily imageShapeFamily;
    @JsonProperty(value="patchSet")
    private final String patchSet;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="databaseSoftwareImageIncludedPatches")
    private final List<String> databaseSoftwareImageIncludedPatches;
    @JsonProperty(value="includedPatchesSummary")
    private final String includedPatchesSummary;
    @JsonProperty(value="databaseSoftwareImageOneOffPatches")
    private final List<String> databaseSoftwareImageOneOffPatches;
    @JsonProperty(value="lsInventory")
    private final String lsInventory;
    @JsonProperty(value="isUpgradeSupported")
    private final Boolean isUpgradeSupported;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "databaseVersion", "displayName", "lifecycleState", "lifecycleDetails", "timeCreated", "imageType", "imageShapeFamily", "patchSet", "freeformTags", "definedTags", "databaseSoftwareImageIncludedPatches", "includedPatchesSummary", "databaseSoftwareImageOneOffPatches", "lsInventory", "isUpgradeSupported"})
    public DatabaseSoftwareImageSummary(String id, String compartmentId, String databaseVersion, String displayName, LifecycleState lifecycleState, String lifecycleDetails, Date timeCreated, ImageType imageType, ImageShapeFamily imageShapeFamily, String patchSet, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, List<String> databaseSoftwareImageIncludedPatches, String includedPatchesSummary, List<String> databaseSoftwareImageOneOffPatches, String lsInventory, Boolean isUpgradeSupported) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.databaseVersion = databaseVersion;
        this.displayName = displayName;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.timeCreated = timeCreated;
        this.imageType = imageType;
        this.imageShapeFamily = imageShapeFamily;
        this.patchSet = patchSet;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.databaseSoftwareImageIncludedPatches = databaseSoftwareImageIncludedPatches;
        this.includedPatchesSummary = includedPatchesSummary;
        this.databaseSoftwareImageOneOffPatches = databaseSoftwareImageOneOffPatches;
        this.lsInventory = lsInventory;
        this.isUpgradeSupported = isUpgradeSupported;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public ImageShapeFamily getImageShapeFamily() {
        return this.imageShapeFamily;
    }

    public String getPatchSet() {
        return this.patchSet;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public List<String> getDatabaseSoftwareImageIncludedPatches() {
        return this.databaseSoftwareImageIncludedPatches;
    }

    public String getIncludedPatchesSummary() {
        return this.includedPatchesSummary;
    }

    public List<String> getDatabaseSoftwareImageOneOffPatches() {
        return this.databaseSoftwareImageOneOffPatches;
    }

    public String getLsInventory() {
        return this.lsInventory;
    }

    public Boolean getIsUpgradeSupported() {
        return this.isUpgradeSupported;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseSoftwareImageSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", databaseVersion=").append(String.valueOf(this.databaseVersion));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", imageType=").append(String.valueOf((Object)this.imageType));
        sb.append(", imageShapeFamily=").append(String.valueOf((Object)this.imageShapeFamily));
        sb.append(", patchSet=").append(String.valueOf(this.patchSet));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", databaseSoftwareImageIncludedPatches=").append(String.valueOf(this.databaseSoftwareImageIncludedPatches));
        sb.append(", includedPatchesSummary=").append(String.valueOf(this.includedPatchesSummary));
        sb.append(", databaseSoftwareImageOneOffPatches=").append(String.valueOf(this.databaseSoftwareImageOneOffPatches));
        sb.append(", lsInventory=").append(String.valueOf(this.lsInventory));
        sb.append(", isUpgradeSupported=").append(String.valueOf(this.isUpgradeSupported));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseSoftwareImageSummary)) {
            return false;
        }
        DatabaseSoftwareImageSummary other = (DatabaseSoftwareImageSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.databaseVersion, other.databaseVersion) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.imageType, (Object)other.imageType) && Objects.equals((Object)this.imageShapeFamily, (Object)other.imageShapeFamily) && Objects.equals(this.patchSet, other.patchSet) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.databaseSoftwareImageIncludedPatches, other.databaseSoftwareImageIncludedPatches) && Objects.equals(this.includedPatchesSummary, other.includedPatchesSummary) && Objects.equals(this.databaseSoftwareImageOneOffPatches, other.databaseSoftwareImageOneOffPatches) && Objects.equals(this.lsInventory, other.lsInventory) && Objects.equals(this.isUpgradeSupported, other.isUpgradeSupported) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.databaseVersion == null ? 43 : this.databaseVersion.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.imageType == null ? 43 : this.imageType.hashCode());
        result = result * 59 + (this.imageShapeFamily == null ? 43 : this.imageShapeFamily.hashCode());
        result = result * 59 + (this.patchSet == null ? 43 : this.patchSet.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.databaseSoftwareImageIncludedPatches == null ? 43 : this.databaseSoftwareImageIncludedPatches.hashCode());
        result = result * 59 + (this.includedPatchesSummary == null ? 43 : this.includedPatchesSummary.hashCode());
        result = result * 59 + (this.databaseSoftwareImageOneOffPatches == null ? 43 : this.databaseSoftwareImageOneOffPatches.hashCode());
        result = result * 59 + (this.lsInventory == null ? 43 : this.lsInventory.hashCode());
        result = result * 59 + (this.isUpgradeSupported == null ? 43 : this.isUpgradeSupported.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ImageShapeFamily implements BmcEnum
    {
        VmBmShape("VM_BM_SHAPE"),
        ExadataShape("EXADATA_SHAPE"),
        ExaccShape("EXACC_SHAPE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ImageShapeFamily> map;

        private ImageShapeFamily(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ImageShapeFamily create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ImageShapeFamily', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ImageShapeFamily.class);
            map = new HashMap<String, ImageShapeFamily>();
            for (ImageShapeFamily v : ImageShapeFamily.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ImageType implements BmcEnum
    {
        GridImage("GRID_IMAGE"),
        DatabaseImage("DATABASE_IMAGE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ImageType> map;

        private ImageType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ImageType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ImageType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ImageType.class);
            map = new HashMap<String, ImageType>();
            for (ImageType v : ImageType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Updating("UPDATING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="databaseVersion")
        private String databaseVersion;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="imageType")
        private ImageType imageType;
        @JsonProperty(value="imageShapeFamily")
        private ImageShapeFamily imageShapeFamily;
        @JsonProperty(value="patchSet")
        private String patchSet;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="databaseSoftwareImageIncludedPatches")
        private List<String> databaseSoftwareImageIncludedPatches;
        @JsonProperty(value="includedPatchesSummary")
        private String includedPatchesSummary;
        @JsonProperty(value="databaseSoftwareImageOneOffPatches")
        private List<String> databaseSoftwareImageOneOffPatches;
        @JsonProperty(value="lsInventory")
        private String lsInventory;
        @JsonProperty(value="isUpgradeSupported")
        private Boolean isUpgradeSupported;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder databaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
            this.__explicitlySet__.add("databaseVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder imageType(ImageType imageType) {
            this.imageType = imageType;
            this.__explicitlySet__.add("imageType");
            return this;
        }

        public Builder imageShapeFamily(ImageShapeFamily imageShapeFamily) {
            this.imageShapeFamily = imageShapeFamily;
            this.__explicitlySet__.add("imageShapeFamily");
            return this;
        }

        public Builder patchSet(String patchSet) {
            this.patchSet = patchSet;
            this.__explicitlySet__.add("patchSet");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder databaseSoftwareImageIncludedPatches(List<String> databaseSoftwareImageIncludedPatches) {
            this.databaseSoftwareImageIncludedPatches = databaseSoftwareImageIncludedPatches;
            this.__explicitlySet__.add("databaseSoftwareImageIncludedPatches");
            return this;
        }

        public Builder includedPatchesSummary(String includedPatchesSummary) {
            this.includedPatchesSummary = includedPatchesSummary;
            this.__explicitlySet__.add("includedPatchesSummary");
            return this;
        }

        public Builder databaseSoftwareImageOneOffPatches(List<String> databaseSoftwareImageOneOffPatches) {
            this.databaseSoftwareImageOneOffPatches = databaseSoftwareImageOneOffPatches;
            this.__explicitlySet__.add("databaseSoftwareImageOneOffPatches");
            return this;
        }

        public Builder lsInventory(String lsInventory) {
            this.lsInventory = lsInventory;
            this.__explicitlySet__.add("lsInventory");
            return this;
        }

        public Builder isUpgradeSupported(Boolean isUpgradeSupported) {
            this.isUpgradeSupported = isUpgradeSupported;
            this.__explicitlySet__.add("isUpgradeSupported");
            return this;
        }

        public DatabaseSoftwareImageSummary build() {
            DatabaseSoftwareImageSummary model = new DatabaseSoftwareImageSummary(this.id, this.compartmentId, this.databaseVersion, this.displayName, this.lifecycleState, this.lifecycleDetails, this.timeCreated, this.imageType, this.imageShapeFamily, this.patchSet, this.freeformTags, this.definedTags, this.databaseSoftwareImageIncludedPatches, this.includedPatchesSummary, this.databaseSoftwareImageOneOffPatches, this.lsInventory, this.isUpgradeSupported);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseSoftwareImageSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("databaseVersion")) {
                this.databaseVersion(model.getDatabaseVersion());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("imageType")) {
                this.imageType(model.getImageType());
            }
            if (model.wasPropertyExplicitlySet("imageShapeFamily")) {
                this.imageShapeFamily(model.getImageShapeFamily());
            }
            if (model.wasPropertyExplicitlySet("patchSet")) {
                this.patchSet(model.getPatchSet());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("databaseSoftwareImageIncludedPatches")) {
                this.databaseSoftwareImageIncludedPatches(model.getDatabaseSoftwareImageIncludedPatches());
            }
            if (model.wasPropertyExplicitlySet("includedPatchesSummary")) {
                this.includedPatchesSummary(model.getIncludedPatchesSummary());
            }
            if (model.wasPropertyExplicitlySet("databaseSoftwareImageOneOffPatches")) {
                this.databaseSoftwareImageOneOffPatches(model.getDatabaseSoftwareImageOneOffPatches());
            }
            if (model.wasPropertyExplicitlySet("lsInventory")) {
                this.lsInventory(model.getLsInventory());
            }
            if (model.wasPropertyExplicitlySet("isUpgradeSupported")) {
                this.isUpgradeSupported(model.getIsUpgradeSupported());
            }
            return this;
        }
    }
}

