/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation;

import com.shapesecurity.salvation.Parser;
import com.shapesecurity.salvation.TokeniserWithLocation;
import com.shapesecurity.salvation.data.Location;
import com.shapesecurity.salvation.data.Notice;
import com.shapesecurity.salvation.data.Origin;
import com.shapesecurity.salvation.data.Policy;
import com.shapesecurity.salvation.data.URI;
import com.shapesecurity.salvation.tokens.Token;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ParserWithLocation
extends Parser {
    private final Location EOF;

    private ParserWithLocation(@Nonnull String sourceText, @Nonnull Token[] tokens, @Nonnull Origin origin, @Nullable Collection<Notice> warningsOut) {
        super(tokens, origin, warningsOut);
        this.EOF = new Location(1, sourceText.length() + 1, sourceText.length());
    }

    @Nonnull
    public static Policy parse(@Nonnull String sourceText, @Nonnull Origin origin) {
        return new ParserWithLocation(sourceText, TokeniserWithLocation.tokenise(sourceText), origin, null).parsePolicyAndAssertEOF();
    }

    @Nonnull
    public static Policy parse(@Nonnull String sourceText, @Nonnull Origin origin, @Nonnull Collection<Notice> warningsOut) {
        return new ParserWithLocation(sourceText, TokeniserWithLocation.tokenise(sourceText), origin, warningsOut).parsePolicyAndAssertEOF();
    }

    @Nonnull
    public static Policy parse(@Nonnull String sourceText, @Nonnull String origin) {
        return new ParserWithLocation(sourceText, TokeniserWithLocation.tokenise(sourceText), URI.parse(origin), null).parsePolicyAndAssertEOF();
    }

    @Nonnull
    public static Policy parse(@Nonnull String sourceText, @Nonnull String origin, @Nonnull Collection<Notice> warningsOut) {
        return new ParserWithLocation(sourceText, TokeniserWithLocation.tokenise(sourceText), URI.parse(origin), warningsOut).parsePolicyAndAssertEOF();
    }

    @Nonnull
    public static List<Policy> parseMulti(@Nonnull String sourceText, @Nonnull Origin origin) {
        return new ParserWithLocation(sourceText, TokeniserWithLocation.tokenise(sourceText), origin, null).parsePolicyListAndAssertEOF();
    }

    @Nonnull
    public static List<Policy> parseMulti(@Nonnull String sourceText, @Nonnull String origin) {
        return new ParserWithLocation(sourceText, TokeniserWithLocation.tokenise(sourceText), URI.parse(origin), null).parsePolicyListAndAssertEOF();
    }

    @Nonnull
    public static List<Policy> parseMulti(@Nonnull String sourceText, @Nonnull Origin origin, @Nonnull Collection<Notice> warningsOut) {
        return new ParserWithLocation(sourceText, TokeniserWithLocation.tokenise(sourceText), origin, warningsOut).parsePolicyListAndAssertEOF();
    }

    @Nonnull
    public static List<Policy> parseMulti(@Nonnull String sourceText, @Nonnull String origin, @Nonnull Collection<Notice> warningsOut) {
        return new ParserWithLocation(sourceText, TokeniserWithLocation.tokenise(sourceText), URI.parse(origin), warningsOut).parsePolicyListAndAssertEOF();
    }

    @Nonnull
    private Location getStartLocation(@Nullable Token token) {
        if (token == null || token.startLocation == null) {
            return new Location(1, 1, 0);
        }
        return token.startLocation;
    }

    @Nonnull
    private Location getEndLocation(@Nullable Token token) {
        if (token == null || token.endLocation == null) {
            return this.EOF;
        }
        return token.endLocation;
    }

    @Override
    @Nonnull
    protected Notice createNotice(@Nullable Token token, @Nonnull Notice.Type type, @Nonnull String message) {
        Notice notice = super.createNotice(type, message);
        notice.startLocation = this.getStartLocation(token);
        notice.endLocation = this.getEndLocation(token);
        return notice;
    }
}

