/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class Timestamp
extends SecurityHeaderBlockImpl {
    public static final SimpleDateFormat calendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final SimpleDateFormat calendarFormatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
    private static final TimeZone utc = TimeZone.getTimeZone("UTC");
    private static Calendar utcCalendar = new GregorianCalendar(utc);
    private static final SimpleDateFormat utcCalendarFormatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static Logger log;
    private static String XSD_DATE_TIME;
    public static final long MAX_CLOCK_SKEW = 300000L;
    public static final long TIMESTAMP_FRESHNESS_LIMIT = 300000L;
    private String created;
    private long timeout = 0L;
    private String createdValueType = XSD_DATE_TIME;
    private String expires = null;
    private String expiresValueType = XSD_DATE_TIME;
    private String wsuId = null;

    public Timestamp() {
    }

    public Timestamp(SOAPElement element) throws XWSSecurityException {
        if (!element.getLocalName().equals("Timestamp") || !XMLUtil.inWsuNS(element)) {
            log.log(Level.SEVERE, "WSS0385.error.creating.timestamp", element.getTagName());
            throw new XWSSecurityException("Invalid timestamp element passed");
        }
        this.setSOAPElement(element);
        Iterator<Node> children = element.getChildElements();
        while (children.hasNext()) {
            org.w3c.dom.Node object = children.next();
            if (object.getNodeType() != 1) continue;
            SOAPElement subElement = (SOAPElement)object;
            if ("Created".equals(subElement.getLocalName()) && XMLUtil.inWsuNS(subElement)) {
                if (this.isBSP() && this.created != null) {
                    log.log(Level.SEVERE, "BSP3203.Onecreated.Timestamp");
                    throw new XWSSecurityException("There can be only one wsu:Created element under Timestamp");
                }
                this.created = subElement.getValue();
                this.createdValueType = subElement.getAttribute("ValueType");
                if (this.isBSP() && this.createdValueType != null && this.createdValueType.length() > 0) {
                    log.log(Level.SEVERE, "BSP3225.createdValueType.Timestamp");
                    throw new XWSSecurityException("A wsu:Created element within a TIMESTAMP MUST NOT include a ValueType attribute.");
                }
                if ("".equalsIgnoreCase(this.createdValueType)) {
                    this.createdValueType = null;
                }
            }
            if (!"Expires".equals(subElement.getLocalName()) || !XMLUtil.inWsuNS(subElement)) continue;
            if (this.isBSP() && this.expires != null) {
                log.log(Level.SEVERE, "BSP3224.Oneexpires.Timestamp");
                throw new XWSSecurityException("There can be only one wsu:Expires element under Timestamp");
            }
            if (this.isBSP() && this.created == null) {
                log.log(Level.SEVERE, "BSP3221.CreatedBeforeExpires.Timestamp");
                throw new XWSSecurityException("wsu:Expires must appear after wsu:Created in the Timestamp");
            }
            this.expires = subElement.getValue();
            this.expiresValueType = subElement.getAttribute("ValueType");
            if (this.isBSP() && this.expiresValueType != null && this.expiresValueType.length() > 0) {
                log.log(Level.SEVERE, "BSP3226.expiresValueType.Timestamp");
                throw new XWSSecurityException("A wsu:Expires element within a TIMESTAMP MUST NOT include a ValueType attribute.");
            }
            if (!"".equalsIgnoreCase(this.expiresValueType)) continue;
            this.expiresValueType = null;
        }
        this.wsuId = element.getAttribute("wsu:Id");
        if ("".equalsIgnoreCase(this.wsuId)) {
            this.wsuId = null;
        }
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getCreatedValueType() {
        return this.createdValueType;
    }

    public void setCreatedValueType(String createdValueType) {
        this.createdValueType = createdValueType;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getExpires() {
        return this.expires;
    }

    public void setExpires(String expires) {
        this.expires = expires;
    }

    public String getExpiresValueType() {
        return this.expiresValueType;
    }

    public void setExpiresValueType(String expiresValueType) {
        this.expiresValueType = expiresValueType;
    }

    @Override
    public String getId() {
        return this.wsuId;
    }

    public void setId(String wsuId) {
        this.wsuId = wsuId;
    }

    @Override
    public SOAPElement getAsSoapElement() throws XWSSecurityException {
        SOAPElement timestamp;
        this.createDateTime();
        try {
            timestamp = Timestamp.getSoapFactory().createElement("Timestamp", "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            timestamp.addNamespaceDeclaration("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            SOAPElement createdElement = timestamp.addChildElement("Created", "wsu").addTextNode(this.created);
            if (this.createdValueType != null && !XSD_DATE_TIME.equalsIgnoreCase(this.createdValueType)) {
                createdElement.setAttribute("ValueType", this.createdValueType);
            }
            if (this.expires != null) {
                SOAPElement expiresElement = timestamp.addChildElement("Expires", "wsu").addTextNode(this.expires);
                if (this.expiresValueType != null && !XSD_DATE_TIME.equalsIgnoreCase(this.expiresValueType)) {
                    expiresElement.setAttribute("ValueType", this.expiresValueType);
                }
            }
            if (this.wsuId != null) {
                this.setWsuIdAttr(timestamp, this.getId());
            }
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, "WSS0386.error.creating.timestamp", se.getMessage());
            throw new XWSSecurityException("There was an error creating  Timestamp " + se.getMessage());
        }
        this.setSOAPElement(timestamp);
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDateTime() throws XWSSecurityException {
        if (this.created == null) {
            Calendar calendar = utcCalendar;
            synchronized (calendar) {
                long currentTime = System.currentTimeMillis();
                utcCalendar.setTimeInMillis(currentTime);
                this.setCreated(utcCalendarFormatter1.format(utcCalendar.getTime()));
                utcCalendar.setTimeInMillis(currentTime + this.timeout);
                this.setExpires(utcCalendarFormatter1.format(utcCalendar.getTime()));
            }
        }
    }

    static {
        utcCalendarFormatter1.setTimeZone(utc);
        log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
        XSD_DATE_TIME = "xsd:dateTime";
    }
}

