/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.classpath;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.javascript2.editor.index.JsIndexer;
import org.netbeans.modules.javascript2.model.spi.PlatformProvider;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ClassPathProviderImpl
implements ClassPathProvider,
PlatformProvider {
    private static final Logger LOG = Logger.getLogger(ClassPathProviderImpl.class.getName());
    protected static final RequestProcessor RP = new RequestProcessor(ClassPathProviderImpl.class);
    public static final String BOOT_CP = "classpath/javascript-boot";
    public static final AtomicBoolean JS_CLASSPATH_REGISTERED = new AtomicBoolean(false);
    private static ClassPath cachedBootClassPath;
    private static List<FileObject> roots;
    private static final StubsBundle[] STUBS_BUNDLES;

    public ClassPath findClassPath(FileObject file, String type) {
        if (type.equals(BOOT_CP)) {
            return ClassPathProviderImpl.getBootClassPath();
        }
        return null;
    }

    public List<FileObject> getPlatformStubs() {
        return Collections.unmodifiableList(ClassPathProviderImpl.getJsStubs());
    }

    public static synchronized ClassPath getBootClassPath() {
        if (cachedBootClassPath == null) {
            List<FileObject> stubs = ClassPathProviderImpl.getJsStubs();
            cachedBootClassPath = ClassPathSupport.createClassPath((FileObject[])stubs.toArray(new FileObject[0]));
        }
        return cachedBootClassPath;
    }

    public static synchronized List<FileObject> getJsStubs() {
        if (roots == null) {
            ArrayList<FileObject> result = new ArrayList<FileObject>(STUBS_BUNDLES.length);
            for (StubsBundle bundle : STUBS_BUNDLES) {
                File stubFile;
                block8: {
                    stubFile = InstalledFileLocator.getDefault().locate("jsstubs/" + bundle.getNameOfDocumented(), "org.netbeans.modules.javascript2.editor", false);
                    if (stubFile == null || !stubFile.exists()) {
                        stubFile = InstalledFileLocator.getDefault().locate("jsstubs/" + bundle.getNameOfPruned(), "org.netbeans.modules.javascript2.editor", false);
                    }
                    if (stubFile == null) {
                        LOG.log(Level.INFO, "Stubfile not found for ({0} / {1}) using InstalledFileLocator, using fallback", new Object[]{bundle.getNameOfPruned(), bundle.getNameOfDocumented()});
                        try {
                            URI moduleJarUri = ClassPathProviderImpl.class.getProtectionDomain().getCodeSource().getLocation().toURI();
                            LOG.log(Level.FINE, "Module JAR: {0}", moduleJarUri);
                            if ("jar".equals(moduleJarUri.getScheme())) {
                                JarURLConnection jarUrlConnection = (JarURLConnection)moduleJarUri.toURL().openConnection();
                                moduleJarUri = jarUrlConnection.getJarFileURL().toURI();
                                LOG.log(Level.FINE, "Module JAR (unwrapped): {0}", moduleJarUri);
                            }
                            File moduleJar = Utilities.toFile((URI)moduleJarUri);
                            LOG.log(Level.FINE, "Module File: {0}", moduleJar);
                            stubFile = new File(moduleJar.getParentFile().getParentFile(), "jsstubs/" + bundle.getNameOfPruned());
                        }
                        catch (IOException | IllegalArgumentException | URISyntaxException x) {
                            if ($assertionsDisabled) break block8;
                            throw new AssertionError((Object)x);
                        }
                    }
                }
                if (stubFile == null || !stubFile.isFile() || !stubFile.exists()) {
                    LOG.log(Level.WARNING, "JavaScript stubs file was not found: {0}", stubFile != null ? stubFile.getAbsolutePath() : null);
                    continue;
                }
                result.add(FileUtil.getArchiveRoot((FileObject)FileUtil.toFileObject((File)stubFile)));
            }
            roots = result;
        }
        return Collections.unmodifiableList(roots);
    }

    public static void registerJsClassPathIfNeeded() {
        Runnable action = () -> ClassPathProviderImpl.registerJsClassPathIfNeededImpl();
        if (JsIndexer.Factory.isScannerThread()) {
            JsIndexer.Factory.addPostScanTask(action);
        } else {
            action.run();
        }
    }

    private static void registerJsClassPathIfNeededImpl() {
        if (JS_CLASSPATH_REGISTERED.compareAndSet(false, true)) {
            SwingUtilities.invokeLater(() -> {
                ClassPath cp = ClassPathProviderImpl.getBootClassPath();
                if (cp != null) {
                    GlobalPathRegistry.getDefault().register(BOOT_CP, new ClassPath[]{cp});
                }
            });
        }
    }

    static {
        STUBS_BUNDLES = new StubsBundle[]{new StubsBundle("core-stubs.zip", "core-doc-stubs.zip"), new StubsBundle("dom-stubs.zip", "dom-doc-stubs.zip")};
    }

    private static class StubsBundle {
        private final String nameOfPruned;
        private final String nameOfDocumented;

        public StubsBundle(String nameOfPruned, String nameOfDocumented) {
            this.nameOfPruned = nameOfPruned;
            this.nameOfDocumented = nameOfDocumented;
        }

        public String getNameOfPruned() {
            return this.nameOfPruned;
        }

        public String getNameOfDocumented() {
            return this.nameOfDocumented;
        }
    }
}

