/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.php.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.hudson.php.ui.options.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HudsonOptionsPanel
extends JPanel {
    private static final long serialVersionUID = -1655785467878L;
    private static final String JOB_CONFIG_LAST_FOLDER_SUFFIX = ".jobConfig";
    private static final String HOME_DIR = System.getProperty("user.home");
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton buildXmlBrowseButton;
    private JLabel buildXmlLabel;
    private JTextField buildXmlTextField;
    private JLabel buildXmlViewLabel;
    private JLabel configNoteLabel;
    private JLabel errorLabel;
    private JLabel installationInfoLabel;
    private JButton jobConfigBrowseButton;
    private JLabel jobConfigDownloadLabel;
    private JLabel jobConfigLabel;
    private JTextField jobConfigTextField;
    private JLabel learnMoreLabel;
    private JLabel noteLabel;
    private JButton phpUnitConfigBrowseButton;
    private JLabel phpUnitConfigLabel;
    private JTextField phpUnitConfigTextField;
    private JLabel phpUnitConfigViewLabel;

    public HudsonOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.configNoteLabel.setText(Bundle.HudsonOptionsPanel_note_config());
        this.errorLabel.setText(" ");
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        this.buildXmlTextField.getDocument().addDocumentListener(documentListener);
        this.jobConfigTextField.getDocument().addDocumentListener(documentListener);
        this.phpUnitConfigTextField.getDocument().addDocumentListener(documentListener);
    }

    public String getBuildXml() {
        return this.buildXmlTextField.getText();
    }

    public void setBuildXml(String buildXml) {
        this.buildXmlTextField.setText(buildXml);
    }

    public String getJobConfig() {
        return this.jobConfigTextField.getText();
    }

    public void setJobConfig(String jobConfig) {
        this.jobConfigTextField.setText(jobConfig);
    }

    public String getPhpUnitConfig() {
        return this.phpUnitConfigTextField.getText();
    }

    public void setPhpUnitConfig(String phpUnitConfig) {
        this.phpUnitConfigTextField.setText(phpUnitConfig);
    }

    public void setError(String message) {
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.buildXmlLabel = new JLabel();
        this.buildXmlTextField = new JTextField();
        this.buildXmlBrowseButton = new JButton();
        this.buildXmlViewLabel = new JLabel();
        this.jobConfigLabel = new JLabel();
        this.jobConfigTextField = new JTextField();
        this.jobConfigBrowseButton = new JButton();
        this.jobConfigDownloadLabel = new JLabel();
        this.phpUnitConfigLabel = new JLabel();
        this.phpUnitConfigTextField = new JTextField();
        this.phpUnitConfigBrowseButton = new JButton();
        this.phpUnitConfigViewLabel = new JLabel();
        this.noteLabel = new JLabel();
        this.configNoteLabel = new JLabel();
        this.installationInfoLabel = new JLabel();
        this.learnMoreLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.buildXmlLabel.setLabelFor(this.buildXmlTextField);
        Mnemonics.setLocalizedText((JLabel)this.buildXmlLabel, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.buildXmlLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.buildXmlBrowseButton, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.buildXmlBrowseButton.text"));
        this.buildXmlBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HudsonOptionsPanel.this.buildXmlBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.buildXmlViewLabel, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.buildXmlViewLabel.text"));
        this.buildXmlViewLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                HudsonOptionsPanel.this.buildXmlViewLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                HudsonOptionsPanel.this.buildXmlViewLabelMousePressed(evt);
            }
        });
        this.jobConfigLabel.setLabelFor(this.jobConfigTextField);
        Mnemonics.setLocalizedText((JLabel)this.jobConfigLabel, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.jobConfigLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jobConfigBrowseButton, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.jobConfigBrowseButton.text"));
        this.jobConfigBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HudsonOptionsPanel.this.jobConfigBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jobConfigDownloadLabel, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.jobConfigDownloadLabel.text"));
        this.jobConfigDownloadLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                HudsonOptionsPanel.this.jobConfigDownloadLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                HudsonOptionsPanel.this.jobConfigDownloadLabelMousePressed(evt);
            }
        });
        this.phpUnitConfigLabel.setLabelFor(this.phpUnitConfigTextField);
        Mnemonics.setLocalizedText((JLabel)this.phpUnitConfigLabel, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.phpUnitConfigLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.phpUnitConfigBrowseButton, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.phpUnitConfigBrowseButton.text"));
        this.phpUnitConfigBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HudsonOptionsPanel.this.phpUnitConfigBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.phpUnitConfigViewLabel, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.phpUnitConfigViewLabel.text"));
        this.phpUnitConfigViewLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                HudsonOptionsPanel.this.phpUnitConfigViewLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                HudsonOptionsPanel.this.phpUnitConfigViewLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.configNoteLabel, (String)"CONFIG NOTE");
        Mnemonics.setLocalizedText((JLabel)this.installationInfoLabel, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.installationInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.learnMoreLabel, (String)NbBundle.getMessage(HudsonOptionsPanel.class, (String)"HudsonOptionsPanel.learnMoreLabel.text"));
        this.learnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                HudsonOptionsPanel.this.learnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                HudsonOptionsPanel.this.learnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.configNoteLabel).addComponent(this.installationInfoLabel).addComponent(this.learnMoreLabel, -2, -1, -2)).addContainerGap(27, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteLabel, -2, -1, -2).addComponent(this.errorLabel)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buildXmlLabel).addComponent(this.jobConfigLabel).addComponent(this.phpUnitConfigLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buildXmlTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buildXmlBrowseButton)).addGroup(layout.createSequentialGroup().addComponent(this.jobConfigTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jobConfigBrowseButton)).addGroup(layout.createSequentialGroup().addComponent(this.phpUnitConfigTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpUnitConfigBrowseButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpUnitConfigViewLabel, -2, -1, -2).addComponent(this.jobConfigDownloadLabel, -2, -1, -2).addComponent(this.buildXmlViewLabel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)))));
        layout.linkSize(0, this.buildXmlBrowseButton, this.jobConfigBrowseButton, this.phpUnitConfigBrowseButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buildXmlLabel).addComponent(this.buildXmlTextField, -2, -1, -2).addComponent(this.buildXmlBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buildXmlViewLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jobConfigTextField, -2, -1, -2).addComponent(this.jobConfigBrowseButton).addComponent(this.jobConfigLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jobConfigDownloadLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpUnitConfigTextField, -2, -1, -2).addComponent(this.phpUnitConfigBrowseButton).addComponent(this.phpUnitConfigLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpUnitConfigViewLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configNoteLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.installationInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.learnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void learnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void learnMoreLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://jenkins-php.org/"));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void jobConfigDownloadLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void jobConfigDownloadLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("https://raw.github.com/sebastianbergmann/php-jenkins-template/master/config.xml"));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void jobConfigBrowseButtonActionPerformed(ActionEvent evt) {
        File jobConfig = new FileChooserBuilder(HudsonOptionsPanel.class.getName() + JOB_CONFIG_LAST_FOLDER_SUFFIX).setTitle(Bundle.HudsonOptionsPanel_jobConfig_browse_title("config.xml")).setFilesOnly(true).setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return "config.xml".equals(f.getName());
            }

            @Override
            public String getDescription() {
                return Bundle.HudsonOptionsPanel_jobConfig_browse_filter("config.xml");
            }
        }).showOpenDialog();
        if (jobConfig != null) {
            jobConfig = FileUtil.normalizeFile((File)jobConfig);
            this.jobConfigTextField.setText(jobConfig.getAbsolutePath());
        }
    }

    private void buildXmlBrowseButtonActionPerformed(ActionEvent evt) {
        File buildXml = new FileChooserBuilder(HudsonOptionsPanel.class).setTitle(Bundle.HudsonOptionsPanel_buildXml_browse_title("build.xml")).setDefaultWorkingDirectory(new File(HOME_DIR)).setFilesOnly(true).setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return "build.xml".equals(f.getName());
            }

            @Override
            public String getDescription() {
                return Bundle.HudsonOptionsPanel_buildXml_browse_filter("build.xml");
            }
        }).showOpenDialog();
        if (buildXml != null) {
            buildXml = FileUtil.normalizeFile((File)buildXml);
            this.buildXmlTextField.setText(buildXml.getAbsolutePath());
        }
    }

    private void phpUnitConfigBrowseButtonActionPerformed(ActionEvent evt) {
        File phpUnitConfig = new FileChooserBuilder(HudsonOptionsPanel.class.getName()).setTitle(Bundle.HudsonOptionsPanel_phpUnitConfig_browse_title("phpunit.xml", "phpunit.xml.dist")).setDefaultWorkingDirectory(new File(HOME_DIR)).setFilesOnly(true).setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                return name.equals("phpunit.xml") || name.equals("phpunit.xml.dist");
            }

            @Override
            public String getDescription() {
                return Bundle.HudsonOptionsPanel_phpUnitConfig_browse_filter("phpunit.xml", "phpunit.xml.dist");
            }
        }).showOpenDialog();
        if (phpUnitConfig != null) {
            phpUnitConfig = FileUtil.normalizeFile((File)phpUnitConfig);
            this.phpUnitConfigTextField.setText(phpUnitConfig.getAbsolutePath());
        }
    }

    private void buildXmlViewLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void buildXmlViewLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://jenkins-php.org/download/build.xml"));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void phpUnitConfigViewLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void phpUnitConfigViewLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://jenkins-php.org/download/phpunit.xml.dist"));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            HudsonOptionsPanel.this.fireChange();
        }
    }
}

