/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.impl;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.gsf.testrunner.ui.api.CallstackFrameNode;
import org.netbeans.modules.gsf.testrunner.ui.api.DiffViewAction;
import org.netbeans.modules.gsf.testrunner.ui.api.Manager;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodNode;
import org.netbeans.modules.gsf.testrunner.ui.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.ui.api.TestsuiteNode;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.ui.FailureDataDisplayer;
import org.netbeans.modules.hudson.api.ui.OpenableInBrowser;
import org.netbeans.modules.hudson.spi.FailureDataDisplayerImpl;
import org.netbeans.modules.hudson.ui.actions.Hyperlinker;
import org.netbeans.modules.hudson.ui.actions.OpenUrlAction;
import org.netbeans.modules.hudson.ui.impl.Bundle;
import org.netbeans.modules.hudson.ui.impl.HudsonLoggerHelper;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class HudsonFailureDisplayer
extends FailureDataDisplayerImpl {
    private static final RequestProcessor RP = new RequestProcessor(HudsonFailureDisplayer.class.getName());
    private static final Logger LOG = Logger.getLogger(HudsonFailureDisplayer.class.getName());
    private static final Pattern ASSERTION_FAILURE = Pattern.compile("(?m)junit[.]framework[.](AssertionFailedError|(Array)?ComparisonFailure)|java[.]lang[.]AssertionError($|: )");
    private final Project project;
    private final TestSession session;
    private final Hyperlinker hyperlinker;
    private InputOutput io;
    private final HudsonJob job;
    private final HudsonJobBuild build;
    private final String displayName;
    boolean firstLine = true;

    public HudsonFailureDisplayer(HudsonJobBuild build) {
        this(build, build.getDisplayName());
    }

    public HudsonFailureDisplayer(HudsonMavenModuleBuild moduleBuild) {
        this(moduleBuild.getBuild(), moduleBuild.getDisplayName());
    }

    private HudsonFailureDisplayer(HudsonJobBuild build, String displayName) {
        this.build = build;
        this.job = this.build.getJob();
        this.displayName = displayName;
        this.hyperlinker = new Hyperlinker(this.job);
        this.project = this.createDummyProject();
        this.session = this.createTestSession(displayName);
    }

    private Project createDummyProject() {
        return new Project(){

            public FileObject getProjectDirectory() {
                return FileUtil.createMemoryFileSystem().getRoot();
            }

            public Lookup getLookup() {
                return Lookup.EMPTY;
            }
        };
    }

    private TestSession createTestSession(String displayName) {
        Manager.getInstance().setNodeFactory((TestRunnerNodeFactory)new HudsonTestRunnerNodeFactory());
        return new TestSession(displayName, this.project, TestSession.SessionType.TEST);
    }

    private void prepareOutput() {
        if (this.io == null) {
            String title = Bundle.ShowFailures_title(this.displayName);
            this.io = IOProvider.getDefault().getIO(title, new Action[0]);
            this.io.select();
            Manager.getInstance().testStarted(this.session);
        }
    }

    public void open() {
    }

    public void showSuite(FailureDataDisplayer.Suite s) {
        this.prepareOutput();
        OutputWriter out = this.io.getOut();
        OutputWriter err = this.io.getErr();
        TestSuite suite = new TestSuite(s.getName());
        this.session.addSuite(suite);
        Manager.getInstance().displaySuiteRunning(this.session, suite.getName());
        if (s.getStderr() != null) {
            Manager.getInstance().displayOutput(this.session, s.getStderr(), true);
        }
        if (s.getStdout() != null) {
            Manager.getInstance().displayOutput(this.session, s.getStdout(), false);
        }
        for (FailureDataDisplayer.Case c : s.getCases()) {
            if (c.getErrorStackTrace() == null) continue;
            String name = c.getClassName() + "." + c.getName();
            String shortName = c.getName();
            if (s.getName() != null && !s.getName().equals(c.getClassName())) {
                shortName = name;
                name = Bundle.ShowFailures_from_suite(name, s.getName());
            }
            this.println();
            out.println("[" + name + "]");
            this.show(c.getErrorStackTrace(), out);
            Testcase test = new Testcase(shortName, null, this.session);
            test.setClassName(c.getClassName());
            Trouble trouble = new Trouble(!ASSERTION_FAILURE.matcher(c.getErrorStackTrace()).lookingAt());
            trouble.setStackTrace(c.getErrorStackTrace().split("\r?\n"));
            test.setTrouble(trouble);
            LOG.log(Level.FINE, "got {0} as {1}", new Object[]{name, test.getStatus()});
            test.setTimeMillis(c.getDuration());
            this.session.addTestCase(test);
        }
        if (s.getStderr() != null || s.getStdout() != null) {
            this.println();
            this.show(s.getStderr(), err);
            this.show(s.getStdout(), out);
        }
        Manager.getInstance().displayReport(this.session, this.session.getReport(s.getDuration()));
    }

    void println() {
        if (this.firstLine) {
            this.firstLine = false;
        } else {
            this.io.getOut().println();
        }
    }

    void show(String lines, OutputWriter w) {
        if (lines == null) {
            return;
        }
        for (String line : lines.split("\r\n?|\n")) {
            this.hyperlinker.handleLine(line, w);
        }
    }

    public void close() {
        if (this.io != null) {
            this.io.getOut().close();
            this.io.getErr().close();
            Manager.getInstance().sessionFinished(this.session);
        }
    }

    private class HudsonTestRunnerNodeFactory
    extends TestRunnerNodeFactory {
        public TestsuiteNode createTestSuiteNode(String suiteName, boolean filtered) {
            return new TestsuiteNode(suiteName, filtered);
        }

        public Node createTestMethodNode(Testcase testcase, Project project) {
            return new TestMethodNode(testcase, project){

                public Action[] getActions(boolean context) {
                    return new Action[]{OpenUrlAction.forOpenable(new OpenableInBrowser(){

                        public String getUrl() {
                            return HudsonFailureDisplayer.this.job.getUrl() + "testReport/" + testcase.getClassName().replaceFirst("[.][^.]+$", "") + "/" + testcase.getClassName().replaceFirst(".+[.]", "") + "/" + testcase.getName() + "/";
                        }
                    }), new DiffViewAction(this.testcase)};
                }
            };
        }

        public Node createCallstackFrameNode(String frameInfo, String displayName) {
            return new CallstackFrameNode(frameInfo, displayName){

                public Action getPreferredAction() {
                    return new AbstractAction(Bundle.LBL_GotoSource()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            final Matcher m = Pattern.compile("\tat (.+[.])[^.]+[.][^.]+[(]([^.]+[.]java):([0-9]+)[)]").matcher(frameInfo);
                            if (m.matches()) {
                                final String resource = m.group(1).replace('.', '/') + m.group(2);
                                RP.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        FileObject f = GlobalPathRegistry.getDefault().findResource(resource);
                                        LOG.log(Level.FINER, "matched {0} -> {1}", new Object[]{resource, f});
                                        if (f != null) {
                                            HudsonLoggerHelper.openAt(f, Integer.parseInt(m.group(3)) - 1, -1, true);
                                        } else {
                                            StatusDisplayer.getDefault().setStatusText(Bundle.no_source_to_hyperlink(resource));
                                        }
                                    }
                                });
                            } else {
                                LOG.log(Level.FINER, "no match for {0}", frameInfo);
                            }
                        }
                    };
                }

                public Action[] getActions(boolean context) {
                    return new Action[]{this.getPreferredAction()};
                }
            };
        }
    }
}

