/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.util;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.api.common.project.ui.customizer.MainClassChooser;
import org.netbeans.spi.project.libraries.LibraryImplementation3;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class CommonProjectUtils {
    public static final String J2SE_PLATFORM_TYPE = "j2se";

    private CommonProjectUtils() {
    }

    @CheckForNull
    public static JavaPlatform getActivePlatform(String activePlatformId) {
        return CommonProjectUtils.getActivePlatform(activePlatformId, null);
    }

    @CheckForNull
    public static JavaPlatform getActivePlatform(@NullAllowed String activePlatformId, @NullAllowed String platformType) {
        JavaPlatform[] installedPlatforms;
        if (platformType == null) {
            platformType = J2SE_PLATFORM_TYPE;
        }
        JavaPlatformManager pm = JavaPlatformManager.getDefault();
        if (activePlatformId == null) {
            JavaPlatform candidate = pm.getDefaultPlatform();
            return candidate == null || !platformType.equals(candidate.getSpecification().getName()) ? null : candidate;
        }
        for (JavaPlatform javaPlatform : installedPlatforms = pm.getPlatforms(null, new Specification(platformType, null))) {
            String antName = (String)javaPlatform.getProperties().get("platform.ant.name");
            if (antName == null || !antName.equals(activePlatformId)) continue;
            return javaPlatform;
        }
        return null;
    }

    public static String getAntPropertyName(String property) {
        if (property != null && property.startsWith("${") && property.endsWith("}")) {
            return property.substring(2, property.length() - 1);
        }
        return property;
    }

    public static Collection<ElementHandle<TypeElement>> getMainMethods(FileObject fo) {
        if (fo == null || MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return Collections.emptySet();
        }
        return SourceUtils.getMainClasses((FileObject)fo);
    }

    public static boolean hasMainMethod(FileObject fo) {
        if (MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return MainClassChooser.unitTestingSupport_hasMainMethodResult;
        }
        if (fo == null) {
            return false;
        }
        return !SourceUtils.getMainClasses((FileObject)fo).isEmpty();
    }

    public static boolean isMainClass(String className, ClassPath bootPath, ClassPath compilePath, ClassPath sourcePath) {
        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)bootPath, (ClassPath)compilePath, (ClassPath)sourcePath);
        return SourceUtils.isMainClass((String)className, (ClasspathInfo)cpInfo);
    }

    @NonNull
    public static String getBuildXmlName(@NonNull PropertyEvaluator eval, @NullAllowed String propName) {
        String buildScriptPath = eval.getProperty(propName != null ? propName : "buildfile");
        if (buildScriptPath == null || buildScriptPath.isEmpty()) {
            buildScriptPath = "build.xml";
        }
        return buildScriptPath;
    }

    public static LibraryImplementation3 createJavaLibraryImplementation(@NonNull String name, @NonNull URL[] classPath, @NonNull URL[] sources, @NonNull URL[] javadoc, @NonNull String[] mavendeps, @NonNull String[] mavenrepos) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"classPath", (Object)classPath);
        Parameters.notNull((CharSequence)"src", (Object)sources);
        Parameters.notNull((CharSequence)"javadoc", (Object)javadoc);
        Parameters.notNull((CharSequence)"mavendeps", (Object)mavendeps);
        Parameters.notNull((CharSequence)"mavenrepos", (Object)mavenrepos);
        LibraryImplementation3 impl = LibrariesSupport.createLibraryImplementation3((String)J2SE_PLATFORM_TYPE, (String[])new String[]{"classpath", "src", "javadoc"});
        impl.setName(name);
        impl.setContent("classpath", Arrays.asList(classPath));
        impl.setContent("src", Arrays.asList(sources));
        impl.setContent("javadoc", Arrays.asList(javadoc));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("maven-dependencies", CommonProjectUtils.getPropertyValue(mavendeps));
        props.put("maven-repositories", CommonProjectUtils.getPropertyValue(mavenrepos));
        impl.setProperties(props);
        return impl;
    }

    @NonNull
    private static String getPropertyValue(@NonNull String[] values) {
        StringBuilder result = new StringBuilder();
        for (String value : values) {
            result.append(value);
            result.append(' ');
        }
        return result.length() == 0 ? result.toString() : result.substring(0, result.length() - 1);
    }
}

