/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

public class PartitionManagerOptions {
    public static final int DefaultLeaseDurationInSeconds = 30;
    public static final int DefaultLeaseRenewIntervalInSeconds = 10;
    public static final int DefaultCheckpointTimeoutInSeconds = 120;
    public static final int DefaultStartupScanDelayInSeconds = 30;
    public static final int DefaultFastScanIntervalInSeconds = 3;
    public static final int DefaultSlowScanIntervalInSeconds = 5;
    protected int leaseDurationInSeconds = 30;
    protected int leaseRenewIntervalInSeconds = 10;
    protected int checkpointTimeoutInSeconds = 120;
    protected int startupScanDelayInSeconds = 30;
    protected int fastScanIntervalInSeconds = 3;
    protected int slowScanIntervalInSeconds = 5;

    public int getLeaseDurationInSeconds() {
        return this.leaseDurationInSeconds;
    }

    public void setLeaseDurationInSeconds(int duration) {
        if (duration <= 0) {
            throw new IllegalArgumentException("Lease duration must be greater than 0");
        }
        this.leaseDurationInSeconds = duration;
    }

    public int getLeaseRenewIntervalInSeconds() {
        return this.leaseRenewIntervalInSeconds;
    }

    public void setLeaseRenewIntervalInSeconds(int interval) {
        if (interval <= 0 || interval > this.leaseDurationInSeconds) {
            throw new IllegalArgumentException("Lease renew interval must be greater than 0 and not more than lease duration");
        }
        this.leaseRenewIntervalInSeconds = interval;
    }

    public int getCheckpointTimeoutInSeconds() {
        return this.checkpointTimeoutInSeconds;
    }

    public void setCheckpointTimeoutInSeconds(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Checkpoint timeout must be greater than 0");
        }
        this.checkpointTimeoutInSeconds = timeout;
    }

    public int getStartupScanDelayInSeconds() {
        return this.startupScanDelayInSeconds;
    }

    public void setStartupScanDelayInSeconds(int delay) {
        if (delay <= 0) {
            throw new IllegalArgumentException("Startup scan delay must be greater than 0");
        }
        this.startupScanDelayInSeconds = delay;
    }

    public int getFastScanIntervalInSeconds() {
        return this.fastScanIntervalInSeconds;
    }

    public void setFastScanIntervalInSeconds(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("Fast scan interval must be greater than 0");
        }
        this.fastScanIntervalInSeconds = interval;
    }

    public int getSlowScanIntervalInSeconds() {
        return this.slowScanIntervalInSeconds;
    }

    public void setSlowScanIntervalInSeconds(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("Slow scan interval must be greater than 0");
        }
        this.slowScanIntervalInSeconds = interval;
    }
}

