/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.jboss.logging.Logger;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.RealmMigration;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.DefaultKeyProviders;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.userprofile.UserProfileProvider;

public class MigrateTo24_0_0
extends RealmMigration {
    private static final Logger LOG = Logger.getLogger(MigrateTo24_0_0.class);
    public static final ModelVersion VERSION = new ModelVersion("24.0.0");
    public static final String REALM_USER_PROFILE_ENABLED = "userProfileEnabled";

    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrateRealm(KeycloakSession session, RealmModel realm) {
        this.updateUserProfileSettings(session);
        this.updateLdapProviderConfig(session);
        this.createHS512ComponentModelKey(session);
        this.bindFirstBrokerLoginFlow(session);
    }

    private void updateUserProfileSettings(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        boolean isUserProfileEnabled = Boolean.parseBoolean(realm.getAttribute(REALM_USER_PROFILE_ENABLED));
        realm.removeAttribute(REALM_USER_PROFILE_ENABLED);
        if (isUserProfileEnabled) {
            LOG.debugf("Skipping migration for realm %s. The declarative user profile is already enabled.", (Object)realm.getName());
            return;
        }
        UserProfileProvider provider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
        UPConfig upConfig = provider.getConfiguration();
        upConfig.setUnmanagedAttributePolicy(UPConfig.UnmanagedAttributePolicy.ENABLED);
        provider.setConfiguration(upConfig);
        LOG.debugf("Enabled the declarative user profile to realm %s with support for unmanaged attributes", (Object)realm.getName());
    }

    private void updateLdapProviderConfig(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        realm.getComponentsStream(realm.getId(), UserStorageProvider.class.getName()).filter(c -> "ldapsOnly".equals(c.getConfig().getFirst((Object)"useTruststoreSpi"))).forEach(c -> {
            c.getConfig().putSingle((Object)"useTruststoreSpi", (Object)"always");
            realm.updateComponent(c);
        });
    }

    private void createHS512ComponentModelKey(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        DefaultKeyProviders.createSecretProvider((RealmModel)realm);
    }

    private void bindFirstBrokerLoginFlow(KeycloakSession session) {
        String flowAlias;
        RealmModel realm = session.getContext().getRealm();
        AuthenticationFlowModel flow = realm.getFlowByAlias(flowAlias = "first broker login");
        if (flow == null) {
            LOG.debugf("No flow found for alias '%s'. Skipping.", (Object)flowAlias);
            return;
        }
        realm.setFirstBrokerLoginFlow(flow);
        LOG.debugf("Flow '%s' has been bound to realm %s as 'First broker login' flow", (Object)flow.getId(), (Object)realm.getName());
    }
}

