/*
 * Decompiled with CFR 0.152.
 */
package tr.model.action;

import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;
import tr.model.Data;
import tr.model.action.Action;
import tr.model.action.ActionStateScheduled;
import tr.model.action.Recurrence;
import tr.model.project.Project;
import tr.util.DateUtils;
import tr.util.ObservableImpl;

public class RecurrenceRemover
extends Thread {
    private static final Logger LOG = Logger.getLogger("tr.model.action");

    private RecurrenceRemover() {
    }

    public static void remove(Data data, int recurrenceID) {
        new RemoverThread(data, recurrenceID).start();
    }

    public static void remove(Data data, int recurrenceID, Date beforeDate) {
        if (beforeDate == null) {
            throw new IllegalArgumentException("Null date.");
        }
        new RemoverThread(data, recurrenceID, beforeDate).start();
    }

    public static void removeAll(Data data) {
        new RemoverThread(data).start();
    }

    private static class RemoverThread
    extends Thread {
        private final Data data;
        private final boolean removeAll;
        private final int recurrenceID;
        private final Date beforeDate;

        public RemoverThread(Data data) {
            this.data = data;
            this.removeAll = true;
            this.recurrenceID = 0;
            this.beforeDate = DateUtils.MAX_DATE;
        }

        public RemoverThread(Data data, int recurrenceID) {
            this.data = data;
            this.recurrenceID = recurrenceID;
            this.removeAll = false;
            this.beforeDate = DateUtils.MAX_DATE;
        }

        public RemoverThread(Data data, int recurrenceID, Date beforeDate) {
            this.data = data;
            this.recurrenceID = recurrenceID;
            this.removeAll = false;
            this.beforeDate = beforeDate;
        }

        public void run() {
            if (this.data == null) {
                LOG.severe("Data instance was not provided.");
                return;
            }
            this.process(this.data.getRootActions());
            this.process(this.data.getRootProjects());
        }

        private void process(Project project) {
            Iterator<ObservableImpl> i = project.iterator(Action.class);
            while (i.hasNext()) {
                this.process(i.next());
            }
            i = project.iterator(Project.class);
            while (i.hasNext()) {
                this.process((Project)i.next());
            }
        }

        private void process(Action action) {
            if (!action.isStateScheduled()) {
                return;
            }
            ActionStateScheduled state = (ActionStateScheduled)action.getState();
            if (state == null) {
                return;
            }
            Recurrence recurrence = state.getRecurrence();
            if (recurrence == null) {
                return;
            }
            if (!state.getDate().before(this.beforeDate)) {
                return;
            }
            if (this.removeAll || recurrence.getID() == this.recurrenceID) {
                state.setRecurrence(null);
            }
        }
    }
}

