/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.model.IndexedComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.property.Uid;

public final class Calendars {
    private Calendars() {
    }

    public static Calendar load(String filename) throws IOException, ParserException {
        FileInputStream fin = new FileInputStream(filename);
        CalendarBuilder builder = new CalendarBuilder();
        return builder.build(fin);
    }

    public static Calendar load(URL url) throws IOException, ParserException {
        CalendarBuilder builder = new CalendarBuilder();
        return builder.build(url.openStream());
    }

    public static Calendar merge(Calendar c1, Calendar c2) {
        Calendar result = new Calendar();
        result.getProperties().addAll(c1.getProperties());
        Iterator i = c2.getProperties().iterator();
        while (i.hasNext()) {
            Property p = (Property)i.next();
            if (result.getProperties().contains(p)) continue;
            result.getProperties().add(p);
        }
        result.getComponents().addAll(c1.getComponents());
        i = c2.getComponents().iterator();
        while (i.hasNext()) {
            Component c = (Component)i.next();
            if (result.getComponents().contains(c)) continue;
            result.getComponents().add(c);
        }
        return result;
    }

    public static Calendar wrap(Component component) {
        ComponentList components = new ComponentList();
        components.add(component);
        return new Calendar(components);
    }

    public static Calendar[] split(Calendar calendar) {
        if (calendar.getComponents().size() <= 1 || calendar.getComponents("VTIMEZONE").size() == calendar.getComponents().size()) {
            return new Calendar[]{calendar};
        }
        IndexedComponentList timezones = new IndexedComponentList(calendar.getComponents("VTIMEZONE"), "TZID");
        HashMap<Uid, Calendar> calendars = new HashMap<Uid, Calendar>();
        Iterator i = calendar.getComponents().iterator();
        while (i.hasNext()) {
            Component c = (Component)i.next();
            if (c instanceof VTimeZone) continue;
            Uid uid = (Uid)c.getProperty("UID");
            Calendar uidCal = (Calendar)calendars.get(uid);
            if (uidCal == null) {
                uidCal = new Calendar(calendar.getProperties(), new ComponentList());
                Iterator mp = uidCal.getProperties("METHOD").iterator();
                while (mp.hasNext()) {
                    uidCal.getProperties().remove(mp.next());
                }
                calendars.put(uid, uidCal);
            }
            Iterator j = c.getProperties().iterator();
            while (j.hasNext()) {
                Property p = (Property)j.next();
                TzId tzid = (TzId)p.getParameter("TZID");
                if (tzid == null) continue;
                VTimeZone timezone = (VTimeZone)timezones.getComponent(tzid.getValue());
                if (uidCal.getComponents().contains(timezone)) continue;
                uidCal.getComponents().add(timezone);
            }
            uidCal.getComponents().add(c);
        }
        return calendars.values().toArray(new Calendar[calendars.values().size()]);
    }

    public static Uid getUid(Calendar calendar) throws ConstraintViolationException {
        Uid uid = null;
        Iterator i = calendar.getComponents().iterator();
        while (i.hasNext()) {
            Component c = (Component)i.next();
            Iterator j = c.getProperties("UID").iterator();
            while (j.hasNext()) {
                Uid foundUid = (Uid)j.next();
                if (uid != null && !uid.equals(foundUid)) {
                    throw new ConstraintViolationException("More than one UID found in calendar");
                }
                uid = foundUid;
            }
        }
        return uid;
    }
}

