/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.awt.Rectangle;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.xml.sax.Locator;

public abstract class Region
extends FObj {
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private int displayAlign;
    private int overflow;
    private String regionName;
    private Numeric referenceOrientation;
    private int writingMode;
    private SimplePageMaster layoutMaster;

    protected Region(FONode parent) {
        super(parent);
        this.layoutMaster = (SimplePageMaster)parent;
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.displayAlign = pList.get(81).getEnum();
        this.overflow = pList.get(153).getEnum();
        this.regionName = pList.get(181).getString();
        this.referenceOrientation = pList.get(179).getNumeric();
        this.writingMode = pList.getWritingMode();
        if (this.regionName.equals("")) {
            this.regionName = this.getDefaultRegionName();
        } else if (this.isReserved(this.getRegionName()) && !this.getRegionName().equals(this.getDefaultRegionName())) {
            throw new ValidationException("region-name '" + this.regionName + "' for " + this.getName() + " is not permitted.", this.locator);
        }
        if (this.getUserAgent().validateStrictly() && (this.getCommonBorderPaddingBackground().getBPPaddingAndBorder(false, null) != 0 || this.getCommonBorderPaddingBackground().getIPPaddingAndBorder(false, null) != 0)) {
            throw new PropertyException("Border and padding for region \"" + this.regionName + "\" must be '0' (See 6.4.13 in XSL 1.0).");
        }
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        this.invalidChildError(loc, nsURI, localName);
    }

    public abstract Rectangle getViewportRectangle(FODimension var1, SimplePageMaster var2);

    protected abstract String getDefaultRegionName();

    protected boolean isReserved(String name) {
        return name.equals("xsl-region-before") || name.equals("xsl-region-start") || name.equals("xsl-region-end") || name.equals("xsl-region-after") || name.equals("xsl-before-float-separator") || name.equals("xsl-footnote-separator");
    }

    public boolean generatesReferenceAreas() {
        return true;
    }

    protected Region getSiblingRegion(int regionId) {
        return this.layoutMaster.getRegion(regionId);
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public int getWritingMode() {
        return this.writingMode;
    }

    public int getOverflow() {
        return this.overflow;
    }

    public int getDisplayAlign() {
        return this.displayAlign;
    }

    public int getReferenceOrientation() {
        return this.referenceOrientation.getValue();
    }
}

