/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.core.startup.layers.BinaryCacheManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.XMLFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayerCacheManager {
    static final Logger err = Logger.getLogger("org.netbeans.core.projects.cache");
    private static LayerCacheManager mgr = new BinaryCacheManager();
    private static LayerCacheManager non = new NonCacheManager();

    public static LayerCacheManager manager(boolean bl) {
        return bl ? mgr : non;
    }

    protected LayerCacheManager() {
    }

    public abstract FileSystem createEmptyFileSystem() throws IOException;

    public abstract FileSystem load(FileSystem var1, ByteBuffer var2) throws IOException;

    public abstract void store(FileSystem var1, List<URL> var2, OutputStream var3) throws IOException;

    public abstract String cacheLocation();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NonCacheManager
    extends LayerCacheManager {
        private NonCacheManager() {
        }

        @Override
        public FileSystem createEmptyFileSystem() throws IOException {
            return new XMLFileSystem();
        }

        @Override
        public FileSystem load(FileSystem fileSystem, ByteBuffer byteBuffer) throws IOException {
            String string;
            byte[] byArray = new byte[byteBuffer.limit()];
            byteBuffer.get(byArray);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            ArrayList<URL> arrayList = new ArrayList<URL>();
            while (dataInputStream.available() > 0) {
                string = dataInputStream.readUTF();
                arrayList.add(new URL(string));
            }
            try {
                string = (XMLFileSystem)fileSystem;
                string.setXmlUrls(arrayList.toArray(new URL[arrayList.size()]));
                return string;
            }
            catch (PropertyVetoException propertyVetoException) {
                throw (IOException)new IOException(propertyVetoException.toString()).initCause(propertyVetoException);
            }
        }

        @Override
        public void store(FileSystem fileSystem, List<URL> list, OutputStream outputStream) throws IOException {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            for (URL uRL : list) {
                dataOutputStream.writeUTF(uRL.toExternalForm());
            }
            dataOutputStream.close();
        }

        @Override
        public String cacheLocation() {
            return "all-local-layers.dat";
        }
    }
}

