/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.datatype;

import com.projectlibre1.configuration.Settings;
import com.projectlibre1.datatype.CanSupplyRateUnit;
import com.projectlibre1.datatype.Duration;
import com.projectlibre1.datatype.DurationFormat;
import com.projectlibre1.datatype.Money;
import com.projectlibre1.datatype.Rate;
import com.projectlibre1.datatype.TimeUnit;
import com.projectlibre1.options.ScheduleOption;
import com.projectlibre1.util.ClassUtils;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class RateFormat
extends Format
implements TimeUnit {
    private static NumberFormat MONEY_FORMAT = Money.getMoneyFormatInstance();
    private static NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();
    private static NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance();
    private static RateFormat moneyInstance = null;
    private static RateFormat instance = null;
    private static RateFormat percentInstance = null;
    private static RateFormat nonTemporalInstance = null;
    private String timeUnitLabel;
    private boolean money;
    public boolean percent;
    private boolean temporal;

    public static RateFormat getInstance(Object object, boolean bl, boolean bl2, boolean bl3) {
        if (instance == null) {
            instance = new RateFormat(null, false, false, true);
            moneyInstance = new RateFormat(null, true, false, true);
            percentInstance = new RateFormat(null, false, true, true);
            nonTemporalInstance = new RateFormat(null, false, false, false);
        }
        String string = RateFormat.unitLabelOfObject(object);
        if (bl2) {
            return percentInstance;
        }
        if (string != null) {
            return new RateFormat(string, bl, false, bl3);
        }
        if (bl) {
            return moneyInstance;
        }
        if (bl3) {
            return instance;
        }
        return nonTemporalInstance;
    }

    public static String unitLabelOfObject(Object object) {
        String string = null;
        if (object != null) {
            if (object instanceof String) {
                string = (String)object;
            } else if (object instanceof CanSupplyRateUnit && (string = ((CanSupplyRateUnit)object).getTimeUnitLabel()) == null) {
                string = "";
            }
        }
        return string;
    }

    private RateFormat(String string, boolean bl, boolean bl2, boolean bl3) {
        this.money = bl;
        this.percent = bl2;
        this.timeUnitLabel = string;
        this.temporal = bl3;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(parsePosition.getIndex()) == '+') {
            parsePosition.setIndex(parsePosition.getIndex() + 1);
        }
        Number number = null;
        if (this.percent) {
            number = PERCENT_FORMAT.parse(string, parsePosition);
            if (number == null && (number = NUMBER_FORMAT.parse(string, parsePosition)) != null) {
                number = new Double(number.doubleValue() / 100.0);
            }
            if (number == null) {
                return null;
            }
            return new Rate(number.doubleValue(), 6);
        }
        if (this.money) {
            number = MONEY_FORMAT.parse(string, parsePosition);
        }
        if (number == null) {
            number = NUMBER_FORMAT.parse(string, parsePosition);
        }
        if (number == null) {
            return null;
        }
        double d = number.doubleValue();
        String string2 = string.substring(parsePosition.getIndex());
        string2 = string2.trim();
        int n = -2;
        int n2 = string2.indexOf(Settings.SLASH);
        if (n2 == -1) {
            if (this.timeUnitLabel == null && this.temporal) {
                n = this.getDefaultType();
            }
        } else {
            string2 = "1" + string2.substring(n2 + 1, string2.length());
            Duration duration = (Duration)DurationFormat.getInstance().parseObject(string2, new ParsePosition(0));
            if (duration == null) {
                return null;
            }
            n = Duration.getEffectiveType(duration.getEncodedMillis());
        }
        return new Rate(d /= Duration.timeUnitFactor(n), n);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object == null) {
            return stringBuffer;
        }
        if (object == ClassUtils.defaultRate) {
            return stringBuffer;
        }
        if (object == ClassUtils.defaultUnitlessRate) {
            return stringBuffer;
        }
        Rate rate = (Rate)object;
        double d = rate.getValue();
        int n = rate.getTimeUnit();
        if (n == -1 && this.temporal) {
            n = this.getDefaultType();
        }
        if (this.percent) {
            PERCENT_FORMAT.format(new Double(d), stringBuffer, fieldPosition);
        } else {
            d *= Duration.timeUnitFactor(n);
            if (this.money) {
                MONEY_FORMAT.format(new Double(d), stringBuffer, fieldPosition);
            } else {
                NumberFormat.getInstance().format(new Double(d), stringBuffer, fieldPosition);
                if (this.timeUnitLabel != null && !this.timeUnitLabel.equals("")) {
                    stringBuffer.append(" " + this.timeUnitLabel);
                }
            }
            if (n != -2) {
                stringBuffer.append(Settings.SLASH);
                String string = DurationFormat.formatTypeUnit(n);
                stringBuffer.append(string);
            }
        }
        return stringBuffer;
    }

    private int getDefaultType() {
        return ScheduleOption.getInstance().getRateEnteredIn();
    }
}

