/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer;

import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.iface.instruction.DualReferenceInstruction;
import com.android.tools.smali.dexlib2.iface.instruction.ReferenceInstruction;
import com.android.tools.smali.dexlib2.iface.instruction.SwitchElement;
import com.android.tools.smali.dexlib2.iface.instruction.formats.ArrayPayload;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction10t;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction10x;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction11n;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction11x;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction12x;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction20bc;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction20t;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction21c;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction21ih;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction21lh;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction21s;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction21t;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction22b;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction22c;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction22cs;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction22s;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction22t;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction22x;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction23x;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction30t;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction31c;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction31i;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction31t;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction32x;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction35c;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction35mi;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction35ms;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction3rc;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction3rmi;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction3rms;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction45cc;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction4rcc;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction51l;
import com.android.tools.smali.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import com.android.tools.smali.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import com.android.tools.smali.dexlib2.iface.reference.CallSiteReference;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodHandleReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodProtoReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import com.android.tools.smali.dexlib2.iface.reference.StringReference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import com.android.tools.smali.dexlib2.writer.CallSiteSection;
import com.android.tools.smali.dexlib2.writer.DexDataWriter;
import com.android.tools.smali.dexlib2.writer.FieldSection;
import com.android.tools.smali.dexlib2.writer.MethodHandleSection;
import com.android.tools.smali.dexlib2.writer.MethodSection;
import com.android.tools.smali.dexlib2.writer.ProtoSection;
import com.android.tools.smali.dexlib2.writer.StringSection;
import com.android.tools.smali.dexlib2.writer.TypeSection;
import com.android.tools.smali.util.ExceptionWithContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;

public class InstructionWriter<StringRef extends StringReference, TypeRef extends TypeReference, FieldRefKey extends FieldReference, MethodRefKey extends MethodReference, ProtoRefKey extends MethodProtoReference, MethodHandleKey extends MethodHandleReference, CallSiteKey extends CallSiteReference> {
    private final Opcodes opcodes;
    private final DexDataWriter writer;
    private final StringSection<?, StringRef> stringSection;
    private final TypeSection<?, ?, TypeRef> typeSection;
    private final FieldSection<?, ?, FieldRefKey, ?> fieldSection;
    private final MethodSection<?, ?, ?, MethodRefKey, ?> methodSection;
    private final ProtoSection<?, ?, ProtoRefKey, ?> protoSection;
    private final MethodHandleSection<MethodHandleKey, ?, ?> methodHandleSection;
    private final CallSiteSection<CallSiteKey, ?> callSiteSection;
    private final Comparator<SwitchElement> switchElementComparator = new Comparator<SwitchElement>(){

        @Override
        public int compare(SwitchElement element1, SwitchElement element2) {
            return Ints.compare(element1.getKey(), element2.getKey());
        }
    };

    static <StringRef extends StringReference, TypeRef extends TypeReference, FieldRefKey extends FieldReference, MethodRefKey extends MethodReference, ProtoRefKey extends MethodProtoReference, MethodHandleKey extends MethodHandleReference, CallSiteKey extends CallSiteReference> InstructionWriter<StringRef, TypeRef, FieldRefKey, MethodRefKey, ProtoRefKey, MethodHandleKey, CallSiteKey> makeInstructionWriter(Opcodes opcodes, DexDataWriter writer, StringSection<?, StringRef> stringSection, TypeSection<?, ?, TypeRef> typeSection, FieldSection<?, ?, FieldRefKey, ?> fieldSection, MethodSection<?, ?, ?, MethodRefKey, ?> methodSection, ProtoSection<?, ?, ProtoRefKey, ?> protoSection, MethodHandleSection<MethodHandleKey, ?, ?> methodHandleSection, CallSiteSection<CallSiteKey, ?> callSiteSection) {
        return new InstructionWriter<StringRef, TypeRef, FieldRefKey, MethodRefKey, ProtoRefKey, MethodHandleKey, CallSiteKey>(opcodes, writer, stringSection, typeSection, fieldSection, methodSection, protoSection, methodHandleSection, callSiteSection);
    }

    InstructionWriter(Opcodes opcodes, DexDataWriter writer, StringSection<?, StringRef> stringSection, TypeSection<?, ?, TypeRef> typeSection, FieldSection<?, ?, FieldRefKey, ?> fieldSection, MethodSection<?, ?, ?, MethodRefKey, ?> methodSection, ProtoSection<?, ?, ProtoRefKey, ?> protoSection, MethodHandleSection<MethodHandleKey, ?, ?> methodHandleSection, CallSiteSection<CallSiteKey, ?> callSiteSection) {
        this.opcodes = opcodes;
        this.writer = writer;
        this.stringSection = stringSection;
        this.typeSection = typeSection;
        this.fieldSection = fieldSection;
        this.methodSection = methodSection;
        this.protoSection = protoSection;
        this.methodHandleSection = methodHandleSection;
        this.callSiteSection = callSiteSection;
    }

    private short getOpcodeValue(Opcode opcode) {
        Short value = this.opcodes.getOpcodeValue(opcode);
        if (value == null) {
            throw new ExceptionWithContext("Instruction %s is invalid for api %d", opcode.name, this.opcodes.api);
        }
        return value;
    }

    public void write(Instruction10t instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction10x instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(0);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction11n instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getNarrowLiteral()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction11x instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction12x instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction20bc instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getVerificationError());
            this.writer.writeUshort(this.getReferenceIndex(instruction));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction20t instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(0);
            this.writer.writeShort(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction21c instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeUshort(this.getReferenceIndex(instruction));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction21ih instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeShort(instruction.getHatLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction21lh instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeShort(instruction.getHatLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction21s instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeShort(instruction.getNarrowLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction21t instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeShort(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction22b instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.write(instruction.getRegisterB());
            this.writer.write(instruction.getNarrowLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction22c instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
            this.writer.writeUshort(this.getReferenceIndex(instruction));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction22cs instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
            this.writer.writeUshort(instruction.getFieldOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction22s instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
            this.writer.writeShort(instruction.getNarrowLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction22t instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
            this.writer.writeShort(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction22x instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeUshort(instruction.getRegisterB());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction23x instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.write(instruction.getRegisterB());
            this.writer.write(instruction.getRegisterC());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction30t instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(0);
            this.writer.writeInt(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction31c instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeInt(this.getReferenceIndex(instruction));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction31i instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeInt(instruction.getNarrowLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction31t instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeInt(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction32x instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(0);
            this.writer.writeUshort(instruction.getRegisterA());
            this.writer.writeUshort(instruction.getRegisterB());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction35c instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterG(), instruction.getRegisterCount()));
            this.writer.writeUshort(this.getReferenceIndex(instruction));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterC(), instruction.getRegisterD()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterE(), instruction.getRegisterF()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction35mi instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterG(), instruction.getRegisterCount()));
            this.writer.writeUshort(instruction.getInlineIndex());
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterC(), instruction.getRegisterD()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterE(), instruction.getRegisterF()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction35ms instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterG(), instruction.getRegisterCount()));
            this.writer.writeUshort(instruction.getVtableIndex());
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterC(), instruction.getRegisterD()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterE(), instruction.getRegisterF()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction3rc instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterCount());
            this.writer.writeUshort(this.getReferenceIndex(instruction));
            this.writer.writeUshort(instruction.getStartRegister());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction3rmi instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterCount());
            this.writer.writeUshort(instruction.getInlineIndex());
            this.writer.writeUshort(instruction.getStartRegister());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction3rms instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterCount());
            this.writer.writeUshort(instruction.getVtableIndex());
            this.writer.writeUshort(instruction.getStartRegister());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction45cc instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterG(), instruction.getRegisterCount()));
            this.writer.writeUshort(this.getReferenceIndex(instruction));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterC(), instruction.getRegisterD()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterE(), instruction.getRegisterF()));
            this.writer.writeUshort(this.getReference2Index(instruction));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction4rcc instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterCount());
            this.writer.writeUshort(this.getReferenceIndex(instruction));
            this.writer.writeUshort(instruction.getStartRegister());
            this.writer.writeUshort(this.getReference2Index(instruction));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Instruction51l instruction) {
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeLong(instruction.getWideLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(ArrayPayload instruction) {
        try {
            this.writer.writeUshort(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.writeUshort(instruction.getElementWidth());
            List<Number> elements = instruction.getArrayElements();
            this.writer.writeInt(elements.size());
            switch (instruction.getElementWidth()) {
                case 1: {
                    for (Number element : elements) {
                        this.writer.write(element.byteValue());
                    }
                    break;
                }
                case 2: {
                    for (Number element : elements) {
                        this.writer.writeShort(element.shortValue());
                    }
                    break;
                }
                case 4: {
                    for (Number element : elements) {
                        this.writer.writeInt(element.intValue());
                    }
                    break;
                }
                case 8: {
                    for (Number element : elements) {
                        this.writer.writeLong(element.longValue());
                    }
                    break;
                }
            }
            if ((this.writer.getPosition() & 1) != 0) {
                this.writer.write(0);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(SparseSwitchPayload instruction) {
        try {
            this.writer.writeUbyte(0);
            this.writer.writeUbyte(this.getOpcodeValue(instruction.getOpcode()) >> 8);
            ImmutableList<? extends SwitchElement> elements = Ordering.from(this.switchElementComparator).immutableSortedCopy(instruction.getSwitchElements());
            this.writer.writeUshort(elements.size());
            for (SwitchElement switchElement : elements) {
                this.writer.writeInt(switchElement.getKey());
            }
            for (SwitchElement switchElement : elements) {
                this.writer.writeInt(switchElement.getOffset());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(PackedSwitchPayload instruction) {
        try {
            this.writer.writeUbyte(0);
            this.writer.writeUbyte(this.getOpcodeValue(instruction.getOpcode()) >> 8);
            List<? extends SwitchElement> elements = instruction.getSwitchElements();
            this.writer.writeUshort(elements.size());
            if (elements.size() == 0) {
                this.writer.writeInt(0);
            } else {
                this.writer.writeInt(elements.get(0).getKey());
                for (SwitchElement switchElement : elements) {
                    this.writer.writeInt(switchElement.getOffset());
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static int packNibbles(int a, int b) {
        return b << 4 | a;
    }

    private int getReferenceIndex(ReferenceInstruction referenceInstruction) {
        return this.getReferenceIndex(referenceInstruction.getReferenceType(), referenceInstruction.getReference());
    }

    private int getReference2Index(DualReferenceInstruction referenceInstruction) {
        return this.getReferenceIndex(referenceInstruction.getReferenceType2(), referenceInstruction.getReference2());
    }

    private int getReferenceIndex(int referenceType, Reference reference) {
        switch (referenceType) {
            case 2: {
                return this.fieldSection.getItemIndex((FieldReference)reference);
            }
            case 3: {
                return this.methodSection.getItemIndex((MethodReference)reference);
            }
            case 0: {
                return this.stringSection.getItemIndex((StringReference)reference);
            }
            case 1: {
                return this.typeSection.getItemIndex((TypeReference)reference);
            }
            case 4: {
                return this.protoSection.getItemIndex((MethodProtoReference)reference);
            }
            case 6: {
                return this.methodHandleSection.getItemIndex((MethodHandleReference)reference);
            }
            case 5: {
                return this.callSiteSection.getItemIndex((CallSiteReference)reference);
            }
        }
        throw new ExceptionWithContext("Unknown reference type: %d", referenceType);
    }
}

