/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable.debug;

import com.android.tools.smali.dexlib2.iface.debug.DebugItem;
import com.android.tools.smali.dexlib2.iface.debug.EndLocal;
import com.android.tools.smali.dexlib2.iface.debug.EpilogueBegin;
import com.android.tools.smali.dexlib2.iface.debug.LineNumber;
import com.android.tools.smali.dexlib2.iface.debug.PrologueEnd;
import com.android.tools.smali.dexlib2.iface.debug.RestartLocal;
import com.android.tools.smali.dexlib2.iface.debug.SetSourceFile;
import com.android.tools.smali.dexlib2.iface.debug.StartLocal;
import com.android.tools.smali.dexlib2.immutable.debug.ImmutableEndLocal;
import com.android.tools.smali.dexlib2.immutable.debug.ImmutableEpilogueBegin;
import com.android.tools.smali.dexlib2.immutable.debug.ImmutableLineNumber;
import com.android.tools.smali.dexlib2.immutable.debug.ImmutablePrologueEnd;
import com.android.tools.smali.dexlib2.immutable.debug.ImmutableRestartLocal;
import com.android.tools.smali.dexlib2.immutable.debug.ImmutableSetSourceFile;
import com.android.tools.smali.dexlib2.immutable.debug.ImmutableStartLocal;
import com.android.tools.smali.util.ExceptionWithContext;
import com.android.tools.smali.util.ImmutableConverter;
import com.google.common.collect.ImmutableList;

public abstract class ImmutableDebugItem
implements DebugItem {
    protected final int codeAddress;
    private static final ImmutableConverter<ImmutableDebugItem, DebugItem> CONVERTER = new ImmutableConverter<ImmutableDebugItem, DebugItem>(){

        @Override
        protected boolean isImmutable(DebugItem item) {
            return item instanceof ImmutableDebugItem;
        }

        @Override
        protected ImmutableDebugItem makeImmutable(DebugItem item) {
            return ImmutableDebugItem.of(item);
        }
    };

    public ImmutableDebugItem(int codeAddress) {
        this.codeAddress = codeAddress;
    }

    public static ImmutableDebugItem of(DebugItem debugItem) {
        if (debugItem instanceof ImmutableDebugItem) {
            return (ImmutableDebugItem)debugItem;
        }
        switch (debugItem.getDebugItemType()) {
            case 3: {
                return ImmutableStartLocal.of((StartLocal)debugItem);
            }
            case 5: {
                return ImmutableEndLocal.of((EndLocal)debugItem);
            }
            case 6: {
                return ImmutableRestartLocal.of((RestartLocal)debugItem);
            }
            case 7: {
                return ImmutablePrologueEnd.of((PrologueEnd)debugItem);
            }
            case 8: {
                return ImmutableEpilogueBegin.of((EpilogueBegin)debugItem);
            }
            case 9: {
                return ImmutableSetSourceFile.of((SetSourceFile)debugItem);
            }
            case 10: {
                return ImmutableLineNumber.of((LineNumber)debugItem);
            }
        }
        throw new ExceptionWithContext("Invalid debug item type: %d", debugItem.getDebugItemType());
    }

    @Override
    public int getCodeAddress() {
        return this.codeAddress;
    }

    public static ImmutableList<ImmutableDebugItem> immutableListOf(Iterable<? extends DebugItem> list) {
        return CONVERTER.toList(list);
    }
}

