/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked;

import com.android.tools.smali.dexlib2.HiddenApiRestriction;
import com.android.tools.smali.dexlib2.base.reference.BaseMethodReference;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedAnnotation;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedClassDef;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethodImplementation;
import com.android.tools.smali.dexlib2.dexbacked.DexReader;
import com.android.tools.smali.dexlib2.dexbacked.util.AnnotationsDirectory;
import com.android.tools.smali.dexlib2.dexbacked.util.FixedSizeList;
import com.android.tools.smali.dexlib2.dexbacked.util.ParameterIterator;
import com.android.tools.smali.dexlib2.iface.Annotation;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.iface.MethodParameter;
import com.android.tools.smali.util.AbstractForwardSequentialList;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DexBackedMethod
extends BaseMethodReference
implements Method {
    public final DexBackedDexFile dexFile;
    public final DexBackedClassDef classDef;
    public final int accessFlags;
    private final int codeOffset;
    private final int parameterAnnotationSetListOffset;
    private final int methodAnnotationSetOffset;
    private final int hiddenApiRestrictions;
    public final int methodIndex;
    private final int startOffset;
    private int methodIdItemOffset;
    private int protoIdItemOffset;
    private int parametersOffset = -1;

    public DexBackedMethod(DexBackedDexFile dexFile, DexReader reader, DexBackedClassDef classDef, int previousMethodIndex, AnnotationsDirectory.AnnotationIterator methodAnnotationIterator, AnnotationsDirectory.AnnotationIterator paramaterAnnotationIterator, int hiddenApiRestrictions) {
        this.dexFile = dexFile;
        this.classDef = classDef;
        this.startOffset = reader.getOffset();
        int methodIndexDiff = reader.readLargeUleb128();
        this.methodIndex = methodIndexDiff + previousMethodIndex;
        this.accessFlags = reader.readSmallUleb128();
        this.codeOffset = reader.readSmallUleb128();
        this.hiddenApiRestrictions = hiddenApiRestrictions;
        this.methodAnnotationSetOffset = methodAnnotationIterator.seekTo(this.methodIndex);
        this.parameterAnnotationSetListOffset = paramaterAnnotationIterator.seekTo(this.methodIndex);
    }

    @Override
    public String getDefiningClass() {
        return this.classDef.getType();
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public String getName() {
        return (String)this.dexFile.getStringSection().get(this.dexFile.getBuffer().readSmallUint(this.getMethodIdItemOffset() + 4));
    }

    @Override
    public String getReturnType() {
        return (String)this.dexFile.getTypeSection().get(this.dexFile.getBuffer().readSmallUint(this.getProtoIdItemOffset() + 4));
    }

    @Override
    public List<? extends MethodParameter> getParameters() {
        int parametersOffset = this.getParametersOffset();
        if (parametersOffset > 0) {
            final List<String> parameterTypes = this.getParameterTypes();
            return new AbstractForwardSequentialList<MethodParameter>(){

                @Override
                public Iterator<MethodParameter> iterator() {
                    return new ParameterIterator(parameterTypes, DexBackedMethod.this.getParameterAnnotations(), DexBackedMethod.this.getParameterNames());
                }

                @Override
                public int size() {
                    return parameterTypes.size();
                }
            };
        }
        return ImmutableList.of();
    }

    public List<? extends Set<? extends DexBackedAnnotation>> getParameterAnnotations() {
        return AnnotationsDirectory.getParameterAnnotations(this.dexFile, this.parameterAnnotationSetListOffset);
    }

    public Iterator<String> getParameterNames() {
        DexBackedMethodImplementation methodImpl = this.getImplementation();
        if (methodImpl != null) {
            return methodImpl.getParameterNames(null);
        }
        return ImmutableSet.of().iterator();
    }

    public List<String> getParameterTypes() {
        int parametersOffset = this.getParametersOffset();
        if (parametersOffset > 0) {
            final int parameterCount = this.dexFile.getDataBuffer().readSmallUint(parametersOffset + 0);
            final int paramListStart = parametersOffset + 4;
            return new FixedSizeList<String>(){

                @Override
                public String readItem(int index) {
                    return (String)DexBackedMethod.this.dexFile.getTypeSection().get(DexBackedMethod.this.dexFile.getDataBuffer().readUshort(paramListStart + 2 * index));
                }

                @Override
                public int size() {
                    return parameterCount;
                }
            };
        }
        return ImmutableList.of();
    }

    @Override
    public Set<? extends Annotation> getAnnotations() {
        return AnnotationsDirectory.getAnnotations(this.dexFile, this.methodAnnotationSetOffset);
    }

    @Override
    public Set<HiddenApiRestriction> getHiddenApiRestrictions() {
        if (this.hiddenApiRestrictions == 7) {
            return ImmutableSet.of();
        }
        return EnumSet.copyOf(HiddenApiRestriction.getAllFlags(this.hiddenApiRestrictions));
    }

    @Override
    public DexBackedMethodImplementation getImplementation() {
        if (this.codeOffset > 0) {
            return this.dexFile.createMethodImplementation(this.dexFile, this, this.codeOffset);
        }
        return null;
    }

    private int getMethodIdItemOffset() {
        if (this.methodIdItemOffset == 0) {
            this.methodIdItemOffset = this.dexFile.getMethodSection().getOffset(this.methodIndex);
        }
        return this.methodIdItemOffset;
    }

    private int getProtoIdItemOffset() {
        if (this.protoIdItemOffset == 0) {
            int protoIndex = this.dexFile.getBuffer().readUshort(this.getMethodIdItemOffset() + 2);
            this.protoIdItemOffset = this.dexFile.getProtoSection().getOffset(protoIndex);
        }
        return this.protoIdItemOffset;
    }

    private int getParametersOffset() {
        if (this.parametersOffset == -1) {
            this.parametersOffset = this.dexFile.getBuffer().readSmallUint(this.getProtoIdItemOffset() + 8);
        }
        return this.parametersOffset;
    }

    public static void skipMethods(DexReader reader, int count) {
        for (int i = 0; i < count; ++i) {
            reader.skipUleb128();
            reader.skipUleb128();
            reader.skipUleb128();
        }
    }
}

