/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.util.ExtDataInput;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.commons.io.input.CountingInputStream;

public class ExtCountingDataInput
extends ExtDataInput {
    private final CountingInputStream mCountIn;
    private static final Logger LOGGER = Logger.getLogger(ExtCountingDataInput.class.getName());

    public ExtCountingDataInput(LittleEndianDataInputStream in) {
        this(new CountingInputStream(in));
    }

    public ExtCountingDataInput(CountingInputStream countIn) {
        super(new LittleEndianDataInputStream(countIn));
        this.mCountIn = countIn;
    }

    public int position() {
        return this.mCountIn.getCount();
    }

    public int remaining() throws IOException {
        return this.mCountIn.available();
    }

    public long skip(int bytes) throws IOException {
        return this.mCountIn.skip(bytes);
    }

    public int[] readSafeIntArray(int length, long maxPosition) throws IOException {
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            if ((long)this.position() >= maxPosition) {
                LOGGER.warning(String.format("Bad string block: string entry is at %d, past end at %d", this.position(), maxPosition));
                return array;
            }
            array[i] = this.readInt();
        }
        return array;
    }
}

