/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.arsc;

import brut.util.ExtCountingDataInput;
import brut.util.ExtDataInput;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.logging.Logger;

public class ARSCHeader {
    public final short type;
    public final int headerSize;
    public final int chunkSize;
    public final int startPosition;
    public final int endPosition;
    private static final Logger LOGGER = Logger.getLogger(ARSCHeader.class.getName());

    public ARSCHeader(short type, int headerSize, int chunkSize, int headerStart) {
        this.type = type;
        this.headerSize = headerSize;
        this.chunkSize = chunkSize;
        this.startPosition = headerStart;
        this.endPosition = headerStart + chunkSize;
    }

    public static ARSCHeader read(ExtCountingDataInput in) throws IOException {
        short type;
        int start = in.position();
        try {
            type = in.readShort();
        }
        catch (EOFException ex) {
            return new ARSCHeader(-1, 0, 0, in.position());
        }
        return new ARSCHeader(type, in.readShort(), in.readInt(), start);
    }

    public void checkForUnreadHeader(ExtCountingDataInput in) throws IOException {
        int actualHeaderSize = in.position() - this.startPosition;
        int exceedingSize = this.headerSize - actualHeaderSize;
        if (exceedingSize > 0) {
            byte[] buf = new byte[exceedingSize];
            in.readFully(buf);
            BigInteger exceedingBI = new BigInteger(1, buf);
            if (exceedingBI.equals(BigInteger.ZERO)) {
                LOGGER.fine(String.format("Chunk header size (%d), read (%d), but exceeding bytes are all zero.", this.headerSize, actualHeaderSize));
            } else {
                LOGGER.warning(String.format("Chunk header size (%d), read (%d). Exceeding bytes: 0x%X.", this.headerSize, actualHeaderSize, exceedingBI));
            }
        }
    }

    public void skipChunk(ExtDataInput in) throws IOException {
        in.skipBytes(this.chunkSize - this.headerSize);
    }
}

