/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.CantFindFrameworkResException;
import brut.androlib.res.data.arsc.ARSCData;
import brut.androlib.res.data.arsc.FlagsOffset;
import brut.androlib.res.decoder.ARSCDecoder;
import brut.util.Jar;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class Framework {
    private final Config config;
    private File mFrameworkDirectory = null;
    private static final Logger LOGGER = Logger.getLogger(Framework.class.getName());

    public Framework(Config config) {
        this.config = config;
    }

    public void installFramework(File frameFile) throws AndrolibException {
        this.installFramework(frameFile, this.config.frameworkTag);
    }

    public void installFramework(File frameFile, String tag) throws AndrolibException {
        InputStream in = null;
        ZipOutputStream out = null;
        try {
            ZipFile zip = new ZipFile(frameFile);
            ZipEntry entry = zip.getEntry("resources.arsc");
            if (entry == null) {
                throw new AndrolibException("Can't find resources.arsc file");
            }
            in = zip.getInputStream(entry);
            byte[] data = IOUtils.toByteArray(in);
            ARSCData arsc = ARSCDecoder.decode(new ByteArrayInputStream(data), true, true);
            this.publicizeResources(data, arsc.getFlagsOffsets());
            File outFile = new File(this.getFrameworkDirectory(), arsc.getOnePackage().getId() + (tag == null ? "" : '-' + tag) + ".apk");
            out = new ZipOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));
            out.setMethod(0);
            CRC32 crc = new CRC32();
            crc.update(data);
            entry = new ZipEntry("resources.arsc");
            entry.setSize(data.length);
            entry.setMethod(0);
            entry.setCrc(crc.getValue());
            out.putNextEntry(entry);
            out.write(data);
            out.closeEntry();
            entry = zip.getEntry("AndroidManifest.xml");
            if (entry != null) {
                in = zip.getInputStream(entry);
                byte[] manifest = IOUtils.toByteArray(in);
                CRC32 manifestCrc = new CRC32();
                manifestCrc.update(manifest);
                entry.setSize(manifest.length);
                entry.setCompressedSize(-1L);
                entry.setCrc(manifestCrc.getValue());
                out.putNextEntry(entry);
                out.write(manifest);
                out.closeEntry();
            }
            zip.close();
            LOGGER.info("Framework installed to: " + outFile);
        }
        catch (IOException ex) {
            try {
                throw new AndrolibException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(out);
    }

    public void listFrameworkDirectory() throws AndrolibException {
        File dir = this.getFrameworkDirectory();
        if (dir == null) {
            LOGGER.severe("No framework directory found. Nothing to list.");
            return;
        }
        for (File file : Objects.requireNonNull(dir.listFiles())) {
            if (!file.isFile() || !file.getName().endsWith(".apk")) continue;
            LOGGER.info(file.getName());
        }
    }

    public void publicizeResources(File arscFile) throws AndrolibException {
        byte[] data = new byte[(int)arscFile.length()];
        try (InputStream in = Files.newInputStream(arscFile.toPath(), new OpenOption[0]);
             OutputStream out = Files.newOutputStream(arscFile.toPath(), new OpenOption[0]);){
            in.read(data);
            this.publicizeResources(data);
            out.write(data);
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void publicizeResources(byte[] arsc) throws AndrolibException {
        this.publicizeResources(arsc, ARSCDecoder.decode(new ByteArrayInputStream(arsc), true, true).getFlagsOffsets());
    }

    public void publicizeResources(byte[] arsc, FlagsOffset[] flagsOffsets) {
        for (FlagsOffset flags : flagsOffsets) {
            int offset;
            int end = offset + 4 * flags.count;
            for (offset = flags.offset + 3; offset < end; offset += 4) {
                int n = offset;
                arsc[n] = (byte)(arsc[n] | 0x40);
            }
        }
    }

    public File getFrameworkDirectory() throws AndrolibException {
        if (this.mFrameworkDirectory != null) {
            return this.mFrameworkDirectory;
        }
        String path = this.config.frameworkDirectory;
        File dir = new File(path);
        if (!dir.isDirectory() && dir.isFile()) {
            throw new AndrolibException("--frame-path is set to a file, not a directory.");
        }
        if (dir.getParentFile() != null && dir.getParentFile().isFile()) {
            throw new AndrolibException("Please remove file at " + dir.getParentFile());
        }
        if (!dir.exists() && !dir.mkdirs()) {
            if (this.config.frameworkDirectory != null) {
                LOGGER.severe("Can't create Framework directory: " + dir);
            }
            throw new AndrolibException(String.format("Can't create directory: (%s). Pass a writable path with --frame-path {DIR}. ", dir));
        }
        if (this.config.frameworkDirectory == null && !dir.canWrite()) {
            LOGGER.severe(String.format("WARNING: Could not write to (%1$s), using %2$s instead...", dir.getAbsolutePath(), System.getProperty("java.io.tmpdir")));
            LOGGER.severe("Please be aware this is a volatile directory and frameworks could go missing, please utilize --frame-path if the default storage directory is unavailable");
            dir = new File(System.getProperty("java.io.tmpdir"));
        }
        this.mFrameworkDirectory = dir;
        return dir;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public File getFrameworkApk(int id, String frameTag) throws AndrolibException {
        File apk;
        File dir = this.getFrameworkDirectory();
        if (frameTag != null && (apk = new File(dir, String.valueOf(id) + '-' + frameTag + ".apk")).exists()) {
            return apk;
        }
        apk = new File(dir, id + ".apk");
        if (apk.exists()) {
            return apk;
        }
        if (id == 1) {
            try (InputStream in = this.getAndroidFrameworkResourcesAsStream();){
                File file;
                block17: {
                    OutputStream out = Files.newOutputStream(apk.toPath(), new OpenOption[0]);
                    try {
                        IOUtils.copy(in, out);
                        file = apk;
                        if (out == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    out.close();
                }
                return file;
            }
            catch (IOException ex) {
                throw new AndrolibException(ex);
            }
        }
        throw new CantFindFrameworkResException(id);
    }

    public void emptyFrameworkDirectory() throws AndrolibException {
        File dir = this.getFrameworkDirectory();
        File apk = new File(dir, "1.apk");
        if (!apk.exists()) {
            LOGGER.warning("Can't empty framework directory, no file found at: " + apk.getAbsolutePath());
        } else {
            try {
                if (apk.exists() && Objects.requireNonNull(dir.listFiles()).length > 1 && !this.config.forceDeleteFramework) {
                    LOGGER.warning("More than default framework detected. Please run command with `--force` parameter to wipe framework directory.");
                } else {
                    for (File file : Objects.requireNonNull(dir.listFiles())) {
                        if (!file.isFile() || !file.getName().endsWith(".apk")) continue;
                        LOGGER.info("Removing " + file.getName() + " framework file...");
                        file.delete();
                    }
                }
            }
            catch (NullPointerException e) {
                throw new AndrolibException(e);
            }
        }
    }

    private InputStream getAndroidFrameworkResourcesAsStream() {
        return Jar.class.getResourceAsStream("/brut/androlib/android-framework.jar");
    }
}

