/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.tls;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

public class MariaDbX509EphemeralTrustingManager
implements X509TrustManager {
    X509TrustManager internal;
    byte[] fingerprint = null;

    public MariaDbX509EphemeralTrustingManager(X509TrustManager javaTrustManager) {
        this.internal = javaTrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String string) throws CertificateException {
        this.internal.checkClientTrusted(x509Certificates, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        try {
            this.internal.checkServerTrusted(x509Certificates, authType);
        }
        catch (CertificateException e) {
            if (e instanceof CertificateExpiredException || x509Certificates == null || x509Certificates.length < 1) {
                throw e;
            }
            try {
                this.fingerprint = MariaDbX509EphemeralTrustingManager.getThumbprint(x509Certificates[0], "SHA-256");
            }
            catch (NoSuchAlgorithmException | CertificateEncodingException ex) {
                throw e;
            }
        }
    }

    public byte[] getFingerprint() {
        return this.fingerprint;
    }

    private static byte[] getThumbprint(X509Certificate cert, String algorithm) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] der = cert.getEncoded();
        md.update(der);
        return md.digest();
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }
}

