/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class UproProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_HEADER = new PatternBuilder().text("*").expression("(..20)").expression("([01])").number("(d+),").expression("(.)").expression("(.)").any().compile();
    private static final Pattern PATTERN_LOCATION = new PatternBuilder().number("(dd)(dd)(dd)").number("(dd)(dd)(dddd)").number("(ddd)(dd)(dddd)").number("(d)").number("(dd)").number("(dd)").number("(dd)(dd)(dd)").compile();

    public UproProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void decodeLocation(Position position, String data) {
        Parser parser = new Parser(PATTERN_LOCATION, data);
        if (parser.matches()) {
            DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
            position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN));
            position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN));
            int flags = parser.nextInt(0);
            position.setValid(!BitUtil.check(flags, 0));
            if (!BitUtil.check(flags, 1)) {
                position.setLatitude(-position.getLatitude());
            }
            if (!BitUtil.check(flags, 2)) {
                position.setLongitude(-position.getLongitude());
            }
            position.setSpeed(parser.nextInt(0) * 2);
            position.setCourse(parser.nextInt(0) * 10);
            dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
            position.setTime(dateBuilder.getDate());
        }
    }

    private String decodeAlarm(int alarm) {
        if (BitUtil.check(alarm, 2)) {
            return "tampering";
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String header;
        Parser parser;
        ByteBuf buf = (ByteBuf)msg;
        if (buf.getByte(buf.readerIndex()) != 42) {
            return null;
        }
        int headerIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)38);
        if (headerIndex < 0) {
            headerIndex = buf.writerIndex();
        }
        if (!(parser = new Parser(PATTERN_HEADER, header = buf.readSlice(headerIndex - buf.readerIndex()).toString(StandardCharsets.US_ASCII))).matches()) {
            return null;
        }
        String head = parser.next();
        boolean reply = parser.next().equals("1");
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        Network network = new Network();
        String type = parser.next();
        String subtype = parser.next();
        if (reply && channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage("*" + head + "Y" + type + subtype + "#", remoteAddress));
        }
        block24: while (buf.readableBytes() > 1) {
            buf.readByte();
            byte dataType = buf.readByte();
            int delimiterIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)38);
            if (delimiterIndex < 0 && (delimiterIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)35)) < 0) {
                delimiterIndex = buf.writerIndex();
            }
            ByteBuf data = buf.readSlice(delimiterIndex - buf.readerIndex());
            int mcc = 0;
            int mnc = 0;
            switch (dataType) {
                case 65: {
                    this.decodeLocation(position, data.toString(StandardCharsets.US_ASCII));
                    break;
                }
                case 66: {
                    position.set("status", data.toString(StandardCharsets.US_ASCII));
                    break;
                }
                case 67: {
                    long odometer = 0L;
                    while (data.isReadable()) {
                        odometer <<= 4;
                        odometer += (long)(data.readByte() - 48);
                    }
                    position.set("odometer", odometer * 2L * 1852L / 3600L);
                    break;
                }
                case 70: {
                    position.setSpeed((double)Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII)) * 0.1);
                    break;
                }
                case 71: {
                    position.setAltitude((double)Integer.parseInt(data.readSlice(6).toString(StandardCharsets.US_ASCII)) * 0.1);
                    break;
                }
                case 73: {
                    int offset;
                    String stringValue = data.toString(StandardCharsets.US_ASCII);
                    int count = Integer.parseInt(stringValue.substring(0, 1));
                    if (stringValue.length() != 6 + count * 10) break;
                    mcc = Integer.parseInt(stringValue.substring(1, 4));
                    mnc = Integer.parseInt(stringValue.substring(4, 6));
                    for (int i = 0; i < count; ++i) {
                        offset = 6 + i * 10;
                        network.addCellTower(CellTower.from(mcc, mnc, Integer.parseInt(stringValue.substring(offset, offset + 4), 16), Integer.parseInt(stringValue.substring(offset + 4, offset + 8), 16), Integer.parseInt(stringValue.substring(offset + 8, offset + 10))));
                    }
                    continue block24;
                }
                case 74: {
                    if (data.readableBytes() != 6) break;
                    char index = (char)data.readUnsignedByte();
                    short status = data.readUnsignedByte();
                    double value = (double)Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII)) * 0.1;
                    if (BitUtil.check(status, 0)) {
                        value = -value;
                    }
                    position.set("temp" + index, value);
                    break;
                }
                case 75: {
                    position.set("statusExtended", data.toString(StandardCharsets.US_ASCII));
                    break;
                }
                case 77: {
                    if (data.readableBytes() == 3) {
                        position.set("batteryLevel", (double)Integer.parseInt(data.readSlice(3).toString(StandardCharsets.US_ASCII)) * 0.1);
                        break;
                    }
                    if (data.readableBytes() != 4) break;
                    char index = (char)data.readUnsignedByte();
                    data.readUnsignedByte();
                    position.set("humidity" + index, Integer.parseInt(data.readSlice(2).toString(StandardCharsets.US_ASCII)));
                    break;
                }
                case 78: {
                    position.set("rssi", Integer.parseInt(data.readSlice(2).toString(StandardCharsets.US_ASCII)));
                    break;
                }
                case 79: {
                    position.set("sat", Integer.parseInt(data.readSlice(2).toString(StandardCharsets.US_ASCII)));
                    break;
                }
                case 80: {
                    if (data.readableBytes() < 16) break;
                    position.setNetwork(new Network(CellTower.from(Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII)), Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII)), Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII), 16), Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII), 16))));
                    break;
                }
                case 81: {
                    if (head.startsWith("HQ")) break;
                    position.set("obdPid", ByteBufUtil.hexDump((ByteBuf)data));
                    break;
                }
                case 82: {
                    if (head.startsWith("HQ")) {
                        position.set("rssi", Integer.parseInt(data.readSlice(2).toString(StandardCharsets.US_ASCII)));
                        position.set("sat", Integer.parseInt(data.readSlice(2).toString(StandardCharsets.US_ASCII)));
                        break;
                    }
                    position.set("odbTravel", ByteBufUtil.hexDump((ByteBuf)data));
                    break;
                }
                case 83: {
                    position.set("obdTraffic", ByteBufUtil.hexDump((ByteBuf)data));
                    break;
                }
                case 84: {
                    if (data.readableBytes() != 2) break;
                    position.set("batteryLevel", Integer.parseInt(data.toString(StandardCharsets.US_ASCII)));
                    break;
                }
                case 86: {
                    position.set("power", (double)Integer.parseInt(data.readSlice(4).toString(StandardCharsets.US_ASCII)) * 0.1);
                    break;
                }
                case 87: {
                    position.set("alarm", this.decodeAlarm(Integer.parseInt(data.readSlice(2).toString(StandardCharsets.US_ASCII))));
                    break;
                }
                case 88: {
                    String[] cells = data.toString(StandardCharsets.US_ASCII).split(";");
                    if (cells[0].startsWith("(")) continue block24;
                    for (int i = 0; i < cells.length; ++i) {
                        String[] values = cells[i].split(",");
                        int index = 0;
                        if (i == 0) {
                            mcc = Integer.parseInt(values[index++]);
                            mnc = Integer.parseInt(values[index++]);
                        }
                        network.addCellTower(CellTower.from(mcc, mnc, Integer.parseInt(values[index++]), Integer.parseInt(values[index++]), Integer.parseInt(values[index])));
                    }
                    position.setNetwork(network);
                    break;
                }
                case 89: {
                    int offset;
                    String stringValue = data.toString(StandardCharsets.US_ASCII);
                    int count = Integer.parseInt(stringValue.substring(0, 1));
                    if (stringValue.length() == 6 + count * 14) {
                        mcc = Integer.parseInt(stringValue.substring(1, 4));
                        mnc = Integer.parseInt(stringValue.substring(4, 6));
                        for (int i = 0; i < count; ++i) {
                            offset = 6 + i * 14;
                            network.addCellTower(CellTower.from(mcc, mnc, Integer.parseInt(stringValue.substring(offset, offset + 4), 16), Long.parseLong(stringValue.substring(offset + 4, offset + 12), 16), Integer.parseInt(stringValue.substring(offset + 12, offset + 14), 16)));
                        }
                        continue block24;
                    }
                    position.set("power", (double)Integer.parseInt(data.readSlice(5).toString(StandardCharsets.US_ASCII)) * 0.001);
                    break;
                }
                case 98: {
                    if (data.readableBytes() <= 3) break;
                    position.set("serial", data.toString(StandardCharsets.US_ASCII).substring(3));
                    break;
                }
                case 100: {
                    position.set("adc1", (double)Integer.parseInt(data.toString(StandardCharsets.US_ASCII)) / 100.0);
                }
            }
        }
        if (network.getCellTowers() != null || network.getWifiAccessPoints() != null) {
            position.setNetwork(network);
        }
        if (position.getLatitude() == 0.0 || position.getLongitude() == 0.0) {
            if (position.getAttributes().isEmpty()) {
                return null;
            }
            this.getLastLocation(position, position.getDeviceTime());
        }
        return position;
    }
}

