/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class LaipacProtocolDecoder
extends BaseProtocolDecoder {
    public static final String DEFAULT_DEVICE_PASSWORD = "00000000";
    private static final Pattern PATTERN_EAVSYS = new PatternBuilder().text("$EAVSYS,").expression("([^,]+),").expression("([0-9]+),").expression("(\\+?[0-9]+)?,").expression("(?:[^,]*),").expression("([^,]*)?").text("*").number("(xx)").compile();
    private static final Pattern PATTERN_AVRMC = new PatternBuilder().text("$AVRMC,").expression("([^,]+),").number("(dd)(dd)(dd),").expression("([AVRPavrp]),").number("(dd)(dd.d+),").expression("([NS]),").number("(ddd)(dd.d+),").number("([EW]),").number("(d+.d+),").number("(d+.d+),").number("(dd)(dd)(dd),").expression("([0-9A-Za-z]),").expression("([\\d.]+),").number("(d+),").number("(d),").number("(d+),").number("(d+)").number(",(xxxx|x)").number("(xxxx),").number("(ddd|d)").number("(ddd)").optional(4).expression(",([^*]*)").optional(1).text("*").number("(xx)").compile();

    public LaipacProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(String event) {
        return switch (event) {
            case "Z" -> "lowBattery";
            case "Y" -> "tow";
            case "X" -> "geofenceEnter";
            case "T" -> "tampering";
            case "H" -> "powerOff";
            case "8" -> "vibration";
            case "7", "4" -> "geofenceExit";
            case "6" -> "overspeed";
            case "5" -> "powerCut";
            case "3" -> "sos";
            default -> null;
        };
    }

    private String decodeEvent(String event, Position position, String model) {
        if (event.length() == 1) {
            char inputStatus = event.charAt(0);
            if (inputStatus >= 'A' && inputStatus <= 'D') {
                int inputStatusInt = inputStatus - 65;
                position.set("in1", BitUtil.check(inputStatusInt, 0));
                position.set("in2", BitUtil.check(inputStatusInt, 1));
                if ("SF-Lite".equals(model)) {
                    position.set("in3", false);
                }
                return null;
            }
            if (inputStatus >= 'O' && inputStatus <= 'R') {
                int inputStatusInt = inputStatus - 79;
                position.set("in1", BitUtil.check(inputStatusInt, 0));
                position.set("in2", BitUtil.check(inputStatusInt, 1));
                if ("SF-Lite".equals(model)) {
                    position.set("in3", true);
                }
                return null;
            }
        }
        return event;
    }

    private void sendEventResponse(String event, String devicePassword, Channel channel, SocketAddress remoteAddress) {
        String responseCode = null;
        switch (event) {
            case "3": {
                responseCode = "d";
                break;
            }
            case "M": {
                responseCode = "m";
                break;
            }
            case "S": 
            case "T": {
                responseCode = "t";
                break;
            }
            case "X": 
            case "4": {
                responseCode = "x";
                break;
            }
            case "Y": {
                responseCode = "y";
                break;
            }
            case "Z": {
                responseCode = "z";
            }
        }
        if (responseCode != null) {
            String response = "$AVCFG," + devicePassword + "," + responseCode;
            response = response + Checksum.nmea(response.substring(1)) + "\r\n";
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private void sendAcknowledge(String status, String event, String checksum, Channel channel, SocketAddress remoteAddress) {
        if (Character.isLowerCase(status.charAt(0))) {
            String response = "$EAVACK," + event + "," + checksum;
            response = response + Checksum.nmea(response.substring(1)) + "\r\n";
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    protected Object decodeEavsys(String sentence, Channel channel, SocketAddress remoteAddress) {
        Parser parser = new Parser(PATTERN_EAVSYS, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.set("iccid", parser.next());
        position.set("phone", parser.next());
        position.set("versionFw", parser.next());
        return position;
    }

    protected Object decodeAvrmc(String sentence, Channel channel, SocketAddress remoteAddress) {
        Parser parser = new Parser(PATTERN_AVRMC, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        String model = this.getDeviceModel(deviceSession);
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        String status = parser.next();
        String upperCaseStatus = status.toUpperCase();
        position.setValid(upperCaseStatus.equals("A") || upperCaseStatus.equals("R") || upperCaseStatus.equals("P"));
        position.set("status", status);
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setTime(dateBuilder.getDate());
        String event = parser.next();
        position.set("alarm", this.decodeAlarm(event));
        position.set("event", this.decodeEvent(event, position, model));
        position.set("battery", Double.parseDouble(parser.next().replaceAll("\\.", "")) * 0.001);
        position.set("odometer", parser.nextDouble() * 1000.0);
        position.set("gps", parser.nextInt());
        position.set("adc1", parser.nextDouble() * 0.001);
        if ("AVL110".equals(model) || "AVL120".equals(model)) {
            position.set("adc2", parser.nextDouble() * 0.001);
        } else {
            parser.next();
        }
        Integer lac = parser.nextHexInt();
        Integer cid = parser.nextHexInt();
        Integer mcc = parser.nextInt();
        Integer mnc = parser.nextInt();
        if (lac != null && cid != null && mcc != null && mnc != null) {
            position.setNetwork(new Network(CellTower.from(mcc, mnc, lac, cid.intValue())));
        }
        parser.next();
        String checksum = parser.next();
        if (channel != null) {
            this.sendAcknowledge(status, event, checksum, channel, remoteAddress);
            String devicePassword = AttributeUtil.getDevicePassword(this.getCacheManager(), deviceSession.getDeviceId(), this.getProtocolName(), DEFAULT_DEVICE_PASSWORD);
            this.sendEventResponse(event, devicePassword, channel, remoteAddress);
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.startsWith("$ECHK")) {
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage(sentence + "\r\n", remoteAddress));
            }
        } else {
            if (sentence.startsWith("$EAVSYS")) {
                return this.decodeEavsys(sentence, channel, remoteAddress);
            }
            if (sentence.startsWith("$AVRMC")) {
                return this.decodeAvrmc(sentence, channel, remoteAddress);
            }
        }
        return null;
    }
}

