/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import jakarta.inject.Inject;
import java.util.List;
import org.traccar.config.Config;
import org.traccar.handler.BasePositionHandler;
import org.traccar.helper.model.GeofenceUtil;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

public class GeofenceHandler
extends BasePositionHandler {
    private final Config config;
    private final CacheManager cacheManager;

    @Inject
    public GeofenceHandler(Config config, CacheManager cacheManager) {
        this.config = config;
        this.cacheManager = cacheManager;
    }

    @Override
    public void handlePosition(Position position, BasePositionHandler.Callback callback) {
        List<Long> geofenceIds = GeofenceUtil.getCurrentGeofences(this.config, this.cacheManager, position);
        if (!geofenceIds.isEmpty()) {
            position.setGeofenceIds(geofenceIds);
        }
        callback.processed(false);
    }
}

