/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.internal.LexicalScope;
import org.apache.commons.jexl3.internal.Scope;
import org.apache.commons.jexl3.parser.ASTAmbiguous;
import org.apache.commons.jexl3.parser.ASTAssignment;
import org.apache.commons.jexl3.parser.ASTDecrementGetNode;
import org.apache.commons.jexl3.parser.ASTGetDecrementNode;
import org.apache.commons.jexl3.parser.ASTGetIncrementNode;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.ASTIncrementGetNode;
import org.apache.commons.jexl3.parser.ASTJexlLambda;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.ASTSetAddNode;
import org.apache.commons.jexl3.parser.ASTSetAndNode;
import org.apache.commons.jexl3.parser.ASTSetDivNode;
import org.apache.commons.jexl3.parser.ASTSetModNode;
import org.apache.commons.jexl3.parser.ASTSetMultNode;
import org.apache.commons.jexl3.parser.ASTSetOrNode;
import org.apache.commons.jexl3.parser.ASTSetShiftLeftNode;
import org.apache.commons.jexl3.parser.ASTSetShiftRightNode;
import org.apache.commons.jexl3.parser.ASTSetShiftRightUnsignedNode;
import org.apache.commons.jexl3.parser.ASTSetSubNode;
import org.apache.commons.jexl3.parser.ASTSetXorNode;
import org.apache.commons.jexl3.parser.ASTVar;
import org.apache.commons.jexl3.parser.FeatureController;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.ParseException;
import org.apache.commons.jexl3.parser.StringParser;
import org.apache.commons.jexl3.parser.Token;

public abstract class JexlParser
extends StringParser {
    public static final String PRAGMA_OPTIONS = "jexl.options";
    public static final String PRAGMA_JEXLNS = "jexl.namespace.";
    public static final String PRAGMA_MODULE = "jexl.module.";
    public static final String PRAGMA_IMPORT = "jexl.import";
    private static final Set<Class<? extends JexlNode>> ASSIGN_NODES = new HashSet<Class>(Arrays.asList(ASTAssignment.class, ASTSetAddNode.class, ASTSetSubNode.class, ASTSetMultNode.class, ASTSetDivNode.class, ASTSetModNode.class, ASTSetAndNode.class, ASTSetOrNode.class, ASTSetXorNode.class, ASTSetShiftLeftNode.class, ASTSetShiftRightNode.class, ASTSetShiftRightUnsignedNode.class, ASTIncrementGetNode.class, ASTDecrementGetNode.class, ASTGetDecrementNode.class, ASTGetIncrementNode.class));
    protected final FeatureController featureController = new FeatureController(JexlEngine.DEFAULT_FEATURES);
    protected JexlInfo info;
    protected String source;
    protected Scope scope;
    protected final Deque<Scope> scopes = new ArrayDeque<Scope>();
    protected Map<String, Object> pragmas;
    protected Set<String> namespaces;
    protected int loopCount;
    protected final Deque<Integer> loopCounts = new ArrayDeque<Integer>();
    protected LexicalUnit block;
    protected final Deque<LexicalUnit> blocks = new ArrayDeque<LexicalUnit>();
    protected final Map<LexicalUnit, Scope> blockScopes = new IdentityHashMap<LexicalUnit, Scope>();

    protected static Token errorToken(Token ... tokens) {
        for (Token token : tokens) {
            if (token == null || token.image == null || token.image.isEmpty()) continue;
            return token;
        }
        return null;
    }

    protected static String readSourceLine(String src, int lineno) {
        String msg = "";
        if (src != null && lineno >= 0) {
            try {
                BufferedReader reader = new BufferedReader(new StringReader(src));
                for (int l = 0; l < lineno; ++l) {
                    msg = reader.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return msg;
    }

    protected static String stringify(Iterable<String> lstr) {
        StringBuilder strb = new StringBuilder();
        boolean dot = false;
        for (String str : lstr) {
            if (!dot) {
                dot = true;
            } else {
                strb.append('.');
            }
            strb.append(str);
        }
        return strb.toString();
    }

    public void allowRegisters(boolean registers) {
        this.featureController.setFeatures(new JexlFeatures(this.featureController.getFeatures()).register(registers));
    }

    protected boolean allowVariable(String image) {
        JexlFeatures features = this.getFeatures();
        if (!features.supportsLocalVar()) {
            return false;
        }
        return !features.isReservedName(image);
    }

    protected void checkLambda(Token token) {
        String arrow = token.image;
        if ("->".equals(arrow)) {
            if (!this.getFeatures().supportsThinArrow()) {
                this.throwFeatureException(16, token);
            }
            return;
        }
        if ("=>".equals(arrow) && !this.getFeatures().supportsFatArrow()) {
            this.throwFeatureException(17, token);
        }
    }

    protected String checkVariable(ASTIdentifier identifier, String name) {
        Integer symbol;
        if (this.scope != null && (symbol = this.scope.getSymbol(name)) != null) {
            identifier.setLexical(this.scope.isLexical(symbol));
            boolean declared = true;
            if (this.scope.isCapturedSymbol(symbol)) {
                identifier.setCaptured(true);
            } else {
                LexicalUnit unit = this.block;
                declared = unit.hasSymbol(symbol);
                if (!declared) {
                    for (LexicalUnit u : this.blocks) {
                        if (!u.hasSymbol(symbol)) continue;
                        unit = u;
                        declared = true;
                        break;
                    }
                }
                if (declared) {
                    if (unit.isConstant(symbol)) {
                        identifier.setConstant(true);
                    }
                } else if (this.info instanceof JexlNode.Info) {
                    declared = this.isSymbolDeclared((JexlNode.Info)this.info, symbol);
                }
            }
            identifier.setSymbol(symbol, name);
            if (!declared) {
                identifier.setShaded(true);
                if (this.getFeatures().isLexicalShade()) {
                    throw new JexlException.Parsing(this.info, name + ": variable is not declared").clean();
                }
            }
        }
        return name;
    }

    protected void cleanup(JexlFeatures features) {
        this.info = null;
        this.source = null;
        this.scope = null;
        this.scopes.clear();
        this.pragmas = null;
        this.namespaces = null;
        this.loopCounts.clear();
        this.loopCount = 0;
        this.blocks.clear();
        this.block = null;
        this.blockScopes.clear();
        this.setFeatures(features);
    }

    protected void controlPragmaAnywhere() {
        JexlFeatures features = this.getFeatures();
        if (features.supportsPragma() && !features.supportsPragmaAnywhere()) {
            this.featureController.setFeatures(new JexlFeatures(this.featureController.getFeatures()).pragma(false));
        }
    }

    protected void declareFunction(ASTVar variable, Token token) {
        String name = token.image;
        if (this.scope == null) {
            this.scope = new Scope(null, new String[0]);
        }
        int symbol = this.scope.declareVariable(name);
        variable.setSymbol(symbol, name);
        variable.setLexical(true);
        if (this.scope.isCapturedSymbol(symbol)) {
            variable.setCaptured(true);
        }
        if (this.declareSymbol(symbol)) {
            this.scope.addLexical(symbol);
            this.block.setConstant(symbol);
        } else {
            if (this.getFeatures().isLexical()) {
                throw new JexlException(variable, name + ": variable is already declared");
            }
            variable.setRedefined(true);
        }
    }

    protected void declareParameter(Token token, boolean lexical, boolean constant) {
        int symbol;
        String identifier = token.image;
        if (!this.allowVariable(identifier)) {
            this.throwFeatureException(2, token);
        }
        if (this.scope == null) {
            this.scope = new Scope(null, null);
        }
        if (!this.block.declareSymbol(symbol = this.scope.declareParameter(identifier))) {
            if (lexical || this.getFeatures().isLexical()) {
                JexlInfo xinfo = this.info.at(token.beginLine, token.beginColumn);
                throw new JexlException.Parsing(xinfo, identifier + ": parameter is already declared").clean();
            }
        } else if (lexical) {
            this.scope.addLexical(symbol);
            if (constant) {
                this.block.setConstant(symbol);
            }
        }
    }

    protected void declarePragma(String key, Object value) {
        String[] nsprefixes;
        JexlFeatures features = this.getFeatures();
        if (!features.supportsPragma()) {
            this.throwFeatureException(11, this.getToken(0));
        }
        if (PRAGMA_IMPORT.equals(key) && !features.supportsImportPragma()) {
            this.throwFeatureException(19, this.getToken(0));
        }
        if (this.pragmas == null) {
            this.pragmas = new TreeMap<String, Object>();
        }
        for (String nsprefix : nsprefixes = new String[]{PRAGMA_JEXLNS, PRAGMA_MODULE}) {
            String nsname;
            if (!key.startsWith(nsprefix)) continue;
            if (!features.supportsNamespacePragma()) {
                this.throwFeatureException(18, this.getToken(0));
            }
            if ((nsname = key.substring(nsprefix.length())).isEmpty()) break;
            if (this.namespaces == null) {
                this.namespaces = new HashSet<String>();
            }
            this.namespaces.add(nsname);
            break;
        }
        if (value == null) {
            this.pragmas.putIfAbsent(key, null);
        } else {
            this.pragmas.merge(key, value, (previous, newValue) -> {
                if (previous instanceof Set) {
                    ((Set)previous).add(newValue);
                    return previous;
                }
                LinkedHashSet<Object> values = new LinkedHashSet<Object>();
                values.add(previous);
                values.add(newValue);
                return values;
            });
        }
    }

    private boolean declareSymbol(int symbol) {
        for (LexicalUnit lu : this.blocks) {
            if (lu.hasSymbol(symbol)) {
                return false;
            }
            if (!(lu instanceof ASTJexlLambda)) continue;
            break;
        }
        return this.block == null || this.block.declareSymbol(symbol);
    }

    protected void declareVariable(ASTVar variable, Token token, boolean lexical, boolean constant) {
        String name = token.image;
        if (!this.allowVariable(name)) {
            this.throwFeatureException(2, token);
        }
        if (this.scope == null) {
            this.scope = new Scope(null, new String[0]);
        }
        int symbol = this.scope.declareVariable(name);
        variable.setSymbol(symbol, name);
        variable.setLexical(lexical);
        variable.setConstant(constant);
        if (this.scope.isCapturedSymbol(symbol)) {
            variable.setCaptured(true);
        }
        if (!this.declareSymbol(symbol)) {
            if (lexical || this.scope.isLexical(symbol) || this.getFeatures().isLexical()) {
                throw new JexlException.Parsing(variable.jexlInfo(), name + ": variable is already declared").clean();
            }
            variable.setRedefined(true);
        } else if (lexical) {
            this.scope.addLexical(symbol);
            if (constant) {
                this.block.setConstant(symbol);
            }
        }
    }

    protected JexlFeatures getFeatures() {
        return this.featureController.getFeatures();
    }

    protected Scope getScope() {
        return this.scope;
    }

    protected abstract Token getToken(int var1);

    protected LexicalUnit getUnit() {
        return this.block;
    }

    protected void Identifier(boolean top) throws ParseException {
    }

    private boolean isConstant(int symbol) {
        if (symbol >= 0) {
            if (this.block != null && this.block.hasSymbol(symbol)) {
                return this.block.isConstant(symbol);
            }
            Scope blockScope = this.blockScopes.get(this.block);
            int lexical = symbol;
            for (LexicalUnit unit : this.blocks) {
                Scope unitScope = this.blockScopes.get(unit);
                if (blockScope != unitScope) {
                    int declared = blockScope.getCaptureDeclaration(lexical);
                    if (declared >= 0) {
                        lexical = declared;
                    }
                    if (unitScope != null) {
                        blockScope = unitScope;
                    }
                }
                if (!unit.hasSymbol(lexical)) continue;
                return unit.isConstant(lexical);
            }
        }
        return false;
    }

    private boolean isNamespace(String name) {
        if ("jexl".equals(name) || "$jexl".equals(name)) {
            return true;
        }
        Set<String> ns = this.namespaces;
        if (ns != null && ns.contains(name)) {
            return true;
        }
        return this.getFeatures().namespaceTest().test(name);
    }

    protected boolean isNamespaceFuncall(Token ns, Token colon, Token fun, Token paren) {
        if (!":".equals(colon.image)) {
            return false;
        }
        if (!"(".equals(paren.image)) {
            return false;
        }
        String name = ns.image;
        if (this.isVariable(name)) {
            return colon.beginColumn - 1 == ns.endColumn && (colon.endColumn == fun.beginColumn - 1 || this.isNamespace(name));
        }
        return true;
    }

    private boolean isSymbolDeclared(JexlNode.Info info, int symbol) {
        for (JexlNode walk = info.getNode(); walk != null; walk = walk.jjtGetParent()) {
            if (!(walk instanceof LexicalUnit)) continue;
            LexicalScope scope = ((LexicalUnit)((Object)walk)).getLexicalScope();
            if (scope != null && scope.hasSymbol(symbol)) {
                return true;
            }
            if (walk instanceof ASTJexlLambda) break;
        }
        return false;
    }

    protected boolean isVariable(String name) {
        return this.scope != null && this.scope.getSymbol(name) != null;
    }

    protected void jjtreeCloseNodeScope(JexlNode node) {
        if (node instanceof ASTAmbiguous) {
            this.throwAmbiguousException(node);
        }
        if (node instanceof ASTJexlScript) {
            ASTJexlScript script;
            if (node instanceof ASTJexlLambda && !this.getFeatures().supportsLambda()) {
                this.throwFeatureException(8, node.jexlInfo());
            }
            if ((script = (ASTJexlScript)node).getScope() != this.scope) {
                script.setScope(this.scope);
            }
        } else if (ASSIGN_NODES.contains(node.getClass())) {
            ASTIdentifier var;
            JexlNode lv = node.jjtGetChild(0);
            if (!lv.isLeftValue()) {
                JexlInfo xinfo = lv.jexlInfo();
                xinfo = this.info.at(xinfo.getLine(), xinfo.getColumn());
                String msg = JexlParser.readSourceLine(this.source, xinfo.getLine());
                throw new JexlException.Assignment(xinfo, msg).clean();
            }
            if (lv instanceof ASTIdentifier && !(lv instanceof ASTVar) && this.isConstant((var = (ASTIdentifier)lv).getSymbol())) {
                JexlInfo xinfo = lv.jexlInfo();
                xinfo = this.info.at(xinfo.getLine(), xinfo.getColumn());
                throw new JexlException.Assignment(xinfo, var.getName()).clean();
            }
        }
        this.featureController.controlNode(node);
    }

    protected void jjtreeOpenNodeScope(JexlNode node) {
    }

    protected void popScope() {
        this.scope = !this.scopes.isEmpty() ? this.scopes.pop() : null;
        if (!this.loopCounts.isEmpty()) {
            this.loopCount = this.loopCounts.pop();
        }
    }

    protected void popUnit(LexicalUnit unit) {
        if (this.block == unit) {
            this.blockScopes.remove(unit);
            this.block = !this.blocks.isEmpty() ? this.blocks.pop() : null;
        }
    }

    protected void pushScope() {
        if (this.scope != null) {
            this.scopes.push(this.scope);
        }
        this.scope = new Scope(this.scope, null);
        this.loopCounts.push(this.loopCount);
        this.loopCount = 0;
    }

    protected void pushUnit(LexicalUnit unit) {
        this.blockScopes.put(unit, this.scope);
        if (this.block != null) {
            this.blocks.push(this.block);
        }
        this.block = unit;
    }

    protected void setFeatures(JexlFeatures features) {
        this.featureController.setFeatures(features);
    }

    protected void throwAmbiguousException(JexlNode node) {
        JexlInfo begin = node.jexlInfo();
        Token t = this.getToken(0);
        JexlInfo end = this.info.at(t.beginLine, t.endColumn);
        String msg = JexlParser.readSourceLine(this.source, end.getLine());
        throw new JexlException.Ambiguous(begin, end, msg).clean();
    }

    protected void throwFeatureException(int feature, JexlInfo info) {
        String msg = info != null ? JexlParser.readSourceLine(this.source, info.getLine()) : null;
        throw new JexlException.Feature(info, feature, msg).clean();
    }

    protected void throwFeatureException(int feature, Token trigger) {
        Token token = trigger;
        if (token == null && (token = this.getToken(0)) == null) {
            throw new JexlException.Parsing(null, JexlFeatures.stringify(feature)).clean();
        }
        JexlInfo xinfo = this.info.at(token.beginLine, token.beginColumn);
        this.throwFeatureException(feature, xinfo);
    }

    protected void throwParsingException(Token parsed) {
        JexlInfo xinfo = null;
        String msg = "unrecoverable state";
        Token token = parsed;
        if (token == null) {
            token = this.getToken(0);
        }
        if (token != null) {
            xinfo = this.info.at(token.beginLine, token.beginColumn);
            msg = token.image;
        }
        throw new JexlException.Parsing(xinfo, msg).clean();
    }

    public static interface LexicalUnit {
        public boolean declareSymbol(int var1);

        public LexicalScope getLexicalScope();

        public int getSymbolCount();

        public boolean hasSymbol(int var1);

        public boolean isConstant(int var1);

        public void setConstant(int var1);
    }
}

