/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.oops.Mark;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class FreeChunk
extends VMObject {
    private static AddressField nextField;
    private static AddressField prevField;
    private static AddressField sizeField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("FreeChunk");
        nextField = type.getAddressField("_next");
        prevField = type.getAddressField("_prev");
        sizeField = type.getAddressField("_size");
    }

    public FreeChunk next() {
        return (FreeChunk)VMObjectFactory.newObject(FreeChunk.class, nextField.getValue(this.addr));
    }

    public FreeChunk prev() {
        Address prev = prevField.getValue(this.addr).andWithMask(-4L);
        return (FreeChunk)VMObjectFactory.newObject(FreeChunk.class, prev);
    }

    public long size() {
        if (VM.getVM().isCompressedOopsEnabled()) {
            Mark mark = new Mark(this.addr.addOffsetTo(sizeField.getOffset()));
            return mark.getSize();
        }
        Address size = sizeField.getValue(this.addr);
        JVMDebugger dbg = VM.getVM().getDebugger();
        return dbg.getAddressValue(size);
    }

    public FreeChunk(Address addr) {
        super(addr);
    }

    public static boolean indicatesFreeChunk(Address cur) {
        FreeChunk f = new FreeChunk(cur);
        return f.isFree();
    }

    public boolean isFree() {
        if (VM.getVM().isCompressedOopsEnabled()) {
            Mark mark = new Mark(this.addr.addOffsetTo(sizeField.getOffset()));
            return mark.isCmsFreeChunk();
        }
        Address prev = prevField.getValue(this.addr);
        JVMDebugger dbg = VM.getVM().getDebugger();
        long word = dbg.getAddressValue(prev);
        return (word & 1L) == 1L;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                FreeChunk.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

