/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class JTreeCollapseAllAction
extends AbstractAction {
    private final JTree tree;

    public JTreeCollapseAllAction(JTree tree, String text) {
        super(text);
        this.tree = tree;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreePath selected = this.tree.getSelectionPath();
        Enumeration<TreePath> descendants = this.tree.getExpandedDescendants(selected);
        if (descendants == null) {
            return;
        }
        ArrayList<TreePath> paths = Collections.list(descendants);
        Collections.sort(paths, new Comparator<TreePath>(){

            @Override
            public int compare(TreePath o1, TreePath o2) {
                return o2.getPathCount() - o1.getPathCount();
            }
        });
        for (TreePath path : paths) {
            this.tree.collapsePath(path);
        }
        this.tree.collapsePath(selected);
    }
}

