/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.SQL;
import ca.sqlpower.sql.SequenceGenerator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PostgreSQLSequenceGenerator
extends SequenceGenerator {
    private Connection con;

    public PostgreSQLSequenceGenerator(Connection con) {
        this.con = con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextLong(String sequenceTable) throws SQLException {
        long nextval;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT nextval(").append(SQL.quote(sequenceTable)).append(")");
        Statement stmt = null;
        try {
            stmt = this.con.createStatement();
            ResultSet rs = stmt.executeQuery(sql.toString());
            if (!rs.next()) {
                throw new SQLException("The sequence returned nothing!");
            }
            nextval = rs.getLong(1);
            rs.close();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return nextval;
    }

    @Override
    public void close() throws SQLException {
        if (this.con != null) {
            this.con.close();
        }
    }
}

