/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectSessionImpl;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.UserSettings;
import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.ContainerPane;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.DraggablePlayPenComponent;
import ca.sqlpower.architect.swingui.DuplicateProperties;
import ca.sqlpower.architect.swingui.ImportSafetyChecker;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.PlayPenLabel;
import ca.sqlpower.architect.swingui.PopupMenuFactory;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.CancelAction;
import ca.sqlpower.architect.swingui.event.PlayPenLifecycleEvent;
import ca.sqlpower.architect.swingui.event.PlayPenLifecycleListener;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.architect.swingui.olap.CubePane;
import ca.sqlpower.architect.swingui.olap.DimensionPane;
import ca.sqlpower.architect.swingui.olap.OLAPPane;
import ca.sqlpower.architect.swingui.olap.OLAPTree;
import ca.sqlpower.architect.swingui.olap.PaneSection;
import ca.sqlpower.architect.swingui.olap.UsageComponent;
import ca.sqlpower.architect.swingui.olap.VirtualCubePane;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.sqlobject.undo.CompoundEventListener;
import ca.sqlpower.swingui.CursorManager;
import ca.sqlpower.swingui.ProgressWatcher;
import ca.sqlpower.swingui.SPSwingWorker;
import ca.sqlpower.swingui.SwingWorkerRegistry;
import ca.sqlpower.swingui.dbtree.SQLObjectSelection;
import ca.sqlpower.util.Monitorable;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import ca.sqlpower.util.UserPrompterFactory;
import com.google.common.collect.ArrayListMultimap;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

@SuppressWarnings(justification="PlayPen is not meant to be serializable", value={"SE_BAD_FIELD"})
public class PlayPen
extends JPanel
implements SPListener,
SelectionListener,
Scrollable {
    public static final String ACTION_COMMAND_SRC_PLAYPEN = "PlayPen";
    private static Logger logger = Logger.getLogger(PlayPen.class);
    private MouseModeType mouseMode = MouseModeType.IDLE;
    private final CursorManager cursorManager;
    private PopupMenuFactory popupFactory;
    protected Set<String> tableNames;
    protected PPMouseListener ppMouseListener;
    protected Rectangle rubberBand;
    protected Color rubberBandColor = Color.black;
    protected double zoom;
    protected PlayPenContentPane contentPane;
    protected Action bringToFrontAction;
    protected Action sendToBackAction;
    protected Action zoomInAction;
    protected Action zoomOutAction;
    protected Component ppScrollPane;
    protected JDialog dbcsDialog;
    protected boolean draggingContainerPanes = false;
    private boolean selectionInProgress = false;
    private Object antialiasSetting = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
    private Map<String, PlayPenComponent> removedComponents = new WeakHashMap<String, PlayPenComponent>();
    private boolean paintingEnabled = true;
    private boolean normalizing;
    final ArchitectSwingSession session;
    private Point viewportPosition;
    private FontRenderContext fontRenderContext;
    private boolean ignoreTreeSelection = false;
    private int transactionCount = 0;
    private boolean childAdded = false;
    private boolean childRemoved = false;
    private boolean propertyChanged = false;
    protected LinkedList<SelectionListener> selectionListeners = new LinkedList();
    protected LinkedList<CancelableListener> cancelableListeners = new LinkedList();
    protected LinkedList<CompoundEventListener> undoEventListeners = new LinkedList();
    private final List<PlayPenLifecycleListener> lifecycleListeners = new ArrayList<PlayPenLifecycleListener>();

    @Override
    protected void addImpl(Component c, Object constraints, int index) {
        throw new UnsupportedOperationException("You can't add swing component for argument");
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(800, 600);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width;
        }
        return visibleRect.height;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width / 5;
        }
        return visibleRect.height / 5;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension usedSpace = this.getUsedArea();
        Dimension vpSize = this.getViewportSize();
        Dimension ppSize = null;
        if (vpSize != null) {
            ppSize = new Dimension(Math.max(usedSpace.width, vpSize.width), Math.max(usedSpace.height, vpSize.height));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("minsize is: " + this.getMinimumSize()));
            logger.debug((Object)("unzoomed userDim is: " + this.unzoomPoint(new Point(usedSpace.width, usedSpace.height))));
            logger.debug((Object)("zoom=" + this.zoom + ",usedSpace size is " + usedSpace));
        }
        if (ppSize != null) {
            logger.debug((Object)("preferred size is ppSize (viewport size was null): " + ppSize));
            return ppSize;
        }
        logger.debug((Object)("preferred size is usedSpace: " + usedSpace));
        return usedSpace;
    }

    public Dimension getUsedArea() {
        Rectangle cbounds = null;
        int minx = 0;
        int miny = 0;
        int maxx = 0;
        int maxy = 0;
        for (PlayPenComponent playPenComponent : this.contentPane.getChildren()) {
            cbounds = playPenComponent.getBounds(cbounds);
            minx = Math.min(cbounds.x, minx);
            miny = Math.min(cbounds.y, miny);
            maxx = Math.max(cbounds.x + cbounds.width, maxx);
            maxy = Math.max(cbounds.y + cbounds.height, maxy);
        }
        return new Dimension((int)((double)Math.max(maxx - minx, this.getMinimumSize().width) * this.zoom), (int)((double)Math.max(maxy - miny, this.getMinimumSize().height) * this.zoom));
    }

    public Dimension getViewportSize() {
        Container c = SwingUtilities.getAncestorOfClass(JViewport.class, this);
        if (c != null) {
            JViewport jvp = (JViewport)c;
            logger.debug((Object)("viewport size is: " + jvp.getSize()));
            return jvp.getSize();
        }
        logger.debug((Object)"viewport size is NULL");
        return null;
    }

    public void setViewportSize(int width, int height) {
        Container c = SwingUtilities.getAncestorOfClass(JViewport.class, this);
        if (c != null) {
            JViewport jvp = (JViewport)c;
            logger.debug((Object)("viewport size set to: " + width + "," + height));
            jvp.setSize(width, height);
        }
    }

    protected void normalize() {
        if (this.normalizing) {
            return;
        }
        this.normalizing = true;
        int minX = 0;
        int minY = 0;
        for (PlayPenComponent playPenComponent : this.contentPane.getChildren()) {
            minX = Math.min(minX, playPenComponent.getX());
            minY = Math.min(minY, playPenComponent.getY());
        }
        if (minX < 0 || minY < 0) {
            for (PlayPenComponent playPenComponent : this.contentPane.getChildren()) {
                playPenComponent.setLocation(playPenComponent.getX() - minX, playPenComponent.getY() - minY);
            }
            this.repaint();
        }
        this.normalizing = false;
    }

    public Point getViewPosition() {
        Container c = SwingUtilities.getAncestorOfClass(JViewport.class, this);
        if (c != null) {
            JViewport jvp = (JViewport)c;
            Point viewPosition = jvp.getViewPosition();
            logger.debug((Object)("view position is: " + viewPosition));
            return viewPosition;
        }
        return this.viewportPosition;
    }

    public void setViewPosition(Point p) {
        Container c = SwingUtilities.getAncestorOfClass(JViewport.class, this);
        if (c != null) {
            JViewport jvp = (JViewport)c;
            logger.debug((Object)("view position set to: " + p));
            if (p != null) {
                jvp.setViewPosition(p);
            }
        }
        this.viewportPosition = p;
    }

    public void setInitialViewPosition() {
        this.setViewPosition(this.viewportPosition);
    }

    public void setPaintingEnabled(boolean paintingEnabled) {
        this.paintingEnabled = paintingEnabled;
    }

    public boolean isPaintingEnabled() {
        return this.paintingEnabled;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.paintingEnabled) {
            return;
        }
        logger.debug((Object)("start of paintComponent, width=" + this.getWidth() + ",height=" + this.getHeight()));
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasSetting);
        if (this.isDebugEnabled()) {
            Rectangle clip = g2.getClipBounds();
            if (clip != null) {
                g2.setColor(Color.green);
                --clip.width;
                --clip.height;
                g2.draw(clip);
                g2.setColor(this.getBackground());
                logger.debug((Object)("Clipping region: " + g2.getClip()));
            } else {
                logger.debug((Object)"Null clipping region");
            }
        }
        Rectangle bounds = new Rectangle();
        AffineTransform backup = g2.getTransform();
        g2.scale(this.zoom, this.zoom);
        AffineTransform zoomedOrigin = g2.getTransform();
        ArrayList<? extends PlayPenComponent> relationshipsLast = new ArrayList<PlayPenComponent>();
        List relations = this.contentPane.getChildren(Relationship.class);
        List usages = this.contentPane.getChildren(UsageComponent.class);
        relationshipsLast.addAll(this.contentPane.getAllChildren());
        relationshipsLast.removeAll(relations);
        relationshipsLast.addAll(relations);
        relationshipsLast.removeAll(usages);
        relationshipsLast.addAll(usages);
        for (int i = relationshipsLast.size() - 1; i >= 0; --i) {
            PlayPenComponent c = (PlayPenComponent)relationshipsLast.get(i);
            c.getBounds(bounds);
            if (g2.hitClip(bounds.x, bounds.y, bounds.width + 1, bounds.height + 1)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Painting visible component " + c));
                }
                g2.translate(c.getLocation().x, c.getLocation().y);
                Font g2Font = g2.getFont();
                c.paint(g2);
                g2.setFont(g2Font);
                g2.setTransform(zoomedOrigin);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("paint: SKIPPING " + c));
            }
            logger.debug((Object)(" skipped bounds are: x=" + bounds.x + " y=" + bounds.y + " width=" + bounds.width + " height=" + bounds.height));
            logger.debug((Object)(" clipping rectangle: x=" + g2.getClipBounds().x + " y=" + g2.getClipBounds().y + " width=" + g2.getClipBounds().width + " height=" + g2.getClipBounds().height));
        }
        if (this.rubberBand != null && !this.rubberBand.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("painting rubber band " + this.rubberBand));
            }
            g2.setColor(this.rubberBandColor);
            Composite backupComp = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
            g2.fillRect(this.rubberBand.x, this.rubberBand.y, this.rubberBand.width - 1, this.rubberBand.height - 1);
            g2.setComposite(backupComp);
            g2.drawRect(this.rubberBand.x, this.rubberBand.y, this.rubberBand.width - 1, this.rubberBand.height - 1);
        }
        g2.setTransform(backup);
        logger.debug((Object)("end of paintComponent, width=" + this.getWidth() + ",height=" + this.getHeight()));
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Point zp = this.unzoomPoint(e.getPoint());
        MouseEvent zoomedEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), zp.x, zp.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
        return this.contentPane.getToolTipText(zoomedEvent);
    }

    public PlayPen(ArchitectSwingSession session) {
        this(session, (SPObject)session.getTargetDatabase());
    }

    public PlayPen(ArchitectSwingSession session, SPObject modelContainer) {
        this(session, new PlayPenContentPane(modelContainer));
    }

    public PlayPen(ArchitectSwingSession session, PlayPenContentPane ppcp) {
        if (session == null) {
            throw new NullPointerException("A null session is not allowed here.");
        }
        this.session = session;
        this.setDatabase(session.getTargetDatabase());
        if (session.isEnterpriseSession()) {
            this.zoom = session.getEnterpriseSession().getPrefDouble("zoom", 1.0);
        } else {
            Preferences p = Preferences.userNodeForPackage(ArchitectSessionImpl.class);
            Preferences prefs = p.node(session.getWorkspace().getName());
            this.zoom = prefs.getDouble("zoom", 1.0);
        }
        this.viewportPosition = new Point(0, 0);
        this.setBackground(Color.white);
        this.contentPane = ppcp;
        this.contentPane.setPlayPen(this);
        this.setName("Play Pen");
        this.setMinimumSize(new Dimension(1, 1));
        if (!GraphicsEnvironment.isHeadless()) {
            new DropTarget(this, new PlayPenDropListener());
            new DragSource().createDefaultDragGestureRecognizer(this, 2, new TablePaneDragGestureListener());
            logger.debug((Object)("DragGestureRecognizer motion threshold: " + this.getToolkit().getDesktopProperty("DnD.gestureMotionThreshold")));
        }
        this.bringToFrontAction = new BringToFrontAction(this);
        this.sendToBackAction = new SendToBackAction(this);
        this.ppMouseListener = new PPMouseListener();
        this.addMouseListener(this.ppMouseListener);
        this.addMouseMotionListener(this.ppMouseListener);
        this.cursorManager = new CursorManager((JComponent)this);
        this.fontRenderContext = null;
    }

    public PlayPen(ArchitectSwingSession session, PlayPen pp) {
        this(session);
        logger.debug((Object)("Copying PlayPen@" + System.identityHashCode(pp) + " into " + System.identityHashCode(this)));
        this.antialiasSetting = pp.antialiasSetting;
        this.setFont(pp.getFont());
        this.setForeground(pp.getForeground());
        this.setBackground(pp.getBackground());
        logger.debug((Object)("Copying " + pp.getContentPane().getChildren().size() + " components..."));
        for (int i = 0; i < pp.getContentPane().getChildren().size(); ++i) {
            PlayPenComponent ppc = pp.getContentPane().getChildren().get(i);
            PlayPenContentPane contentPane = this.contentPane;
            if (ppc instanceof TablePane) {
                TablePane tp = (TablePane)ppc;
                this.addImpl(new TablePane(tp, contentPane), ppc.getPreferredLocation());
                continue;
            }
            if (ppc instanceof Relationship) {
                Relationship rel = (Relationship)ppc;
                this.addImpl(new Relationship(rel, contentPane), ppc.getPreferredLocation());
                continue;
            }
            if (ppc instanceof CubePane) {
                CubePane cp = (CubePane)ppc;
                this.addImpl(new CubePane(cp, contentPane), ppc.getPreferredLocation());
                continue;
            }
            if (ppc instanceof DimensionPane) {
                DimensionPane dp = (DimensionPane)ppc;
                this.addImpl(new DimensionPane(dp, contentPane), ppc.getPreferredLocation());
                continue;
            }
            if (ppc instanceof VirtualCubePane) {
                VirtualCubePane vcp = (VirtualCubePane)ppc;
                this.addImpl(new VirtualCubePane(vcp, contentPane), ppc.getPreferredLocation());
                continue;
            }
            if (ppc instanceof UsageComponent) {
                UsageComponent uc = (UsageComponent)ppc;
                contentPane.addChild((SPObject)new UsageComponent(uc, contentPane), i);
                continue;
            }
            throw new UnsupportedOperationException("I don't know how to copy PlayPenComponent type " + ppc.getClass().getName());
        }
        this.setSize(this.getPreferredSize());
    }

    protected void addImpl(PlayPenComponent c, Object constraints) {
        if (c instanceof Relationship || c instanceof UsageComponent || c instanceof PlayPenLabel) {
            this.contentPane.addChild((SPObject)c, this.contentPane.getFirstDependentComponentIndex());
        } else if (c instanceof ContainerPane) {
            if (!(constraints instanceof Point)) {
                throw new IllegalArgumentException("Constraints must be a Point");
            }
            c.setLocation((Point)constraints);
            this.contentPane.addChild((SPObject)c, 0);
            if (c instanceof TablePane) {
                ((TablePane)c).updateHiddenColumns();
                ((TablePane)c).updateNameDisplay();
            }
        } else {
            throw new IllegalArgumentException("PlayPen can't contain components of type " + c.getClass().getName());
        }
        Dimension size = c.getPreferredSize();
        c.setSize(size);
        logger.debug((Object)("Set size to " + size));
        logger.debug((Object)("Final state looks like " + c));
    }

    public void destroy() {
        logger.debug((Object)("Destroying playpen " + System.identityHashCode(this)));
        this.firePlayPenLifecycleEvent();
        this.removeHierarchyListeners((SPObject)this.session.getTargetDatabase());
    }

    public List<SQLTable> getTables() throws SQLObjectException {
        ArrayList<SQLTable> tables = new ArrayList<SQLTable>();
        SQLObjectUtils.findDescendentsByClass((SQLObject)this.session.getTargetDatabase(), SQLTable.class, tables);
        return tables;
    }

    private final void setDatabase(SQLDatabase newdb) {
        if (newdb == null) {
            throw new NullPointerException("db must be non-null");
        }
        newdb.setPlayPenDatabase(true);
        JDBCDataSource dbcs = new JDBCDataSource(this.session.getDataSources());
        newdb.setDataSource(dbcs);
        SQLPowerUtils.listenToHierarchy((SPObject)newdb, (SPListener)this);
        this.tableNames = new HashSet<String>();
    }

    public void setDatabaseConnection(JDBCDataSource dbcs) {
        JDBCDataSource tSpec = this.session.getTargetDatabase().getDataSource();
        tSpec.setDisplayName(dbcs.getDisplayName());
        tSpec.getParentType().setJdbcDriver(dbcs.getDriverClass());
        tSpec.setUrl(dbcs.getUrl());
        tSpec.setUser(dbcs.getUser());
        tSpec.setPass(dbcs.getPass());
        tSpec.setPlSchema(dbcs.getPlSchema());
        tSpec.setPlDbType(dbcs.getPlDbType());
        tSpec.setOdbcDsn(dbcs.getOdbcDsn());
    }

    public void setupKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CANCEL");
        this.getActionMap().put("CANCEL", new CancelAction(this));
        String KEY_SELECT_UPWARD = "ca.sqlpower.architect.PlayPen.KEY_SELECT_UPWARD";
        String KEY_SELECT_DOWNWARD = "ca.sqlpower.architect.PlayPen.KEY_SELECT_DOWNWARD";
        inputMap.put(KeyStroke.getKeyStroke(38, 0), KEY_SELECT_UPWARD);
        this.getActionMap().put(KEY_SELECT_UPWARD, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayPenComponent item;
                List<PlayPenComponent> items = PlayPen.this.getSelectedItems();
                if (items.size() == 1 && (item = items.get(0)) instanceof TablePane) {
                    TablePane tp = (TablePane)item;
                    int oldIndex = tp.getSelectedItemIndex();
                    try {
                        if (oldIndex < 0) {
                            oldIndex = ((SQLTable)tp.getModel()).getColumns().size();
                        }
                        int newIndex = oldIndex;
                        while (newIndex - 1 >= 0 && tp.getHiddenColumns().contains(((SQLTable)tp.getModel()).getColumn(--newIndex))) {
                        }
                        if (!tp.getHiddenColumns().contains(((SQLTable)tp.getModel()).getColumn(newIndex))) {
                            tp.selectNone();
                            tp.selectItem(newIndex);
                        }
                    }
                    catch (SQLObjectException ex) {
                        throw new SQLObjectRuntimeException(ex);
                    }
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(40, 0), KEY_SELECT_DOWNWARD);
        this.getActionMap().put(KEY_SELECT_DOWNWARD, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block8: {
                    PlayPenComponent item;
                    List<PlayPenComponent> items = PlayPen.this.getSelectedItems();
                    if (items.size() == 1 && (item = items.get(0)) instanceof TablePane) {
                        TablePane tp = (TablePane)item;
                        int oldIndex = tp.getSelectedItemIndex();
                        if (oldIndex < 0) {
                            oldIndex = -1;
                        }
                        try {
                            if (oldIndex >= ((SQLTable)tp.getModel()).getColumns().size() - 1) break block8;
                            try {
                                int newIndex = oldIndex;
                                while (newIndex + 1 < ((SQLTable)tp.getModel()).getColumns().size() && tp.getHiddenColumns().contains(((SQLTable)tp.getModel()).getColumn(++newIndex))) {
                                }
                                if (!tp.getHiddenColumns().contains(((SQLTable)tp.getModel()).getColumn(newIndex))) {
                                    tp.selectNone();
                                    tp.selectItem(newIndex);
                                }
                            }
                            catch (SQLObjectException ex) {
                                throw new SQLObjectRuntimeException(ex);
                            }
                        }
                        catch (SQLObjectException e1) {
                            logger.error((Object)("Could not get columns of " + tp.getName()), (Throwable)e1);
                        }
                    }
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            private void changeCursor(KeyEvent e) {
                if ((e.getModifiersEx() & 0x200) != 0) {
                    PlayPen.this.cursorManager.dragAllModeStarted();
                } else {
                    PlayPen.this.cursorManager.dragAllModeFinished();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                this.changeCursor(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.changeCursor(e);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                this.changeCursor(e);
            }
        });
    }

    public boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    public void setChildPosition(PlayPenComponent child, Point p) {
        this.setChildPositionImpl(child, p.x, p.y);
    }

    public void setChildPosition(PlayPenComponent child, int x, int y) {
        this.setChildPositionImpl(child, x, y);
    }

    protected void setChildPositionImpl(PlayPenComponent child, int x, int y) {
        child.setLocation((int)((double)x / this.zoom), (int)((double)y / this.zoom));
    }

    public Action getMouseZoomInAction() {
        if (this.zoomInAction == null) {
            return this.session.getArchitectFrame().getZoomInAction();
        }
        return this.zoomInAction;
    }

    public void setMouseZoomInAction(Action zoomInAction) {
        this.zoomInAction = zoomInAction;
    }

    public Action getMouseZoomOutAction() {
        if (this.zoomOutAction == null) {
            return this.session.getArchitectFrame().getZoomOutAction();
        }
        return this.zoomOutAction;
    }

    public void setMouseZoomOutAction(Action zoomOutAction) {
        this.zoomOutAction = zoomOutAction;
    }

    public Point zoomPoint(Point p) {
        if (p == null) {
            return null;
        }
        p.x = (int)((double)p.x * this.zoom);
        p.y = (int)((double)p.y * this.zoom);
        return p;
    }

    public Point unzoomPoint(Point p) {
        if (p == null) {
            return null;
        }
        p.x = (int)((double)p.x / this.zoom);
        p.y = (int)((double)p.y / this.zoom);
        return p;
    }

    public Rectangle zoomRect(Rectangle r) {
        r.x = (int)((double)r.x * this.zoom);
        r.y = (int)((double)r.y * this.zoom);
        r.width = (int)((double)r.width * this.zoom);
        r.height = (int)((double)r.height * this.zoom);
        return r;
    }

    public Rectangle unzoomRect(Rectangle r) {
        r.x = (int)((double)r.x / this.zoom);
        r.y = (int)((double)r.y / this.zoom);
        r.width = (int)((double)r.width / this.zoom);
        r.height = (int)((double)r.height / this.zoom);
        return r;
    }

    public void setZoom(double newZoom) {
        if (newZoom != this.zoom) {
            double oldZoom = this.zoom;
            this.zoom = newZoom;
            if (this.session.isEnterpriseSession()) {
                this.session.getEnterpriseSession().putPref("zoom", this.zoom);
            } else {
                UserSettings sprefs = this.session.getUserSettings().getSwingSettings();
                if (sprefs != null) {
                    sprefs.setObject("zoom", new Double(this.zoom));
                }
            }
            this.firePropertyChange("zoom", oldZoom, newZoom);
            this.revalidate();
            this.repaint();
        }
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setRenderingAntialiased(boolean v) {
        this.antialiasSetting = v ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
        this.repaint();
    }

    public boolean isRenderingAntialiased() {
        return this.antialiasSetting == RenderingHints.VALUE_ANTIALIAS_ON;
    }

    public PlayPenContentPane getContentPane() {
        return this.contentPane;
    }

    public void setContentPane(PlayPenContentPane pane) {
        this.contentPane = pane;
        pane.setPlayPen(this);
    }

    public void addRelationship(Relationship r) {
        this.addImpl(r, null);
    }

    public void addTablePane(TablePane tp, Point point) {
        this.addImpl(tp, point);
    }

    public void addLabel(PlayPenLabel label, Point point) {
        this.addImpl(label, point);
    }

    public void addPlayPenComponent(PlayPenComponent ppc, Point point) {
        this.addImpl(ppc, point);
    }

    public TablePane findTablePane(SQLTable t) {
        return (TablePane)this.findPPComponent(t);
    }

    public PlayPenComponent findPPComponent(Object model) {
        for (PlayPenComponent playPenComponent : this.contentPane.getChildren()) {
            if (playPenComponent.getModel() != model) continue;
            return playPenComponent;
        }
        return null;
    }

    public TablePane findTablePaneByName(String name) {
        name = name.toLowerCase();
        for (PlayPenComponent playPenComponent : this.contentPane.getChildren()) {
            if (!(playPenComponent instanceof TablePane) || !((SQLTable)((TablePane)playPenComponent).getModel()).getName().toLowerCase().equals(name)) continue;
            return (TablePane)playPenComponent;
        }
        return null;
    }

    public Relationship findRelationship(SQLRelationship r) {
        return (Relationship)this.findPPComponent(r);
    }

    public Set<String> getTableNames() {
        return this.tableNames;
    }

    public void resetTableNames() {
        this.tableNames.clear();
        for (TablePane tp : this.contentPane.getChildren(TablePane.class)) {
            this.tableNames.add(((SQLTable)tp.getModel()).getName().toLowerCase());
        }
    }

    public int getPPComponentCount() {
        return this.contentPane.getChildren().size();
    }

    public synchronized TablePane importTableCopy(SQLTable source, Point preferredLocation, DuplicateProperties duplicateProperties) throws SQLObjectException {
        return this.importTableCopy(source, preferredLocation, duplicateProperties, true);
    }

    public synchronized TablePane importTableCopy(SQLTable source, Point preferredLocation, DuplicateProperties duplicateProperties, boolean assignTypes) throws SQLObjectException {
        int suffix;
        SQLTable newTable;
        switch (duplicateProperties.getDefaultTransferStyle()) {
            case REVERSE_ENGINEER: {
                newTable = source.createInheritingInstance(this.session.getTargetDatabase());
                break;
            }
            case COPY: {
                newTable = source.createCopy(this.session.getTargetDatabase(), duplicateProperties.isPreserveColumnSource());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown transfer style " + duplicateProperties.getDefaultTransferStyle());
            }
        }
        for (SQLColumn column : newTable.getColumns()) {
            SQLColumn sourceColumn = newTable.getColumnByName(column.getName());
            ASUtils.correctSourceColumn(sourceColumn, duplicateProperties, column, this.getSession().getDBTree());
        }
        if (assignTypes) {
            String platform = source.getParentDatabase() != null && source.getParentDatabase().getDataSource() != null ? source.getParentDatabase().getDataSource().getParentType().getName() : "GENERIC";
            SQLColumn.assignTypes((List)newTable.getColumns(), (DataSourceCollection)newTable.getParentDatabase().getDataSource().getParentCollection(), (String)platform, (UserPrompterFactory)this.getSession());
        }
        boolean isAlreadyOnPlaypen = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("before add: " + this.tableNames));
        }
        if ((suffix = this.uniqueTableSuffix(source.getName())) != 0) {
            String newName = source.getName() + "_" + suffix;
            newTable.setName(newName);
            isAlreadyOnPlaypen = true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("after add: " + this.tableNames));
        }
        TablePane tp = new TablePane(newTable, this.getContentPane());
        logger.info((Object)("adding table " + newTable));
        this.addImpl(tp, preferredLocation);
        tp.revalidate();
        if (duplicateProperties.getDefaultTransferStyle() == SQLTable.TransferStyles.REVERSE_ENGINEER) {
            this.createRelationshipsFromPP(source, newTable, true, isAlreadyOnPlaypen, suffix);
            this.createRelationshipsFromPP(source, newTable, false, isAlreadyOnPlaypen, suffix);
        }
        return tp;
    }

    public int uniqueTableSuffix(String base) {
        int suffix = 0;
        if (!this.tableNames.add(base.toLowerCase())) {
            boolean done = false;
            while (!done) {
                done = this.tableNames.add(base.toLowerCase() + "_" + ++suffix);
            }
        }
        return suffix;
    }

    private void createRelationshipsFromPP(SQLTable source, SQLTable newTable, boolean isPrimaryKeyTableNew, boolean isAlreadyOnPlaypen, int suffix) throws SQLObjectException {
        if (!(this.contentPane instanceof PlayPenContentPane)) {
            throw new IllegalStateException("Must have a PlayPenContent to make releationships: this PlayPen has " + ((Object)((Object)this.contentPane)).getClass().getName());
        }
        PlayPenContentPane contentPane = this.contentPane;
        Iterator sourceKeys = null;
        sourceKeys = isPrimaryKeyTableNew ? source.getExportedKeys().iterator() : SQLRelationship.getExportedKeys((List)source.getImportedKeys()).iterator();
        while (sourceKeys.hasNext()) {
            SQLRelationship r = (SQLRelationship)sourceKeys.next();
            if (r.getFkTable().equals((Object)r.getPkTable()) && !isPrimaryKeyTableNew) continue;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Looking for fk table " + r.getFkTable().getName() + " in playpen"));
            }
            TablePane tablePane = null;
            tablePane = !isAlreadyOnPlaypen ? (isPrimaryKeyTableNew ? this.findTablePaneByName(r.getFkTable().getName()) : this.findTablePaneByName(r.getPkTable().getName())) : (isPrimaryKeyTableNew ? this.findTablePaneByName(r.getFkTable().getName() + "_" + suffix) : this.findTablePaneByName(r.getPkTable().getName() + "_" + suffix));
            if (tablePane != null) {
                logger.info((Object)"FOUND IT!");
                SQLRelationship newRel = new SQLRelationship();
                newRel.updateToMatch((SQLObject)r, true);
                SQLTable oldTable = r.getFkTable().equals((Object)r.getPkTable()) ? newTable : (SQLTable)tablePane.getModel();
                if (isPrimaryKeyTableNew) {
                    newRel.attachRelationship(newTable, oldTable, false);
                } else {
                    newRel.attachRelationship(oldTable, newTable, false);
                }
                this.addImpl(new Relationship(newRel, contentPane), null);
                for (SQLRelationship.ColumnMapping m : r.getChildren()) {
                    this.setupMapping(newTable, oldTable, newRel, m, isPrimaryKeyTableNew);
                }
                continue;
            }
            logger.info((Object)"NOT FOUND");
        }
    }

    private void setupMapping(SQLTable newTable, SQLTable otherTable, SQLRelationship newRel, SQLRelationship.ColumnMapping m, boolean newTableIsPk) throws SQLObjectException {
        SQLColumn pkCol = null;
        SQLColumn fkCol = null;
        if (newTableIsPk) {
            pkCol = newTable.getColumnByName(m.getPkColumn().getName());
            fkCol = otherTable.getColumnByName(m.getFkColumn().getName());
            if (pkCol == null) {
                throw new IllegalStateException("Couldn't find pkCol " + m.getPkColumn().getName() + " in new table");
            }
            if (fkCol == null) {
                return;
            }
        } else {
            pkCol = otherTable.getColumnByName(m.getPkColumn().getName());
            fkCol = newTable.getColumnByName(m.getFkColumn().getName());
            if (fkCol == null) {
                throw new IllegalStateException("Couldn't find fkCol " + m.getFkColumn().getName() + " in new table");
            }
            if (pkCol == null) {
                return;
            }
        }
        fkCol.addReference();
        SQLRelationship.ColumnMapping newMapping = new SQLRelationship.ColumnMapping();
        newMapping.setPkColumn(pkCol);
        newMapping.setFkColumn(fkCol);
        newRel.addChild((SQLObject)newMapping);
    }

    public synchronized void addObjects(List<SQLObject> list, Point preferredLocation, SPSwingWorker nextProcess, SQLTable.TransferStyles transferStyle) throws SQLObjectException {
        ProgressMonitor pm = new ProgressMonitor(this, Messages.getString("PlayPen.copyingObjectsToThePlaypen"), "...", 0, 100);
        AddObjectsTask t = new AddObjectsTask(list, preferredLocation, pm, this.session, transferStyle);
        t.setNextProcess(nextProcess);
        new Thread((Runnable)((Object)t), "Objects-Adder").start();
    }

    private void addHierarchyListeners(SPObject sqlObject) {
        SQLPowerUtils.listenToHierarchy((SPObject)sqlObject, (SPListener)this);
    }

    private void removeHierarchyListeners(SPObject sqlObject) {
        SQLPowerUtils.unlistenToHierarchy((SPObject)sqlObject, (SPListener)this);
    }

    public void childAdded(SPChildEvent e) {
        logger.debug((Object)("SQLObject children got inserted: " + e));
        SPObject child = e.getChild();
        this.addHierarchyListeners(child);
        if (!this.contentPane.isMagicEnabled() || !e.getSource().isMagicEnabled()) {
            return;
        }
        this.childAdded = true;
        boolean fireEvent = false;
        try {
            if (child instanceof SQLTable || child instanceof SQLRelationship && ((SQLTable)e.getSource()).getExportedKeys().contains(child)) {
                fireEvent = true;
                PlayPenComponent ppc = this.removedComponents.get(child.getUUID());
                if (ppc != null) {
                    if (PlayPenContentPane.isDependentComponentType(ppc.getClass())) {
                        this.contentPane.addChild((SPObject)ppc, this.contentPane.getFirstDependentComponentIndex());
                    } else {
                        this.contentPane.addChild((SPObject)ppc, 0);
                    }
                }
            }
        }
        catch (SQLObjectException ex) {
            throw new RuntimeException(ex);
        }
        if (fireEvent) {
            this.firePropertyChange("model.children", null, child);
        }
    }

    public void childRemoved(SPChildEvent e) {
        logger.debug((Object)("SQLObject children got removed: " + e));
        SPObject child = e.getChild();
        this.removeHierarchyListeners(child);
        if (!this.contentPane.isMagicEnabled() || !e.getSource().isMagicEnabled()) {
            return;
        }
        boolean foundRemovedComponent = false;
        try {
            if (child instanceof SQLTable) {
                for (int i = 0; i < this.contentPane.getChildren().size(); ++i) {
                    TablePane tp;
                    PlayPenComponent c = this.contentPane.getChildren().get(i);
                    if (!(c instanceof TablePane) || (tp = (TablePane)c).getModel() != child) continue;
                    this.removedComponents.put(((SQLTable)tp.getModel()).getUUID(), c);
                    this.contentPane.removeChild((SPObject)c);
                    foundRemovedComponent = true;
                }
            } else if (child instanceof SQLRelationship || child instanceof SQLRelationship.SQLImportedKey) {
                for (int i = 0; i < this.contentPane.getChildren().size(); ++i) {
                    Relationship r;
                    PlayPenComponent c = this.contentPane.getChildren().get(i);
                    if (!(c instanceof Relationship) || (r = (Relationship)c).getModel() != child && (!(child instanceof SQLRelationship.SQLImportedKey) || r.getModel() != ((SQLRelationship.SQLImportedKey)child).getRelationship())) continue;
                    r.setSelected(false, 4);
                    this.removedComponents.put(r.getModel().getUUID(), c);
                    this.contentPane.removeChild((SPObject)c);
                    foundRemovedComponent = true;
                }
            }
        }
        catch (ObjectDependentException ex) {
            throw new RuntimeException(ex);
        }
        if (foundRemovedComponent) {
            this.childRemoved = true;
            this.firePropertyChange("model.children", child, null);
        }
    }

    public void propertyChanged(PropertyChangeEvent e) {
        this.revalidate();
        this.firePropertyChange("model." + e.getPropertyName(), e.getOldValue(), e.getNewValue());
    }

    public void transactionStarted(TransactionEvent e) {
        ++this.transactionCount;
    }

    public void transactionEnded(TransactionEvent e) {
        --this.transactionCount;
        if (this.transactionCount == 0) {
            if (this.childAdded || this.propertyChanged) {
                this.revalidate();
            }
            if (this.childRemoved) {
                this.repaint();
            }
            this.childAdded = false;
            this.childRemoved = false;
            this.propertyChanged = false;
        } else if (this.transactionCount < 0) {
            throw new IllegalStateException("Commit attempted while not in a transaction");
        }
    }

    public void transactionRollback(TransactionEvent e) {
        logger.error((Object)"Unable to rollback changes to the playpen");
        this.transactionCount = 0;
        this.childAdded = false;
        this.childRemoved = false;
        this.propertyChanged = false;
    }

    @Override
    public void itemSelected(SelectionEvent e) {
        this.fireSelectionEvent(e);
    }

    @Override
    public void itemDeselected(SelectionEvent e) {
        this.fireSelectionEvent(e);
    }

    public void selectNone() {
        this.session.getDBTree().clearSelection();
        for (PlayPenComponent playPenComponent : this.contentPane.getChildren()) {
            if (!(playPenComponent instanceof Selectable)) continue;
            PlayPenComponent s = playPenComponent;
            s.setSelected(false, 4);
        }
    }

    public void selectAll() {
        for (PlayPenComponent playPenComponent : this.contentPane.getChildren()) {
            if (!(playPenComponent instanceof Selectable)) continue;
            PlayPenComponent s = playPenComponent;
            s.setSelected(true, 4);
        }
        this.mouseMode = MouseModeType.MULTI_SELECT;
    }

    public List<PlayPenComponent> getSelectedItems() {
        ArrayList<PlayPenComponent> selected = new ArrayList<PlayPenComponent>();
        for (PlayPenComponent playPenComponent : this.contentPane.getChildren()) {
            if (!playPenComponent.isSelected()) continue;
            selected.add(playPenComponent);
        }
        return Collections.unmodifiableList(selected);
    }

    public List<ContainerPane<?, ?>> getSelectedContainers() {
        ArrayList<ContainerPane> selected = new ArrayList<ContainerPane>();
        for (ContainerPane tp : this.contentPane.getChildren(ContainerPane.class)) {
            if (!tp.isSelected()) continue;
            selected.add(tp);
        }
        return Collections.unmodifiableList(selected);
    }

    public List<DraggablePlayPenComponent> getSelectedDraggableComponents() {
        ArrayList<DraggablePlayPenComponent> selected = new ArrayList<DraggablePlayPenComponent>();
        for (DraggablePlayPenComponent tp : this.contentPane.getChildren(DraggablePlayPenComponent.class)) {
            if (!tp.isSelected()) continue;
            selected.add(tp);
        }
        return Collections.unmodifiableList(selected);
    }

    public List<Relationship> getSelectedRelationShips() {
        ArrayList<Relationship> selected = new ArrayList<Relationship>();
        for (Relationship r : this.contentPane.getChildren(Relationship.class)) {
            if (!r.isSelected()) continue;
            selected.add(r);
        }
        return Collections.unmodifiableList(selected);
    }

    public void addSelectionListener(SelectionListener l) {
        this.selectionListeners.add(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.selectionListeners.remove(l);
    }

    protected void fireSelectionEvent(SelectionEvent e) {
        if (e.getType() == 1) {
            for (int i = this.selectionListeners.size() - 1; i >= 0; --i) {
                this.selectionListeners.get(i).itemSelected(e);
            }
        } else if (e.getType() == 2) {
            for (int i = this.selectionListeners.size() - 1; i >= 0; --i) {
                this.selectionListeners.get(i).itemDeselected(e);
            }
        } else {
            throw new IllegalStateException("Unknown selection event type " + e.getType());
        }
    }

    public void addCancelableListener(CancelableListener l) {
        this.cancelableListeners.add(l);
    }

    public void removeCancelableListener(CancelableListener l) {
        this.cancelableListeners.remove(l);
    }

    public void fireCancel() {
        for (int i = this.cancelableListeners.size() - 1; i >= 0; --i) {
            this.cancelableListeners.get(i).cancel();
        }
    }

    public void addUndoEventListener(CompoundEventListener l) {
        this.undoEventListeners.add(l);
    }

    public void removeSelectionListener(CompoundEventListener l) {
        this.undoEventListeners.remove(l);
    }

    private void fireUndoCompoundEvent(TransactionEvent e) {
        Iterator it = this.undoEventListeners.iterator();
        if (e.getState().equals((Object)TransactionEvent.TransactionState.START)) {
            while (it.hasNext()) {
                ((CompoundEventListener)it.next()).transactionStarted(e);
            }
        } else {
            while (it.hasNext()) {
                ((CompoundEventListener)it.next()).transactionEnded(e);
            }
        }
    }

    public void startCompoundEdit(String message) {
        this.fireUndoCompoundEvent(TransactionEvent.createStartTransactionEvent((Object)this, (String)message));
    }

    public void endCompoundEdit(String message) {
        this.fireUndoCompoundEvent(TransactionEvent.createEndTransactionEvent((Object)this));
    }

    boolean addTransferable(Transferable t, Point dropPoint, SQLTable.TransferStyles transferStyle) throws UnsupportedFlavorException, IOException, SQLObjectException {
        if (t.isDataFlavorSupported(SQLObjectSelection.LOCAL_SQLOBJECT_ARRAY_FLAVOUR) || t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            this.contentPane.begin("Adding transferrable to play pen");
            try {
                if (t.isDataFlavorSupported(SQLObjectSelection.LOCAL_SQLOBJECT_ARRAY_FLAVOUR)) {
                    SQLObject[] paths = (SQLObject[])t.getTransferData(SQLObjectSelection.LOCAL_SQLOBJECT_ARRAY_FLAVOUR);
                    ArrayList<SQLObject> sqlObjects = new ArrayList<SQLObject>();
                    for (SQLObject oo : paths) {
                        if (oo instanceof SQLObject) {
                            sqlObjects.add(oo);
                            continue;
                        }
                        logger.error((Object)("Unknown object dropped in PlayPen: " + oo));
                    }
                    this.addObjects(sqlObjects, dropPoint, null, transferStyle);
                    this.contentPane.commit();
                    return true;
                }
                String[] stringPieces = ((String)t.getTransferData(DataFlavor.stringFlavor)).split("[\n\r\t]+");
                ArrayList<SQLObject> sqlObjects = new ArrayList<SQLObject>();
                for (String s : stringPieces) {
                    if (s.length() <= 0) continue;
                    SQLTable newTable = new SQLTable();
                    newTable.setName(s);
                    newTable.initFolders(true);
                    sqlObjects.add((SQLObject)newTable);
                }
                this.addObjects(sqlObjects, dropPoint, null, transferStyle);
                this.contentPane.commit();
                return true;
            }
            catch (Throwable e) {
                this.contentPane.rollback("Error occurred: " + e.toString());
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public void pasteData(Transferable t) {
        if (!this.getSelectedContainers().isEmpty()) {
            for (ContainerPane<?, ?> cp : this.getSelectedContainers()) {
                cp.pasteData(t);
            }
            return;
        }
        Point p = this.getMousePosition();
        if (p == null) {
            p = new Point(0, 0);
        }
        this.unzoomPoint(p);
        try {
            if (!this.addTransferable(t, p, SQLTable.TransferStyles.COPY)) {
                JOptionPane.showMessageDialog(this, "Cannot paste the copied objects. Unknown object type.", "Cannot Paste Objects", 2);
            }
        }
        catch (UnsupportedFlavorException e) {
            throw new RuntimeException("Could not paste copied object type.", e);
        }
        catch (IOException e) {
            logger.error((Object)"The real IOException", (Throwable)e);
            throw new RuntimeException("Data copied changed while pasting.", e);
        }
        catch (SQLObjectException e) {
            throw new RuntimeException("Exception while pasting a SQLObject.", e);
        }
    }

    public Rectangle getRubberBand() {
        return this.rubberBand;
    }

    public boolean isSelectionInProgress() {
        return this.selectionInProgress;
    }

    public boolean isDraggingTablePanes() {
        return this.draggingContainerPanes;
    }

    public void setDraggingContainerPanes(boolean draggingContainerPanes) {
        this.draggingContainerPanes = draggingContainerPanes;
    }

    public FontRenderContext getFontRenderContext() {
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        FontRenderContext frc = null;
        if (g2 != null) {
            g2.scale(this.zoom, this.zoom);
            frc = g2.getFontRenderContext();
            g2.dispose();
        } else {
            frc = this.fontRenderContext;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning frc=" + frc));
        }
        return frc;
    }

    public void setFontRenderContext(FontRenderContext frc) {
        this.fontRenderContext = frc;
    }

    public void selectObjects(List<? extends SPObject> selections) throws SQLObjectException {
        if (this.ignoreTreeSelection) {
            return;
        }
        this.ignoreTreeSelection = true;
        logger.debug((Object)("selecting: " + selections));
        DBTree tree = this.session.getDBTree();
        ArrayList<SQLTable> colTables = new ArrayList<SQLTable>();
        ArrayList<Object> ignoredObjs = new ArrayList<Object>();
        for (SPObject sPObject : selections) {
            if (sPObject instanceof SQLColumn) {
                SQLColumn col = (SQLColumn)sPObject;
                SQLTable table = col.getParent();
                TablePane tablePane = this.findTablePane(table);
                if (tablePane != null) {
                    int index;
                    TreePath tp;
                    colTables.add(table);
                    if (!tablePane.isSelected()) {
                        tablePane.setSelected(true, 4);
                    }
                    if (!tree.isPathSelected(tp = tree.getTreePathForNode((SQLObject)table))) {
                        tree.addSelectionPath(tp);
                        tree.clearNonPlayPenSelections();
                        TreePath colPath = tree.getTreePathForNode((SQLObject)col);
                        tree.removeSelectionPath(colPath);
                        tree.addSelectionPath(colPath);
                    }
                    if (!tablePane.isItemSelected(index = table.getColumnIndex(col))) {
                        tablePane.selectItem(index);
                        continue;
                    }
                    ignoredObjs.add(col);
                    continue;
                }
                ignoredObjs.add(col);
                ignoredObjs.add(table);
                continue;
            }
            if (sPObject instanceof SQLTable) {
                TablePane tp = this.findTablePane((SQLTable)sPObject);
                if (tp != null && !tp.isSelected()) {
                    tp.setSelected(true, 4);
                    continue;
                }
                ignoredObjs.add(sPObject);
                continue;
            }
            if (!(sPObject instanceof SQLRelationship)) continue;
            Relationship r = this.findRelationship((SQLRelationship)sPObject);
            if (r != null && !r.isSelected()) {
                r.setSelected(true, 4);
            } else {
                ignoredObjs.add(sPObject);
            }
            tree.clearNonPlayPenSelections();
        }
        logger.debug((Object)("selectObjects ignoring: " + ignoredObjs));
        logger.debug((Object)("selectObjects adding tables selections: " + colTables));
        for (PlayPenComponent playPenComponent : this.getSelectedItems()) {
            Relationship relationship;
            if (playPenComponent instanceof TablePane) {
                TablePane tablePane = (TablePane)playPenComponent;
                if (!selections.contains(tablePane.getModel()) && !colTables.contains(tablePane.getModel())) {
                    tablePane.setSelected(false, 4);
                }
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (SQLColumn col : tablePane.getSelectedItems()) {
                    if (selections.contains(col) || col.getParent() == null) continue;
                    indices.add(col.getParent().getColumnIndex(col));
                }
                Iterator<Object> i$ = indices.iterator();
                while (i$.hasNext()) {
                    int index = (Integer)i$.next();
                    tablePane.deselectItem(index);
                }
                continue;
            }
            if (!(playPenComponent instanceof Relationship) || selections.contains((relationship = (Relationship)playPenComponent).getModel())) continue;
            relationship.setSelected(false, 4);
        }
        this.ignoreTreeSelection = false;
    }

    public void selectObjects(List<OLAPObject> selections, OLAPTree tree) throws SQLObjectException {
        if (this.ignoreTreeSelection) {
            return;
        }
        this.ignoreTreeSelection = true;
        logger.debug((Object)("selecting: " + selections));
        ArrayList<OLAPObject> extraSelections = new ArrayList<OLAPObject>();
        ArrayList<OLAPObject> ignoredObjs = new ArrayList<OLAPObject>();
        for (OLAPObject obj : selections) {
            if (obj instanceof MondrianModel.Cube) {
                this.selectCube((MondrianModel.Cube)obj, ignoredObjs);
            } else if (obj instanceof MondrianModel.VirtualCube) {
                this.selectVirtualCube((MondrianModel.VirtualCube)obj, ignoredObjs);
            } else if (obj instanceof MondrianModel.Dimension || obj instanceof MondrianModel.DimensionUsage) {
                this.selectDimension(obj, ignoredObjs, extraSelections, tree);
            } else if (obj instanceof MondrianModel.Measure) {
                this.selectMeasure((MondrianModel.Measure)obj, ignoredObjs, extraSelections, tree);
            } else if (obj instanceof MondrianModel.VirtualCubeDimension || obj instanceof MondrianModel.VirtualCubeMeasure) {
                this.selectItemFromVirtualCube(obj, ignoredObjs, extraSelections, tree);
            } else if (obj instanceof MondrianModel.CubeUsage) {
                this.selectCubeUsage((MondrianModel.CubeUsage)obj, ignoredObjs, extraSelections, tree);
            } else if (obj instanceof MondrianModel.Hierarchy && obj.getParent() instanceof MondrianModel.Dimension && obj.getParent().getParent() instanceof MondrianModel.Schema) {
                this.selectHierarchy((MondrianModel.Hierarchy)obj, ignoredObjs, extraSelections, tree);
            } else if (obj instanceof MondrianModel.Level && obj.getParent() instanceof MondrianModel.Hierarchy && obj.getParent().getParent() instanceof MondrianModel.Dimension && obj.getParent().getParent().getParent() instanceof MondrianModel.Schema) {
                this.selectLevel((MondrianModel.Level)obj, ignoredObjs, extraSelections, tree);
            }
            logger.debug((Object)("selectObjects ignoring: " + ignoredObjs));
            logger.debug((Object)("selectObjects adding tables selections: " + extraSelections));
            for (PlayPenComponent comp : this.getSelectedItems()) {
                ArrayList<OLAPObject> oos;
                if (comp instanceof CubePane) {
                    CubePane cp = (CubePane)comp;
                    if (!selections.contains(cp.getModel()) && !extraSelections.contains(cp.getModel())) {
                        cp.setSelected(false, 4);
                    }
                    oos = new ArrayList<OLAPObject>();
                    for (OLAPObject oLAPObject : cp.getSelectedItems()) {
                        if (selections.contains((Object)oLAPObject) || extraSelections.contains((Object)oLAPObject)) continue;
                        oos.add(oLAPObject);
                    }
                    for (OLAPObject oLAPObject : oos) {
                        cp.deselectItem(oLAPObject);
                    }
                    continue;
                }
                if (comp instanceof VirtualCubePane) {
                    VirtualCubePane vcp = (VirtualCubePane)comp;
                    if (!selections.contains(vcp.getModel()) && !extraSelections.contains(vcp.getModel())) {
                        vcp.setSelected(false, 4);
                    }
                    oos = new ArrayList();
                    for (OLAPObject oLAPObject : vcp.getSelectedItems()) {
                        if (selections.contains((Object)oLAPObject) || extraSelections.contains((Object)oLAPObject)) continue;
                        oos.add(oLAPObject);
                    }
                    for (OLAPObject oLAPObject : oos) {
                        vcp.deselectItem(oLAPObject);
                    }
                    continue;
                }
                if (comp instanceof DimensionPane) {
                    DimensionPane dp = (DimensionPane)comp;
                    if (!selections.contains(dp.getModel()) && !extraSelections.contains(dp.getModel())) {
                        dp.setSelected(false, 4);
                    }
                    oos = new ArrayList();
                    for (OLAPObject oLAPObject : dp.getSelectedItems()) {
                        if (selections.contains((Object)oLAPObject) || extraSelections.contains((Object)oLAPObject)) continue;
                        oos.add(oLAPObject);
                    }
                    for (PaneSection paneSection : dp.getSelectedSections()) {
                        if (!(paneSection instanceof DimensionPane.HierarchySection) || selections.contains((Object)((DimensionPane.HierarchySection)paneSection).getHierarchy()) || extraSelections.contains((Object)((DimensionPane.HierarchySection)paneSection).getHierarchy())) continue;
                        oos.add(((DimensionPane.HierarchySection)paneSection).getHierarchy());
                    }
                    for (OLAPObject oLAPObject : oos) {
                        if (oLAPObject instanceof MondrianModel.Level) {
                            dp.deselectItem((MondrianModel.Level)oLAPObject);
                            continue;
                        }
                        if (!(oLAPObject instanceof MondrianModel.Hierarchy)) continue;
                        dp.deselectSection(dp.findSection((MondrianModel.Hierarchy)oLAPObject));
                    }
                    continue;
                }
                if (comp instanceof UsageComponent) {
                    UsageComponent uc = (UsageComponent)comp;
                    if (selections.contains((Object)uc.getModel()) || extraSelections.contains((Object)uc.getModel())) continue;
                    uc.setSelected(false, 4);
                    continue;
                }
                throw new IllegalArgumentException("Unknown PlayPenComponent type " + comp.getClass() + "!");
            }
        }
        this.ignoreTreeSelection = false;
    }

    private VirtualCubePane selectCubeUsage(MondrianModel.CubeUsage obj, List<OLAPObject> ignoredObjs, List<OLAPObject> extraSelections, OLAPTree tree) {
        if (obj.getParent() instanceof MondrianModel.CubeUsages) {
            if (obj.getParent().getParent() instanceof MondrianModel.VirtualCube) {
                VirtualCubePane vcp = this.selectVirtualCube((MondrianModel.VirtualCube)obj.getParent().getParent(), ignoredObjs);
                if (vcp != null) {
                    this.selectParents(obj, (OLAPObject)((Object)vcp.getModel()), tree, extraSelections);
                    vcp.selectItem(obj);
                }
                return vcp;
            }
            throw new IllegalStateException("Parent type " + obj.getParent().getParent().getClass() + " is not a valid parent for type " + obj.getParent().getClass() + "!");
        }
        throw new IllegalStateException("Parent type " + obj.getParent().getClass() + " is not a valid parent for type " + ((Object)((Object)obj)).getClass() + "!");
    }

    private CubePane selectCube(MondrianModel.Cube cube, List<OLAPObject> ignoredObjs) {
        CubePane cp = (CubePane)this.findPPComponent((Object)cube);
        if (cp != null && !cp.isSelected()) {
            cp.setSelected(true, 4);
        } else {
            ignoredObjs.add(cube);
        }
        return cp;
    }

    private VirtualCubePane selectVirtualCube(MondrianModel.VirtualCube vCube, List<OLAPObject> ignoredObjs) {
        VirtualCubePane vcp = (VirtualCubePane)this.findPPComponent((Object)vCube);
        if (vcp != null && !vcp.isSelected()) {
            vcp.setSelected(true, 4);
        } else {
            ignoredObjs.add(vCube);
        }
        return vcp;
    }

    private OLAPPane<?, ?> selectDimension(OLAPObject obj, List<OLAPObject> ignoredObjs, List<OLAPObject> extraSelections, OLAPTree tree) {
        if (obj.getParent() instanceof MondrianModel.Cube) {
            CubePane cp = this.selectCube((MondrianModel.Cube)obj.getParent(), ignoredObjs);
            if (cp != null) {
                this.selectParents(obj, (OLAPObject)((Object)cp.getModel()), tree, extraSelections);
                cp.selectItem(obj);
            }
            return cp;
        }
        if (obj.getParent() instanceof MondrianModel.Schema) {
            DimensionPane dp = (DimensionPane)this.findPPComponent((Object)obj);
            if (dp != null && !dp.isSelected()) {
                dp.setSelected(true, 4);
            } else {
                ignoredObjs.add(obj);
            }
            return dp;
        }
        throw new IllegalStateException("Parent type " + obj.getParent().getClass() + " is not a valid parent for type " + ((Object)((Object)obj)).getClass() + "!");
    }

    private CubePane selectMeasure(MondrianModel.Measure measure, List<OLAPObject> ignoredObjs, List<OLAPObject> extraSelections, OLAPTree tree) {
        if (measure.getParent() instanceof MondrianModel.Cube) {
            CubePane cp = this.selectCube((MondrianModel.Cube)measure.getParent(), ignoredObjs);
            if (cp != null) {
                this.selectParents(measure, (OLAPObject)((Object)cp.getModel()), tree, extraSelections);
                cp.selectItem(measure);
            }
            return cp;
        }
        throw new IllegalStateException("Parent type " + measure.getParent().getClass() + " is not a valid parent for type " + ((Object)((Object)measure)).getClass() + "!");
    }

    private VirtualCubePane selectItemFromVirtualCube(OLAPObject obj, List<OLAPObject> ignoredObjs, List<OLAPObject> extraSelections, OLAPTree tree) {
        if (obj.getParent() instanceof MondrianModel.VirtualCube) {
            VirtualCubePane vcp = this.selectVirtualCube((MondrianModel.VirtualCube)obj.getParent(), ignoredObjs);
            if (vcp != null) {
                this.selectParents(obj, (OLAPObject)((Object)vcp.getModel()), tree, extraSelections);
                vcp.selectItem(obj);
            }
            return vcp;
        }
        throw new IllegalStateException("Parent type " + obj.getParent().getClass() + " is not a valid parent for type " + ((Object)((Object)obj)).getClass() + "!");
    }

    private DimensionPane selectHierarchy(MondrianModel.Hierarchy hierarchy, List<OLAPObject> ignoredObjs, List<OLAPObject> extraSelections, OLAPTree tree) {
        if (hierarchy.getParent() instanceof MondrianModel.Dimension) {
            DimensionPane dp = (DimensionPane)this.selectDimension((OLAPObject)hierarchy.getParent(), ignoredObjs, extraSelections, tree);
            if (dp == null) {
                throw new NullPointerException("OLAPPane that contains " + ((Object)((Object)hierarchy)).getClass() + " not found.");
            }
            this.selectParents(hierarchy, (OLAPObject)((Object)dp.getModel()), tree, extraSelections);
            dp.selectSection(dp.findSection(hierarchy));
            return dp;
        }
        throw new IllegalStateException("Parent type " + hierarchy.getParent().getClass() + " is not a valid parent for type " + ((Object)((Object)hierarchy)).getClass() + "!");
    }

    private DimensionPane selectLevel(MondrianModel.Level level, List<OLAPObject> ignoredObjs, List<OLAPObject> extraSelections, OLAPTree tree) {
        if (level.getParent() instanceof MondrianModel.Hierarchy) {
            DimensionPane dp = (DimensionPane)this.selectDimension((OLAPObject)level.getParent().getParent(), ignoredObjs, extraSelections, tree);
            if (dp == null) {
                throw new NullPointerException("OLAPPane that contains " + ((Object)((Object)level)).getClass() + " not found.");
            }
            this.selectParents(level, (OLAPObject)((Object)dp.getModel()), tree, extraSelections);
            dp.selectItem(level);
            return dp;
        }
        throw new IllegalStateException("Parent type " + level.getParent().getClass() + " is not a valid parent for type " + ((Object)((Object)level)).getClass() + "!");
    }

    private void selectParents(OLAPObject obj, OLAPObject parent, OLAPTree tree, List<OLAPObject> extraSelections) {
        TreePath tp = tree.getTreePathForNode((SPObject)parent);
        if (!tree.isPathSelected(tp)) {
            tree.addSelectionPath(tp);
            tree.clearNonPlayPenSelections();
            TreePath childPath = tree.getTreePathForNode((SPObject)obj);
            tree.removeSelectionPath(childPath);
            tree.addSelectionPath(childPath);
        }
        extraSelections.add(parent);
    }

    public void setMouseMode(MouseModeType mouseMode) {
        this.mouseMode = mouseMode;
    }

    public MouseModeType getMouseMode() {
        return this.mouseMode;
    }

    public ArchitectSwingSession getSession() {
        return this.session;
    }

    public CursorManager getCursorManager() {
        return this.cursorManager;
    }

    public PopupMenuFactory getPopupFactory() {
        return this.popupFactory;
    }

    public void setPopupFactory(PopupMenuFactory popupFactory) {
        this.popupFactory = popupFactory;
    }

    public void setIgnoreTreeSelection(boolean value) {
        this.ignoreTreeSelection = value;
    }

    public boolean ignoreTreeSelection() {
        return this.ignoreTreeSelection;
    }

    public void showSelected() {
        Rectangle r = null;
        Point minX = null;
        Point minY = null;
        for (PlayPenComponent comp : this.getSelectedItems()) {
            if (r == null) {
                r = comp.getBounds();
                minX = comp.getLocation();
                minY = comp.getLocation();
                continue;
            }
            r.add(comp.getBounds());
            if ((double)comp.getX() < minX.getX()) {
                minX = comp.getLocation();
            }
            if (!((double)comp.getY() < minY.getY())) continue;
            minY = comp.getLocation();
        }
        Rectangle visibleRect = this.unzoomRect(this.getVisibleRect());
        if (r.getHeight() > (double)visibleRect.height) {
            r.setLocation(minY.getLocation());
            r.setSize(r.width, visibleRect.height);
        }
        if (r.getWidth() > (double)visibleRect.width) {
            r.setLocation(minX.getLocation());
            r.setSize(visibleRect.width, r.height);
        }
        this.scrollRectToVisible(this.zoomRect(r));
    }

    public void updateTablePanes() {
        for (TablePane tp : this.contentPane.getChildren(TablePane.class)) {
            tp.updateHiddenColumns();
            tp.updateNameDisplay();
            tp.revalidate();
            tp.repaint();
        }
    }

    public void addPlayPenLifecycleListener(PlayPenLifecycleListener ppll) {
        this.lifecycleListeners.add(ppll);
    }

    private void firePlayPenLifecycleEvent() {
        PlayPenLifecycleEvent evt = new PlayPenLifecycleEvent(this);
        for (int i = this.lifecycleListeners.size() - 1; i >= 0; --i) {
            this.lifecycleListeners.get(i).PlayPenLifeEnding(evt);
        }
    }

    public static class SendToBackAction
    extends AbstractAction {
        protected PlayPen pp;

        public SendToBackAction(PlayPen pp) {
            super(Messages.getString("PlayPen.sendToBackActionName"));
            this.pp = pp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.pp.getContentPane().begin("Sending playpen components to back");
            LinkedHashSet<PlayPenComponent> independentComponents = new LinkedHashSet<PlayPenComponent>();
            LinkedHashSet<PlayPenComponent> dependentComponents = new LinkedHashSet<PlayPenComponent>();
            for (PlayPenComponent c : this.pp.getSelectedItems()) {
                if (PlayPenContentPane.isDependentComponentType(c.getClass())) {
                    if (dependentComponents.add(c)) {
                        try {
                            this.pp.getContentPane().removeChild((SPObject)c);
                        }
                        catch (ObjectDependentException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                } else {
                    independentComponents.add(c);
                }
                if (!(c instanceof TablePane)) continue;
                for (Relationship r : this.pp.getContentPane().getChildren(Relationship.class)) {
                    if (c != r.getFkTable() && c != r.getPkTable() || !dependentComponents.add(r)) continue;
                    try {
                        this.pp.getContentPane().removeChild((SPObject)r);
                    }
                    catch (ObjectDependentException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            for (PlayPenComponent c : independentComponents) {
                try {
                    this.pp.getContentPane().removeChild((SPObject)c);
                }
                catch (ObjectDependentException ex) {
                    throw new RuntimeException(ex);
                }
            }
            for (PlayPenComponent c : independentComponents) {
                this.pp.getContentPane().addChild((SPObject)c, this.pp.getContentPane().getFirstDependentComponentIndex());
            }
            for (PlayPenComponent c : dependentComponents) {
                this.pp.getContentPane().addChild((SPObject)c, this.pp.getContentPane().getChildren().size());
            }
            this.pp.repaint();
            this.pp.getContentPane().commit();
        }
    }

    public static class BringToFrontAction
    extends AbstractAction {
        protected PlayPen pp;

        public BringToFrontAction(PlayPen pp) {
            super(Messages.getString("PlayPen.bringToFrontActionName"));
            this.pp = pp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.pp.getContentPane().begin("Bringing playpen components to front.");
            LinkedHashSet<PlayPenComponent> independentComponents = new LinkedHashSet<PlayPenComponent>();
            LinkedHashSet<PlayPenComponent> dependentComponents = new LinkedHashSet<PlayPenComponent>();
            for (PlayPenComponent c : this.pp.getSelectedItems()) {
                if (PlayPenContentPane.isDependentComponentType(c.getClass())) {
                    if (dependentComponents.add(c)) {
                        try {
                            this.pp.getContentPane().removeChild((SPObject)c);
                        }
                        catch (ObjectDependentException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                } else {
                    independentComponents.add(c);
                }
                if (!(c instanceof TablePane)) continue;
                for (Relationship r : this.pp.getContentPane().getChildren(Relationship.class)) {
                    if (c != r.getFkTable() && c != r.getPkTable() || !dependentComponents.add(r)) continue;
                    try {
                        this.pp.getContentPane().removeChild((SPObject)r);
                    }
                    catch (ObjectDependentException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            for (PlayPenComponent c : independentComponents) {
                try {
                    this.pp.getContentPane().removeChild((SPObject)c);
                }
                catch (ObjectDependentException ex) {
                    throw new RuntimeException(ex);
                }
            }
            for (PlayPenComponent c : independentComponents) {
                this.pp.getContentPane().addChild((SPObject)c, 0);
            }
            for (PlayPenComponent c : dependentComponents) {
                this.pp.getContentPane().addChild((SPObject)c, this.pp.getContentPane().getFirstDependentComponentIndex());
            }
            this.pp.repaint();
            this.pp.getContentPane().commit();
        }
    }

    public static class FloatingContainerPaneListener
    extends MouseInputAdapter {
        private static final int AUTO_SCROLL_INSET = 20;
        private Insets scrollUnits = new Insets(20, 20, 20, 20);
        private PlayPen pp;
        private Map<DraggablePlayPenComponent, Point> ppcToHandleMap = new HashMap<DraggablePlayPenComponent, Point>();
        private Map<DraggablePlayPenComponent, Point> ppcToPointMap = new HashMap<DraggablePlayPenComponent, Point>();

        public FloatingContainerPaneListener(PlayPen pp, Map<DraggablePlayPenComponent, Point> ppcToHandleMap) {
            this.pp = pp;
            Point pointerLocation = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(pointerLocation, pp);
            logger.debug((Object)("Adding floating container pane at:" + pointerLocation));
            this.ppcToHandleMap = new HashMap<DraggablePlayPenComponent, Point>(ppcToHandleMap);
            for (Map.Entry<DraggablePlayPenComponent, Point> entry : ppcToHandleMap.entrySet()) {
                DraggablePlayPenComponent ppc = entry.getKey();
                Point handle = entry.getValue();
                Point point = new Point(pointerLocation.x - handle.x, pointerLocation.y - handle.y);
                this.ppcToPointMap.put(ppc, point);
            }
            pp.addMouseMotionListener(this);
            pp.addMouseListener(this);
            pp.cursorManager.tableDragStarted();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.mouseDragged(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            for (Map.Entry<DraggablePlayPenComponent, Point> entry : this.ppcToHandleMap.entrySet()) {
                DraggablePlayPenComponent ppc = entry.getKey();
                Point handle = entry.getValue();
                Point p = this.ppcToPointMap.get(ppc);
                this.pp.zoomPoint(e.getPoint());
                p.setLocation(e.getPoint().x - handle.x, e.getPoint().y - handle.y);
                this.pp.setChildPosition(ppc, p);
                JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this.pp);
                if (viewport == null || this.pp.getSelectedItems().size() < 1) {
                    return;
                }
                this.pp.revalidate();
                Point viewPos = viewport.getViewPosition();
                Rectangle view = viewport.getViewRect();
                int viewHeight = viewport.getHeight();
                int viewWidth = viewport.getWidth();
                Rectangle bounds = this.pp.zoomRect(ppc.getBounds());
                if (p.y - viewPos.y < this.scrollUnits.top && viewPos.y > 0) {
                    view.y = bounds.y - this.scrollUnits.top;
                }
                if (viewPos.y + viewHeight - p.y - bounds.height < this.scrollUnits.bottom) {
                    view.y = bounds.y + bounds.height - viewHeight + this.scrollUnits.bottom;
                }
                if (p.x - viewPos.x < this.scrollUnits.left && viewPos.x > 0) {
                    view.x = bounds.x - this.scrollUnits.left;
                }
                if (viewPos.x + viewWidth - p.x - bounds.width < this.scrollUnits.right) {
                    view.x = bounds.x + bounds.width - viewWidth + this.scrollUnits.right;
                }
                logger.debug((Object)viewport.getViewPosition());
                this.pp.scrollRectToVisible(view);
                if (ppc == null) continue;
                ppc.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.cleanup();
            this.pp.normalize();
            this.pp.revalidate();
            for (DraggablePlayPenComponent ppc : this.ppcToHandleMap.keySet()) {
                if (!ppc.isBeingDragged()) continue;
                ppc.doneDragging();
            }
        }

        protected void cleanup() {
            this.pp.cursorManager.placeModeFinished();
            this.pp.cursorManager.tableDragFinished();
            this.pp.removeMouseMotionListener(this);
            this.pp.removeMouseListener(this);
        }
    }

    protected class PPMouseListener
    implements MouseListener,
    MouseMotionListener {
        protected Point rubberBandOrigin;

        protected PPMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            Point p = evt.getPoint();
            PlayPen.this.unzoomPoint(p);
            PlayPenComponent c = PlayPen.this.contentPane.getComponentAt(p);
            if (c instanceof PlayPenComponent) {
                c.handleMouseEvent(evt);
            } else {
                PlayPen.this.session.getArchitectFrame().getCreateIdentifyingRelationshipAction().cancel();
                PlayPen.this.session.getArchitectFrame().getCreateNonIdentifyingRelationshipAction().cancel();
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            PlayPen.this.requestFocus();
            Point p = evt.getPoint();
            PlayPen.this.unzoomPoint(p);
            PlayPenComponent c = PlayPen.this.contentPane.getComponentAt(p);
            PlayPen.this.selectionInProgress = true;
            if (c instanceof PlayPenComponent) {
                c.handleMouseEvent(evt);
            } else if ((evt.getModifiersEx() & 0x400) != 0 && !evt.isPopupTrigger()) {
                PlayPen.this.mouseMode = MouseModeType.IDLE;
                PlayPen.this.selectNone();
                this.rubberBandOrigin = new Point(p);
                PlayPen.this.rubberBand = new Rectangle(this.rubberBandOrigin.x, this.rubberBandOrigin.y, 0, 0);
            }
            this.maybeShowPopup(evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            PlayPen.this.draggingContainerPanes = false;
            PlayPen.this.selectionInProgress = false;
            if (PlayPen.this.rubberBand != null && evt.getButton() == 1) {
                Rectangle dirtyRegion = PlayPen.this.rubberBand;
                this.rubberBandOrigin = null;
                PlayPen.this.rubberBand = null;
                PlayPen.this.zoomRect(dirtyRegion);
                this.repaintRubberBandRegion(dirtyRegion);
                if (PlayPen.this.getSelectedItems().size() > 0) {
                    PlayPen.this.mouseMode = MouseModeType.MULTI_SELECT;
                } else {
                    PlayPen.this.mouseMode = MouseModeType.IDLE;
                }
            }
            this.maybeShowPopup(evt);
            PlayPen.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            this.mouseMoved(evt);
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            if (PlayPen.this.rubberBand != null) {
                Rectangle dirtyRegion = PlayPen.this.zoomRect(new Rectangle(PlayPen.this.rubberBand));
                Point p = PlayPen.this.unzoomPoint(evt.getPoint());
                PlayPen.this.rubberBand.setBounds(this.rubberBandOrigin.x, this.rubberBandOrigin.y, 0, 0);
                PlayPen.this.rubberBand.add(p);
                PlayPen.this.mouseMode = MouseModeType.RUBBERBAND_MOVE;
                for (PlayPenComponent playPenComponent : PlayPen.this.contentPane.getChildren()) {
                    playPenComponent.handleMouseEvent(evt);
                }
                dirtyRegion.add(PlayPen.this.zoomRect(new Rectangle(PlayPen.this.rubberBand)));
                this.repaintRubberBandRegion(dirtyRegion);
            }
        }

        private void repaintRubberBandRegion(Rectangle region) {
            Rectangle dirtyRegion = new Rectangle(region);
            dirtyRegion.x -= 3;
            dirtyRegion.y -= 3;
            dirtyRegion.width += 6;
            dirtyRegion.height += 6;
            PlayPen.this.repaint(dirtyRegion);
        }

        public void maybeShowPopup(MouseEvent evt) {
            Point p = PlayPen.this.unzoomPoint(evt.getPoint());
            PlayPenComponent c = PlayPen.this.contentPane.getComponentAt(p);
            if (!PlayPen.this.mouseMode.equals((Object)MouseModeType.CREATING_RELATIONSHIP) && !PlayPen.this.mouseMode.equals((Object)MouseModeType.CREATING_TABLE)) {
                if (c != null) {
                    if (!c.isBeingDragged()) {
                        p.translate(-c.getX(), -c.getY());
                        if (evt.isPopupTrigger() && !evt.isConsumed()) {
                            c.showPopup(p);
                        }
                    }
                } else if (evt.isPopupTrigger() && PlayPen.this.popupFactory != null) {
                    JPanel pp = (JPanel)evt.getSource();
                    JPopupMenu popup = PlayPen.this.popupFactory.createPopupMenu(null);
                    popup.show(pp, evt.getX(), evt.getY());
                }
            }
        }
    }

    private static class DnDLabel
    extends JTextArea {
        private static final int BORDER_WIDTH = 5;

        DnDLabel(String text) {
            super(text);
            this.setOpaque(false);
            this.setBackground(new Color(-869059789, true));
            this.setForeground(Color.WHITE);
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 15, 15);
            super.paint(g);
        }
    }

    public class TablePaneDragGestureListener
    implements DragGestureListener {
        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (dge.getTriggerEvent() instanceof MouseEvent && (dge.getTriggerEvent().getModifiers() & 0x10) == 0) {
                return;
            }
            if (PlayPen.this.session.getArchitectFrame().createRelationshipIsActive()) {
                logger.debug((Object)"CreateRelationship() is active, short circuiting DnD.");
                return;
            }
            if (PlayPen.this.draggingContainerPanes) {
                logger.debug((Object)"TablePaneDragGestureListener: ignoring drag event because draggingTablePanes is true");
                return;
            }
            MouseEvent triggerEvent = (MouseEvent)dge.getTriggerEvent();
            PlayPenComponent c = PlayPen.this.contentPane.getComponentAt(PlayPen.this.unzoomPoint(triggerEvent.getPoint()));
            if (c instanceof ContainerPane) {
                ContainerPane tp = (ContainerPane)c;
                Point dragOrigin = tp.getPlayPen().unzoomPoint(new Point(dge.getDragOrigin()));
                dragOrigin.x -= tp.getX();
                dragOrigin.y -= tp.getY();
                logger.debug((Object)("Recognized drag gesture on " + tp.getName() + "! origin=" + dragOrigin));
                Transferable transferableSelection = tp.createTransferableForSelection();
                if (transferableSelection != null) {
                    DnDLabel label = new DnDLabel(transferableSelection.toString());
                    Dimension labelSize = label.getPreferredSize();
                    label.setSize(labelSize);
                    BufferedImage dragImage = new BufferedImage(labelSize.width, labelSize.height, 2);
                    Graphics2D imageGraphics = dragImage.createGraphics();
                    label.paint(imageGraphics);
                    imageGraphics.dispose();
                    dge.getSourceAsDragGestureRecognizer().setSourceActions(3);
                    dge.getDragSource().startDrag(dge, null, dragImage, new Point(0, 0), transferableSelection, tp);
                }
            }
        }
    }

    private static class PlayPenDropListener
    implements DropTargetListener {
        private ContainerPane<?, ?> tpTarget;

        private PlayPenDropListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            logger.debug((Object)"Drag enter");
            this.dragOver(dtde);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            logger.debug((Object)"Drag exit");
            if (this.tpTarget != null) {
                this.tpTarget.dragExit(dte);
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            PlayPen pp = (PlayPen)dtde.getDropTargetContext().getComponent();
            Point sp = pp.unzoomPoint(new Point(dtde.getLocation()));
            PlayPenComponent ppc = pp.contentPane.getComponentAt(sp);
            ContainerPane tp = ppc instanceof ContainerPane ? (ContainerPane)ppc : null;
            if (tp != this.tpTarget) {
                if (this.tpTarget != null) {
                    this.tpTarget.dragExit(dtde);
                }
                this.tpTarget = tp;
                if (this.tpTarget != null) {
                    this.tpTarget.dragEnter(dtde);
                }
            }
            if (this.tpTarget != null) {
                this.tpTarget.dragOver(dtde);
            } else {
                dtde.acceptDrag(3 & dtde.getDropAction());
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            logger.debug((Object)("On drop, source actions are " + dtde.getSourceActions() + " and drop action is " + dtde.getDropAction()));
            logger.info((Object)("Drop: I am over dtde=" + dtde));
            if (this.tpTarget != null) {
                this.tpTarget.drop(dtde);
                return;
            }
            if ((dtde.getSourceActions() & dtde.getDropAction()) == 0) {
                dtde.rejectDrop();
                return;
            }
            Transferable t = dtde.getTransferable();
            PlayPen playpen = (PlayPen)dtde.getDropTargetContext().getComponent();
            try {
                Point dropLoc = playpen.unzoomPoint(new Point(dtde.getLocation()));
                if (playpen.addTransferable(t, dropLoc, SQLTable.TransferStyles.REVERSE_ENGINEER)) {
                    dtde.acceptDrop(1);
                    dtde.dropComplete(true);
                } else {
                    dtde.rejectDrop();
                }
            }
            catch (UnsupportedFlavorException ufe) {
                logger.error((Object)ufe);
                dtde.rejectDrop();
            }
            catch (IOException ioe) {
                logger.error((Object)ioe);
                dtde.rejectDrop();
            }
            catch (InvalidDnDOperationException ex) {
                logger.error((Object)ex);
                dtde.rejectDrop();
            }
            catch (SQLObjectException ex) {
                logger.error((Object)ex);
                dtde.rejectDrop();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            logger.debug((Object)"Drop Action Changed");
        }

        public DataFlavor bestImportFlavor(JComponent c, DataFlavor[] flavors) {
            DataFlavor best = null;
            logger.debug((Object)("PlayPenTransferHandler: can I import " + Arrays.asList(flavors)));
            for (int i = 0; i < flavors.length; ++i) {
                String cls = flavors[i].getDefaultRepresentationClassAsString();
                logger.debug((Object)("representation class = " + cls));
                logger.debug((Object)("mime type = " + flavors[i].getMimeType()));
                logger.debug((Object)("type = " + flavors[i].getPrimaryType()));
                logger.debug((Object)("subtype = " + flavors[i].getSubType()));
                logger.debug((Object)("class = " + flavors[i].getParameter("class")));
                logger.debug((Object)("isSerializedObject = " + flavors[i].isFlavorSerializedObjectType()));
                logger.debug((Object)("isInputStream = " + flavors[i].isRepresentationClassInputStream()));
                logger.debug((Object)("isRemoteObject = " + flavors[i].isFlavorRemoteObjectType()));
                logger.debug((Object)("isLocalObject = " + flavors[i].getMimeType().equals("application/x-java-jvm-local-objectref")));
                if (flavors[i].equals(SQLObjectSelection.LOCAL_SQLOBJECT_ARRAY_FLAVOUR)) {
                    logger.debug((Object)"YES");
                    best = flavors[i];
                    continue;
                }
                logger.debug((Object)"NO!");
            }
            return best;
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            return this.bestImportFlavor(c, flavors) != null;
        }
    }

    protected class AddObjectsTask
    extends SPSwingWorker {
        private List<SQLObject> sqlObjects;
        private Point preferredLocation;
        private String errorMessage;
        private ProgressMonitor pm;
        private final SQLTable.TransferStyles transferStyle;

        public AddObjectsTask(List<SQLObject> sqlObjects, Point preferredLocation, ProgressMonitor pm, ArchitectSwingSession session, SQLTable.TransferStyles transferStyle) {
            super((SwingWorkerRegistry)session);
            this.errorMessage = null;
            this.sqlObjects = sqlObjects;
            this.preferredLocation = preferredLocation;
            this.transferStyle = transferStyle;
            ProgressWatcher.watchProgress((ProgressMonitor)pm, (Monitorable)this);
            this.pm = pm;
        }

        public synchronized boolean isCancelled() {
            return super.isCancelled() || this.pm.isCanceled();
        }

        public void doStuff() {
            logger.info((Object)("AddObjectsTask starting on thread " + Thread.currentThread().getName()));
            PlayPen.this.session.getArchitectFrame().getContentPane().setCursor(new Cursor(3));
            try {
                Iterator<SQLObject> soIt = this.sqlObjects.iterator();
                while (soIt.hasNext() && !this.isCancelled()) {
                    SQLObject so = soIt.next();
                    SQLObjectUtils.countTablesSnapshot((SQLObject)so);
                }
            }
            catch (SQLObjectException e) {
                logger.error((Object)"Unexpected exception during populate", (Throwable)e);
                this.setDoStuffException(e);
                this.errorMessage = "Unexpected exception during populate: " + e.getMessage();
            }
            PlayPen.this.session.runInForeground(new Runnable(){

                @Override
                public void run() {
                    try {
                        int tableCount = 0;
                        Iterator soIt = AddObjectsTask.this.sqlObjects.iterator();
                        while (soIt.hasNext() && !AddObjectsTask.this.isCancelled()) {
                            SQLObject so = (SQLObject)soIt.next();
                            tableCount += SQLObjectUtils.countTablesSnapshot((SQLObject)so);
                        }
                        AddObjectsTask.this.setJobSize(new Integer(tableCount));
                    }
                    catch (SQLObjectException e) {
                        logger.error((Object)"Unexpected exception, objects should be populated by this pass.", (Throwable)e);
                        AddObjectsTask.this.setDoStuffException(e);
                        AddObjectsTask.this.errorMessage = "Unexpected exception, objects should be populated by this pass: " + e.getMessage();
                    }
                }
            });
            this.ensurePopulated(this.sqlObjects);
            logger.info((Object)"AddObjectsTask done");
        }

        private void ensurePopulated(List<? extends SQLObject> soList) {
            for (SQLObject sQLObject : soList) {
                if (this.isCancelled()) break;
                if (sQLObject instanceof SQLTable) {
                    PlayPen.this.session.runInForeground(new Runnable(){

                        @Override
                        public void run() {
                            AddObjectsTask.this.setProgress(AddObjectsTask.this.getProgress() + 1);
                        }
                    });
                }
                this.ensurePopulated(sQLObject.getChildren());
            }
        }

        public void cleanup() {
            if (this.getDoStuffException() != null) {
                ASUtils.showExceptionDialogNoReport(PlayPen.this.session.getArchitectFrame(), this.errorMessage, this.getDoStuffException());
                if (this.getNextProcess() != null) {
                    this.setCancelled(true);
                }
            }
            PlayPen.this.session.getPlayPen().startCompoundEdit("Drag to Playpen");
            ImportSafetyChecker checker = new ImportSafetyChecker(PlayPen.this.session);
            this.sqlObjects = checker.filterImportedItems(this.sqlObjects);
            PlayPen.this.session.getPlayPen().getContentPane().begin("Drag to Playpen");
            try {
                Iterator<SQLObject> soIt = this.sqlObjects.iterator();
                ArrayListMultimap addedColumns = ArrayListMultimap.create();
                PlayPen.this.resetTableNames();
                while (soIt.hasNext() && !this.isCancelled()) {
                    String platform;
                    TablePane tp;
                    SQLTable sourceTable;
                    Object nextTable;
                    SQLObject someData = soIt.next();
                    DuplicateProperties duplicateProperties = ASUtils.createDuplicateProperties(PlayPen.this.getSession(), someData);
                    if (this.transferStyle == SQLTable.TransferStyles.COPY && duplicateProperties.isCanCopy()) {
                        duplicateProperties.setDefaultTransferStyle(this.transferStyle);
                    } else if (this.transferStyle == SQLTable.TransferStyles.REVERSE_ENGINEER && duplicateProperties.isCanReverseEngineer()) {
                        duplicateProperties.setDefaultTransferStyle(this.transferStyle);
                    }
                    if (someData instanceof SQLTable) {
                        TablePane tp2 = PlayPen.this.importTableCopy((SQLTable)someData, this.preferredLocation, duplicateProperties, false);
                        this.setMessage(ArchitectUtils.truncateString(((SQLTable)someData).getName()));
                        this.preferredLocation.x += tp2.getPreferredSize().width + 5;
                        SQLDatabase dbAncestor = (SQLDatabase)SQLPowerUtils.getAncestor((SPObject)someData, SQLDatabase.class);
                        String platform2 = dbAncestor == null ? null : dbAncestor.getDataSource().getParentType().getName();
                        addedColumns.putAll((Object)platform2, (Iterable)((SQLTable)tp2.getModel()).getChildren(SQLColumn.class));
                        this.increaseProgress();
                        continue;
                    }
                    if (someData instanceof SQLSchema) {
                        SQLSchema sourceSchema = (SQLSchema)someData;
                        Iterator it = sourceSchema.getChildren().iterator();
                        while (it.hasNext() && !this.isCancelled()) {
                            nextTable = it.next();
                            sourceTable = (SQLTable)nextTable;
                            this.setMessage(ArchitectUtils.truncateString(sourceTable.getName()));
                            tp = PlayPen.this.importTableCopy(sourceTable, this.preferredLocation, duplicateProperties, false);
                            this.preferredLocation.x += tp.getPreferredSize().width + 5;
                            platform = ((SQLDatabase)SQLPowerUtils.getAncestor((SPObject)someData, SQLDatabase.class)).getDataSource().getParentType().getName();
                            addedColumns.putAll((Object)platform, (Iterable)((SQLTable)tp.getModel()).getChildren(SQLColumn.class));
                            this.increaseProgress();
                        }
                        continue;
                    }
                    if (someData instanceof SQLCatalog) {
                        SQLCatalog sourceCatalog = (SQLCatalog)someData;
                        Iterator cit = sourceCatalog.getChildren().iterator();
                        if (sourceCatalog.isSchemaContainer()) {
                            while (cit.hasNext() && !this.isCancelled()) {
                                SQLSchema sourceSchema = (SQLSchema)cit.next();
                                Iterator it = sourceSchema.getChildren().iterator();
                                while (it.hasNext() && !this.isCancelled()) {
                                    Object nextTable2 = it.next();
                                    SQLTable sourceTable2 = (SQLTable)nextTable2;
                                    this.setMessage(ArchitectUtils.truncateString(sourceTable2.getName()));
                                    TablePane tp3 = PlayPen.this.importTableCopy(sourceTable2, this.preferredLocation, duplicateProperties, false);
                                    this.preferredLocation.x += tp3.getPreferredSize().width + 5;
                                    String platform3 = ((SQLDatabase)SQLPowerUtils.getAncestor((SPObject)someData, SQLDatabase.class)).getDataSource().getParentType().getName();
                                    addedColumns.putAll((Object)platform3, (Iterable)((SQLTable)tp3.getModel()).getChildren(SQLColumn.class));
                                    this.increaseProgress();
                                }
                            }
                            continue;
                        }
                        while (cit.hasNext() && !this.isCancelled()) {
                            nextTable = cit.next();
                            sourceTable = (SQLTable)nextTable;
                            this.setMessage(ArchitectUtils.truncateString(sourceTable.getName()));
                            tp = PlayPen.this.importTableCopy(sourceTable, this.preferredLocation, duplicateProperties, false);
                            this.preferredLocation.x += tp.getPreferredSize().width + 5;
                            platform = ((SQLDatabase)SQLPowerUtils.getAncestor((SPObject)someData, SQLDatabase.class)).getDataSource().getParentType().getName();
                            addedColumns.putAll((Object)platform, (Iterable)((SQLTable)tp.getModel()).getChildren(SQLColumn.class));
                            this.increaseProgress();
                        }
                        continue;
                    }
                    logger.error((Object)("Unknown object dropped in PlayPen: " + someData));
                }
                for (String platform : addedColumns.keySet()) {
                    SQLColumn.assignTypes((List)addedColumns.get((Object)platform), PlayPen.this.session.getDataSources(), (String)platform, (UserPrompterFactory)PlayPen.this.session);
                }
                PlayPen.this.session.getPlayPen().getContentPane().commit();
            }
            catch (SQLObjectException e) {
                PlayPen.this.session.getPlayPen().getContentPane().rollback(e.getMessage());
                ASUtils.showExceptionDialog(PlayPen.this.session, "Unexpected Exception During Import", e);
            }
            catch (Throwable e) {
                PlayPen.this.session.getPlayPen().getContentPane().rollback(e.getMessage());
                throw new RuntimeException(e);
            }
            finally {
                PlayPen.this.session.getArchitectFrame().getContentPane().setCursor(new Cursor(0));
                PlayPen.this.session.getPlayPen().endCompoundEdit("Ending multi-select");
            }
            if (this.getJobSize() == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(PlayPen.this.session.getArchitectFrame(), Messages.getString("PlayPen.noObjectsToImportFound"), Messages.getString("PlayPen.noObjectsToImportFoundDialogTitle"), 2);
                    }
                });
            }
        }
    }

    public static enum MouseModeType {
        IDLE,
        CREATING_TABLE,
        CREATING_RELATIONSHIP,
        SELECT_TABLE,
        SELECT_RELATIONSHIP,
        SELECT_ITEM,
        SELECT_SECTION,
        MULTI_SELECT,
        RUBBERBAND_MOVE;

    }

    public static interface CancelableListener {
        public void cancel();
    }
}

