/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.swingui.SPSUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class AbstractPlacer
extends MouseAdapter
implements PlayPen.CancelableListener {
    private static final Logger logger = Logger.getLogger(AbstractPlacer.class);
    protected final PlayPen playpen;

    protected AbstractPlacer(PlayPen playpen) {
        this.playpen = playpen;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.cleanup();
        Point p = e.getPoint();
        this.playpen.unzoomPoint(p);
        logger.debug((Object)("Placing item at: " + p));
        try {
            DataEntryPanel editPanel = this.place(p);
            Window owner = SwingUtilities.getWindowAncestor(this.playpen);
            JDialog d = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)editPanel, (Component)owner, (String)this.getEditDialogTitle(), (String)Messages.getString("PlayPen.okOption"));
            d.pack();
            d.setLocationRelativeTo(owner);
            d.setVisible(true);
        }
        catch (SQLObjectException ex) {
            logger.error((Object)"Failed to add item to play pen:", (Throwable)ex);
            SPSUtils.showExceptionDialogNoReport((Component)this.playpen.getSession().getArchitectFrame(), (String)"Add item to play pen failed", (Throwable)ex);
            return;
        }
    }

    protected abstract String getEditDialogTitle();

    public abstract DataEntryPanel place(Point var1) throws SQLObjectException;

    @Override
    public void cancel() {
        this.cleanup();
    }

    public void dirtyup() {
        this.playpen.fireCancel();
        this.playpen.getCursorManager().placeModeStarted();
        this.playpen.addMouseListener(this);
        this.playpen.addCancelableListener(this);
    }

    private void cleanup() {
        this.playpen.removeCancelableListener(this);
        this.playpen.removeMouseListener(this);
        this.playpen.getCursorManager().placeModeFinished();
    }
}

