// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
)

func resourceAppEngineFlexibleAppVersion() *schema.Resource {
	return &schema.Resource{
		Create: resourceAppEngineFlexibleAppVersionCreate,
		Read:   resourceAppEngineFlexibleAppVersionRead,
		Update: resourceAppEngineFlexibleAppVersionUpdate,
		Delete: resourceAppEngineFlexibleAppVersionDelete,

		Importer: &schema.ResourceImporter{
			State: resourceAppEngineFlexibleAppVersionImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(20 * time.Minute),
			Update: schema.DefaultTimeout(20 * time.Minute),
			Delete: schema.DefaultTimeout(20 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"liveness_check": {
				Type:        schema.TypeList,
				Required:    true,
				Description: `Health checking configuration for VM instances. Unhealthy instances are killed and replaced with new instances.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"path": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `The request path.`,
						},
						"check_interval": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Interval between health checks.`,
							Default:     "30s",
						},
						"failure_threshold": {
							Type:        schema.TypeFloat,
							Optional:    true,
							Description: `Number of consecutive failed checks required before considering the VM unhealthy. Default: 4.`,
							Default:     4.0,
						},
						"host": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com"`,
						},
						"initial_delay": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `The initial delay before starting to execute the checks. Default: "300s"`,
							Default:     "300s",
						},
						"success_threshold": {
							Type:        schema.TypeFloat,
							Optional:    true,
							Description: `Number of consecutive successful checks required before considering the VM healthy. Default: 2.`,
							Default:     2.0,
						},
						"timeout": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Time before the check is considered failed. Default: "4s"`,
							Default:     "4s",
						},
					},
				},
			},
			"readiness_check": {
				Type:        schema.TypeList,
				Required:    true,
				Description: `Configures readiness health checking for instances. Unhealthy instances are not put into the backend traffic rotation.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"path": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `The request path.`,
						},
						"app_start_timeout": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `A maximum time limit on application initialization, measured from moment the application successfully
replies to a healthcheck until it is ready to serve traffic. Default: "300s"`,
							Default: "300s",
						},
						"check_interval": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Interval between health checks.  Default: "5s".`,
							Default:     "5s",
						},
						"failure_threshold": {
							Type:        schema.TypeFloat,
							Optional:    true,
							Description: `Number of consecutive failed checks required before removing traffic. Default: 2.`,
							Default:     2.0,
						},
						"host": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com"`,
						},
						"success_threshold": {
							Type:        schema.TypeFloat,
							Optional:    true,
							Description: `Number of consecutive successful checks required before receiving traffic. Default: 2.`,
							Default:     2.0,
						},
						"timeout": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Time before the check is considered failed. Default: "4s"`,
							Default:     "4s",
						},
					},
				},
			},
			"runtime": {
				Type:        schema.TypeString,
				Required:    true,
				Description: `Desired runtime. Example python27.`,
			},
			"service": {
				Type:             schema.TypeString,
				Required:         true,
				DiffSuppressFunc: compareSelfLinkOrResourceName,
				Description:      `AppEngine service resource. Can contain numbers, letters, and hyphens.`,
			},
			"api_config": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Serving configuration for Google Cloud Endpoints.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"script": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Path to the script from the application root directory.`,
						},
						"auth_fail_action": {
							Type:         schema.TypeString,
							Optional:     true,
							ValidateFunc: validateEnum([]string{"AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED", ""}),
							Description:  `Action to take when users access resources that require authentication. Default value: "AUTH_FAIL_ACTION_REDIRECT" Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"]`,
							Default:      "AUTH_FAIL_ACTION_REDIRECT",
						},
						"login": {
							Type:         schema.TypeString,
							Optional:     true,
							ValidateFunc: validateEnum([]string{"LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED", ""}),
							Description:  `Level of login required to access this resource. Default value: "LOGIN_OPTIONAL" Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"]`,
							Default:      "LOGIN_OPTIONAL",
						},
						"security_level": {
							Type:         schema.TypeString,
							Optional:     true,
							ValidateFunc: validateEnum([]string{"SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS", ""}),
							Description:  `Security (HTTPS) enforcement for this URL. Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"]`,
						},
						"url": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `URL to serve the endpoint at.`,
						},
					},
				},
			},
			"automatic_scaling": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Automatic scaling is based on request rate, response latencies, and other application metrics.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"cpu_utilization": {
							Type:        schema.TypeList,
							Required:    true,
							Description: `Target scaling by CPU usage.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"target_utilization": {
										Type:        schema.TypeFloat,
										Required:    true,
										Description: `Target CPU utilization ratio to maintain when scaling. Must be between 0 and 1.`,
									},
									"aggregation_window_length": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `Period of time over which CPU utilization is calculated.`,
									},
								},
							},
						},
						"cool_down_period": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `The time period that the Autoscaler should wait before it starts collecting information from a new instance.
This prevents the autoscaler from collecting information when the instance is initializing,
during which the collected usage would not be reliable. Default: 120s`,
							Default: "120s",
						},
						"disk_utilization": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Target scaling by disk usage.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"target_read_bytes_per_second": {
										Type:         schema.TypeInt,
										Optional:     true,
										Description:  `Target bytes read per second.`,
										AtLeastOneOf: []string{"automatic_scaling.0.disk_utilization.0.target_write_bytes_per_second", "automatic_scaling.0.disk_utilization.0.target_write_ops_per_second", "automatic_scaling.0.disk_utilization.0.target_read_bytes_per_second", "automatic_scaling.0.disk_utilization.0.target_read_ops_per_second"},
									},
									"target_read_ops_per_second": {
										Type:         schema.TypeInt,
										Optional:     true,
										Description:  `Target ops read per seconds.`,
										AtLeastOneOf: []string{"automatic_scaling.0.disk_utilization.0.target_write_bytes_per_second", "automatic_scaling.0.disk_utilization.0.target_write_ops_per_second", "automatic_scaling.0.disk_utilization.0.target_read_bytes_per_second", "automatic_scaling.0.disk_utilization.0.target_read_ops_per_second"},
									},
									"target_write_bytes_per_second": {
										Type:         schema.TypeInt,
										Optional:     true,
										Description:  `Target bytes written per second.`,
										AtLeastOneOf: []string{"automatic_scaling.0.disk_utilization.0.target_write_bytes_per_second", "automatic_scaling.0.disk_utilization.0.target_write_ops_per_second", "automatic_scaling.0.disk_utilization.0.target_read_bytes_per_second", "automatic_scaling.0.disk_utilization.0.target_read_ops_per_second"},
									},
									"target_write_ops_per_second": {
										Type:         schema.TypeInt,
										Optional:     true,
										Description:  `Target ops written per second.`,
										AtLeastOneOf: []string{"automatic_scaling.0.disk_utilization.0.target_write_bytes_per_second", "automatic_scaling.0.disk_utilization.0.target_write_ops_per_second", "automatic_scaling.0.disk_utilization.0.target_read_bytes_per_second", "automatic_scaling.0.disk_utilization.0.target_read_ops_per_second"},
									},
								},
							},
						},
						"max_concurrent_requests": {
							Type:     schema.TypeInt,
							Computed: true,
							Optional: true,
							Description: `Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.

Defaults to a runtime-specific value.`,
						},
						"max_idle_instances": {
							Type:        schema.TypeInt,
							Optional:    true,
							Description: `Maximum number of idle instances that should be maintained for this version.`,
						},
						"max_pending_latency": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.`,
						},
						"max_total_instances": {
							Type:        schema.TypeInt,
							Optional:    true,
							Description: `Maximum number of instances that should be started to handle requests for this version. Default: 20`,
							Default:     20,
						},
						"min_idle_instances": {
							Type:        schema.TypeInt,
							Optional:    true,
							Description: `Minimum number of idle instances that should be maintained for this version. Only applicable for the default version of a service.`,
						},
						"min_pending_latency": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.`,
						},
						"min_total_instances": {
							Type:        schema.TypeInt,
							Optional:    true,
							Description: `Minimum number of running instances that should be maintained for this version. Default: 2`,
							Default:     2,
						},
						"network_utilization": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Target scaling by network usage.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"target_received_bytes_per_second": {
										Type:         schema.TypeInt,
										Optional:     true,
										Description:  `Target bytes received per second.`,
										AtLeastOneOf: []string{"automatic_scaling.0.network_utilization.0.target_sent_bytes_per_second", "automatic_scaling.0.network_utilization.0.target_sent_packets_per_second", "automatic_scaling.0.network_utilization.0.target_received_bytes_per_second", "automatic_scaling.0.network_utilization.0.target_received_packets_per_second"},
									},
									"target_received_packets_per_second": {
										Type:         schema.TypeInt,
										Optional:     true,
										Description:  `Target packets received per second.`,
										AtLeastOneOf: []string{"automatic_scaling.0.network_utilization.0.target_sent_bytes_per_second", "automatic_scaling.0.network_utilization.0.target_sent_packets_per_second", "automatic_scaling.0.network_utilization.0.target_received_bytes_per_second", "automatic_scaling.0.network_utilization.0.target_received_packets_per_second"},
									},
									"target_sent_bytes_per_second": {
										Type:         schema.TypeInt,
										Optional:     true,
										Description:  `Target bytes sent per second.`,
										AtLeastOneOf: []string{"automatic_scaling.0.network_utilization.0.target_sent_bytes_per_second", "automatic_scaling.0.network_utilization.0.target_sent_packets_per_second", "automatic_scaling.0.network_utilization.0.target_received_bytes_per_second", "automatic_scaling.0.network_utilization.0.target_received_packets_per_second"},
									},
									"target_sent_packets_per_second": {
										Type:         schema.TypeInt,
										Optional:     true,
										Description:  `Target packets sent per second.`,
										AtLeastOneOf: []string{"automatic_scaling.0.network_utilization.0.target_sent_bytes_per_second", "automatic_scaling.0.network_utilization.0.target_sent_packets_per_second", "automatic_scaling.0.network_utilization.0.target_received_bytes_per_second", "automatic_scaling.0.network_utilization.0.target_received_packets_per_second"},
									},
								},
							},
						},
						"request_utilization": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Target scaling by request utilization.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"target_concurrent_requests": {
										Type:         schema.TypeFloat,
										Optional:     true,
										Description:  `Target number of concurrent requests.`,
										AtLeastOneOf: []string{"automatic_scaling.0.request_utilization.0.target_request_count_per_second", "automatic_scaling.0.request_utilization.0.target_concurrent_requests"},
									},
									"target_request_count_per_second": {
										Type:         schema.TypeString,
										Optional:     true,
										Description:  `Target requests per second.`,
										AtLeastOneOf: []string{"automatic_scaling.0.request_utilization.0.target_request_count_per_second", "automatic_scaling.0.request_utilization.0.target_concurrent_requests"},
									},
								},
							},
						},
					},
				},
				ExactlyOneOf: []string{"automatic_scaling", "manual_scaling"},
			},
			"beta_settings": {
				Type:        schema.TypeMap,
				Optional:    true,
				Description: `Metadata settings that are supplied to this version to enable beta runtime features.`,
				Elem:        &schema.Schema{Type: schema.TypeString},
			},
			"default_expiration": {
				Type:     schema.TypeString,
				Optional: true,
				Description: `Duration that static files should be cached by web proxies and browsers.
Only applicable if the corresponding StaticFilesHandler does not specify its own expiration time.`,
			},
			"deployment": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Code and application artifacts that make up this version.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"cloud_build_options": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Options for the build operations performed as a part of the version deployment. Only applicable when creating a version using source code directly.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"app_yaml_path": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Path to the yaml file used in deployment, used to determine runtime configuration details.`,
									},
									"cloud_build_timeout": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `The Cloud Build timeout used as part of any dependent builds performed by version creation. Defaults to 10 minutes.

A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".`,
									},
								},
							},
							AtLeastOneOf: []string{"deployment.0.zip", "deployment.0.files", "deployment.0.container"},
						},
						"container": {
							Type:        schema.TypeList,
							Computed:    true,
							Optional:    true,
							Description: `The Docker image for the container that runs the version.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"image": {
										Type:     schema.TypeString,
										Required: true,
										Description: `URI to the hosted container image in Google Container Registry. The URI must be fully qualified and include a tag or digest.
Examples: "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"`,
									},
								},
							},
							AtLeastOneOf: []string{"deployment.0.zip", "deployment.0.files", "deployment.0.container"},
						},
						"files": {
							Type:     schema.TypeSet,
							Optional: true,
							Description: `Manifest of the files stored in Google Cloud Storage that are included as part of this version.
All files must be readable using the credentials supplied with this call.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"name": {
										Type:     schema.TypeString,
										Required: true,
									},
									"source_url": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Source URL`,
									},
									"sha1_sum": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `SHA1 checksum of the file`,
									},
								},
							},
							AtLeastOneOf: []string{"deployment.0.zip", "deployment.0.files", "deployment.0.container"},
						},
						"zip": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `Zip File`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"source_url": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Source URL`,
									},
									"files_count": {
										Type:        schema.TypeInt,
										Optional:    true,
										Description: `files count`,
									},
								},
							},
							AtLeastOneOf: []string{"deployment.0.zip", "deployment.0.files", "deployment.0.container"},
						},
					},
				},
			},
			"endpoints_api_service": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Code and application artifacts that make up this version.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"name": {
							Type:     schema.TypeString,
							Required: true,
							Description: `Endpoints service name which is the name of the "service" resource in the Service Management API.
For example "myapi.endpoints.myproject.cloud.goog"`,
						},
						"config_id": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Endpoints service configuration ID as specified by the Service Management API. For example "2016-09-19r1".

By default, the rollout strategy for Endpoints is "FIXED". This means that Endpoints starts up with a particular configuration ID.
When a new configuration is rolled out, Endpoints must be given the new configuration ID. The configId field is used to give the configuration ID
and is required in this case.

Endpoints also has a rollout strategy called "MANAGED". When using this, Endpoints fetches the latest configuration and does not need
the configuration ID. In this case, configId must be omitted.`,
						},
						"disable_trace_sampling": {
							Type:        schema.TypeBool,
							Optional:    true,
							Description: `Enable or disable trace sampling. By default, this is set to false for enabled.`,
							Default:     false,
						},
						"rollout_strategy": {
							Type:         schema.TypeString,
							Optional:     true,
							ValidateFunc: validateEnum([]string{"FIXED", "MANAGED", ""}),
							Description:  `Endpoints rollout strategy. If FIXED, configId must be specified. If MANAGED, configId must be omitted. Default value: "FIXED" Possible values: ["FIXED", "MANAGED"]`,
							Default:      "FIXED",
						},
					},
				},
			},
			"entrypoint": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `The entrypoint for the application.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"shell": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `The format should be a shell command that can be fed to bash -c.`,
						},
					},
				},
			},
			"env_variables": {
				Type:        schema.TypeMap,
				Optional:    true,
				Description: `Environment variables available to the application.  As these are not returned in the API request, Terraform will not detect any changes made outside of the Terraform config.`,
				Elem:        &schema.Schema{Type: schema.TypeString},
			},
			"handlers": {
				Type:     schema.TypeList,
				Computed: true,
				Optional: true,
				Description: `An ordered list of URL-matching patterns that should be applied to incoming requests.
The first matching URL handles the request and other request handlers are not attempted.`,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"auth_fail_action": {
							Type:         schema.TypeString,
							Optional:     true,
							ValidateFunc: validateEnum([]string{"AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED", ""}),
							Description:  `Actions to take when the user is not logged in. Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"]`,
						},
						"login": {
							Type:         schema.TypeString,
							Optional:     true,
							ValidateFunc: validateEnum([]string{"LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED", ""}),
							Description:  `Methods to restrict access to a URL based on login status. Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"]`,
						},
						"redirect_http_response_code": {
							Type:         schema.TypeString,
							Optional:     true,
							ValidateFunc: validateEnum([]string{"REDIRECT_HTTP_RESPONSE_CODE_301", "REDIRECT_HTTP_RESPONSE_CODE_302", "REDIRECT_HTTP_RESPONSE_CODE_303", "REDIRECT_HTTP_RESPONSE_CODE_307", ""}),
							Description:  `30x code to use when performing redirects for the secure field. Possible values: ["REDIRECT_HTTP_RESPONSE_CODE_301", "REDIRECT_HTTP_RESPONSE_CODE_302", "REDIRECT_HTTP_RESPONSE_CODE_303", "REDIRECT_HTTP_RESPONSE_CODE_307"]`,
						},
						"script": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `Executes a script to handle the requests that match this URL pattern.
Only the auto value is supported for Node.js in the App Engine standard environment, for example "script:" "auto".`,
							MaxItems: 1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"script_path": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Path to the script from the application root directory.`,
									},
								},
							},
						},
						"security_level": {
							Type:         schema.TypeString,
							Optional:     true,
							ValidateFunc: validateEnum([]string{"SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS", ""}),
							Description:  `Security (HTTPS) enforcement for this URL. Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"]`,
						},
						"static_files": {
							Type:     schema.TypeList,
							Optional: true,
							Description: `Files served directly to the user for a given URL, such as images, CSS stylesheets, or JavaScript source files.
Static file handlers describe which files in the application directory are static files, and which URLs serve them.`,
							MaxItems: 1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"application_readable": {
										Type:     schema.TypeBool,
										Optional: true,
										Description: `Whether files should also be uploaded as code data. By default, files declared in static file handlers are
uploaded as static data and are only served to end users; they cannot be read by the application. If enabled,
uploads are charged against both your code and static data storage resource quotas.`,
									},
									"expiration": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `Time a static file served by this handler should be cached by web proxies and browsers.
A duration in seconds with up to nine fractional digits, terminated by 's'. Example "3.5s".
Default is '0s'`,
										Default: "0s",
									},
									"http_headers": {
										Type:     schema.TypeMap,
										Optional: true,
										Description: `HTTP headers to use for all responses from these URLs.
An object containing a list of "key:value" value pairs.".`,
										Elem: &schema.Schema{Type: schema.TypeString},
									},
									"mime_type": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `MIME type used to serve all files served by this handler.
Defaults to file-specific MIME types, which are derived from each file's filename extension.`,
									},
									"path": {
										Type:     schema.TypeString,
										Optional: true,
										Description: `Path to the static files matched by the URL pattern, from the application root directory.
The path can refer to text matched in groupings in the URL pattern.`,
									},
									"require_matching_file": {
										Type:        schema.TypeBool,
										Optional:    true,
										Description: `Whether this handler should match the request if the file referenced by the handler does not exist.`,
									},
									"upload_path_regex": {
										Type:        schema.TypeString,
										Optional:    true,
										Description: `Regular expression that matches the file paths for all files that should be referenced by this handler.`,
									},
								},
							},
						},
						"url_regex": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `URL prefix. Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings.
All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.`,
						},
					},
				},
			},
			"inbound_services": {
				Type:        schema.TypeSet,
				Optional:    true,
				Description: `A list of the types of messages that this application is able to receive. Possible values: ["INBOUND_SERVICE_MAIL", "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE", "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE", "INBOUND_SERVICE_WARMUP"]`,
				Elem: &schema.Schema{
					Type:         schema.TypeString,
					ValidateFunc: validateEnum([]string{"INBOUND_SERVICE_MAIL", "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE", "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE", "INBOUND_SERVICE_WARMUP"}),
				},
				Set: schema.HashString,
			},
			"instance_class": {
				Type:     schema.TypeString,
				Optional: true,
				Description: `Instance class that is used to run this version. Valid values are
AutomaticScaling: F1, F2, F4, F4_1G
ManualScaling: B1, B2, B4, B8, B4_1G
Defaults to F1 for AutomaticScaling and B1 for ManualScaling.`,
			},
			"manual_scaling": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"instances": {
							Type:     schema.TypeInt,
							Required: true,
							Description: `Number of instances to assign to the service at the start.

**Note:** When managing the number of instances at runtime through the App Engine Admin API or the (now deprecated) Python 2
Modules API set_num_instances() you must use 'lifecycle.ignore_changes = ["manual_scaling"[0].instances]' to prevent drift detection.`,
						},
					},
				},
				ExactlyOneOf: []string{"automatic_scaling", "manual_scaling"},
			},
			"network": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Extra network settings`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"name": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Google Compute Engine network where the virtual machines are created. Specify the short name, not the resource path.`,
						},
						"forwarded_ports": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `List of ports, or port pairs, to forward from the virtual machine to the application container.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
						},
						"instance_tag": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Tag to apply to the instance during creation.`,
						},
						"session_affinity": {
							Type:        schema.TypeBool,
							Optional:    true,
							Description: `Enable session affinity.`,
						},
						"subnetwork": {
							Type:     schema.TypeString,
							Optional: true,
							Description: `Google Cloud Platform sub-network where the virtual machines are created. Specify the short name, not the resource path.

If the network that the instance is being created in is a Legacy network, then the IP address is allocated from the IPv4Range.
If the network that the instance is being created in is an auto Subnet Mode Network, then only network name should be specified (not the subnetworkName) and the IP address is created from the IPCidrRange of the subnetwork that exists in that zone for that network.
If the network that the instance is being created in is a custom Subnet Mode Network, then the subnetworkName must be specified and the IP address is created from the IPCidrRange of the subnetwork.
If specified, the subnetwork must exist in the same region as the App Engine flexible environment application.`,
						},
					},
				},
			},
			"nobuild_files_regex": {
				Type:        schema.TypeString,
				Optional:    true,
				Description: `Files that match this pattern will not be built into this version. Only applicable for Go runtimes.`,
			},
			"resources": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Machine resources for a version.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"cpu": {
							Type:         schema.TypeInt,
							Optional:     true,
							Description:  `Number of CPU cores needed.`,
							AtLeastOneOf: []string{"resources.0.cpu", "resources.0.disk_gb", "resources.0.memory_gb", "resources.0.volumes"},
						},
						"disk_gb": {
							Type:         schema.TypeInt,
							Optional:     true,
							Description:  `Disk size (GB) needed.`,
							AtLeastOneOf: []string{"resources.0.cpu", "resources.0.disk_gb", "resources.0.memory_gb", "resources.0.volumes"},
						},
						"memory_gb": {
							Type:         schema.TypeFloat,
							Optional:     true,
							Description:  `Memory (GB) needed.`,
							AtLeastOneOf: []string{"resources.0.cpu", "resources.0.disk_gb", "resources.0.memory_gb", "resources.0.volumes"},
						},
						"volumes": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `List of ports, or port pairs, to forward from the virtual machine to the application container.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"name": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Unique name for the volume.`,
									},
									"size_gb": {
										Type:        schema.TypeInt,
										Required:    true,
										Description: `Volume size in gigabytes.`,
									},
									"volume_type": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Underlying volume type, e.g. 'tmpfs'.`,
									},
								},
							},
							AtLeastOneOf: []string{"resources.0.cpu", "resources.0.disk_gb", "resources.0.memory_gb", "resources.0.volumes"},
						},
					},
				},
			},
			"runtime_api_version": {
				Type:     schema.TypeString,
				Computed: true,
				Optional: true,
				Description: `The version of the API in the given runtime environment.
Please see the app.yaml reference for valid values at 'https://cloud.google.com/appengine/docs/standard/<language>/config/appref'\
Substitute '<language>' with 'python', 'java', 'php', 'ruby', 'go' or 'nodejs'.`,
			},
			"runtime_channel": {
				Type:        schema.TypeString,
				Optional:    true,
				Description: `The channel of the runtime to use. Only available for some runtimes.`,
			},
			"runtime_main_executable_path": {
				Type:        schema.TypeString,
				Optional:    true,
				Description: `The path or name of the app's main executable.`,
			},
			"service_account": {
				Type:     schema.TypeString,
				Optional: true,
				Description: `The identity that the deployed version will run as. Admin API will use the App Engine Appspot service account as
default if this field is neither provided in app.yaml file nor through CLI flag.`,
			},
			"serving_status": {
				Type:         schema.TypeString,
				Optional:     true,
				ValidateFunc: validateEnum([]string{"SERVING", "STOPPED", ""}),
				Description:  `Current serving status of this version. Only the versions with a SERVING status create instances and can be billed. Default value: "SERVING" Possible values: ["SERVING", "STOPPED"]`,
				Default:      "SERVING",
			},
			"version_id": {
				Type:     schema.TypeString,
				Optional: true,
				ForceNew: true,
				Description: `Relative name of the version within the service. For example, 'v1'. Version names can contain only lowercase letters, numbers, or hyphens.
Reserved names,"default", "latest", and any name with the prefix "ah-".`,
			},
			"vpc_access_connector": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Enables VPC connectivity for standard apps.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"name": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.`,
						},
					},
				},
			},
			"name": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `Full path to the Version resource in the API. Example, "v1".`,
			},
			"noop_on_destroy": {
				Type:     schema.TypeBool,
				Optional: true,
				Default:  false,
			},
			"delete_service_on_destroy": {
				Type:     schema.TypeBool,
				Optional: true,
				Default:  false,
			},
			"project": {
				Type:     schema.TypeString,
				Optional: true,
				Computed: true,
				ForceNew: true,
			},
		},
		UseJSONNumber: true,
	}
}

func resourceAppEngineFlexibleAppVersionCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	idProp, err := expandAppEngineFlexibleAppVersionVersionId(d.Get("version_id"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("version_id"); !isEmptyValue(reflect.ValueOf(idProp)) && (ok || !reflect.DeepEqual(v, idProp)) {
		obj["id"] = idProp
	}
	inboundServicesProp, err := expandAppEngineFlexibleAppVersionInboundServices(d.Get("inbound_services"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("inbound_services"); !isEmptyValue(reflect.ValueOf(inboundServicesProp)) && (ok || !reflect.DeepEqual(v, inboundServicesProp)) {
		obj["inboundServices"] = inboundServicesProp
	}
	instanceClassProp, err := expandAppEngineFlexibleAppVersionInstanceClass(d.Get("instance_class"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("instance_class"); !isEmptyValue(reflect.ValueOf(instanceClassProp)) && (ok || !reflect.DeepEqual(v, instanceClassProp)) {
		obj["instanceClass"] = instanceClassProp
	}
	networkProp, err := expandAppEngineFlexibleAppVersionNetwork(d.Get("network"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("network"); !isEmptyValue(reflect.ValueOf(networkProp)) && (ok || !reflect.DeepEqual(v, networkProp)) {
		obj["network"] = networkProp
	}
	resourcesProp, err := expandAppEngineFlexibleAppVersionResources(d.Get("resources"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("resources"); !isEmptyValue(reflect.ValueOf(resourcesProp)) && (ok || !reflect.DeepEqual(v, resourcesProp)) {
		obj["resources"] = resourcesProp
	}
	runtimeProp, err := expandAppEngineFlexibleAppVersionRuntime(d.Get("runtime"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("runtime"); !isEmptyValue(reflect.ValueOf(runtimeProp)) && (ok || !reflect.DeepEqual(v, runtimeProp)) {
		obj["runtime"] = runtimeProp
	}
	runtimeChannelProp, err := expandAppEngineFlexibleAppVersionRuntimeChannel(d.Get("runtime_channel"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("runtime_channel"); !isEmptyValue(reflect.ValueOf(runtimeChannelProp)) && (ok || !reflect.DeepEqual(v, runtimeChannelProp)) {
		obj["runtimeChannel"] = runtimeChannelProp
	}
	betaSettingsProp, err := expandAppEngineFlexibleAppVersionBetaSettings(d.Get("beta_settings"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("beta_settings"); !isEmptyValue(reflect.ValueOf(betaSettingsProp)) && (ok || !reflect.DeepEqual(v, betaSettingsProp)) {
		obj["betaSettings"] = betaSettingsProp
	}
	servingStatusProp, err := expandAppEngineFlexibleAppVersionServingStatus(d.Get("serving_status"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("serving_status"); !isEmptyValue(reflect.ValueOf(servingStatusProp)) && (ok || !reflect.DeepEqual(v, servingStatusProp)) {
		obj["servingStatus"] = servingStatusProp
	}
	runtimeApiVersionProp, err := expandAppEngineFlexibleAppVersionRuntimeApiVersion(d.Get("runtime_api_version"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("runtime_api_version"); !isEmptyValue(reflect.ValueOf(runtimeApiVersionProp)) && (ok || !reflect.DeepEqual(v, runtimeApiVersionProp)) {
		obj["runtimeApiVersion"] = runtimeApiVersionProp
	}
	handlersProp, err := expandAppEngineFlexibleAppVersionHandlers(d.Get("handlers"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("handlers"); !isEmptyValue(reflect.ValueOf(handlersProp)) && (ok || !reflect.DeepEqual(v, handlersProp)) {
		obj["handlers"] = handlersProp
	}
	runtimeMainExecutablePathProp, err := expandAppEngineFlexibleAppVersionRuntimeMainExecutablePath(d.Get("runtime_main_executable_path"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("runtime_main_executable_path"); !isEmptyValue(reflect.ValueOf(runtimeMainExecutablePathProp)) && (ok || !reflect.DeepEqual(v, runtimeMainExecutablePathProp)) {
		obj["runtimeMainExecutablePath"] = runtimeMainExecutablePathProp
	}
	serviceAccountProp, err := expandAppEngineFlexibleAppVersionServiceAccount(d.Get("service_account"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("service_account"); !isEmptyValue(reflect.ValueOf(serviceAccountProp)) && (ok || !reflect.DeepEqual(v, serviceAccountProp)) {
		obj["serviceAccount"] = serviceAccountProp
	}
	apiConfigProp, err := expandAppEngineFlexibleAppVersionApiConfig(d.Get("api_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("api_config"); !isEmptyValue(reflect.ValueOf(apiConfigProp)) && (ok || !reflect.DeepEqual(v, apiConfigProp)) {
		obj["apiConfig"] = apiConfigProp
	}
	envVariablesProp, err := expandAppEngineFlexibleAppVersionEnvVariables(d.Get("env_variables"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("env_variables"); !isEmptyValue(reflect.ValueOf(envVariablesProp)) && (ok || !reflect.DeepEqual(v, envVariablesProp)) {
		obj["envVariables"] = envVariablesProp
	}
	defaultExpirationProp, err := expandAppEngineFlexibleAppVersionDefaultExpiration(d.Get("default_expiration"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("default_expiration"); !isEmptyValue(reflect.ValueOf(defaultExpirationProp)) && (ok || !reflect.DeepEqual(v, defaultExpirationProp)) {
		obj["defaultExpiration"] = defaultExpirationProp
	}
	readinessCheckProp, err := expandAppEngineFlexibleAppVersionReadinessCheck(d.Get("readiness_check"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("readiness_check"); !isEmptyValue(reflect.ValueOf(readinessCheckProp)) && (ok || !reflect.DeepEqual(v, readinessCheckProp)) {
		obj["readinessCheck"] = readinessCheckProp
	}
	livenessCheckProp, err := expandAppEngineFlexibleAppVersionLivenessCheck(d.Get("liveness_check"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("liveness_check"); !isEmptyValue(reflect.ValueOf(livenessCheckProp)) && (ok || !reflect.DeepEqual(v, livenessCheckProp)) {
		obj["livenessCheck"] = livenessCheckProp
	}
	nobuildFilesRegexProp, err := expandAppEngineFlexibleAppVersionNobuildFilesRegex(d.Get("nobuild_files_regex"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("nobuild_files_regex"); !isEmptyValue(reflect.ValueOf(nobuildFilesRegexProp)) && (ok || !reflect.DeepEqual(v, nobuildFilesRegexProp)) {
		obj["nobuildFilesRegex"] = nobuildFilesRegexProp
	}
	deploymentProp, err := expandAppEngineFlexibleAppVersionDeployment(d.Get("deployment"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("deployment"); !isEmptyValue(reflect.ValueOf(deploymentProp)) && (ok || !reflect.DeepEqual(v, deploymentProp)) {
		obj["deployment"] = deploymentProp
	}
	endpointsApiServiceProp, err := expandAppEngineFlexibleAppVersionEndpointsApiService(d.Get("endpoints_api_service"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("endpoints_api_service"); !isEmptyValue(reflect.ValueOf(endpointsApiServiceProp)) && (ok || !reflect.DeepEqual(v, endpointsApiServiceProp)) {
		obj["endpointsApiService"] = endpointsApiServiceProp
	}
	entrypointProp, err := expandAppEngineFlexibleAppVersionEntrypoint(d.Get("entrypoint"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("entrypoint"); !isEmptyValue(reflect.ValueOf(entrypointProp)) && (ok || !reflect.DeepEqual(v, entrypointProp)) {
		obj["entrypoint"] = entrypointProp
	}
	vpcAccessConnectorProp, err := expandAppEngineFlexibleAppVersionVPCAccessConnector(d.Get("vpc_access_connector"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("vpc_access_connector"); !isEmptyValue(reflect.ValueOf(vpcAccessConnectorProp)) && (ok || !reflect.DeepEqual(v, vpcAccessConnectorProp)) {
		obj["vpcAccessConnector"] = vpcAccessConnectorProp
	}
	automaticScalingProp, err := expandAppEngineFlexibleAppVersionAutomaticScaling(d.Get("automatic_scaling"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("automatic_scaling"); !isEmptyValue(reflect.ValueOf(automaticScalingProp)) && (ok || !reflect.DeepEqual(v, automaticScalingProp)) {
		obj["automaticScaling"] = automaticScalingProp
	}
	manualScalingProp, err := expandAppEngineFlexibleAppVersionManualScaling(d.Get("manual_scaling"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("manual_scaling"); !isEmptyValue(reflect.ValueOf(manualScalingProp)) && (ok || !reflect.DeepEqual(v, manualScalingProp)) {
		obj["manualScaling"] = manualScalingProp
	}

	obj, err = resourceAppEngineFlexibleAppVersionEncoder(d, meta, obj)
	if err != nil {
		return err
	}

	lockName, err := replaceVars(d, config, "apps/{{project}}")
	if err != nil {
		return err
	}
	mutexKV.Lock(lockName)
	defer mutexKV.Unlock(lockName)

	url, err := replaceVars(d, config, "{{AppEngineBasePath}}apps/{{project}}/services/{{service}}/versions")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new FlexibleAppVersion: %#v", obj)
	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for FlexibleAppVersion: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "POST", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutCreate), isAppEngineRetryableError)
	if err != nil {
		return fmt.Errorf("Error creating FlexibleAppVersion: %s", err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "apps/{{project}}/services/{{service}}/versions/{{version_id}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	err = appEngineOperationWaitTime(
		config, res, project, "Creating FlexibleAppVersion", userAgent,
		d.Timeout(schema.TimeoutCreate))

	if err != nil {
		// The resource didn't actually create
		d.SetId("")
		return fmt.Errorf("Error waiting to create FlexibleAppVersion: %s", err)
	}

	log.Printf("[DEBUG] Finished creating FlexibleAppVersion %q: %#v", d.Id(), res)

	return resourceAppEngineFlexibleAppVersionRead(d, meta)
}

func resourceAppEngineFlexibleAppVersionRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{AppEngineBasePath}}apps/{{project}}/services/{{service}}/versions/{{version_id}}?view=FULL")
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for FlexibleAppVersion: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequest(config, "GET", billingProject, url, userAgent, nil, isAppEngineRetryableError)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("AppEngineFlexibleAppVersion %q", d.Id()))
	}

	// Explicitly set virtual fields to default values if unset
	if _, ok := d.GetOkExists("noop_on_destroy"); !ok {
		if err := d.Set("noop_on_destroy", false); err != nil {
			return fmt.Errorf("Error setting noop_on_destroy: %s", err)
		}
	}
	if _, ok := d.GetOkExists("delete_service_on_destroy"); !ok {
		if err := d.Set("delete_service_on_destroy", false); err != nil {
			return fmt.Errorf("Error setting delete_service_on_destroy: %s", err)
		}
	}
	if err := d.Set("project", project); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}

	if err := d.Set("name", flattenAppEngineFlexibleAppVersionName(res["name"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("version_id", flattenAppEngineFlexibleAppVersionVersionId(res["id"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("inbound_services", flattenAppEngineFlexibleAppVersionInboundServices(res["inboundServices"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("instance_class", flattenAppEngineFlexibleAppVersionInstanceClass(res["instanceClass"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("network", flattenAppEngineFlexibleAppVersionNetwork(res["network"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("resources", flattenAppEngineFlexibleAppVersionResources(res["resources"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("runtime", flattenAppEngineFlexibleAppVersionRuntime(res["runtime"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("runtime_channel", flattenAppEngineFlexibleAppVersionRuntimeChannel(res["runtimeChannel"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("serving_status", flattenAppEngineFlexibleAppVersionServingStatus(res["servingStatus"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("runtime_api_version", flattenAppEngineFlexibleAppVersionRuntimeApiVersion(res["runtimeApiVersion"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("handlers", flattenAppEngineFlexibleAppVersionHandlers(res["handlers"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("runtime_main_executable_path", flattenAppEngineFlexibleAppVersionRuntimeMainExecutablePath(res["runtimeMainExecutablePath"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("service_account", flattenAppEngineFlexibleAppVersionServiceAccount(res["serviceAccount"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("api_config", flattenAppEngineFlexibleAppVersionApiConfig(res["apiConfig"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("default_expiration", flattenAppEngineFlexibleAppVersionDefaultExpiration(res["defaultExpiration"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("readiness_check", flattenAppEngineFlexibleAppVersionReadinessCheck(res["readinessCheck"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("liveness_check", flattenAppEngineFlexibleAppVersionLivenessCheck(res["livenessCheck"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("nobuild_files_regex", flattenAppEngineFlexibleAppVersionNobuildFilesRegex(res["nobuildFilesRegex"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("deployment", flattenAppEngineFlexibleAppVersionDeployment(res["deployment"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("endpoints_api_service", flattenAppEngineFlexibleAppVersionEndpointsApiService(res["endpointsApiService"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("vpc_access_connector", flattenAppEngineFlexibleAppVersionVPCAccessConnector(res["vpcAccessConnector"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("automatic_scaling", flattenAppEngineFlexibleAppVersionAutomaticScaling(res["automaticScaling"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}
	if err := d.Set("manual_scaling", flattenAppEngineFlexibleAppVersionManualScaling(res["manualScaling"], d, config)); err != nil {
		return fmt.Errorf("Error reading FlexibleAppVersion: %s", err)
	}

	return nil
}

func resourceAppEngineFlexibleAppVersionUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for FlexibleAppVersion: %s", err)
	}
	billingProject = project

	obj := make(map[string]interface{})
	idProp, err := expandAppEngineFlexibleAppVersionVersionId(d.Get("version_id"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("version_id"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, idProp)) {
		obj["id"] = idProp
	}
	inboundServicesProp, err := expandAppEngineFlexibleAppVersionInboundServices(d.Get("inbound_services"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("inbound_services"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, inboundServicesProp)) {
		obj["inboundServices"] = inboundServicesProp
	}
	instanceClassProp, err := expandAppEngineFlexibleAppVersionInstanceClass(d.Get("instance_class"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("instance_class"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, instanceClassProp)) {
		obj["instanceClass"] = instanceClassProp
	}
	networkProp, err := expandAppEngineFlexibleAppVersionNetwork(d.Get("network"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("network"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, networkProp)) {
		obj["network"] = networkProp
	}
	resourcesProp, err := expandAppEngineFlexibleAppVersionResources(d.Get("resources"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("resources"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, resourcesProp)) {
		obj["resources"] = resourcesProp
	}
	runtimeProp, err := expandAppEngineFlexibleAppVersionRuntime(d.Get("runtime"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("runtime"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, runtimeProp)) {
		obj["runtime"] = runtimeProp
	}
	runtimeChannelProp, err := expandAppEngineFlexibleAppVersionRuntimeChannel(d.Get("runtime_channel"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("runtime_channel"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, runtimeChannelProp)) {
		obj["runtimeChannel"] = runtimeChannelProp
	}
	betaSettingsProp, err := expandAppEngineFlexibleAppVersionBetaSettings(d.Get("beta_settings"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("beta_settings"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, betaSettingsProp)) {
		obj["betaSettings"] = betaSettingsProp
	}
	servingStatusProp, err := expandAppEngineFlexibleAppVersionServingStatus(d.Get("serving_status"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("serving_status"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, servingStatusProp)) {
		obj["servingStatus"] = servingStatusProp
	}
	runtimeApiVersionProp, err := expandAppEngineFlexibleAppVersionRuntimeApiVersion(d.Get("runtime_api_version"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("runtime_api_version"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, runtimeApiVersionProp)) {
		obj["runtimeApiVersion"] = runtimeApiVersionProp
	}
	handlersProp, err := expandAppEngineFlexibleAppVersionHandlers(d.Get("handlers"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("handlers"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, handlersProp)) {
		obj["handlers"] = handlersProp
	}
	runtimeMainExecutablePathProp, err := expandAppEngineFlexibleAppVersionRuntimeMainExecutablePath(d.Get("runtime_main_executable_path"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("runtime_main_executable_path"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, runtimeMainExecutablePathProp)) {
		obj["runtimeMainExecutablePath"] = runtimeMainExecutablePathProp
	}
	serviceAccountProp, err := expandAppEngineFlexibleAppVersionServiceAccount(d.Get("service_account"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("service_account"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, serviceAccountProp)) {
		obj["serviceAccount"] = serviceAccountProp
	}
	apiConfigProp, err := expandAppEngineFlexibleAppVersionApiConfig(d.Get("api_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("api_config"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, apiConfigProp)) {
		obj["apiConfig"] = apiConfigProp
	}
	envVariablesProp, err := expandAppEngineFlexibleAppVersionEnvVariables(d.Get("env_variables"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("env_variables"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, envVariablesProp)) {
		obj["envVariables"] = envVariablesProp
	}
	defaultExpirationProp, err := expandAppEngineFlexibleAppVersionDefaultExpiration(d.Get("default_expiration"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("default_expiration"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, defaultExpirationProp)) {
		obj["defaultExpiration"] = defaultExpirationProp
	}
	readinessCheckProp, err := expandAppEngineFlexibleAppVersionReadinessCheck(d.Get("readiness_check"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("readiness_check"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, readinessCheckProp)) {
		obj["readinessCheck"] = readinessCheckProp
	}
	livenessCheckProp, err := expandAppEngineFlexibleAppVersionLivenessCheck(d.Get("liveness_check"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("liveness_check"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, livenessCheckProp)) {
		obj["livenessCheck"] = livenessCheckProp
	}
	nobuildFilesRegexProp, err := expandAppEngineFlexibleAppVersionNobuildFilesRegex(d.Get("nobuild_files_regex"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("nobuild_files_regex"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, nobuildFilesRegexProp)) {
		obj["nobuildFilesRegex"] = nobuildFilesRegexProp
	}
	deploymentProp, err := expandAppEngineFlexibleAppVersionDeployment(d.Get("deployment"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("deployment"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, deploymentProp)) {
		obj["deployment"] = deploymentProp
	}
	endpointsApiServiceProp, err := expandAppEngineFlexibleAppVersionEndpointsApiService(d.Get("endpoints_api_service"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("endpoints_api_service"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, endpointsApiServiceProp)) {
		obj["endpointsApiService"] = endpointsApiServiceProp
	}
	entrypointProp, err := expandAppEngineFlexibleAppVersionEntrypoint(d.Get("entrypoint"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("entrypoint"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, entrypointProp)) {
		obj["entrypoint"] = entrypointProp
	}
	vpcAccessConnectorProp, err := expandAppEngineFlexibleAppVersionVPCAccessConnector(d.Get("vpc_access_connector"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("vpc_access_connector"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, vpcAccessConnectorProp)) {
		obj["vpcAccessConnector"] = vpcAccessConnectorProp
	}
	automaticScalingProp, err := expandAppEngineFlexibleAppVersionAutomaticScaling(d.Get("automatic_scaling"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("automatic_scaling"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, automaticScalingProp)) {
		obj["automaticScaling"] = automaticScalingProp
	}
	manualScalingProp, err := expandAppEngineFlexibleAppVersionManualScaling(d.Get("manual_scaling"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("manual_scaling"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, manualScalingProp)) {
		obj["manualScaling"] = manualScalingProp
	}

	obj, err = resourceAppEngineFlexibleAppVersionEncoder(d, meta, obj)
	if err != nil {
		return err
	}

	lockName, err := replaceVars(d, config, "apps/{{project}}")
	if err != nil {
		return err
	}
	mutexKV.Lock(lockName)
	defer mutexKV.Unlock(lockName)

	url, err := replaceVars(d, config, "{{AppEngineBasePath}}apps/{{project}}/services/{{service}}/versions")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating FlexibleAppVersion %q: %#v", d.Id(), obj)

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "POST", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutUpdate), isAppEngineRetryableError)

	if err != nil {
		return fmt.Errorf("Error updating FlexibleAppVersion %q: %s", d.Id(), err)
	} else {
		log.Printf("[DEBUG] Finished updating FlexibleAppVersion %q: %#v", d.Id(), res)
	}

	err = appEngineOperationWaitTime(
		config, res, project, "Updating FlexibleAppVersion", userAgent,
		d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return err
	}

	return resourceAppEngineFlexibleAppVersionRead(d, meta)
}

func resourceAppEngineFlexibleAppVersionDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	if d.Get("noop_on_destroy") == true {
		log.Printf("[DEBUG] Keeping the AppVersion %q", d.Id())
		return nil
	}

	project, err := getProject(d, config)
	if err != nil {
		return err
	}

	lockName, err := replaceVars(d, config, "apps/{{project}}/services/{{service}}")
	if err != nil {
		return err
	}
	mutexKV.Lock(lockName)
	defer mutexKV.Unlock(lockName)

	if d.Get("delete_service_on_destroy") == true {
		url, err := replaceVars(d, config, "{{AppEngineBasePath}}apps/{{project}}/services/{{service}}")
		if err != nil {
			return err
		}
		var obj map[string]interface{}
		log.Printf("[DEBUG] Deleting Service %q", d.Id())
		res, err := sendRequestWithTimeout(config, "DELETE", project, url, userAgent, obj, d.Timeout(schema.TimeoutDelete), isAppEngineRetryableError)
		if err != nil {
			return handleNotFoundError(err, d, "Service")
		}
		err = appEngineOperationWaitTime(
			config, res, project, "Deleting Service", userAgent,
			d.Timeout(schema.TimeoutDelete))

		if err != nil {
			return err
		}
		log.Printf("[DEBUG] Finished deleting Service %q: %#v", d.Id(), res)
		return nil
	} else {
		url, err := replaceVars(d, config, "{{AppEngineBasePath}}apps/{{project}}/services/{{service}}/versions/{{version_id}}")
		if err != nil {
			return err
		}
		var obj map[string]interface{}
		log.Printf("[DEBUG] Deleting AppVersion %q", d.Id())
		res, err := sendRequestWithTimeout(config, "DELETE", project, url, userAgent, obj, d.Timeout(schema.TimeoutDelete), isAppEngineRetryableError)
		if err != nil {
			return handleNotFoundError(err, d, "AppVersion")
		}
		err = appEngineOperationWaitTime(
			config, res, project, "Deleting AppVersion", userAgent,
			d.Timeout(schema.TimeoutDelete))

		if err != nil {
			return err
		}
		log.Printf("[DEBUG] Finished deleting AppVersion %q: %#v", d.Id(), res)
		return nil

	}
}

func resourceAppEngineFlexibleAppVersionImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	config := meta.(*Config)
	if err := parseImportId([]string{
		"apps/(?P<project>[^/]+)/services/(?P<service>[^/]+)/versions/(?P<version_id>[^/]+)",
		"(?P<project>[^/]+)/(?P<service>[^/]+)/(?P<version_id>[^/]+)",
		"(?P<service>[^/]+)/(?P<version_id>[^/]+)",
	}, d, config); err != nil {
		return nil, err
	}

	// Replace import id for the resource id
	id, err := replaceVars(d, config, "apps/{{project}}/services/{{service}}/versions/{{version_id}}")
	if err != nil {
		return nil, fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	// Explicitly set virtual fields to default values on import
	if err := d.Set("noop_on_destroy", false); err != nil {
		return nil, fmt.Errorf("Error setting noop_on_destroy: %s", err)
	}
	if err := d.Set("delete_service_on_destroy", false); err != nil {
		return nil, fmt.Errorf("Error setting delete_service_on_destroy: %s", err)
	}

	return []*schema.ResourceData{d}, nil
}

func flattenAppEngineFlexibleAppVersionName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionVersionId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionInboundServices(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	return schema.NewSet(schema.HashString, v.([]interface{}))
}

func flattenAppEngineFlexibleAppVersionInstanceClass(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionNetwork(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["forwarded_ports"] =
		flattenAppEngineFlexibleAppVersionNetworkForwardedPorts(original["forwardedPorts"], d, config)
	transformed["instance_tag"] =
		flattenAppEngineFlexibleAppVersionNetworkInstanceTag(original["instanceTag"], d, config)
	transformed["name"] =
		flattenAppEngineFlexibleAppVersionNetworkName(original["name"], d, config)
	transformed["subnetwork"] =
		flattenAppEngineFlexibleAppVersionNetworkSubnetwork(original["subnetworkName"], d, config)
	transformed["session_affinity"] =
		flattenAppEngineFlexibleAppVersionNetworkSessionAffinity(original["sessionAffinity"], d, config)
	return []interface{}{transformed}
}
func flattenAppEngineFlexibleAppVersionNetworkForwardedPorts(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionNetworkInstanceTag(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionNetworkName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionNetworkSubnetwork(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionNetworkSessionAffinity(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionResources(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["cpu"] =
		flattenAppEngineFlexibleAppVersionResourcesCpu(original["cpu"], d, config)
	transformed["disk_gb"] =
		flattenAppEngineFlexibleAppVersionResourcesDiskGb(original["diskGb"], d, config)
	transformed["memory_gb"] =
		flattenAppEngineFlexibleAppVersionResourcesMemoryGb(original["memoryGb"], d, config)
	transformed["volumes"] =
		flattenAppEngineFlexibleAppVersionResourcesVolumes(original["volumes"], d, config)
	return []interface{}{transformed}
}
func flattenAppEngineFlexibleAppVersionResourcesCpu(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenAppEngineFlexibleAppVersionResourcesDiskGb(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenAppEngineFlexibleAppVersionResourcesMemoryGb(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionResourcesVolumes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"name":        flattenAppEngineFlexibleAppVersionResourcesVolumesName(original["name"], d, config),
			"volume_type": flattenAppEngineFlexibleAppVersionResourcesVolumesVolumeType(original["volumeType"], d, config),
			"size_gb":     flattenAppEngineFlexibleAppVersionResourcesVolumesSizeGb(original["sizeGb"], d, config),
		})
	}
	return transformed
}
func flattenAppEngineFlexibleAppVersionResourcesVolumesName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionResourcesVolumesVolumeType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionResourcesVolumesSizeGb(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenAppEngineFlexibleAppVersionRuntime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionRuntimeChannel(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionServingStatus(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionRuntimeApiVersion(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionHandlers(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"url_regex":                   flattenAppEngineFlexibleAppVersionHandlersUrlRegex(original["urlRegex"], d, config),
			"security_level":              flattenAppEngineFlexibleAppVersionHandlersSecurityLevel(original["securityLevel"], d, config),
			"login":                       flattenAppEngineFlexibleAppVersionHandlersLogin(original["login"], d, config),
			"auth_fail_action":            flattenAppEngineFlexibleAppVersionHandlersAuthFailAction(original["authFailAction"], d, config),
			"redirect_http_response_code": flattenAppEngineFlexibleAppVersionHandlersRedirectHttpResponseCode(original["redirectHttpResponseCode"], d, config),
			"script":                      flattenAppEngineFlexibleAppVersionHandlersScript(original["script"], d, config),
			"static_files":                flattenAppEngineFlexibleAppVersionHandlersStaticFiles(original["staticFiles"], d, config),
		})
	}
	return transformed
}
func flattenAppEngineFlexibleAppVersionHandlersUrlRegex(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionHandlersSecurityLevel(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionHandlersLogin(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionHandlersAuthFailAction(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionHandlersRedirectHttpResponseCode(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionHandlersScript(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["script_path"] =
		flattenAppEngineFlexibleAppVersionHandlersScriptScriptPath(original["scriptPath"], d, config)
	return []interface{}{transformed}
}
func flattenAppEngineFlexibleAppVersionHandlersScriptScriptPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionHandlersStaticFiles(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["path"] =
		flattenAppEngineFlexibleAppVersionHandlersStaticFilesPath(original["path"], d, config)
	transformed["upload_path_regex"] =
		flattenAppEngineFlexibleAppVersionHandlersStaticFilesUploadPathRegex(original["uploadPathRegex"], d, config)
	transformed["http_headers"] =
		flattenAppEngineFlexibleAppVersionHandlersStaticFilesHttpHeaders(original["httpHeaders"], d, config)
	transformed["mime_type"] =
		flattenAppEngineFlexibleAppVersionHandlersStaticFilesMimeType(original["mimeType"], d, config)
	transformed["expiration"] =
		flattenAppEngineFlexibleAppVersionHandlersStaticFilesExpiration(original["expiration"], d, config)
	transformed["require_matching_file"] =
		flattenAppEngineFlexibleAppVersionHandlersStaticFilesRequireMatchingFile(original["requireMatchingFile"], d, config)
	transformed["application_readable"] =
		flattenAppEngineFlexibleAppVersionHandlersStaticFilesApplicationReadable(original["applicationReadable"], d, config)
	return []interface{}{transformed}
}
func flattenAppEngineFlexibleAppVersionHandlersStaticFilesPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionHandlersStaticFilesUploadPathRegex(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionHandlersStaticFilesHttpHeaders(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionHandlersStaticFilesMimeType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionHandlersStaticFilesExpiration(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionHandlersStaticFilesRequireMatchingFile(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionHandlersStaticFilesApplicationReadable(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionRuntimeMainExecutablePath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionServiceAccount(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionApiConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["auth_fail_action"] =
		flattenAppEngineFlexibleAppVersionApiConfigAuthFailAction(original["authFailAction"], d, config)
	transformed["login"] =
		flattenAppEngineFlexibleAppVersionApiConfigLogin(original["login"], d, config)
	transformed["script"] =
		flattenAppEngineFlexibleAppVersionApiConfigScript(original["script"], d, config)
	transformed["security_level"] =
		flattenAppEngineFlexibleAppVersionApiConfigSecurityLevel(original["securityLevel"], d, config)
	transformed["url"] =
		flattenAppEngineFlexibleAppVersionApiConfigUrl(original["url"], d, config)
	return []interface{}{transformed}
}
func flattenAppEngineFlexibleAppVersionApiConfigAuthFailAction(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionApiConfigLogin(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionApiConfigScript(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionApiConfigSecurityLevel(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionApiConfigUrl(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionDefaultExpiration(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionReadinessCheck(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["path"] =
		flattenAppEngineFlexibleAppVersionReadinessCheckPath(original["path"], d, config)
	transformed["host"] =
		flattenAppEngineFlexibleAppVersionReadinessCheckHost(original["host"], d, config)
	transformed["failure_threshold"] =
		flattenAppEngineFlexibleAppVersionReadinessCheckFailureThreshold(original["failureThreshold"], d, config)
	transformed["success_threshold"] =
		flattenAppEngineFlexibleAppVersionReadinessCheckSuccessThreshold(original["successThreshold"], d, config)
	transformed["check_interval"] =
		flattenAppEngineFlexibleAppVersionReadinessCheckCheckInterval(original["checkInterval"], d, config)
	transformed["timeout"] =
		flattenAppEngineFlexibleAppVersionReadinessCheckTimeout(original["timeout"], d, config)
	transformed["app_start_timeout"] =
		flattenAppEngineFlexibleAppVersionReadinessCheckAppStartTimeout(original["appStartTimeout"], d, config)
	return []interface{}{transformed}
}
func flattenAppEngineFlexibleAppVersionReadinessCheckPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionReadinessCheckHost(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionReadinessCheckFailureThreshold(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionReadinessCheckSuccessThreshold(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionReadinessCheckCheckInterval(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionReadinessCheckTimeout(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionReadinessCheckAppStartTimeout(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionLivenessCheck(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["path"] =
		flattenAppEngineFlexibleAppVersionLivenessCheckPath(original["path"], d, config)
	transformed["host"] =
		flattenAppEngineFlexibleAppVersionLivenessCheckHost(original["host"], d, config)
	transformed["failure_threshold"] =
		flattenAppEngineFlexibleAppVersionLivenessCheckFailureThreshold(original["failureThreshold"], d, config)
	transformed["success_threshold"] =
		flattenAppEngineFlexibleAppVersionLivenessCheckSuccessThreshold(original["successThreshold"], d, config)
	transformed["check_interval"] =
		flattenAppEngineFlexibleAppVersionLivenessCheckCheckInterval(original["checkInterval"], d, config)
	transformed["timeout"] =
		flattenAppEngineFlexibleAppVersionLivenessCheckTimeout(original["timeout"], d, config)
	transformed["initial_delay"] =
		flattenAppEngineFlexibleAppVersionLivenessCheckInitialDelay(original["initialDelay"], d, config)
	return []interface{}{transformed}
}
func flattenAppEngineFlexibleAppVersionLivenessCheckPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionLivenessCheckHost(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionLivenessCheckFailureThreshold(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionLivenessCheckSuccessThreshold(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionLivenessCheckCheckInterval(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionLivenessCheckTimeout(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionLivenessCheckInitialDelay(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionNobuildFilesRegex(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionDeployment(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	original := v.(map[string]interface{})
	transformed := make(map[string]interface{})
	transformed["zip"] = d.Get("deployment.0.zip")
	transformed["files"] = d.Get("deployment.0.files")
	transformed["container"] =
		flattenAppEngineFlexibleAppVersionDeploymentContainer(original["container"], d, config)
	transformed["cloud_build_options"] =
		flattenAppEngineFlexibleAppVersionDeploymentCloudBuildOptions(original["cloudBuildOptions"], d, config)

	return []interface{}{transformed}
}

func flattenAppEngineFlexibleAppVersionDeploymentContainer(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["image"] =
		flattenAppEngineFlexibleAppVersionDeploymentContainerImage(original["image"], d, config)
	return []interface{}{transformed}
}

func flattenAppEngineFlexibleAppVersionDeploymentContainerImage(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionDeploymentCloudBuildOptions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["app_yaml_path"] =
		flattenAppEngineFlexibleAppVersionDeploymentCloudBuildOptionsAppYamlPath(original["appYamlPath"], d, config)
	transformed["cloud_build_timeout"] =
		flattenAppEngineFlexibleAppVersionDeploymentCloudBuildOptionsCloudBuildTimeout(original["cloudBuildTimeout"], d, config)
	return []interface{}{transformed}
}

func flattenAppEngineFlexibleAppVersionDeploymentCloudBuildOptionsAppYamlPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionDeploymentCloudBuildOptionsCloudBuildTimeout(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionEndpointsApiService(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["name"] =
		flattenAppEngineFlexibleAppVersionEndpointsApiServiceName(original["name"], d, config)
	transformed["config_id"] =
		flattenAppEngineFlexibleAppVersionEndpointsApiServiceConfigId(original["configId"], d, config)
	transformed["rollout_strategy"] =
		flattenAppEngineFlexibleAppVersionEndpointsApiServiceRolloutStrategy(original["rolloutStrategy"], d, config)
	transformed["disable_trace_sampling"] =
		flattenAppEngineFlexibleAppVersionEndpointsApiServiceDisableTraceSampling(original["disableTraceSampling"], d, config)
	return []interface{}{transformed}
}
func flattenAppEngineFlexibleAppVersionEndpointsApiServiceName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionEndpointsApiServiceConfigId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionEndpointsApiServiceRolloutStrategy(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionEndpointsApiServiceDisableTraceSampling(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionVPCAccessConnector(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["name"] =
		flattenAppEngineFlexibleAppVersionVPCAccessConnectorName(original["name"], d, config)
	return []interface{}{transformed}
}
func flattenAppEngineFlexibleAppVersionVPCAccessConnectorName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionAutomaticScaling(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["cool_down_period"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingCoolDownPeriod(original["coolDownPeriod"], d, config)
	transformed["cpu_utilization"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingCpuUtilization(original["cpuUtilization"], d, config)
	transformed["max_concurrent_requests"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingMaxConcurrentRequests(original["maxConcurrentRequests"], d, config)
	transformed["max_idle_instances"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingMaxIdleInstances(original["maxIdleInstances"], d, config)
	transformed["max_total_instances"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingMaxTotalInstances(original["maxTotalInstances"], d, config)
	transformed["max_pending_latency"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingMaxPendingLatency(original["maxPendingLatency"], d, config)
	transformed["min_idle_instances"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingMinIdleInstances(original["minIdleInstances"], d, config)
	transformed["min_total_instances"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingMinTotalInstances(original["minTotalInstances"], d, config)
	transformed["min_pending_latency"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingMinPendingLatency(original["minPendingLatency"], d, config)
	transformed["request_utilization"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingRequestUtilization(original["requestUtilization"], d, config)
	transformed["disk_utilization"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingDiskUtilization(original["diskUtilization"], d, config)
	transformed["network_utilization"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization(original["networkUtilization"], d, config)
	return []interface{}{transformed}
}
func flattenAppEngineFlexibleAppVersionAutomaticScalingCoolDownPeriod(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingCpuUtilization(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["aggregation_window_length"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationAggregationWindowLength(original["aggregationWindowLength"], d, config)
	transformed["target_utilization"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationTargetUtilization(original["targetUtilization"], d, config)
	return []interface{}{transformed}
}
func flattenAppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationAggregationWindowLength(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationTargetUtilization(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingMaxConcurrentRequests(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingMaxIdleInstances(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingMaxTotalInstances(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingMaxPendingLatency(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingMinIdleInstances(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingMinTotalInstances(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingMinPendingLatency(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingRequestUtilization(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["target_request_count_per_second"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationTargetRequestCountPerSecond(original["targetRequestCountPerSecond"], d, config)
	transformed["target_concurrent_requests"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationTargetConcurrentRequests(original["targetConcurrentRequests"], d, config)
	return []interface{}{transformed}
}
func flattenAppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationTargetRequestCountPerSecond(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationTargetConcurrentRequests(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingDiskUtilization(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["target_write_bytes_per_second"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationTargetWriteBytesPerSecond(original["targetWriteBytesPerSecond"], d, config)
	transformed["target_write_ops_per_second"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationTargetWriteOpsPerSecond(original["targetWriteOpsPerSecond"], d, config)
	transformed["target_read_bytes_per_second"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationTargetReadBytesPerSecond(original["targetReadBytesPerSecond"], d, config)
	transformed["target_read_ops_per_second"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationTargetReadOpsPerSecond(original["targetReadOpsPerSecond"], d, config)
	return []interface{}{transformed}
}
func flattenAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationTargetWriteBytesPerSecond(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationTargetWriteOpsPerSecond(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationTargetReadBytesPerSecond(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationTargetReadOpsPerSecond(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["target_sent_bytes_per_second"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationTargetSentBytesPerSecond(original["targetSentBytesPerSecond"], d, config)
	transformed["target_sent_packets_per_second"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationTargetSentPacketsPerSecond(original["targetSentPacketsPerSecond"], d, config)
	transformed["target_received_bytes_per_second"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationTargetReceivedBytesPerSecond(original["targetReceivedBytesPerSecond"], d, config)
	transformed["target_received_packets_per_second"] =
		flattenAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationTargetReceivedPacketsPerSecond(original["targetReceivedPacketsPerSecond"], d, config)
	return []interface{}{transformed}
}
func flattenAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationTargetSentBytesPerSecond(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationTargetSentPacketsPerSecond(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationTargetReceivedBytesPerSecond(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationTargetReceivedPacketsPerSecond(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenAppEngineFlexibleAppVersionManualScaling(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["instances"] =
		flattenAppEngineFlexibleAppVersionManualScalingInstances(original["instances"], d, config)
	return []interface{}{transformed}
}
func flattenAppEngineFlexibleAppVersionManualScalingInstances(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func expandAppEngineFlexibleAppVersionVersionId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionInboundServices(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	v = v.(*schema.Set).List()
	return v, nil
}

func expandAppEngineFlexibleAppVersionInstanceClass(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionNetwork(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedForwardedPorts, err := expandAppEngineFlexibleAppVersionNetworkForwardedPorts(original["forwarded_ports"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedForwardedPorts); val.IsValid() && !isEmptyValue(val) {
		transformed["forwardedPorts"] = transformedForwardedPorts
	}

	transformedInstanceTag, err := expandAppEngineFlexibleAppVersionNetworkInstanceTag(original["instance_tag"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInstanceTag); val.IsValid() && !isEmptyValue(val) {
		transformed["instanceTag"] = transformedInstanceTag
	}

	transformedName, err := expandAppEngineFlexibleAppVersionNetworkName(original["name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedName); val.IsValid() && !isEmptyValue(val) {
		transformed["name"] = transformedName
	}

	transformedSubnetwork, err := expandAppEngineFlexibleAppVersionNetworkSubnetwork(original["subnetwork"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSubnetwork); val.IsValid() && !isEmptyValue(val) {
		transformed["subnetworkName"] = transformedSubnetwork
	}

	transformedSessionAffinity, err := expandAppEngineFlexibleAppVersionNetworkSessionAffinity(original["session_affinity"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSessionAffinity); val.IsValid() && !isEmptyValue(val) {
		transformed["sessionAffinity"] = transformedSessionAffinity
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionNetworkForwardedPorts(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionNetworkInstanceTag(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionNetworkName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionNetworkSubnetwork(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionNetworkSessionAffinity(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionResources(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedCpu, err := expandAppEngineFlexibleAppVersionResourcesCpu(original["cpu"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCpu); val.IsValid() && !isEmptyValue(val) {
		transformed["cpu"] = transformedCpu
	}

	transformedDiskGb, err := expandAppEngineFlexibleAppVersionResourcesDiskGb(original["disk_gb"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDiskGb); val.IsValid() && !isEmptyValue(val) {
		transformed["diskGb"] = transformedDiskGb
	}

	transformedMemoryGb, err := expandAppEngineFlexibleAppVersionResourcesMemoryGb(original["memory_gb"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMemoryGb); val.IsValid() && !isEmptyValue(val) {
		transformed["memoryGb"] = transformedMemoryGb
	}

	transformedVolumes, err := expandAppEngineFlexibleAppVersionResourcesVolumes(original["volumes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedVolumes); val.IsValid() && !isEmptyValue(val) {
		transformed["volumes"] = transformedVolumes
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionResourcesCpu(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionResourcesDiskGb(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionResourcesMemoryGb(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionResourcesVolumes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedName, err := expandAppEngineFlexibleAppVersionResourcesVolumesName(original["name"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedName); val.IsValid() && !isEmptyValue(val) {
			transformed["name"] = transformedName
		}

		transformedVolumeType, err := expandAppEngineFlexibleAppVersionResourcesVolumesVolumeType(original["volume_type"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedVolumeType); val.IsValid() && !isEmptyValue(val) {
			transformed["volumeType"] = transformedVolumeType
		}

		transformedSizeGb, err := expandAppEngineFlexibleAppVersionResourcesVolumesSizeGb(original["size_gb"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedSizeGb); val.IsValid() && !isEmptyValue(val) {
			transformed["sizeGb"] = transformedSizeGb
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandAppEngineFlexibleAppVersionResourcesVolumesName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionResourcesVolumesVolumeType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionResourcesVolumesSizeGb(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionRuntime(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionRuntimeChannel(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionBetaSettings(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandAppEngineFlexibleAppVersionServingStatus(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionRuntimeApiVersion(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionHandlers(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	req := make([]interface{}, 0, len(l))
	for _, raw := range l {
		if raw == nil {
			continue
		}
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedUrlRegex, err := expandAppEngineFlexibleAppVersionHandlersUrlRegex(original["url_regex"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedUrlRegex); val.IsValid() && !isEmptyValue(val) {
			transformed["urlRegex"] = transformedUrlRegex
		}

		transformedSecurityLevel, err := expandAppEngineFlexibleAppVersionHandlersSecurityLevel(original["security_level"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedSecurityLevel); val.IsValid() && !isEmptyValue(val) {
			transformed["securityLevel"] = transformedSecurityLevel
		}

		transformedLogin, err := expandAppEngineFlexibleAppVersionHandlersLogin(original["login"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedLogin); val.IsValid() && !isEmptyValue(val) {
			transformed["login"] = transformedLogin
		}

		transformedAuthFailAction, err := expandAppEngineFlexibleAppVersionHandlersAuthFailAction(original["auth_fail_action"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedAuthFailAction); val.IsValid() && !isEmptyValue(val) {
			transformed["authFailAction"] = transformedAuthFailAction
		}

		transformedRedirectHttpResponseCode, err := expandAppEngineFlexibleAppVersionHandlersRedirectHttpResponseCode(original["redirect_http_response_code"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedRedirectHttpResponseCode); val.IsValid() && !isEmptyValue(val) {
			transformed["redirectHttpResponseCode"] = transformedRedirectHttpResponseCode
		}

		transformedScript, err := expandAppEngineFlexibleAppVersionHandlersScript(original["script"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedScript); val.IsValid() && !isEmptyValue(val) {
			transformed["script"] = transformedScript
		}

		transformedStaticFiles, err := expandAppEngineFlexibleAppVersionHandlersStaticFiles(original["static_files"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedStaticFiles); val.IsValid() && !isEmptyValue(val) {
			transformed["staticFiles"] = transformedStaticFiles
		}

		req = append(req, transformed)
	}
	return req, nil
}

func expandAppEngineFlexibleAppVersionHandlersUrlRegex(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionHandlersSecurityLevel(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionHandlersLogin(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionHandlersAuthFailAction(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionHandlersRedirectHttpResponseCode(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionHandlersScript(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedScriptPath, err := expandAppEngineFlexibleAppVersionHandlersScriptScriptPath(original["script_path"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedScriptPath); val.IsValid() && !isEmptyValue(val) {
		transformed["scriptPath"] = transformedScriptPath
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionHandlersScriptScriptPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionHandlersStaticFiles(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedPath, err := expandAppEngineFlexibleAppVersionHandlersStaticFilesPath(original["path"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPath); val.IsValid() && !isEmptyValue(val) {
		transformed["path"] = transformedPath
	}

	transformedUploadPathRegex, err := expandAppEngineFlexibleAppVersionHandlersStaticFilesUploadPathRegex(original["upload_path_regex"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUploadPathRegex); val.IsValid() && !isEmptyValue(val) {
		transformed["uploadPathRegex"] = transformedUploadPathRegex
	}

	transformedHttpHeaders, err := expandAppEngineFlexibleAppVersionHandlersStaticFilesHttpHeaders(original["http_headers"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedHttpHeaders); val.IsValid() && !isEmptyValue(val) {
		transformed["httpHeaders"] = transformedHttpHeaders
	}

	transformedMimeType, err := expandAppEngineFlexibleAppVersionHandlersStaticFilesMimeType(original["mime_type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMimeType); val.IsValid() && !isEmptyValue(val) {
		transformed["mimeType"] = transformedMimeType
	}

	transformedExpiration, err := expandAppEngineFlexibleAppVersionHandlersStaticFilesExpiration(original["expiration"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedExpiration); val.IsValid() && !isEmptyValue(val) {
		transformed["expiration"] = transformedExpiration
	}

	transformedRequireMatchingFile, err := expandAppEngineFlexibleAppVersionHandlersStaticFilesRequireMatchingFile(original["require_matching_file"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRequireMatchingFile); val.IsValid() && !isEmptyValue(val) {
		transformed["requireMatchingFile"] = transformedRequireMatchingFile
	}

	transformedApplicationReadable, err := expandAppEngineFlexibleAppVersionHandlersStaticFilesApplicationReadable(original["application_readable"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedApplicationReadable); val.IsValid() && !isEmptyValue(val) {
		transformed["applicationReadable"] = transformedApplicationReadable
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionHandlersStaticFilesPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionHandlersStaticFilesUploadPathRegex(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionHandlersStaticFilesHttpHeaders(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandAppEngineFlexibleAppVersionHandlersStaticFilesMimeType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionHandlersStaticFilesExpiration(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionHandlersStaticFilesRequireMatchingFile(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionHandlersStaticFilesApplicationReadable(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionRuntimeMainExecutablePath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionServiceAccount(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionApiConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedAuthFailAction, err := expandAppEngineFlexibleAppVersionApiConfigAuthFailAction(original["auth_fail_action"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAuthFailAction); val.IsValid() && !isEmptyValue(val) {
		transformed["authFailAction"] = transformedAuthFailAction
	}

	transformedLogin, err := expandAppEngineFlexibleAppVersionApiConfigLogin(original["login"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLogin); val.IsValid() && !isEmptyValue(val) {
		transformed["login"] = transformedLogin
	}

	transformedScript, err := expandAppEngineFlexibleAppVersionApiConfigScript(original["script"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedScript); val.IsValid() && !isEmptyValue(val) {
		transformed["script"] = transformedScript
	}

	transformedSecurityLevel, err := expandAppEngineFlexibleAppVersionApiConfigSecurityLevel(original["security_level"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSecurityLevel); val.IsValid() && !isEmptyValue(val) {
		transformed["securityLevel"] = transformedSecurityLevel
	}

	transformedUrl, err := expandAppEngineFlexibleAppVersionApiConfigUrl(original["url"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUrl); val.IsValid() && !isEmptyValue(val) {
		transformed["url"] = transformedUrl
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionApiConfigAuthFailAction(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionApiConfigLogin(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionApiConfigScript(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionApiConfigSecurityLevel(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionApiConfigUrl(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionEnvVariables(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandAppEngineFlexibleAppVersionDefaultExpiration(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionReadinessCheck(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedPath, err := expandAppEngineFlexibleAppVersionReadinessCheckPath(original["path"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPath); val.IsValid() && !isEmptyValue(val) {
		transformed["path"] = transformedPath
	}

	transformedHost, err := expandAppEngineFlexibleAppVersionReadinessCheckHost(original["host"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedHost); val.IsValid() && !isEmptyValue(val) {
		transformed["host"] = transformedHost
	}

	transformedFailureThreshold, err := expandAppEngineFlexibleAppVersionReadinessCheckFailureThreshold(original["failure_threshold"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedFailureThreshold); val.IsValid() && !isEmptyValue(val) {
		transformed["failureThreshold"] = transformedFailureThreshold
	}

	transformedSuccessThreshold, err := expandAppEngineFlexibleAppVersionReadinessCheckSuccessThreshold(original["success_threshold"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSuccessThreshold); val.IsValid() && !isEmptyValue(val) {
		transformed["successThreshold"] = transformedSuccessThreshold
	}

	transformedCheckInterval, err := expandAppEngineFlexibleAppVersionReadinessCheckCheckInterval(original["check_interval"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCheckInterval); val.IsValid() && !isEmptyValue(val) {
		transformed["checkInterval"] = transformedCheckInterval
	}

	transformedTimeout, err := expandAppEngineFlexibleAppVersionReadinessCheckTimeout(original["timeout"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTimeout); val.IsValid() && !isEmptyValue(val) {
		transformed["timeout"] = transformedTimeout
	}

	transformedAppStartTimeout, err := expandAppEngineFlexibleAppVersionReadinessCheckAppStartTimeout(original["app_start_timeout"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAppStartTimeout); val.IsValid() && !isEmptyValue(val) {
		transformed["appStartTimeout"] = transformedAppStartTimeout
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionReadinessCheckPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionReadinessCheckHost(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionReadinessCheckFailureThreshold(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionReadinessCheckSuccessThreshold(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionReadinessCheckCheckInterval(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionReadinessCheckTimeout(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionReadinessCheckAppStartTimeout(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionLivenessCheck(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedPath, err := expandAppEngineFlexibleAppVersionLivenessCheckPath(original["path"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPath); val.IsValid() && !isEmptyValue(val) {
		transformed["path"] = transformedPath
	}

	transformedHost, err := expandAppEngineFlexibleAppVersionLivenessCheckHost(original["host"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedHost); val.IsValid() && !isEmptyValue(val) {
		transformed["host"] = transformedHost
	}

	transformedFailureThreshold, err := expandAppEngineFlexibleAppVersionLivenessCheckFailureThreshold(original["failure_threshold"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedFailureThreshold); val.IsValid() && !isEmptyValue(val) {
		transformed["failureThreshold"] = transformedFailureThreshold
	}

	transformedSuccessThreshold, err := expandAppEngineFlexibleAppVersionLivenessCheckSuccessThreshold(original["success_threshold"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSuccessThreshold); val.IsValid() && !isEmptyValue(val) {
		transformed["successThreshold"] = transformedSuccessThreshold
	}

	transformedCheckInterval, err := expandAppEngineFlexibleAppVersionLivenessCheckCheckInterval(original["check_interval"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCheckInterval); val.IsValid() && !isEmptyValue(val) {
		transformed["checkInterval"] = transformedCheckInterval
	}

	transformedTimeout, err := expandAppEngineFlexibleAppVersionLivenessCheckTimeout(original["timeout"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTimeout); val.IsValid() && !isEmptyValue(val) {
		transformed["timeout"] = transformedTimeout
	}

	transformedInitialDelay, err := expandAppEngineFlexibleAppVersionLivenessCheckInitialDelay(original["initial_delay"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInitialDelay); val.IsValid() && !isEmptyValue(val) {
		transformed["initialDelay"] = transformedInitialDelay
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionLivenessCheckPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionLivenessCheckHost(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionLivenessCheckFailureThreshold(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionLivenessCheckSuccessThreshold(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionLivenessCheckCheckInterval(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionLivenessCheckTimeout(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionLivenessCheckInitialDelay(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionNobuildFilesRegex(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionDeployment(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedZip, err := expandAppEngineFlexibleAppVersionDeploymentZip(original["zip"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedZip); val.IsValid() && !isEmptyValue(val) {
		transformed["zip"] = transformedZip
	}

	transformedFiles, err := expandAppEngineFlexibleAppVersionDeploymentFiles(original["files"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedFiles); val.IsValid() && !isEmptyValue(val) {
		transformed["files"] = transformedFiles
	}

	transformedContainer, err := expandAppEngineFlexibleAppVersionDeploymentContainer(original["container"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedContainer); val.IsValid() && !isEmptyValue(val) {
		transformed["container"] = transformedContainer
	}

	transformedCloudBuildOptions, err := expandAppEngineFlexibleAppVersionDeploymentCloudBuildOptions(original["cloud_build_options"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCloudBuildOptions); val.IsValid() && !isEmptyValue(val) {
		transformed["cloudBuildOptions"] = transformedCloudBuildOptions
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionDeploymentZip(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedSourceUrl, err := expandAppEngineFlexibleAppVersionDeploymentZipSourceUrl(original["source_url"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSourceUrl); val.IsValid() && !isEmptyValue(val) {
		transformed["sourceUrl"] = transformedSourceUrl
	}

	transformedFilesCount, err := expandAppEngineFlexibleAppVersionDeploymentZipFilesCount(original["files_count"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedFilesCount); val.IsValid() && !isEmptyValue(val) {
		transformed["filesCount"] = transformedFilesCount
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionDeploymentZipSourceUrl(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionDeploymentZipFilesCount(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionDeploymentFiles(v interface{}, d TerraformResourceData, config *Config) (map[string]interface{}, error) {
	if v == nil {
		return map[string]interface{}{}, nil
	}
	m := make(map[string]interface{})
	for _, raw := range v.(*schema.Set).List() {
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedSha1Sum, err := expandAppEngineFlexibleAppVersionDeploymentFilesSha1Sum(original["sha1_sum"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedSha1Sum); val.IsValid() && !isEmptyValue(val) {
			transformed["sha1Sum"] = transformedSha1Sum
		}

		transformedSourceUrl, err := expandAppEngineFlexibleAppVersionDeploymentFilesSourceUrl(original["source_url"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedSourceUrl); val.IsValid() && !isEmptyValue(val) {
			transformed["sourceUrl"] = transformedSourceUrl
		}

		transformedName, err := expandString(original["name"], d, config)
		if err != nil {
			return nil, err
		}
		m[transformedName] = transformed
	}
	return m, nil
}

func expandAppEngineFlexibleAppVersionDeploymentFilesSha1Sum(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionDeploymentFilesSourceUrl(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionDeploymentContainer(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedImage, err := expandAppEngineFlexibleAppVersionDeploymentContainerImage(original["image"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedImage); val.IsValid() && !isEmptyValue(val) {
		transformed["image"] = transformedImage
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionDeploymentContainerImage(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionDeploymentCloudBuildOptions(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedAppYamlPath, err := expandAppEngineFlexibleAppVersionDeploymentCloudBuildOptionsAppYamlPath(original["app_yaml_path"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAppYamlPath); val.IsValid() && !isEmptyValue(val) {
		transformed["appYamlPath"] = transformedAppYamlPath
	}

	transformedCloudBuildTimeout, err := expandAppEngineFlexibleAppVersionDeploymentCloudBuildOptionsCloudBuildTimeout(original["cloud_build_timeout"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCloudBuildTimeout); val.IsValid() && !isEmptyValue(val) {
		transformed["cloudBuildTimeout"] = transformedCloudBuildTimeout
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionDeploymentCloudBuildOptionsAppYamlPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionDeploymentCloudBuildOptionsCloudBuildTimeout(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionEndpointsApiService(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedName, err := expandAppEngineFlexibleAppVersionEndpointsApiServiceName(original["name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedName); val.IsValid() && !isEmptyValue(val) {
		transformed["name"] = transformedName
	}

	transformedConfigId, err := expandAppEngineFlexibleAppVersionEndpointsApiServiceConfigId(original["config_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedConfigId); val.IsValid() && !isEmptyValue(val) {
		transformed["configId"] = transformedConfigId
	}

	transformedRolloutStrategy, err := expandAppEngineFlexibleAppVersionEndpointsApiServiceRolloutStrategy(original["rollout_strategy"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRolloutStrategy); val.IsValid() && !isEmptyValue(val) {
		transformed["rolloutStrategy"] = transformedRolloutStrategy
	}

	transformedDisableTraceSampling, err := expandAppEngineFlexibleAppVersionEndpointsApiServiceDisableTraceSampling(original["disable_trace_sampling"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDisableTraceSampling); val.IsValid() && !isEmptyValue(val) {
		transformed["disableTraceSampling"] = transformedDisableTraceSampling
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionEndpointsApiServiceName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionEndpointsApiServiceConfigId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionEndpointsApiServiceRolloutStrategy(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionEndpointsApiServiceDisableTraceSampling(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionEntrypoint(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedShell, err := expandAppEngineFlexibleAppVersionEntrypointShell(original["shell"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedShell); val.IsValid() && !isEmptyValue(val) {
		transformed["shell"] = transformedShell
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionEntrypointShell(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionVPCAccessConnector(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedName, err := expandAppEngineFlexibleAppVersionVPCAccessConnectorName(original["name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedName); val.IsValid() && !isEmptyValue(val) {
		transformed["name"] = transformedName
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionVPCAccessConnectorName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScaling(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedCoolDownPeriod, err := expandAppEngineFlexibleAppVersionAutomaticScalingCoolDownPeriod(original["cool_down_period"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCoolDownPeriod); val.IsValid() && !isEmptyValue(val) {
		transformed["coolDownPeriod"] = transformedCoolDownPeriod
	}

	transformedCpuUtilization, err := expandAppEngineFlexibleAppVersionAutomaticScalingCpuUtilization(original["cpu_utilization"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCpuUtilization); val.IsValid() && !isEmptyValue(val) {
		transformed["cpuUtilization"] = transformedCpuUtilization
	}

	transformedMaxConcurrentRequests, err := expandAppEngineFlexibleAppVersionAutomaticScalingMaxConcurrentRequests(original["max_concurrent_requests"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMaxConcurrentRequests); val.IsValid() && !isEmptyValue(val) {
		transformed["maxConcurrentRequests"] = transformedMaxConcurrentRequests
	}

	transformedMaxIdleInstances, err := expandAppEngineFlexibleAppVersionAutomaticScalingMaxIdleInstances(original["max_idle_instances"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMaxIdleInstances); val.IsValid() && !isEmptyValue(val) {
		transformed["maxIdleInstances"] = transformedMaxIdleInstances
	}

	transformedMaxTotalInstances, err := expandAppEngineFlexibleAppVersionAutomaticScalingMaxTotalInstances(original["max_total_instances"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMaxTotalInstances); val.IsValid() && !isEmptyValue(val) {
		transformed["maxTotalInstances"] = transformedMaxTotalInstances
	}

	transformedMaxPendingLatency, err := expandAppEngineFlexibleAppVersionAutomaticScalingMaxPendingLatency(original["max_pending_latency"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMaxPendingLatency); val.IsValid() && !isEmptyValue(val) {
		transformed["maxPendingLatency"] = transformedMaxPendingLatency
	}

	transformedMinIdleInstances, err := expandAppEngineFlexibleAppVersionAutomaticScalingMinIdleInstances(original["min_idle_instances"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMinIdleInstances); val.IsValid() && !isEmptyValue(val) {
		transformed["minIdleInstances"] = transformedMinIdleInstances
	}

	transformedMinTotalInstances, err := expandAppEngineFlexibleAppVersionAutomaticScalingMinTotalInstances(original["min_total_instances"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMinTotalInstances); val.IsValid() && !isEmptyValue(val) {
		transformed["minTotalInstances"] = transformedMinTotalInstances
	}

	transformedMinPendingLatency, err := expandAppEngineFlexibleAppVersionAutomaticScalingMinPendingLatency(original["min_pending_latency"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedMinPendingLatency); val.IsValid() && !isEmptyValue(val) {
		transformed["minPendingLatency"] = transformedMinPendingLatency
	}

	transformedRequestUtilization, err := expandAppEngineFlexibleAppVersionAutomaticScalingRequestUtilization(original["request_utilization"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRequestUtilization); val.IsValid() && !isEmptyValue(val) {
		transformed["requestUtilization"] = transformedRequestUtilization
	}

	transformedDiskUtilization, err := expandAppEngineFlexibleAppVersionAutomaticScalingDiskUtilization(original["disk_utilization"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDiskUtilization); val.IsValid() && !isEmptyValue(val) {
		transformed["diskUtilization"] = transformedDiskUtilization
	}

	transformedNetworkUtilization, err := expandAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization(original["network_utilization"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedNetworkUtilization); val.IsValid() && !isEmptyValue(val) {
		transformed["networkUtilization"] = transformedNetworkUtilization
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingCoolDownPeriod(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingCpuUtilization(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedAggregationWindowLength, err := expandAppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationAggregationWindowLength(original["aggregation_window_length"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAggregationWindowLength); val.IsValid() && !isEmptyValue(val) {
		transformed["aggregationWindowLength"] = transformedAggregationWindowLength
	}

	transformedTargetUtilization, err := expandAppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationTargetUtilization(original["target_utilization"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTargetUtilization); val.IsValid() && !isEmptyValue(val) {
		transformed["targetUtilization"] = transformedTargetUtilization
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationAggregationWindowLength(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationTargetUtilization(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingMaxConcurrentRequests(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingMaxIdleInstances(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingMaxTotalInstances(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingMaxPendingLatency(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingMinIdleInstances(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingMinTotalInstances(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingMinPendingLatency(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingRequestUtilization(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedTargetRequestCountPerSecond, err := expandAppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationTargetRequestCountPerSecond(original["target_request_count_per_second"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTargetRequestCountPerSecond); val.IsValid() && !isEmptyValue(val) {
		transformed["targetRequestCountPerSecond"] = transformedTargetRequestCountPerSecond
	}

	transformedTargetConcurrentRequests, err := expandAppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationTargetConcurrentRequests(original["target_concurrent_requests"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTargetConcurrentRequests); val.IsValid() && !isEmptyValue(val) {
		transformed["targetConcurrentRequests"] = transformedTargetConcurrentRequests
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationTargetRequestCountPerSecond(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationTargetConcurrentRequests(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingDiskUtilization(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedTargetWriteBytesPerSecond, err := expandAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationTargetWriteBytesPerSecond(original["target_write_bytes_per_second"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTargetWriteBytesPerSecond); val.IsValid() && !isEmptyValue(val) {
		transformed["targetWriteBytesPerSecond"] = transformedTargetWriteBytesPerSecond
	}

	transformedTargetWriteOpsPerSecond, err := expandAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationTargetWriteOpsPerSecond(original["target_write_ops_per_second"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTargetWriteOpsPerSecond); val.IsValid() && !isEmptyValue(val) {
		transformed["targetWriteOpsPerSecond"] = transformedTargetWriteOpsPerSecond
	}

	transformedTargetReadBytesPerSecond, err := expandAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationTargetReadBytesPerSecond(original["target_read_bytes_per_second"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTargetReadBytesPerSecond); val.IsValid() && !isEmptyValue(val) {
		transformed["targetReadBytesPerSecond"] = transformedTargetReadBytesPerSecond
	}

	transformedTargetReadOpsPerSecond, err := expandAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationTargetReadOpsPerSecond(original["target_read_ops_per_second"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTargetReadOpsPerSecond); val.IsValid() && !isEmptyValue(val) {
		transformed["targetReadOpsPerSecond"] = transformedTargetReadOpsPerSecond
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationTargetWriteBytesPerSecond(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationTargetWriteOpsPerSecond(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationTargetReadBytesPerSecond(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationTargetReadOpsPerSecond(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedTargetSentBytesPerSecond, err := expandAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationTargetSentBytesPerSecond(original["target_sent_bytes_per_second"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTargetSentBytesPerSecond); val.IsValid() && !isEmptyValue(val) {
		transformed["targetSentBytesPerSecond"] = transformedTargetSentBytesPerSecond
	}

	transformedTargetSentPacketsPerSecond, err := expandAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationTargetSentPacketsPerSecond(original["target_sent_packets_per_second"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTargetSentPacketsPerSecond); val.IsValid() && !isEmptyValue(val) {
		transformed["targetSentPacketsPerSecond"] = transformedTargetSentPacketsPerSecond
	}

	transformedTargetReceivedBytesPerSecond, err := expandAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationTargetReceivedBytesPerSecond(original["target_received_bytes_per_second"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTargetReceivedBytesPerSecond); val.IsValid() && !isEmptyValue(val) {
		transformed["targetReceivedBytesPerSecond"] = transformedTargetReceivedBytesPerSecond
	}

	transformedTargetReceivedPacketsPerSecond, err := expandAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationTargetReceivedPacketsPerSecond(original["target_received_packets_per_second"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTargetReceivedPacketsPerSecond); val.IsValid() && !isEmptyValue(val) {
		transformed["targetReceivedPacketsPerSecond"] = transformedTargetReceivedPacketsPerSecond
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationTargetSentBytesPerSecond(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationTargetSentPacketsPerSecond(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationTargetReceivedBytesPerSecond(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationTargetReceivedPacketsPerSecond(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandAppEngineFlexibleAppVersionManualScaling(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedInstances, err := expandAppEngineFlexibleAppVersionManualScalingInstances(original["instances"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInstances); val.IsValid() && !isEmptyValue(val) {
		transformed["instances"] = transformedInstances
	}

	return transformed, nil
}

func expandAppEngineFlexibleAppVersionManualScalingInstances(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func resourceAppEngineFlexibleAppVersionEncoder(d *schema.ResourceData, meta interface{}, obj map[string]interface{}) (map[string]interface{}, error) {
	obj["env"] = "flex"
	return obj, nil
}
