/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import net.i2p.I2PAppContext;
import net.i2p.data.i2np.EncryptedBuildRecord;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.ShortEncryptedBuildRecord;
import net.i2p.data.i2np.TunnelBuildReplyMessage;

public class OutboundTunnelBuildReplyMessage
extends TunnelBuildReplyMessage {
    public static final int MESSAGE_TYPE = 26;
    public static final int SHORT_RECORD_SIZE = 218;

    public OutboundTunnelBuildReplyMessage(I2PAppContext context) {
        super(context, 0);
    }

    public OutboundTunnelBuildReplyMessage(I2PAppContext context, int records) {
        super(context, records);
    }

    @Override
    public void setRecord(int index, EncryptedBuildRecord record) {
        if (record != null && record.length() != 218) {
            throw new IllegalArgumentException();
        }
        super.setRecord(index, record);
    }

    @Override
    protected int calculateWrittenLength() {
        return 1 + this.RECORD_COUNT * 218;
    }

    @Override
    public int getType() {
        return 26;
    }

    @Override
    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException {
        int r;
        if (type != 26) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        if ((r = data[offset++] & 0xFF) <= 0 || r > 8) {
            throw new I2NPMessageException("Bad record count " + r);
        }
        this.RECORD_COUNT = r;
        if (dataSize != this.calculateWrittenLength()) {
            throw new I2NPMessageException("Wrong length (expects " + this.calculateWrittenLength() + ", recv " + dataSize + ")");
        }
        this._records = new EncryptedBuildRecord[this.RECORD_COUNT];
        for (int i = 0; i < this.RECORD_COUNT; ++i) {
            byte[] rec = new byte[218];
            System.arraycopy(data, offset, rec, 0, 218);
            this.setRecord(i, new ShortEncryptedBuildRecord(rec));
            offset += 218;
        }
    }

    @Override
    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        int remaining = out.length - (curIndex + this.calculateWrittenLength());
        if (remaining < 0) {
            throw new I2NPMessageException("Not large enough (too short by " + remaining + ")");
        }
        if (this.RECORD_COUNT <= 0 || this.RECORD_COUNT > 8) {
            throw new I2NPMessageException("Bad record count " + this.RECORD_COUNT);
        }
        out[curIndex++] = (byte)this.RECORD_COUNT;
        for (int i = 0; i < this.RECORD_COUNT; ++i) {
            System.arraycopy(this._records[i].getData(), 0, out, curIndex, 218);
            curIndex += 218;
        }
        return curIndex;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[OutboundTunnelBuildReplyMessage: \n\tID: ").append(this.getUniqueId()).append("\n\tRecords: ").append(this.getRecordCount()).append(']');
        return buf.toString();
    }
}

