/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.util;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.modifiablevariable.util.ModifiableVariableField;
import de.rub.nds.modifiablevariable.util.ModifiableVariableListHolder;
import de.rub.nds.modifiablevariable.util.RandomHelper;
import de.rub.nds.modifiablevariable.util.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModifiableVariableAnalyzer {
    private static final Logger LOGGER = LogManager.getLogger(ModifiableVariableAnalyzer.class);

    public static List<Field> getAllModifiableVariableFields(Object object) {
        return ReflectionHelper.getFieldsUpTo(object.getClass(), null, ModifiableVariable.class);
    }

    public static Field getRandomModifiableVariableField(Object object) {
        List<Field> fields = ModifiableVariableAnalyzer.getAllModifiableVariableFields(object);
        int randomField = RandomHelper.getRandom().nextInt(fields.size());
        return fields.get(randomField);
    }

    public static boolean isModifiableVariableHolder(Object object) {
        List<Field> fields = ModifiableVariableAnalyzer.getAllModifiableVariableFields(object);
        return !fields.isEmpty();
    }

    public static List<ModifiableVariableField> getAllModifiableVariableFieldsRecursively(Object object) {
        List<ModifiableVariableListHolder> holders = ModifiableVariableAnalyzer.getAllModifiableVariableHoldersRecursively(object);
        LinkedList<ModifiableVariableField> fields = new LinkedList<ModifiableVariableField>();
        for (ModifiableVariableListHolder holder : holders) {
            for (Field f : holder.getFields()) {
                fields.add(new ModifiableVariableField(holder.getObject(), f));
            }
        }
        return fields;
    }

    public static List<ModifiableVariableListHolder> getAllModifiableVariableHoldersRecursively(Object object) {
        LinkedList<ModifiableVariableListHolder> holders = new LinkedList<ModifiableVariableListHolder>();
        List<Field> modFields = ModifiableVariableAnalyzer.getAllModifiableVariableFields(object);
        if (!modFields.isEmpty()) {
            holders.add(new ModifiableVariableListHolder(object, modFields));
        }
        List<Field> allFields = ReflectionHelper.getFieldsUpTo(object.getClass(), null, null);
        for (Field f : allFields) {
            try {
                HoldsModifiableVariable holdsVariable = f.getAnnotation(HoldsModifiableVariable.class);
                f.setAccessible(true);
                Object possibleHolder = f.get(object);
                if (possibleHolder == null || holdsVariable == null) continue;
                if (possibleHolder instanceof List) {
                    holders.addAll(ModifiableVariableAnalyzer.getAllModifiableVariableHoldersFromList((List)possibleHolder));
                    continue;
                }
                if (possibleHolder.getClass().isArray()) {
                    holders.addAll(ModifiableVariableAnalyzer.getAllModifiableVariableHoldersFromArray((Object[])possibleHolder));
                    continue;
                }
                holders.addAll(ModifiableVariableAnalyzer.getAllModifiableVariableHoldersRecursively(possibleHolder));
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                LOGGER.debug("Accessing field {} of type {} not possible: {}", (Object)f.getName(), f.getType(), (Object)ex.toString());
            }
        }
        return holders;
    }

    public static List<ModifiableVariableListHolder> getAllModifiableVariableHoldersFromList(List<Object> list) {
        LinkedList<ModifiableVariableListHolder> result = new LinkedList<ModifiableVariableListHolder>();
        for (Object o : list) {
            if (o != null) {
                result.addAll(ModifiableVariableAnalyzer.getAllModifiableVariableHoldersRecursively(o));
                continue;
            }
            LOGGER.warn("Found null getAllModifiableVariableHoldersFromList");
        }
        return result;
    }

    public static List<ModifiableVariableListHolder> getAllModifiableVariableHoldersFromArray(Object[] array) {
        LinkedList<ModifiableVariableListHolder> result = new LinkedList<ModifiableVariableListHolder>();
        for (Object o : array) {
            result.addAll(ModifiableVariableAnalyzer.getAllModifiableVariableHoldersRecursively(o));
        }
        return result;
    }
}

