/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignatureAndHashAlgorithmsExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignatureAndHashAlgorithmsExtensionSerializer
extends ExtensionSerializer<SignatureAndHashAlgorithmsExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SignatureAndHashAlgorithmsExtensionMessage msg;

    public SignatureAndHashAlgorithmsExtensionSerializer(SignatureAndHashAlgorithmsExtensionMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        LOGGER.debug("Serializing SigantureAndHashAlgorithmsExtensionMessage");
        this.writeSignatureAndHashAlgorithmsLength(this.msg);
        this.writeSignatureAndHashAlgorithms(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeSignatureAndHashAlgorithmsLength(SignatureAndHashAlgorithmsExtensionMessage msg) {
        this.appendInt((Integer)msg.getSignatureAndHashAlgorithmsLength().getValue(), 2);
        LOGGER.debug("SignatureAndHashAlgorithmsLength: " + msg.getSignatureAndHashAlgorithmsLength().getValue());
    }

    private void writeSignatureAndHashAlgorithms(SignatureAndHashAlgorithmsExtensionMessage msg) {
        this.appendBytes((byte[])msg.getSignatureAndHashAlgorithms().getValue());
        LOGGER.debug("SignatureAndHashAlgorithms: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSignatureAndHashAlgorithms().getValue())));
    }
}

